/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.loader.DynamicClassLoader;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.TimedCache;
import com.caucho.vfs.Path;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootDynamicClassLoader
extends DynamicClassLoader {
    private static final URL NULL_URL;
    private static final ClassLoader _systemClassLoader;
    private static final DynamicClassLoader _systemRootClassLoader;
    private TimedCache<String, String> _classNotFoundCache = new TimedCache(8192, 60000L);
    private TimedCache<String, URL> _resourceCache = new TimedCache(8192, 60000L);
    private Path _libexec;

    private RootDynamicClassLoader(ClassLoader parent) {
        super(parent, false, true);
        if (parent instanceof DynamicClassLoader) {
            throw new IllegalStateException();
        }
    }

    static DynamicClassLoader create(ClassLoader parent) {
        if (parent instanceof DynamicClassLoader) {
            return (DynamicClassLoader)parent;
        }
        if (parent == _systemClassLoader) {
            return _systemRootClassLoader;
        }
        return new RootDynamicClassLoader(parent);
    }

    public static DynamicClassLoader getSystemRootClassLoader() {
        return _systemRootClassLoader;
    }

    @Override
    public boolean isRoot() {
        return true;
    }

    @Override
    public Class<?> loadClassImpl(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> cl = this.findLoadedClass(name);
        if (cl != null) {
            if (resolve) {
                this.resolveClass(cl);
            }
            return cl;
        }
        if (this._classNotFoundCache.get(name) != null) {
            return null;
        }
        try {
            cl = super.loadClassImpl(name, resolve);
        }
        catch (ClassNotFoundException e) {
            this._classNotFoundCache.put(name, name);
            throw e;
        }
        if (cl == null) {
            this._classNotFoundCache.put(name, name);
        }
        return cl;
    }

    @Override
    public URL getResource(String name) {
        URL url = this._resourceCache.get(name);
        if (url == null) {
            url = super.getResource(name);
            if (url != null) {
                this._resourceCache.put(name, url);
            } else {
                this._resourceCache.put(name, NULL_URL);
            }
        } else if (url == NULL_URL) {
            url = null;
        }
        return url;
    }

    private Path getLibexec() {
        if (this._libexec == null) {
            this._libexec = CauchoSystem.isWindows() ? (CauchoSystem.is64Bit() ? CauchoSystem.getResinHome().lookup("win64") : CauchoSystem.getResinHome().lookup("win32")) : (CauchoSystem.is64Bit() ? CauchoSystem.getResinHome().lookup("libexec64") : CauchoSystem.getResinHome().lookup("libexec"));
        }
        return this._libexec;
    }

    @Override
    public String findLibrary(String name) {
        Path path = this.getLibexec().lookup("lib" + name + ".so");
        if (path.canRead()) {
            return path.getNativePath();
        }
        path = this.getLibexec().lookup("lib" + name + ".jnilib");
        if (path.canRead()) {
            return path.getNativePath();
        }
        path = this.getLibexec().lookup(name + ".dll");
        return super.findLibrary(name);
    }

    static {
        URL nullUrl = null;
        try {
            nullUrl = new URL("file:///caucho.com/null");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        NULL_URL = nullUrl;
        ClassLoader systemClassLoader = null;
        try {
            systemClassLoader = ClassLoader.getSystemClassLoader();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (systemClassLoader == null) {
                systemClassLoader = RootDynamicClassLoader.class.getClassLoader();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        _systemClassLoader = systemClassLoader;
        _systemRootClassLoader = _systemClassLoader instanceof DynamicClassLoader ? (DynamicClassLoader)_systemClassLoader : new RootDynamicClassLoader(_systemClassLoader);
    }
}

