/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.log;

import com.caucho.bam.actor.ActorSender;
import com.caucho.bam.actor.SimpleActorSender;
import com.caucho.bam.stream.NullActor;
import com.caucho.config.ConfigException;
import com.caucho.hemp.broker.HempBroker;
import com.caucho.util.L10N;
import java.io.Serializable;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import javax.annotation.PostConstruct;

public class HmtpHandler
extends Handler {
    private static final L10N L = new L10N(HmtpHandler.class);
    private String _to;
    private ActorSender _conn;

    public void setTo(String to) {
        this._to = to;
    }

    @PostConstruct
    public void init() throws ConfigException {
        if (this._to == null) {
            throw new ConfigException(L.l("BamHandler needs a 'to' attribute"));
        }
        HempBroker broker = HempBroker.getCurrent();
        NullActor stream = new NullActor("log@localhost", broker);
        this._conn = new SimpleActorSender(stream, broker, "log@localhost", null);
    }

    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        Filter filter = this.getFilter();
        if (filter != null && !filter.isLoggable(record)) {
            return;
        }
        try {
            Formatter formatter = this.getFormatter();
            String value = formatter != null ? formatter.format(record) : record.getMessage();
            this._conn.message(this._to, (Serializable)((Object)value));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void flush() {
    }

    public void close() {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._to + "]";
    }
}

