/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.log;

import com.caucho.config.ConfigException;
import com.caucho.config.types.Period;
import com.caucho.hemp.services.MailService;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.mail.Address;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class MailHandler
extends Handler
implements AlarmListener {
    private static final Logger log = Logger.getLogger(MailHandler.class.getName());
    private static final L10N L = new L10N(MailHandler.class);
    private long _delayTime = 60000L;
    private long _timeIntervalMin = 10800000L;
    private long _lastMailTime;
    private StringBuilder _text;
    private Alarm _alarm;
    private MailService _mailService = new MailService();

    public MailHandler() {
        this._alarm = new Alarm(this);
    }

    public void setDelayTime(Period period) {
        this._delayTime = period.getPeriod();
    }

    public void setMailIntervalMin(Period period) {
        this._timeIntervalMin = period.getPeriod();
    }

    public void setMailSession(Session session) {
        this._mailService.setSession(session);
    }

    public void setProperty(String key, String value) {
        this._mailService.setProperty(key, value);
    }

    public void setProperties(Properties props) {
        this._mailService.setProperties(props);
    }

    public void addTo(String to) throws AddressException {
        this._mailService.addTo((Address)new InternetAddress(to));
    }

    @PostConstruct
    public void init() throws ConfigException {
        this._mailService.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        Filter filter = this.getFilter();
        if (filter != null && !filter.isLoggable(record)) {
            return;
        }
        try {
            Object writer;
            String value;
            Formatter formatter = this.getFormatter();
            if (formatter != null) {
                value = formatter.format(record);
            } else {
                value = record.getMessage();
                Throwable thrown = record.getThrown();
                if (thrown != null) {
                    writer = new StringWriter();
                    PrintWriter out = new PrintWriter((Writer)writer);
                    thrown.printStackTrace(out);
                    out.close();
                    value = value + "\n" + out;
                }
            }
            boolean isStartAlarm = false;
            writer = this;
            synchronized (writer) {
                if (this._text == null) {
                    isStartAlarm = true;
                    this._text = new StringBuilder();
                }
                this._text.append(value).append("\n");
            }
            if (isStartAlarm) {
                long delta = this._lastMailTime + this._timeIntervalMin - CurrentTime.getCurrentTime();
                if (delta < this._delayTime) {
                    delta = this._delayTime;
                }
                this._alarm.queue(delta);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAlarm(Alarm alarm) {
        String text = null;
        MailHandler mailHandler = this;
        synchronized (mailHandler) {
            if (this._text != null) {
                text = this._text.toString();
            }
            this._text = null;
        }
        this._lastMailTime = CurrentTime.getCurrentTime();
        if (text != null) {
            this._mailService.send(text);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public void close() {
        String text = null;
        MailHandler mailHandler = this;
        synchronized (mailHandler) {
            if (this._text != null) {
                text = this._text.toString();
            }
            this._text = null;
        }
        if (text != null) {
            this._mailService.send(text);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

