/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.management.server;

import com.caucho.jmx.Description;
import com.caucho.jmx.Units;
import com.caucho.management.server.ManagedObjectMXBean;
import com.caucho.management.server.PersistentStoreMXBean;
import com.caucho.management.server.WebAppMXBean;

@Description(value="The session manager for a web-app")
public interface SessionManagerMXBean
extends ManagedObjectMXBean {
    @Description(value="The owning WebApp for this session manager")
    public WebAppMXBean getWebApp();

    @Description(value="The persistent store")
    public PersistentStoreMXBean getPersistentStore();

    @Description(value="The configured value, if true serialize the session on each request, even if no attributes have been set")
    public boolean isAlwaysSaveSession();

    @Description(value="The configured value, if true append the server's cluster index to the cookie value")
    public boolean isCookieAppendServerIndex();

    @Description(value="The configured host domain used for session cookies")
    public String getCookieDomain();

    @Description(value="The configured value, if true the cookie should only be used for http, not https requests")
    public boolean isCookieHttpOnly();

    @Description(value="The configured length of the generated cookie")
    public long getCookieLength();

    @Description(value="The configured session cookie max-age in milliseconds sent to the browser")
    @Units(value="milliseconds")
    public long getCookieMaxAge();

    @Description(value="The configured cookie name for servlet sessions")
    public String getCookieName();

    @Description(value="The configured session cookie port sent to the browser")
    public String getCookiePort();

    @Description(value="The configured value, if true the session cookie should only be sent on a secure connection")
    public boolean isCookieSecure();

    @Description(value="The configured cookie version sent to the browser")
    public int getCookieVersion();

    @Description(value="The configured value, if true session cookies are enabled")
    public boolean isEnableCookies();

    @Description(value="The configured value, if true (discouraged) URL-rewriting is enabled. URL-rewriting should be avoided as a security risk.")
    public boolean isEnableURLRewriting();

    @Description(value="The configured value, if true persistent sessions should ignore serialization errors.")
    public boolean isIgnoreSerializationErrors();

    @Description(value="The configured value, if true the session should be invalidated only after listeners are called")
    public boolean isInvalidateAfterListener();

    @Description(value="The configured value, if true the session-id should be reused if no session exists to match the cookie. This should generally be true to ensure web-app session consistency")
    public boolean isReuseSessionId();

    @Description(value="The configured session persistence mode. The session save-mode is one of: before-headers, after-request, on-shutdown")
    public String getSaveMode();

    @Description(value="The configured maximum number of sessions in memory. The number of persistent sessions may be larger")
    public int getSessionMax();

    @Description(value="The configured time in milliseconds before an idle session is destroyed")
    @Units(value="milliseconds")
    public long getSessionTimeout();

    @Description(value="The current number of active sessions")
    public long getSessionActiveCount();

    @Description(value="The total number of sessions that have been created")
    public long getSessionCreateCountTotal();

    @Description(value="The total number of sessions that have been invalidated")
    public long getSessionInvalidateCountTotal();

    @Description(value="The total number of times a session has timed out")
    public long getSessionTimeoutCountTotal();

    @Description(value="A string representation of the serialized session")
    public String sessionSerializationDebug(String var1);

    @Description(value="A JSON formatted representation of session")
    public String sessionAsJsonString(String var1);

    @Description(value="A list fo session ids")
    public String[] sessionIdList();

    @Description(value="A JSON formatted representation of session")
    public String sessionsAsJsonString();

    @Description(value="Estimated Memory Size")
    public long getEstimatedMemorySize();

    @Description(value="The server for a session")
    public int stickySessionServer(String var1, int var2);
}

