/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.message.common;

import com.caucho.env.thread.AbstractTaskWorker;
import com.caucho.message.MessageReceiverFactory;
import com.caucho.message.MessageReceiverListener;
import com.caucho.message.common.AbstractMessageReceiver;
import com.caucho.message.common.MessageReceiverCredit;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicMessageReceiver<T>
extends AbstractMessageReceiver<T> {
    private static final Logger log = Logger.getLogger(BasicMessageReceiver.class.getName());
    private final String _address;
    private final MessageReceiverListener<T> _listener;
    private final LinkedBlockingQueue<QueueEntry<T>> _queue = new LinkedBlockingQueue();
    private final MessageReceiverCredit _credit = new MessageReceiverCredit();
    private final MessageListenerWorker _worker;
    private long _lastMessageId;

    protected BasicMessageReceiver(MessageReceiverFactory factory) {
        this._address = factory.getAddress();
        this._listener = factory.getListener();
        this._credit.setPrefetch(factory.getPrefetch());
        this._worker = this._listener != null ? new MessageListenerWorker() : null;
    }

    public String getAddress() {
        return this._address;
    }

    public int getPrefetch() {
        return this._credit.getPrefetch();
    }

    @Override
    public long getLastMessageId() {
        return this._lastMessageId;
    }

    @Override
    public void onBuild() {
        this.wake();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected T pollMicros(long timeoutMicros) {
        T t;
        block7: {
            QueueEntry<T> entry;
            boolean isFlow;
            block5: {
                T t2;
                block6: {
                    isFlow = false;
                    entry = this._queue.poll(timeoutMicros, TimeUnit.MICROSECONDS);
                    if (entry != null) break block5;
                    t2 = null;
                    Object var8_8 = null;
                    if (!isFlow || !this._credit.isFlowRequired()) break block6;
                    int credit = this._credit.getCredit();
                    long endpointSequence = this._credit.getEndpointSequence();
                    this._credit.updateCredit(credit);
                    this.updateFlow(credit, endpointSequence);
                }
                return t2;
            }
            try {
                isFlow = true;
                this._credit.receiveClient();
                T value = entry.getValue();
                this._lastMessageId = entry.getMessageId();
                t = value;
                Object var8_9 = null;
                if (!isFlow || !this._credit.isFlowRequired()) break block7;
                int credit = this._credit.getCredit();
                long endpointSequence = this._credit.getEndpointSequence();
                this._credit.updateCredit(credit);
                this.updateFlow(credit, endpointSequence);
            }
            catch (InterruptedException e) {
                T t3;
                block8: {
                    try {
                        log.log(Level.FINE, e.toString(), e);
                        t3 = null;
                        Object var8_10 = null;
                        if (!isFlow || !this._credit.isFlowRequired()) break block8;
                        int credit = this._credit.getCredit();
                        long endpointSequence = this._credit.getEndpointSequence();
                        this._credit.updateCredit(credit);
                        this.updateFlow(credit, endpointSequence);
                    }
                    catch (Throwable throwable) {
                        block9: {
                            Object var8_11 = null;
                            if (!isFlow || !this._credit.isFlowRequired()) break block9;
                            int credit = this._credit.getCredit();
                            long endpointSequence = this._credit.getEndpointSequence();
                            this._credit.updateCredit(credit);
                            this.updateFlow(credit, endpointSequence);
                        }
                        throw throwable;
                    }
                }
                return t3;
            }
        }
        return t;
    }

    protected void updateFlow(int credit, long endpointSequence) {
    }

    public void updateCredit(int credit) {
        this._credit.updateCredit(credit);
    }

    public void receiveEntry(T value) {
        long mid = this._credit.receiveEndpoint();
        this._queue.add(new QueueEntry<T>(mid, value));
        this.wake();
    }

    protected void wake() {
        MessageListenerWorker worker = this._worker;
        if (worker != null) {
            worker.wake();
        }
    }

    private void receiveMessages() {
        while (this.receiveMessage()) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean receiveMessage() {
        QueueEntry<T> entry;
        boolean isFlow;
        block5: {
            isFlow = false;
            try {
                entry = this._queue.poll();
                if (entry != null) break block5;
                boolean bl = false;
                Object var9_5 = null;
                if (isFlow && this._credit.isFlowRequired()) {
                    int credit = this._credit.getCredit();
                    long endpointSequence = this._credit.getEndpointSequence();
                    this._credit.updateCredit(credit);
                    this.updateFlow(credit, endpointSequence);
                }
                return bl;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var9_7 = null;
                    if (!isFlow || !this._credit.isFlowRequired()) break block6;
                    int credit = this._credit.getCredit();
                    long endpointSequence = this._credit.getEndpointSequence();
                    this._credit.updateCredit(credit);
                    this.updateFlow(credit, endpointSequence);
                }
                throw throwable;
            }
        }
        isFlow = true;
        this._credit.receiveClient();
        long mid = entry.getMessageId();
        T value = entry.getValue();
        this._lastMessageId = mid;
        MessageReceiverListener<T> listener = this._listener;
        listener.onMessage(mid, value, this);
        boolean bl = true;
        Object var9_6 = null;
        if (isFlow && this._credit.isFlowRequired()) {
            int credit = this._credit.getCredit();
            long endpointSequence = this._credit.getEndpointSequence();
            this._credit.updateCredit(credit);
            this.updateFlow(credit, endpointSequence);
        }
        return bl;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getAddress() + "]";
    }

    private class MessageListenerWorker
    extends AbstractTaskWorker {
        private MessageListenerWorker() {
        }

        public long runTask() {
            BasicMessageReceiver.this.receiveMessages();
            return 0L;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class QueueEntry<T> {
        private long _mid;
        private T _value;

        QueueEntry(long mid, T value) {
            this._mid = mid;
            this._value = value;
        }

        public long getMessageId() {
            return this._mid;
        }

        public T getValue() {
            return this._value;
        }
    }
}

