/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.message.nautilus;

import com.caucho.db.block.BlockStore;
import java.io.IOException;

final class MessageDataNode {
    private final BlockStore _store;
    private final long _blockAddress;
    private final int _offset;
    private final int _length;
    private MessageDataNode _next;

    MessageDataNode(BlockStore store, long blockAddress, int offset, int length) {
        this._store = store;
        this._blockAddress = blockAddress;
        this._offset = offset;
        this._length = length;
    }

    final int getLength() {
        return this._length;
    }

    final void read(int nodeOffset, byte[] buffer, int offset, int length) throws IOException {
        this._store.readBlock(this._blockAddress, nodeOffset + this._offset, buffer, offset, length);
    }

    final MessageDataNode getNext() {
        return this._next;
    }

    final void setNext(MessageDataNode next) {
        this._next = next;
    }

    final long getBlockAddress() {
        return this._blockAddress;
    }
}

