/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.message.nautilus;

import com.caucho.config.ConfigException;
import com.caucho.db.block.BlockStore;
import com.caucho.env.actor.ActorQueue;
import com.caucho.env.service.RootDirectorySystem;
import com.caucho.loader.Environment;
import com.caucho.message.DistributionMode;
import com.caucho.message.broker.AbstractMessageBroker;
import com.caucho.message.broker.BrokerReceiver;
import com.caucho.message.broker.BrokerSender;
import com.caucho.message.broker.EnvironmentMessageBroker;
import com.caucho.message.broker.ReceiverMessageHandler;
import com.caucho.message.journal.JournalFile;
import com.caucho.message.journal.JournalRecoverListener;
import com.caucho.message.journal.JournalResult;
import com.caucho.message.journal.JournalWriteActor;
import com.caucho.message.nautilus.NautilusBrokerPublisher;
import com.caucho.message.nautilus.NautilusBrokerStore;
import com.caucho.message.nautilus.NautilusBrokerSubscriber;
import com.caucho.message.nautilus.NautilusCheckpointPublisher;
import com.caucho.message.nautilus.NautilusMultiQueueActor;
import com.caucho.message.nautilus.NautilusRingItem;
import com.caucho.util.L10N;
import com.caucho.util.RingItemFactory;
import com.caucho.vfs.Path;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.Startup;
import javax.inject.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Startup
@Singleton
public class NautilusBroker
extends AbstractMessageBroker
implements Closeable {
    private static final Logger log = Logger.getLogger(NautilusBroker.class.getName());
    private static final L10N L = new L10N(NautilusBroker.class);
    private Path _path;
    private JournalFile _journalFile;
    private NautilusMultiQueueActor _nautilusActor;
    private ActorQueue<NautilusRingItem> _nautilusActorQueue;
    private NautilusBrokerStore _brokerStore = new NautilusBrokerStore();

    public void setPath(Path path) {
        this._path = path;
    }

    @PostConstruct
    public void init() {
        if (this._path == null) {
            throw new ConfigException(L.l("'path' is required for a journal broker."));
        }
        this.initImpl();
        Environment.addCloseListener(this);
        this.registerSelf();
    }

    public static NautilusBroker getCurrent() {
        EnvironmentMessageBroker envBroker = EnvironmentMessageBroker.create();
        NautilusBroker broker = (NautilusBroker)envBroker.findBroker(NautilusBroker.class);
        if (broker == null) {
            broker = new NautilusBroker();
            RootDirectorySystem dirSystem = RootDirectorySystem.getCurrent();
            Path path = dirSystem.getDataDirectory().lookup("msg.journal");
            broker.setPath(path);
            broker.init();
            envBroker.addBroker(broker);
        }
        return broker;
    }

    @Override
    public BrokerSender createSender(String name, Map<String, Object> nodeProperties) {
        NautilusBrokerStore.BrokerQueue queue = this.getQueue(name);
        return new NautilusBrokerPublisher(queue.getId(), this.getActorQueue());
    }

    @Override
    public BrokerReceiver createReceiver(String name, DistributionMode distMode, Map<String, Object> nodeProperties, ReceiverMessageHandler handler) {
        NautilusBrokerStore.BrokerQueue queue = this.getQueue(name);
        return new NautilusBrokerSubscriber(queue.getName(), queue.getId(), this._nautilusActorQueue, handler);
    }

    private NautilusBrokerStore.BrokerQueue getQueue(String name) {
        NautilusBrokerStore.BrokerQueue queue = this._brokerStore.addQueue(name);
        return queue;
    }

    private void initImpl() {
        this._nautilusActor = new NautilusMultiQueueActor();
        RecoverListener recover = new RecoverListener();
        this._journalFile = new JournalFile(this._path, recover);
        this._nautilusActorQueue = new ActorQueue<NautilusRingItem>(8192, new NautilusItemFactory(), new JournalWriteActor(this._journalFile), this._nautilusActor);
        NautilusCheckpointPublisher pub = new NautilusCheckpointPublisher(this._nautilusActorQueue);
        this._nautilusActor.setNautilusCheckpointPublisher(pub);
    }

    public int getSize() {
        return this._nautilusActor.getSize();
    }

    public long getEnqueueCount() {
        return this._nautilusActor.getEnqueueCount();
    }

    public long getDequeueCount() {
        return this._nautilusActor.getDequeueCount();
    }

    ActorQueue<NautilusRingItem> getActorQueue() {
        return this._nautilusActorQueue;
    }

    @Override
    public void close() {
        System.out.println("CLOSE-ME:");
        this._nautilusActorQueue.wake();
        this._journalFile.close();
    }

    class RecoverListener
    implements JournalRecoverListener {
        private NautilusRingItem _entry = new NautilusRingItem(0);

        RecoverListener() {
        }

        public void onEntry(long code, boolean isInit, boolean isFin, long xid, long qid, long mid, BlockStore store, long blockAddress, int blockOffset, int length) throws IOException {
            this._entry.init(code, xid, qid, mid, null, 0, 0, null);
            JournalResult result = this._entry.getResult();
            result.init1(store, blockAddress, blockOffset, length);
            try {
                NautilusBroker.this._nautilusActor.process(this._entry);
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            this._entry.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NautilusItemFactory
    implements RingItemFactory<NautilusRingItem> {
        NautilusItemFactory() {
        }

        @Override
        public NautilusRingItem createItem(int index) {
            return new NautilusRingItem(index);
        }
    }
}

