/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.message.nautilus;

import com.caucho.env.actor.ActorQueue;
import com.caucho.message.broker.BrokerReceiver;
import com.caucho.message.broker.ReceiverMessageHandler;
import com.caucho.message.nautilus.MessageDataInputStream;
import com.caucho.message.nautilus.MessageDataNode;
import com.caucho.message.nautilus.NautilusQueue;
import com.caucho.message.nautilus.NautilusRingItem;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NautilusBrokerSubscriber
implements BrokerReceiver {
    private static final long MASK = 0xFFFFFFFFL;
    private static final Logger log = Logger.getLogger(NautilusBrokerSubscriber.class.getName());
    private final String _queueName;
    private final long _qid;
    private final ActorQueue<NautilusRingItem> _nautilusQueue;
    private final ReceiverMessageHandler _subscriberHandler;
    private long _deliveryCount;
    private int _credit;

    NautilusBrokerSubscriber(String queueName, long qid, ActorQueue<NautilusRingItem> nautilusActorQueue, ReceiverMessageHandler subscriberHandler) {
        this._queueName = queueName;
        this._qid = qid;
        this._nautilusQueue = nautilusActorQueue;
        this._subscriberHandler = subscriberHandler;
        if (subscriberHandler == null) {
            throw new NullPointerException();
        }
        this.start();
    }

    @Override
    public void accepted(long xid, long mid) {
        NautilusRingItem entry = this._nautilusQueue.startOffer(true);
        entry.initAck(xid, this._qid, mid, this);
        this._nautilusQueue.finishOffer(entry);
        this._nautilusQueue.wake();
    }

    @Override
    public void rejected(long xid, long mid, String message) {
        System.out.println("reject: " + mid);
    }

    @Override
    public void modified(long xid, long mid, boolean isFailed, boolean isUndeliverableHere) {
    }

    @Override
    public void released(long xid, long mid) {
        System.out.println("releaseE: " + mid);
    }

    @Override
    public void flow(long deliveryCount, int linkCredit) {
        NautilusRingItem entry = this._nautilusQueue.startOffer(true);
        entry.initFlow(this._qid, this, deliveryCount, linkCredit);
        this._nautilusQueue.finishOffer(entry);
        this._nautilusQueue.wake();
    }

    @Override
    public void close() {
        this.stop();
    }

    private void start() {
        NautilusRingItem entry = this._nautilusQueue.startOffer(true);
        entry.initSubscribe(this._qid, this);
        this._nautilusQueue.finishOffer(entry);
        this._nautilusQueue.wake();
    }

    private void stop() {
        NautilusRingItem entry = this._nautilusQueue.startOffer(true);
        entry.initUnsubscribe(this._qid, this);
        this._nautilusQueue.finishOffer(entry);
        this._nautilusQueue.wake();
    }

    public void onTransfer(NautilusQueue.QueueEntry entry) {
        this.onTransfer(entry.getSequence(), entry.getDataHead());
    }

    private void onTransfer(long mid, MessageDataNode dataHead) {
        this._deliveryCount = this._deliveryCount + 1L & 0xFFFFFFFFL;
        --this._credit;
        MessageDataInputStream is = new MessageDataInputStream(dataHead);
        long len = dataHead.getLength();
        try {
            this._subscriberHandler.onMessage(mid, is, len);
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
        }
    }

    boolean isAvailable() {
        return this._credit > 0;
    }

    boolean onFlow(long clientDeliveryCount, int credit) {
        if (clientDeliveryCount >= 0L) {
            long delta = this._deliveryCount - clientDeliveryCount & 0xFFFFFFFFL;
            credit = (int)((long)credit - delta);
        }
        if (credit < 0) {
            credit = 0;
        }
        this._credit = credit;
        return credit > 0;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._qid + "," + this._queueName + "]";
    }
}

