/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.message.nautilus;

import com.caucho.env.actor.AbstractActorProcessor;
import com.caucho.env.actor.ActorQueue;
import com.caucho.env.actor.ValueActorQueue;
import com.caucho.message.nautilus.NautilusRingItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NautilusCheckpointPublisher {
    private ActorQueue<NautilusRingItem> _nautilusQueue;
    private ValueActorQueue<Long> _checkpointQueue;

    NautilusCheckpointPublisher(ActorQueue<NautilusRingItem> nautilusQueue) {
        this._nautilusQueue = nautilusQueue;
        this._checkpointQueue = new ValueActorQueue(256, new CheckpointProcessor());
    }

    boolean checkpoint(long blockAddress) {
        boolean isValid = this._checkpointQueue.offer(new Long(blockAddress), false);
        this._checkpointQueue.wake();
        return isValid;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CheckpointProcessor
    extends AbstractActorProcessor<Long> {
        CheckpointProcessor() {
        }

        @Override
        public String getThreadName() {
            return this.toString();
        }

        @Override
        public void process(Long blockAddress) throws Exception {
            NautilusRingItem entry = (NautilusRingItem)NautilusCheckpointPublisher.this._nautilusQueue.startOffer(true);
            entry.initCheckpoint(blockAddress, 0, 0);
            NautilusCheckpointPublisher.this._nautilusQueue.finishOffer(entry);
            NautilusCheckpointPublisher.this._nautilusQueue.wake();
        }

        @Override
        public void onProcessComplete() throws Exception {
        }
    }
}

