/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.network.balance;

import com.caucho.bam.BamException;
import com.caucho.env.meter.ActiveMeter;
import com.caucho.env.meter.ActiveTimeMeter;
import com.caucho.network.balance.ClientSocketApi;
import com.caucho.network.balance.ClientSocketFactory;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClientSocket
implements ClientSocketApi {
    private static final L10N L = new L10N(ClientSocket.class);
    private static final Logger log = Logger.getLogger(ClientSocket.class.getName());
    private ClientSocketFactory _pool;
    private long _poolSequenceId;
    private ReadStream _is;
    private WriteStream _os;
    private boolean _isAuthenticated;
    private ActiveMeter _connProbe;
    private ActiveTimeMeter _requestTimeProbe;
    private ActiveMeter _idleProbe;
    private long _requestStartTime;
    private boolean _isIdle;
    private long _idleStartTime;
    private String _debugId;

    ClientSocket(ClientSocketFactory pool, int count, ReadStream is, WriteStream os) {
        this._pool = pool;
        this._poolSequenceId = pool.getStartSequenceId();
        this._is = is;
        this._os = os;
        this._debugId = "[" + pool.getDebugId() + ":" + count + "]";
        this._connProbe = pool.getConnectionProbe();
        this._requestTimeProbe = pool.getRequestTimeProbe();
        this._idleProbe = pool.getIdleProbe();
        this._connProbe.start();
        this.toActive();
    }

    public ClientSocketFactory getPool() {
        return this._pool;
    }

    public ReadStream getInputStream() {
        this._idleStartTime = 0L;
        return this._is;
    }

    public WriteStream getOutputStream() {
        this._idleStartTime = 0L;
        return this._os;
    }

    public boolean isAuthenticated() {
        return this._isAuthenticated;
    }

    public void setAuthenticated(boolean isAuthenticated) {
        this._isAuthenticated = isAuthenticated;
    }

    public long getIdleStartTime() {
        return this._idleStartTime;
    }

    public void setIdleStartTime(long idleStartTime) {
        this._idleStartTime = idleStartTime;
    }

    public void clearIdleStartTime() {
        this._idleStartTime = 0L;
        this._is.clearReadTime();
    }

    public boolean isIdleExpired() {
        long now = CurrentTime.getCurrentTime();
        return this._pool.getLoadBalanceIdleTime() < now - this._idleStartTime;
    }

    public boolean isIdleAlmostExpired(long delta) {
        long now = CurrentTime.getCurrentTime();
        return this._pool.getLoadBalanceIdleTime() < now - this._idleStartTime + delta;
    }

    public boolean isPoolSequenceIdValid() {
        return this._poolSequenceId == (long)this._pool.getStartSequenceId();
    }

    public String getAddress() {
        return "clusterStream@admin.resin";
    }

    public void switchToHmtp(boolean isUnidir) {
        try {
            WriteStream out = this.getOutputStream();
            if (isUnidir) {
                out.write(55);
            } else {
                out.write(56);
            }
            out.write(0);
            out.write(1);
            boolean isAdmin = true;
            out.write(isAdmin ? 1 : 0);
            out.flush();
        }
        catch (IOException e) {
            throw new BamException(e);
        }
    }

    public String getDebugId() {
        return this._debugId;
    }

    public void clearRecycle() {
        this._pool.clearRecycle();
    }

    public void free(long idleStartTime) {
        if (this._is == null) {
            IllegalStateException exn = new IllegalStateException(L.l("{0} unexpected free of closed stream", (Object)this));
            exn.fillInStackTrace();
            log.log(Level.FINE, exn.toString(), exn);
            return;
        }
        long requestStartTime = this._requestStartTime;
        this._requestStartTime = 0L;
        if (requestStartTime > 0L) {
            this._requestTimeProbe.end(requestStartTime);
        }
        if (idleStartTime <= 0L && (idleStartTime = this._is.getReadTime()) <= 0L) {
            idleStartTime = CurrentTime.getCurrentTime();
        }
        this._idleStartTime = idleStartTime;
        this._idleProbe.start();
        this._isIdle = true;
        this._pool.free(this);
    }

    public void toActive() {
        if (this._isIdle) {
            this._isIdle = false;
            this._idleProbe.end();
        }
        this._requestStartTime = this._requestTimeProbe.start();
    }

    public boolean isClosed() {
        return this._is == null;
    }

    public void close() {
        if (this._is != null) {
            this._pool.close(this);
        }
        this.closeImpl();
    }

    void closeImpl() {
        ReadStream is = this._is;
        this._is = null;
        WriteStream os = this._os;
        this._os = null;
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
        if (is != null) {
            this._connProbe.end();
            if (this._requestStartTime > 0L) {
                this._requestTimeProbe.end(this._requestStartTime);
            }
            if (this._isIdle) {
                this._idleProbe.end();
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._debugId + "]";
    }
}

