/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.network.balance;

import com.caucho.env.meter.ActiveMeter;
import com.caucho.env.meter.ActiveTimeMeter;
import com.caucho.env.meter.CountMeter;
import com.caucho.env.meter.MeterService;
import com.caucho.network.balance.ClientSocket;
import com.caucho.network.balance.ClientSocketFactoryApi;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.ReadWritePair;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClientSocketFactory
implements ClientSocketFactoryApi {
    private static final Logger log = Logger.getLogger(ClientSocketFactory.class.getName());
    private static final L10N L = new L10N(ClientSocketFactory.class);
    private static final int WARMUP_MAX = 16;
    private static final int WARMUP_MIN = -16;
    private static final int[] WARMUP_CONNECTION_MAX = new int[]{1, 1, 1, 1, 2, 2, 2, 2, 4, 4, 8, 8, 16, 32, 64, 128};
    private final String _sourceId;
    private final String _targetId;
    private final String _address;
    private final int _port;
    private final boolean _isSecure;
    private String _debugId;
    private String _statCategory;
    private String _statId;
    private Path _tcpPath;
    private boolean _isHeartbeatServer;
    private int _maxConnections = 0x3FFFFFFF;
    private long _loadBalanceConnectTimeout = 5000L;
    private long _loadBalanceConnectionMin = 0L;
    private long _loadBalanceSocketTimeout = 30000L;
    private long _loadBalanceIdleTime = 10000L;
    private long _loadBalanceRecoverTime = 15000L;
    private long _loadBalanceWarmupTime = 60000L;
    private int _loadBalanceWeight = 100;
    private ClientSocket[] _idle = new ClientSocket[64];
    private volatile int _idleHead;
    private volatile int _idleTail;
    private int _idleSize = 16;
    private int _streamCount;
    private long _warmupChunkTime;
    private long _failChunkTime;
    private volatile State _state = State.NEW;
    private volatile boolean _isHeartbeatActive;
    private final AtomicInteger _startSequenceId = new AtomicInteger();
    private final AtomicInteger _activeCount = new AtomicInteger();
    private final AtomicInteger _startingCount = new AtomicInteger();
    private final AtomicInteger _loadBalanceAllocateCount = new AtomicInteger();
    private volatile int _warmupState;
    private volatile int _currentFailCount;
    private volatile long _lastFailConnectTime;
    private volatile long _dynamicFailRecoverTime = 1000L;
    private volatile long _lastFailTime;
    private volatile long _lastBusyTime;
    private volatile long _failTime;
    private volatile long _firstSuccessTime;
    private volatile long _lastSuccessTime;
    private volatile long _prevSuccessTime;
    private volatile double _latencyFactor;
    private ActiveTimeMeter _requestTimeProbe;
    private ActiveMeter _connProbe;
    private ActiveMeter _idleProbe;
    private CountMeter _connFailProbe;
    private CountMeter _requestFailProbe;
    private CountMeter _requestBusyProbe;
    private volatile long _keepaliveCountTotal;
    private final AtomicLong _connectCountTotal = new AtomicLong();
    private final AtomicLong _failCountTotal = new AtomicLong();
    private volatile long _busyCountTotal;
    private volatile double _cpuLoadAvg;
    private volatile long _cpuSetTime;

    public ClientSocketFactory(String address, int port) {
        this(address, port, false);
    }

    public ClientSocketFactory(String address, int port, boolean isSecure) {
        this("client", address + ":" + port, null, null, address, port, isSecure);
    }

    public ClientSocketFactory(String sourceId, String targetId, String statCategory, String statId, String address, int port, boolean isSecure) {
        this._sourceId = sourceId;
        if ("".equals(targetId)) {
            targetId = "default";
        }
        this._targetId = targetId;
        this._debugId = this._sourceId + "->" + this._targetId;
        this._address = address;
        this._port = port;
        this._isSecure = isSecure;
        this._statCategory = statCategory;
        if (statId != null && !"".equals(statId) && !statId.startsWith("|")) {
            statId = "|" + statId;
        }
        this._statId = statId;
    }

    public String getId() {
        return this._targetId;
    }

    public String getDebugId() {
        return this._debugId;
    }

    public String getAddress() {
        return this._address;
    }

    public int getPort() {
        return this._port;
    }

    public void setHeartbeatServer(boolean isHeartbeatServer) {
        this._isHeartbeatServer = isHeartbeatServer;
    }

    public long getLoadBalanceConnectTimeout() {
        return this._loadBalanceConnectTimeout;
    }

    public void setLoadBalanceConnectTimeout(long timeout) {
        this._loadBalanceConnectTimeout = timeout;
    }

    public long getLoadBalanceConnectionMin() {
        return this._loadBalanceConnectionMin;
    }

    public void setLoadBalanceConnectionMin(int connectionMin) {
        this._loadBalanceConnectionMin = connectionMin;
    }

    public long getLoadBalanceSocketTimeout() {
        return this._loadBalanceSocketTimeout;
    }

    public void setLoadBalanceSocketTimeout(long timeout) {
        this._loadBalanceSocketTimeout = timeout;
    }

    public long getLoadBalanceIdleTime() {
        return this._loadBalanceIdleTime;
    }

    public void setLoadBalanceIdleTime(long timeout) {
        this._loadBalanceIdleTime = timeout;
    }

    public void setLoadBalanceRecoverTime(long timeout) {
        this._loadBalanceRecoverTime = timeout;
    }

    public long getLoadBalanceRecoverTime() {
        return this._loadBalanceRecoverTime;
    }

    public void setLoadBalanceWarmupTime(long timeout) {
        this._loadBalanceWarmupTime = timeout;
    }

    public int getLoadBalanceWeight() {
        return this._loadBalanceWeight;
    }

    public void setLoadBalanceWeight(int weight) {
        this._loadBalanceWeight = weight;
    }

    public int getStartSequenceId() {
        return this._startSequenceId.get();
    }

    public void init() {
        String address;
        this._warmupChunkTime = this._loadBalanceWarmupTime / 16L;
        if (this._warmupChunkTime <= 0L) {
            this._warmupChunkTime = 1L;
        }
        this._failChunkTime = this._loadBalanceRecoverTime / 16L;
        if (this._failChunkTime <= 0L) {
            this._failChunkTime = 1L;
        }
        if ((address = this.getAddress()) == null) {
            address = "localhost";
        }
        HashMap<String, Object> attr = new HashMap<String, Object>();
        attr.put("connect-timeout", this._loadBalanceConnectTimeout);
        attr.put("socket-timeout", this._loadBalanceSocketTimeout);
        attr.put("no-delay", true);
        this._tcpPath = this._isSecure ? Vfs.lookup("tcps://" + address + ":" + this._port, attr) : Vfs.lookup("tcp://" + address + ":" + this._port, attr);
        this._state = State.STARTING;
    }

    public int getActiveCount() {
        return this._activeCount.get();
    }

    public int getIdleCount() {
        return (this._idleHead - this._idleTail + this._idle.length) % this._idle.length;
    }

    public int getLoadBalanceAllocateCount() {
        return this._loadBalanceAllocateCount.get();
    }

    public void allocateLoadBalance() {
        this._loadBalanceAllocateCount.incrementAndGet();
    }

    public void freeLoadBalance() {
        this._loadBalanceAllocateCount.decrementAndGet();
    }

    public long getConnectCountTotal() {
        return this._connectCountTotal.get();
    }

    public long getKeepaliveCountTotal() {
        return this._keepaliveCountTotal;
    }

    public long getFailCountTotal() {
        return this._failCountTotal.get();
    }

    public Date getLastFailTime() {
        return new Date(this._lastFailTime);
    }

    public Date getLastFailConnectTime() {
        return new Date(this._lastFailConnectTime);
    }

    public long getLastSuccessTime() {
        return this._lastSuccessTime;
    }

    public double getLatencyFactor() {
        long decayPeriod = 60000L;
        long now = CurrentTime.getCurrentTime();
        long delta = decayPeriod - (now - this._lastSuccessTime);
        if (delta <= 0L) {
            return 0.0;
        }
        return this._latencyFactor * (double)delta / (double)decayPeriod;
    }

    public long getBusyCountTotal() {
        return this._busyCountTotal;
    }

    public Date getLastBusyTime() {
        return new Date(this._lastBusyTime);
    }

    public void setCpuLoadAvg(double load) {
        this._cpuSetTime = CurrentTime.getCurrentTime();
        this._cpuLoadAvg = load;
    }

    public double getCpuLoadAvg() {
        double avg = this._cpuLoadAvg;
        long time = this._cpuSetTime;
        long now = CurrentTime.getCurrentTime();
        if (now - time < 10000L) {
            return avg;
        }
        return avg * 10000.0 / (double)(now - time);
    }

    public final boolean isActive() {
        return this._state.isLive();
    }

    public final boolean isHeartbeatActive() {
        return this._isHeartbeatActive;
    }

    public boolean isDead() {
        return !this.isActive();
    }

    public boolean isFailed(long now) {
        if (now <= this._failTime + this._dynamicFailRecoverTime) {
            if (this._failTime <= this._lastFailConnectTime) {
                this.logFinest("isFailed TRUE: prior connect failure");
                return true;
            }
            if (this._lastSuccessTime <= this._failTime) {
                this.logFinest("isFailed TRUE: prior read failure with no recent successes");
                return true;
            }
            this.logFinest("isFailed FALSE: because there were recent successes");
        } else if (this._failTime > 0L) {
            this.logFinest(L.l("isFailed FALSE: not in window ({0} < {1} + {2})", (Object)now, (Object)this._failTime, (Object)this._dynamicFailRecoverTime));
        }
        return false;
    }

    private void logFinest(String msg) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this.getDebugId() + " " + msg);
        }
    }

    public boolean isBusy(long now) {
        return now < this._lastBusyTime + this._dynamicFailRecoverTime;
    }

    public void enable() {
        this.start();
    }

    public void disable() {
        this.stop();
    }

    public String getState() {
        this.updateWarmup();
        return String.valueOf((Object)this._state);
    }

    public boolean canOpen() {
        if (this.getIdleCount() > 0) {
            return true;
        }
        State state = this._state;
        if (state == State.ACTIVE) {
            return true;
        }
        if (!state.isEnabled()) {
            return false;
        }
        long now = CurrentTime.getCurrentTime();
        return !this.isFailed(now);
    }

    public boolean canOpenWarmOrRecycle() {
        return this.getIdleCount() > 0 || this.canOpenWarm();
    }

    public boolean canOpenWarm() {
        State state = this._state;
        if (state == State.ACTIVE) {
            return true;
        }
        if (state.isEnabled()) {
            long now = CurrentTime.getCurrentTime();
            if (this.isFailed(now)) {
                return false;
            }
            long firstSuccessTime = this._firstSuccessTime;
            int warmupState = 0;
            if (firstSuccessTime > 0L) {
                warmupState = (int)((now - firstSuccessTime) / this._warmupChunkTime);
            }
            if ((warmupState -= this._currentFailCount) < 0) {
                return this._failTime - (long)warmupState * this._failChunkTime < now;
            }
            if (16 <= warmupState) {
                return true;
            }
            int connectionMax = WARMUP_CONNECTION_MAX[warmupState];
            int idleCount = this.getIdleCount();
            int activeCount = this._activeCount.get() + this._startingCount.get();
            int totalCount = activeCount + idleCount;
            return totalCount < connectionMax;
        }
        return false;
    }

    public boolean isEnabled() {
        return this._state.isEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toBusy() {
        this._lastBusyTime = CurrentTime.getCurrentTime();
        this._firstSuccessTime = 0L;
        this._requestBusyProbe.start();
        ClientSocketFactory clientSocketFactory = this;
        synchronized (clientSocketFactory) {
            ++this._busyCountTotal;
            this._state = this._state.toBusy();
        }
    }

    public void toFail() {
        this._lastFailTime = this._failTime = CurrentTime.getCurrentTime();
        this._firstSuccessTime = 0L;
        this.getRequestFailProbe().start();
        this._failCountTotal.incrementAndGet();
        this._state = this._state.toFail();
        this.clearRecycle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failSocket(long time) {
        this.getRequestFailProbe().start();
        this._failCountTotal.incrementAndGet();
        this.logFinest(L.l("failSocket: time={0}, _failTime={1}", (Object)time, (Object)this._failTime));
        ClientSocketFactory clientSocketFactory = this;
        synchronized (clientSocketFactory) {
            if (time > this._failTime) {
                this.degrade(time);
                this._firstSuccessTime = 0L;
                this._lastFailTime = this._failTime = time;
                this._dynamicFailRecoverTime *= 2L;
                if (this._loadBalanceRecoverTime < this._dynamicFailRecoverTime) {
                    this._dynamicFailRecoverTime = this._loadBalanceRecoverTime;
                }
                this._state = this._state.toFail();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failConnect(long time) {
        this.getConnectionFailProbe().start();
        this._failCountTotal.incrementAndGet();
        this.logFinest(L.l("failConnect: time={0}, _failTime={1}", (Object)time, (Object)this._failTime));
        ClientSocketFactory clientSocketFactory = this;
        synchronized (clientSocketFactory) {
            if (time > this._failTime) {
                this.degrade(time);
                this._firstSuccessTime = 0L;
                this._failTime = time;
                this._lastFailTime = time;
                this._lastFailConnectTime = time;
                this._dynamicFailRecoverTime *= 2L;
                if (this._loadBalanceRecoverTime < this._dynamicFailRecoverTime) {
                    this._dynamicFailRecoverTime = this._loadBalanceRecoverTime;
                }
                this._state = this._state.toFail();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void busy(long time) {
        this.getRequestBusyProbe().start();
        ClientSocketFactory clientSocketFactory = this;
        synchronized (clientSocketFactory) {
            this.degrade(time);
            this._lastBusyTime = time;
            this._firstSuccessTime = 0L;
            ++this._currentFailCount;
            ++this._busyCountTotal;
            this._state = this._state.toBusy();
        }
    }

    private void degrade(long time) {
        if (time - this._failTime >= 100L) {
            ++this._currentFailCount;
            --this._warmupState;
            if (this._warmupState < -16) {
                this._warmupState = -16;
            }
        }
    }

    public void success() {
        this._currentFailCount = 0;
        long now = CurrentTime.getCurrentTime();
        if (this._firstSuccessTime <= 0L) {
            this._firstSuccessTime = now;
        }
        this._dynamicFailRecoverTime = 1000L;
    }

    public void start() {
        this._state = this._state.toStart();
    }

    public void stop() {
        this._state = this._state.toStandby();
        this._firstSuccessTime = 0L;
        this._startSequenceId.incrementAndGet();
        this.clearRecycle();
    }

    public void enableSessionOnly() {
        this._state = this._state.toSessionOnly();
    }

    public ClientSocket openWarm() {
        State state = this._state;
        if (!state.isEnabled()) {
            return null;
        }
        ClientSocket stream = this.openRecycle();
        if (stream != null) {
            return stream;
        }
        if (this.canOpenWarm()) {
            return this.connect();
        }
        return null;
    }

    public ClientSocket openIfLive() {
        if (this._state.isClosed()) {
            return null;
        }
        ClientSocket stream = this.openRecycle();
        if (stream != null) {
            return stream;
        }
        long now = CurrentTime.getCurrentTime();
        if (this.isFailed(now)) {
            return null;
        }
        if (this._state == State.FAIL && this._startingCount.get() > 0) {
            return null;
        }
        return this.connect();
    }

    public ClientSocket openIfHeartbeatActive() {
        if (this._state.isClosed()) {
            return null;
        }
        if (!this._isHeartbeatActive && this._isHeartbeatServer) {
            return null;
        }
        ClientSocket stream = this.openRecycle();
        if (stream != null) {
            return stream;
        }
        return this.connect();
    }

    public ClientSocket openSticky() {
        State state = this._state;
        if (!state.isSessionEnabled()) {
            return null;
        }
        ClientSocket stream = this.openRecycle();
        if (stream != null) {
            return stream;
        }
        long now = CurrentTime.getCurrentTime();
        if (this.isFailed(now)) {
            return null;
        }
        if (this.isBusy(now)) {
            return null;
        }
        return this.connect();
    }

    public ClientSocket open() {
        State state = this._state;
        if (!state.isInit()) {
            return null;
        }
        ClientSocket stream = this.openRecycle();
        if (stream != null) {
            return stream;
        }
        return this.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientSocket openRecycle() {
        long now = CurrentTime.getCurrentTime();
        ClientSocket stream = null;
        ClientSocketFactory clientSocketFactory = this;
        synchronized (clientSocketFactory) {
            if (this._idleHead != this._idleTail) {
                stream = this._idle[this._idleHead];
                long freeTime = stream.getIdleStartTime();
                this._idle[this._idleHead] = null;
                this._idleHead = (this._idleHead + this._idle.length - 1) % this._idle.length;
                if (now < freeTime + this._loadBalanceIdleTime) {
                    this._activeCount.incrementAndGet();
                    ++this._keepaliveCountTotal;
                    stream.clearIdleStartTime();
                    stream.toActive();
                    return stream;
                }
            }
        }
        if (stream != null) {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this + " close idle " + stream + " expire=" + QDate.formatISO8601(stream.getIdleStartTime() + this._loadBalanceIdleTime));
            }
            stream.closeImpl();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientSocket connect() {
        if (this._maxConnections <= this._activeCount.get() + this._startingCount.get()) {
            if (log.isLoggable(Level.WARNING)) {
                log.warning(this + " connect exceeded max-connections" + "\n  max-connections=" + this._maxConnections + "\n  activeCount=" + this._activeCount.get() + "\n  startingCount=" + this._startingCount.get());
            }
            return null;
        }
        this._startingCount.incrementAndGet();
        State state = this._state;
        if (!state.isInit()) {
            this._startingCount.decrementAndGet();
            IllegalStateException e = new IllegalStateException(L.l("'{0}' connection cannot be opened because the server pool has not been started.", (Object)this));
            log.log(Level.WARNING, e.toString(), e);
            throw e;
        }
        if (this.getPort() <= 0) {
            return null;
        }
        long connectionStartTime = CurrentTime.getCurrentTime();
        try {
            ReadWritePair pair = this.openTCPPair();
            ReadStream rs = pair.getReadStream();
            rs.setEnableReadTime(true);
            rs.setAttribute("timeout", new Integer((int)this._loadBalanceSocketTimeout));
            this._activeCount.incrementAndGet();
            this._connectCountTotal.incrementAndGet();
            ClientSocket stream = new ClientSocket(this, this._streamCount++, rs, pair.getWriteStream());
            if (log.isLoggable(Level.FINER)) {
                log.finer("connect " + stream);
            }
            if (this._firstSuccessTime <= 0L) {
                if (this._state.isStarting()) {
                    this._state = this._loadBalanceWarmupTime > 0L ? State.WARMUP : State.ACTIVE;
                    this._firstSuccessTime = CurrentTime.getCurrentTime();
                }
                if (this._warmupState < 0) {
                    this._warmupState = 0;
                }
            }
            ClientSocket clientSocket = stream;
            return clientSocket;
        }
        catch (IOException e) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, this + " " + e.toString(), e);
            } else {
                log.finer(this + " " + e.toString());
            }
            this.failConnect(connectionStartTime);
            ClientSocket clientSocket = null;
            return clientSocket;
        }
        finally {
            this._startingCount.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wake() {
        ClientSocketFactory clientSocketFactory = this;
        synchronized (clientSocketFactory) {
            if (this._state == State.FAIL) {
                this._state = State.STARTING;
            }
            this._failTime = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void free(ClientSocket stream) {
        this.success();
        this._activeCount.decrementAndGet();
        ClientSocketFactory clientSocketFactory = this;
        synchronized (clientSocketFactory) {
            int size = (this._idleHead - this._idleTail + this._idle.length) % this._idle.length;
            if (this._state != State.CLOSED && size < this._idleSize) {
                this._idleHead = (this._idleHead + 1) % this._idle.length;
                this._idle[this._idleHead] = stream;
                stream = null;
            }
            long now = CurrentTime.getCurrentTime();
            long prevSuccessTime = this._prevSuccessTime;
            if (prevSuccessTime > 0L) {
                this._latencyFactor = 0.95 * this._latencyFactor + 0.05 * (double)(now - prevSuccessTime);
            }
            this._prevSuccessTime = this._activeCount.get() > 0 ? now : 0L;
            this._lastSuccessTime = now;
            this.logFinest(L.l("free: _lastSuccessTime={0}, _failTime={1}", (Object)now, (Object)this._failTime));
        }
        this.updateWarmup();
        long now = CurrentTime.getCurrentTime();
        long maxIdleTime = this._loadBalanceIdleTime;
        ClientSocket oldStream = null;
        do {
            oldStream = null;
            ClientSocketFactory clientSocketFactory2 = this;
            synchronized (clientSocketFactory2) {
                if (this._idleHead != this._idleTail) {
                    int nextTail = (this._idleTail + 1) % this._idle.length;
                    oldStream = this._idle[nextTail];
                    if (oldStream != null && oldStream.getIdleStartTime() + maxIdleTime < now) {
                        this._idle[nextTail] = null;
                        this._idleTail = nextTail;
                    } else {
                        oldStream = null;
                    }
                }
            }
            if (oldStream == null) continue;
            oldStream.closeImpl();
        } while (oldStream != null);
        if (stream != null) {
            stream.closeImpl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateWarmup() {
        ClientSocketFactory clientSocketFactory = this;
        synchronized (clientSocketFactory) {
            if (!this.isEnabled()) {
                return;
            }
            long now = CurrentTime.getCurrentTime();
            int warmupState = this._warmupState;
            if (warmupState >= 0 && this._firstSuccessTime > 0L) {
                warmupState = (int)((now - this._firstSuccessTime) / this._warmupChunkTime);
                this._dynamicFailRecoverTime = 1000L;
                if (16 <= warmupState) {
                    warmupState = 16;
                    this._state = this._state.toActive();
                }
            }
            this._warmupState = warmupState;
        }
    }

    void close(ClientSocket stream) {
        if (log.isLoggable(Level.FINER)) {
            log.finer("close " + stream);
        }
        this._activeCount.decrementAndGet();
    }

    public void notifyHeartbeatStart() {
        this._isHeartbeatActive = true;
        this.clearRecycle();
        this.wake();
    }

    public void notifyHeartbeatStop() {
        this._isHeartbeatActive = false;
        this._startSequenceId.incrementAndGet();
        this.clearRecycle();
        this.toFail();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRecycle() {
        ArrayList<ClientSocket> recycleList = null;
        ClientSocketFactory clientSocketFactory = this;
        synchronized (clientSocketFactory) {
            this._idleTail = 0;
            this._idleHead = 0;
            for (int i = 0; i < this._idle.length; ++i) {
                ClientSocket stream = this._idle[i];
                this._idle[i] = null;
                if (stream == null) continue;
                if (recycleList == null) {
                    recycleList = new ArrayList<ClientSocket>();
                }
                recycleList.add(stream);
            }
        }
        if (recycleList != null) {
            for (ClientSocket stream : recycleList) {
                stream.closeImpl();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ClientSocketFactory clientSocketFactory = this;
        synchronized (clientSocketFactory) {
            if (this._state == State.CLOSED) {
                return;
            }
            this._state = State.CLOSED;
        }
        clientSocketFactory = this;
        synchronized (clientSocketFactory) {
            this._idleTail = 0;
            this._idleHead = 0;
        }
        for (int i = 0; i < this._idle.length; ++i) {
            ClientSocket stream;
            ClientSocketFactory clientSocketFactory2 = this;
            synchronized (clientSocketFactory2) {
                stream = this._idle[i];
                this._idle[i] = null;
            }
            if (stream == null) continue;
            stream.closeImpl();
        }
    }

    ReadWritePair openTCPPair() throws IOException {
        return this._tcpPath.openReadWrite();
    }

    public boolean canConnect() {
        try {
            this.wake();
            ClientSocket stream = this.open();
            if (stream != null) {
                stream.free(stream.getIdleStartTime());
                return true;
            }
            return false;
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
            return false;
        }
    }

    public ActiveMeter getConnectionProbe() {
        if (this._connProbe == null) {
            this._connProbe = MeterService.createActiveMeter(this._statCategory + "|Connection", this._statId);
        }
        return this._connProbe;
    }

    public CountMeter getConnectionFailProbe() {
        if (this._connFailProbe == null) {
            String name = this._statCategory + "|Connection Fail|" + this._statId;
            this._connFailProbe = MeterService.createCountMeter(name);
        }
        return this._connFailProbe;
    }

    public ActiveTimeMeter getRequestTimeProbe() {
        if (this._requestTimeProbe == null) {
            this._requestTimeProbe = MeterService.createActiveTimeMeter(this._statCategory + "|Request", "Time", this._statId);
        }
        return this._requestTimeProbe;
    }

    public CountMeter getRequestFailProbe() {
        if (this._requestFailProbe == null) {
            String name = this._statCategory + "|Request Fail" + this._statId;
            this._requestFailProbe = MeterService.createCountMeter(name);
        }
        return this._requestFailProbe;
    }

    public CountMeter getRequestBusyProbe() {
        if (this._requestBusyProbe == null) {
            String name = this._statCategory + "|Request Busy" + this._statId;
            this._requestBusyProbe = MeterService.createCountMeter(name);
        }
        return this._requestBusyProbe;
    }

    public ActiveMeter getIdleProbe() {
        if (this._idleProbe == null) {
            this._idleProbe = MeterService.createActiveMeter(this._statCategory + "|Idle", this._statId);
        }
        return this._idleProbe;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getDebugId() + "," + this._address + ":" + this._port + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        NEW{

            boolean isInit() {
                return false;
            }

            boolean isEnabled() {
                return false;
            }

            boolean isSessionEnabled() {
                return false;
            }
        }
        ,
        STANDBY{

            boolean isEnabled() {
                return false;
            }

            boolean isSessionEnabled() {
                return false;
            }

            State toActive() {
                return this;
            }

            State toFail() {
                return this;
            }

            State toBusy() {
                return this;
            }

            State toSessionOnly() {
                return this;
            }
        }
        ,
        SESSION_ONLY{

            boolean isEnabled() {
                return false;
            }

            State toFail() {
                return this;
            }

            State toBusy() {
                return this;
            }
        }
        ,
        STARTING{

            boolean isStarting() {
                return true;
            }

            boolean isLive() {
                return true;
            }
        }
        ,
        WARMUP{

            boolean isStarting() {
                return true;
            }

            boolean isLive() {
                return true;
            }

            State toStart() {
                return this;
            }
        }
        ,
        BUSY{

            boolean isStarting() {
                return true;
            }
        }
        ,
        FAIL{

            boolean isStarting() {
                return true;
            }

            boolean isLive() {
                return false;
            }
        }
        ,
        ACTIVE{

            boolean isLive() {
                return true;
            }

            State toStart() {
                return this;
            }
        }
        ,
        CLOSED{

            boolean isInit() {
                return false;
            }

            boolean isClosed() {
                return true;
            }

            boolean isSessionEnabled() {
                return false;
            }

            boolean isEnabled() {
                return false;
            }

            boolean isLive() {
                return false;
            }

            State toStart() {
                return this;
            }

            State toActive() {
                return this;
            }

            State toBusy() {
                return this;
            }

            State toFail() {
                return this;
            }

            State toStandby() {
                return this;
            }

            State toSessionOnly() {
                return this;
            }
        };


        boolean isInit() {
            return true;
        }

        boolean isClosed() {
            return false;
        }

        boolean isStarting() {
            return false;
        }

        boolean isLive() {
            return false;
        }

        boolean isSessionEnabled() {
            return true;
        }

        boolean isEnabled() {
            return true;
        }

        State toStart() {
            return STARTING;
        }

        State toActive() {
            return ACTIVE;
        }

        State toFail() {
            return FAIL;
        }

        State toBusy() {
            return BUSY;
        }

        State toStandby() {
            return STANDBY;
        }

        State toSessionOnly() {
            return SESSION_ONLY;
        }
    }
}

