/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.network.listen;

import com.caucho.inject.Module;
import com.caucho.network.listen.TcpSocketLink;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
enum SocketLinkState {
    INIT{

        boolean isAllowIdle() {
            return true;
        }

        SocketLinkState toInit(TcpSocketLink conn) {
            return INIT;
        }

        SocketLinkState toIdle() {
            return IDLE;
        }

        SocketLinkState toAccept() {
            return ACCEPT;
        }
    }
    ,
    ACCEPT{

        boolean isActive() {
            return true;
        }

        SocketLinkState toActiveWithKeepalive(TcpSocketLink conn) {
            conn.getPort().keepaliveAllocate();
            return REQUEST_ACTIVE_KA;
        }

        SocketLinkState toActiveNoKeepalive(TcpSocketLink conn) {
            return REQUEST_ACTIVE_NKA;
        }
    }
    ,
    REQUEST_ACTIVE_KA{

        boolean isActive() {
            return true;
        }

        boolean isRequestActive() {
            return true;
        }

        boolean isKeepaliveAllocated() {
            return true;
        }

        SocketLinkState toActiveWithKeepalive(TcpSocketLink conn) {
            return REQUEST_ACTIVE_KA;
        }

        SocketLinkState toActiveNoKeepalive(TcpSocketLink conn) {
            conn.getPort().keepaliveFree();
            return REQUEST_ACTIVE_NKA;
        }

        SocketLinkState toKillKeepalive(TcpSocketLink conn) {
            conn.getPort().keepaliveFree();
            return REQUEST_ACTIVE_NKA;
        }

        SocketLinkState toKeepalive(TcpSocketLink conn) {
            return KEEPALIVE_THREAD;
        }

        SocketLinkState toComet() {
            return COMET_KA;
        }

        SocketLinkState toDuplex(TcpSocketLink conn) {
            conn.getPort().keepaliveFree();
            return DUPLEX;
        }

        SocketLinkState toClosed(TcpSocketLink conn) {
            conn.getPort().keepaliveFree();
            return CLOSED;
        }
    }
    ,
    REQUEST_ACTIVE_NKA{

        boolean isActive() {
            return true;
        }

        SocketLinkState toComet() {
            return COMET_NKA;
        }

        SocketLinkState toDuplex(TcpSocketLink conn) {
            return DUPLEX;
        }
    }
    ,
    KEEPALIVE_THREAD{

        boolean isKeepalive() {
            return true;
        }

        boolean isKeepaliveAllocated() {
            return true;
        }

        SocketLinkState toActiveWithKeepalive(TcpSocketLink conn) {
            return REQUEST_ACTIVE_KA;
        }

        SocketLinkState toActiveNoKeepalive(TcpSocketLink conn) {
            conn.getPort().keepaliveFree();
            return REQUEST_ACTIVE_NKA;
        }

        SocketLinkState toKeepaliveSelect() {
            return KEEPALIVE_SELECT;
        }

        SocketLinkState toClosed(TcpSocketLink conn) {
            conn.getPort().keepaliveFree();
            return CLOSED;
        }
    }
    ,
    KEEPALIVE_SELECT{

        boolean isKeepalive() {
            return true;
        }

        boolean isKeepaliveAllocated() {
            return true;
        }

        SocketLinkState toActiveWithKeepalive(TcpSocketLink conn) {
            return REQUEST_ACTIVE_KA;
        }

        SocketLinkState toActiveNoKeepalive(TcpSocketLink conn) {
            conn.getPort().keepaliveFree();
            return REQUEST_ACTIVE_NKA;
        }

        SocketLinkState toClosed(TcpSocketLink conn) {
            conn.getPort().keepaliveFree();
            return CLOSED;
        }
    }
    ,
    COMET_KA{

        boolean isComet() {
            return true;
        }

        boolean isCometActive() {
            return true;
        }

        boolean isAsyncStarted() {
            return true;
        }

        boolean isKeepaliveAllocated() {
            return true;
        }

        SocketLinkState toCometSuspend(TcpSocketLink conn) {
            conn.getPort().cometSuspend(conn);
            return COMET_SUSPEND_KA;
        }

        SocketLinkState toCometComplete() {
            return COMET_COMPLETE_KA;
        }

        SocketLinkState toKillKeepalive(TcpSocketLink conn) {
            conn.getPort().keepaliveFree();
            return COMET_NKA;
        }

        SocketLinkState toClosed(TcpSocketLink conn) {
            conn.getPort().keepaliveFree();
            return CLOSED;
        }
    }
    ,
    COMET_NKA{

        boolean isComet() {
            return true;
        }

        boolean isCometActive() {
            return true;
        }

        boolean isAsyncStarted() {
            return true;
        }

        SocketLinkState toCometSuspend(TcpSocketLink conn) {
            conn.getPort().cometSuspend(conn);
            return COMET_SUSPEND_NKA;
        }

        SocketLinkState toCometComplete() {
            return COMET_COMPLETE_NKA;
        }
    }
    ,
    COMET_SUSPEND_KA{

        boolean isComet() {
            return true;
        }

        boolean isCometSuspend() {
            return true;
        }

        boolean isAsyncStarted() {
            return true;
        }

        boolean isKeepaliveAllocated() {
            return true;
        }

        SocketLinkState toKillKeepalive(TcpSocketLink conn) {
            conn.getPort().keepaliveFree();
            return COMET_SUSPEND_NKA;
        }

        SocketLinkState toCometResume(TcpSocketLink conn) {
            conn.getPort().cometDetach(conn);
            return REQUEST_ACTIVE_KA;
        }

        SocketLinkState toClosed(TcpSocketLink conn) {
            conn.getPort().cometDetach(conn);
            throw new IllegalStateException((Object)((Object)this) + " " + conn);
        }

        SocketLinkState toDestroy(TcpSocketLink conn) {
            conn.getPort().cometDetach(conn);
            throw new IllegalStateException((Object)((Object)this) + " " + conn);
        }
    }
    ,
    COMET_SUSPEND_NKA{

        boolean isComet() {
            return true;
        }

        boolean isCometSuspend() {
            return true;
        }

        boolean isAsyncStarted() {
            return true;
        }

        SocketLinkState toCometResume(TcpSocketLink conn) {
            conn.getPort().cometDetach(conn);
            return REQUEST_ACTIVE_NKA;
        }

        SocketLinkState toClosed(TcpSocketLink conn) {
            conn.getPort().cometDetach(conn);
            throw new IllegalStateException((Object)((Object)this) + " " + conn);
        }

        SocketLinkState toDestroy(TcpSocketLink conn) {
            conn.getPort().cometDetach(conn);
            throw new IllegalStateException((Object)((Object)this) + " " + conn);
        }
    }
    ,
    COMET_COMPLETE_KA{

        boolean isComet() {
            return true;
        }

        boolean isCometComplete() {
            return true;
        }

        boolean isKeepaliveAllocated() {
            return true;
        }

        SocketLinkState toActiveWithKeepalive(TcpSocketLink conn) {
            return REQUEST_ACTIVE_KA;
        }

        SocketLinkState toActiveNoKeepalive(TcpSocketLink conn) {
            conn.getPort().keepaliveFree();
            return REQUEST_ACTIVE_NKA;
        }

        SocketLinkState toKillKeepalive(TcpSocketLink conn) {
            conn.getPort().keepaliveFree();
            return COMET_COMPLETE_NKA;
        }

        SocketLinkState toCometComplete() {
            return this;
        }

        SocketLinkState toKeepalive(TcpSocketLink conn) {
            return KEEPALIVE_THREAD;
        }

        SocketLinkState toClosed(TcpSocketLink conn) {
            conn.getPort().keepaliveFree();
            return CLOSED;
        }
    }
    ,
    COMET_COMPLETE_NKA{

        boolean isComet() {
            return true;
        }

        boolean isCometComplete() {
            return true;
        }

        SocketLinkState toCometComplete() {
            return this;
        }
    }
    ,
    DUPLEX{

        boolean isDuplex() {
            return true;
        }

        SocketLinkState toKeepalive(TcpSocketLink conn) {
            conn.getPort().duplexKeepaliveBegin();
            return DUPLEX_KEEPALIVE;
        }

        SocketLinkState toDuplexActive(TcpSocketLink conn) {
            return DUPLEX;
        }
    }
    ,
    DUPLEX_KEEPALIVE{

        boolean isDuplex() {
            return true;
        }

        boolean isKeepalive() {
            return true;
        }

        SocketLinkState toKeepaliveSelect() {
            return DUPLEX_KEEPALIVE;
        }

        SocketLinkState toDuplexActive(TcpSocketLink conn) {
            conn.getPort().duplexKeepaliveEnd();
            return DUPLEX;
        }

        SocketLinkState toClosed(TcpSocketLink conn) {
            conn.getPort().duplexKeepaliveEnd();
            return CLOSED;
        }
    }
    ,
    CLOSED{

        boolean isClosed() {
            return true;
        }

        boolean isAllowIdle() {
            return true;
        }

        SocketLinkState toAccept() {
            return ACCEPT;
        }

        SocketLinkState toIdle() {
            return IDLE;
        }
    }
    ,
    IDLE{

        boolean isIdle() {
            return true;
        }

        SocketLinkState toInit(TcpSocketLink conn) {
            return INIT;
        }

        SocketLinkState toAccept() {
            return ACCEPT;
        }

        SocketLinkState toFree(TcpSocketLink conn) {
            return this;
        }

        SocketLinkState toDestroy(TcpSocketLink conn) {
            throw new IllegalStateException((Object)((Object)this) + " is an illegal destroy state");
        }
    }
    ,
    DESTROYED{

        boolean isClosed() {
            return true;
        }

        boolean isDestroyed() {
            return true;
        }

        SocketLinkState toClosed(TcpSocketLink conn) {
            return this;
        }

        SocketLinkState toDestroy(TcpSocketLink conn) {
            return this;
        }
    };

    private static final Logger log;

    boolean isIdle() {
        return false;
    }

    boolean isComet() {
        return false;
    }

    boolean isCometActive() {
        return false;
    }

    boolean isCometSuspend() {
        return false;
    }

    boolean isCometWake() {
        return false;
    }

    boolean isAsyncStarted() {
        return false;
    }

    boolean isCometComplete() {
        return false;
    }

    boolean isDuplex() {
        return false;
    }

    boolean isKeepaliveAllocated() {
        return false;
    }

    boolean isKeepalive() {
        return false;
    }

    boolean isActive() {
        return false;
    }

    boolean isRequestActive() {
        return false;
    }

    boolean isClosed() {
        return false;
    }

    boolean isDestroyed() {
        return false;
    }

    boolean isAllowIdle() {
        return false;
    }

    SocketLinkState toInit(TcpSocketLink conn) {
        throw new IllegalStateException((Object)((Object)this) + " cannot switch to init for " + conn);
    }

    SocketLinkState toAccept() {
        throw new IllegalStateException((Object)((Object)this) + " cannot switch to accept");
    }

    SocketLinkState toActive(TcpSocketLink conn, long connectionStartTime) {
        if (conn.getPort().isKeepaliveAllowed(connectionStartTime)) {
            return this.toActiveWithKeepalive(conn);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(conn + " keepalive disallowed");
        }
        return this.toActiveNoKeepalive(conn);
    }

    SocketLinkState toActiveWithKeepalive(TcpSocketLink conn) {
        throw new IllegalStateException((Object)((Object)this) + " cannot switch to active");
    }

    SocketLinkState toActiveNoKeepalive(TcpSocketLink conn) {
        throw new IllegalStateException((Object)((Object)this) + " cannot switch to active");
    }

    SocketLinkState toKillKeepalive(TcpSocketLink conn) {
        return this;
    }

    SocketLinkState toKeepalive(TcpSocketLink conn) {
        throw new IllegalStateException((Object)((Object)this) + " cannot switch to keepalive");
    }

    SocketLinkState toKeepaliveSelect() {
        throw new IllegalStateException((Object)((Object)this) + " cannot switch to keepalive select");
    }

    SocketLinkState toComet() {
        throw new IllegalStateException((Object)((Object)this) + " cannot switch to comet");
    }

    SocketLinkState toCometSuspend(TcpSocketLink conn) {
        throw new IllegalStateException((Object)((Object)this) + " cannot suspend comet");
    }

    SocketLinkState toCometResume(TcpSocketLink conn) {
        throw new IllegalStateException((Object)((Object)this) + " cannot resume comet");
    }

    SocketLinkState toCometDispatch() {
        throw new IllegalStateException((Object)((Object)this) + " cannot dispatch comet");
    }

    SocketLinkState toCometComplete() {
        throw new IllegalStateException((Object)((Object)this) + " cannot complete comet");
    }

    SocketLinkState toDuplex(TcpSocketLink conn) {
        throw new IllegalStateException((Object)((Object)this) + " cannot switch to duplex/websocket");
    }

    SocketLinkState toDuplexActive(TcpSocketLink conn) {
        throw new IllegalStateException((Object)((Object)this) + " cannot switch to duplex/websocket");
    }

    SocketLinkState toIdle() {
        throw new IllegalStateException((Object)((Object)this) + " is an illegal idle state");
    }

    SocketLinkState toFree(TcpSocketLink conn) {
        throw new IllegalStateException((Object)((Object)this) + " is an illegal free state for " + conn);
    }

    SocketLinkState toClosed(TcpSocketLink conn) {
        return CLOSED;
    }

    SocketLinkState toDestroy(TcpSocketLink conn) {
        this.toClosed(conn);
        conn.getPort().closeConnection(conn);
        return DESTROYED;
    }

    static {
        log = Logger.getLogger(SocketLinkState.class.getName());
    }
}

