/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.network.listen;

import com.caucho.inject.Module;
import com.caucho.network.listen.AsyncController;
import com.caucho.network.listen.SocketLinkCometListener;
import com.caucho.network.listen.TcpSocketLink;
import com.caucho.util.CurrentTime;
import java.util.logging.Level;
import java.util.logging.Logger;

@Module
class TcpAsyncController
extends AsyncController {
    private static final Logger log = Logger.getLogger(TcpAsyncController.class.getName());
    private TcpSocketLink _conn;
    private SocketLinkCometListener _cometHandler;
    private boolean _isCompleteRequested;
    private boolean _isTimeout;

    TcpAsyncController(TcpSocketLink conn) {
        this._conn = conn;
    }

    void initHandler(SocketLinkCometListener cometHandler) {
        this._cometHandler = cometHandler;
    }

    public TcpSocketLink getConnection() {
        return this._conn;
    }

    public void setMaxIdleTime(long idleTime) {
        if (idleTime < 0L || 0x3FFFFFFFFFFFFFFFL < idleTime) {
            idleTime = 0x3FFFFFFFFFFFFFFFL;
        }
        this._conn.setIdleTimeout(idleTime);
    }

    public long getMaxIdleTime() {
        return this._conn.getIdleTimeout();
    }

    public final void complete() {
        this._isCompleteRequested = true;
        try {
            this.wake();
        }
        catch (Exception e) {
            log.log(Level.FINEST, e.toString(), e);
        }
    }

    public final boolean wake() {
        TcpSocketLink conn = this._conn;
        if (conn != null) {
            conn.requestWakeComet();
            return true;
        }
        return false;
    }

    public boolean isAsyncStarted() {
        TcpSocketLink conn = this._conn;
        return conn != null && conn.isAsyncStarted();
    }

    public boolean isDuplex() {
        return false;
    }

    public final void timeout() {
        this._cometHandler.onTimeout();
        this._isTimeout = true;
        this._isCompleteRequested = true;
        try {
            this.wake();
        }
        catch (Exception e) {
            log.log(Level.FINEST, e.toString(), e);
        }
    }

    void setTimeout() {
        this._isTimeout = true;
        this._isCompleteRequested = true;
    }

    public final boolean isTimeout() {
        return this._isTimeout;
    }

    public final boolean isActive() {
        return this._conn != null;
    }

    final void setCompleteRequested() {
        this._isCompleteRequested = true;
    }

    final boolean isCompleteRequested() {
        return this._isCompleteRequested;
    }

    public boolean isComet() {
        TcpSocketLink conn = this._conn;
        return conn != null && !this._isCompleteRequested;
    }

    public final boolean isClosed() {
        TcpSocketLink conn = this._conn;
        return conn == null || this._isCompleteRequested;
    }

    public void toResume() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose() {
        this._cometHandler.onComplete();
    }

    public void close() {
        super.close();
        this._conn = null;
    }

    public String toString() {
        TcpSocketLink conn = this._conn;
        if (conn == null) {
            return this.getClass().getSimpleName() + "[closed]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        if (CurrentTime.isTest()) {
            sb.append("test");
        } else {
            sb.append(conn.getId());
        }
        TcpSocketLink tcpConn = null;
        if (this._conn instanceof TcpSocketLink) {
            tcpConn = this._conn;
        }
        if (this._isCompleteRequested) {
            sb.append(",complete");
        }
        if (this._isTimeout) {
            sb.append(",timeout");
        }
        if (tcpConn != null) {
            sb.append("," + (Object)((Object)tcpConn.getRequestState()));
        }
        sb.append("]");
        return sb.toString();
    }
}

