/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.profile;

import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HeapDump {
    private static final L10N L = new L10N(HeapDump.class);
    private static final Logger log = Logger.getLogger(HeapDump.class.getName());
    private static HeapDump _heapDump;

    protected HeapDump() {
    }

    public static HeapDump create() {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> heapDumpClass = Class.forName("com.caucho.profile.ProHeapDump", false, loader);
            _heapDump = (HeapDump)heapDumpClass.newInstance();
            return _heapDump;
        }
        catch (ClassNotFoundException e) {
            log.log(Level.FINEST, e.toString(), e);
            throw new ConfigException(L.l("HeapDump requires Resin Professional"));
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    public static boolean isAvailable() {
        try {
            return HeapDump.create() != null;
        }
        catch (Exception e) {
            log.log(Level.FINEST, e.toString(), e);
            return false;
        }
    }

    public Object dump() {
        throw new ConfigException(L.l("HeapDump requires Resin Professional"));
    }

    public Object getLastHeapDump() {
        throw new ConfigException(L.l("HeapDump requires Resin Professional"));
    }

    public void writeHeapDump(PrintWriter out) throws IOException {
        throw new ConfigException(L.l("HeapDump requires Resin Professional"));
    }

    public void writeExtendedHeapDump(PrintWriter out) throws IOException {
        throw new ConfigException(L.l("HeapDump requires Resin Professional"));
    }

    public void logHeapDump(Logger log, Level level) {
        throw new ConfigException(L.l("HeapDump requires Resin Professional"));
    }

    public String jsonHeapDump() {
        throw new UnsupportedOperationException(L.l("HeapDump requires Resin Professional"));
    }
}

