/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus;

import com.caucho.config.ConfigException;
import com.caucho.java.JavaCompilerUtil;
import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.QuercusRuntimeException;
import com.caucho.quercus.QuercusTimer;
import com.caucho.quercus.QuercusVersion;
import com.caucho.quercus.annotation.ClassImplementation;
import com.caucho.quercus.env.AbstractJavaMethod;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.ConstStringValue;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.MethodIntern;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.SessionArrayValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeBuilderValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.quercus.lib.db.JavaSqlDriverWrapper;
import com.caucho.quercus.lib.db.JdbcDriverContext;
import com.caucho.quercus.lib.file.FileModule;
import com.caucho.quercus.lib.regexp.RegexpModule;
import com.caucho.quercus.lib.session.QuercusSessionManager;
import com.caucho.quercus.module.IniDefinition;
import com.caucho.quercus.module.IniDefinitions;
import com.caucho.quercus.module.ModuleContext;
import com.caucho.quercus.module.ModuleInfo;
import com.caucho.quercus.module.ModuleStartupListener;
import com.caucho.quercus.module.QuercusModule;
import com.caucho.quercus.module.StaticFunction;
import com.caucho.quercus.page.InterpretedPage;
import com.caucho.quercus.page.PageManager;
import com.caucho.quercus.page.QuercusPage;
import com.caucho.quercus.parser.QuercusParser;
import com.caucho.quercus.program.ClassDef;
import com.caucho.quercus.program.JavaClassDef;
import com.caucho.quercus.program.QuercusProgram;
import com.caucho.quercus.program.UndefinedFunction;
import com.caucho.util.IntMap;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.caucho.util.TimedCache;
import com.caucho.vfs.FilePath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cache.Cache;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuercusContext {
    private static L10N L = new L10N(QuercusContext.class);
    private static final Logger log = Logger.getLogger(QuercusContext.class.getName());
    private static HashSet<String> _superGlobals = new HashSet();
    private static IniDefinitions _ini = new IniDefinitions();
    private final PageManager _pageManager;
    private final ClassLoader _loader;
    private final QuercusSessionManager _sessionManager;
    private ModuleContext _moduleContext;
    private static LruCache<String, UnicodeBuilderValue> _unicodeMap = new LruCache(8192);
    private static LruCache<String, StringValue> _stringMap = new LruCache(8192);
    private HashMap<String, ModuleInfo> _modules = new HashMap();
    private ArrayList<ModuleInfo> _moduleInitList = new ArrayList();
    private HashSet<ModuleStartupListener> _moduleStartupListeners = new HashSet();
    private HashSet<String> _extensionSet = new HashSet();
    private HashSet<String> _extensionSetLowerCase = new HashSet();
    private HashMap<String, AbstractFunction> _funMap = new HashMap();
    private HashMap<String, AbstractFunction> _lowerFunMap = new HashMap();
    private ConcurrentHashMap<String, JavaClassDef> _javaClassWrappers = new ConcurrentHashMap();
    private LruCache<String, String> _classNotFoundCache = new LruCache(64);
    private HashMap<String, JavaClassDef> _lowerJavaClassWrappers = new HashMap();
    private HashMap<String, Class<?>> _javaInitClassMap = new HashMap();
    private final IniDefinitions _iniDefinitions = new IniDefinitions();
    private Path _iniFile;
    private HashMap<String, Value> _iniMap;
    private HashMap<Value, Value> _serverEnvMap = new HashMap();
    private IntMap _classNameMap = new IntMap(8192);
    private String[] _classNames = new String[256];
    private ClassDef[] _classDefMap = new ClassDef[256];
    private QuercusClass[] _classCacheMap = new QuercusClass[256];
    private IntMap _constantNameMap = new IntMap(8192);
    private int[] _constantLowerMap = new int[256];
    private Value[] _constantNameList = new Value[256];
    private Value[] _constantMap = new Value[256];
    protected IntMap _functionNameMap = new IntMap(8192);
    private AbstractFunction[] _functionMap = new AbstractFunction[256];
    private LruCache<StringValue, QuercusProgram> _evalCache = new LruCache(4096);
    private int _includeCacheMax = 8192;
    private long _includeCacheTimeout = 10000L;
    private TimedCache<IncludeKey, Path> _includeCache;
    private long _defCacheHitCount;
    private long _defCacheMissCount;
    private ConcurrentHashMap<String, Object> _specialMap = new ConcurrentHashMap();
    private String _scriptEncoding;
    private String _phpVersion = "5.3.2";
    private String _mySqlVersion;
    private boolean _isStrict;
    private boolean _isLooseParse;
    private boolean _isRequireSource;
    private boolean _isConnectionPool = true;
    private DataSource _database;
    private ConcurrentHashMap<String, DataSource> _databaseMap = new ConcurrentHashMap();
    private ConcurrentHashMap<Env, Env> _activeEnvSet = new ConcurrentHashMap();
    private long _staticId;
    private Path _pwd;
    private Path _workDir;
    private Path _webInfDir;
    private ServletContext _servletContext;
    private QuercusTimer _quercusTimer;
    private EnvTimeoutThread _envTimeoutThread;
    protected long _envTimeout = 60000L;
    protected static final long ENV_TIMEOUT_UPDATE_INTERVAL = 1000L;
    private long _dependencyCheckInterval = 2000L;
    private boolean _isClosed;
    private JdbcDriverContext _jdbcDriverContext;
    private Boolean _isUnicodeSemantics;
    public static final IniDefinition INI_INCLUDE_PATH;
    public static final IniDefinition INI_REGISTER_LONG_ARRAYS;
    public static final IniDefinition INI_ALWAYS_POPULATE_RAW_POST_DATA;
    public static final IniDefinition INI_UNICODE_SEMANTICS;
    public static final IniDefinition INI_UNICODE_FALLBACK_ENCODING;
    public static final IniDefinition INI_UNICODE_FROM_ERROR_MODE;
    public static final IniDefinition INI_UNICODE_FROM_ERROR_SUBST_CHAR;
    public static final IniDefinition INI_UNICODE_HTTP_INPUT_ENCODING;
    public static final IniDefinition INI_UNICODE_OUTPUT_ENCODING;
    public static final IniDefinition INI_UNICODE_RUNTIME_ENCODING;
    public static final IniDefinition INI_UNICODE_SCRIPT_ENCODING;

    public QuercusContext() {
        this._loader = Thread.currentThread().getContextClassLoader();
        this._pageManager = this.createPageManager();
        this._sessionManager = this.createSessionManager();
        this._moduleContext = this.getLocalContext();
    }

    public long getCurrentTime() {
        return this._quercusTimer.getCurrentTime();
    }

    public long getExactTimeNanoseconds() {
        return this._quercusTimer.getExactTimeNanoseconds();
    }

    public long getExactTime() {
        return this._quercusTimer.getExactTime();
    }

    public Path getPwd() {
        if (this._pwd == null) {
            this._pwd = new FilePath(System.getProperty("user.dir"));
        }
        return this._pwd;
    }

    public void setPwd(Path path) {
        this._pwd = path;
    }

    public Path getWebInfDir() {
        if (this._webInfDir == null) {
            this._webInfDir = this.getPwd().lookup("WEB-INF");
        }
        return this._webInfDir;
    }

    public void setWebInfDir(Path path) {
        this._webInfDir = path;
    }

    public Path getWorkDir() {
        if (this._workDir == null) {
            this._workDir = this.getWebInfDir().lookup("work");
        }
        return this._workDir;
    }

    public void setWorkDir(Path workDir) {
        this._workDir = workDir;
    }

    public String getCookieName() {
        return "JSESSIONID";
    }

    public final long getDependencyCheckInterval() {
        return this._dependencyCheckInterval;
    }

    public final void setDependencyCheckInterval(long ms) {
        this._dependencyCheckInterval = ms;
    }

    public int getIncludeCacheMax() {
        return this._includeCacheMax;
    }

    public void setIncludeCacheMax(int cacheMax) {
        this._includeCacheMax = cacheMax;
    }

    public void setIncludeCacheTimeout(long timeout) {
        this._includeCacheTimeout = timeout;
    }

    public long getIncludeCacheTimeout() {
        return this._includeCacheTimeout;
    }

    public String getName() {
        if (this.isPro()) {
            return "Quercus Pro";
        }
        return "Quercus";
    }

    public String getVersion() {
        return "Open Source " + QuercusVersion.getVersionNumber();
    }

    public String getVersionDate() {
        return QuercusVersion.getVersionDate();
    }

    public String getSapiName() {
        return "cgi";
    }

    public boolean isRegisterArgv() {
        return this.getIniBoolean("register_argc_argv");
    }

    public boolean isProfile() {
        return false;
    }

    public int getProfileIndex(String name) {
        return -1;
    }

    public void setProfileProbability(double probability) {
    }

    protected PageManager createPageManager() {
        return new PageManager(this);
    }

    protected QuercusSessionManager createSessionManager() {
        return new QuercusSessionManager(this);
    }

    public final ModuleContext getLocalContext() {
        return this.getLocalContext(this._loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleContext getLocalContext(ClassLoader loader) {
        QuercusContext quercusContext = this;
        synchronized (quercusContext) {
            if (this._moduleContext == null) {
                this._moduleContext = this.createModuleContext(null, loader);
                this._moduleContext.init();
            }
        }
        return this._moduleContext;
    }

    protected ModuleContext createModuleContext(ModuleContext parent, ClassLoader loader) {
        return new ModuleContext(parent, loader);
    }

    public ModuleContext getModuleContext() {
        return this._moduleContext;
    }

    public QuercusSessionManager getQuercusSessionManager() {
        return this._sessionManager;
    }

    public boolean isCompile() {
        return this._pageManager.isCompile();
    }

    public boolean isPro() {
        return false;
    }

    public boolean isResin() {
        return false;
    }

    public void setUnicodeSemantics(boolean isUnicode) {
        this._isUnicodeSemantics = isUnicode;
    }

    public boolean isUnicodeSemantics() {
        if (this._isUnicodeSemantics == null) {
            return false;
        }
        return this._isUnicodeSemantics;
    }

    public boolean isAllowUrlInclude() {
        return this.getIniBoolean("allow_url_include");
    }

    public boolean isAllowUrlFopen() {
        return this.getIniBoolean("allow_url_fopen");
    }

    public void setCompile(boolean isCompile) {
        this._pageManager.setCompile(isCompile);
    }

    public void setLazyCompile(boolean isCompile) {
        this._pageManager.setLazyCompile(isCompile);
    }

    public void setCompileFailover(boolean isCompileFailover) {
        this._pageManager.setCompileFailover(isCompileFailover);
    }

    public String getScriptEncoding() {
        if (this._scriptEncoding != null) {
            return this._scriptEncoding;
        }
        if (this.isUnicodeSemantics()) {
            return "utf-8";
        }
        return "iso-8859-1";
    }

    public void setScriptEncoding(String encoding) {
        this._scriptEncoding = encoding;
    }

    public String getOutputEncoding() {
        if (!this._isUnicodeSemantics.booleanValue()) {
            return null;
        }
        String encoding = INI_UNICODE_OUTPUT_ENCODING.getAsString(this);
        if (encoding == null) {
            encoding = INI_UNICODE_FALLBACK_ENCODING.getAsString(this);
        }
        if (encoding == null) {
            encoding = "utf-8";
        }
        return encoding;
    }

    public String getMysqlVersion() {
        return this._mySqlVersion;
    }

    public void setMysqlVersion(String version) {
        this._mySqlVersion = version;
    }

    public String getPhpVersion() {
        return this._phpVersion;
    }

    public void setPhpVersion(String version) {
        this._phpVersion = version;
    }

    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    public ServletContext getServletContext() {
        return this._servletContext;
    }

    public void setDatabase(DataSource database) {
        this._database = database;
    }

    public DataSource getDatabase() {
        return this._database;
    }

    public JdbcDriverContext getJdbcDriverContext() {
        if (this._jdbcDriverContext == null) {
            this._jdbcDriverContext = new JdbcDriverContext();
            Value driverValue = this.getIniValue("quercus.jdbc_drivers");
            if (driverValue.isArray()) {
                ArrayValue array = (ArrayValue)driverValue.toArray();
                for (Map.Entry<Value, Value> entry : array.entrySet()) {
                    Value key = entry.getKey();
                    Value value = entry.getValue();
                    this._jdbcDriverContext.setProtocol(key.toString(), value.toString());
                }
            }
        }
        return this._jdbcDriverContext;
    }

    public DataSource findDatabase(String driver, String url) {
        if (this._database != null) {
            return this._database;
        }
        try {
            String key = driver + ";" + url;
            DataSource database = this._databaseMap.get(key);
            if (database != null) {
                return database;
            }
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> cls = loader.loadClass(driver);
            Object ds = cls.newInstance();
            database = ds instanceof DataSource ? (DataSource)ds : new JavaSqlDriverWrapper((Driver)ds, url);
            this._databaseMap.put(key, database);
            return database;
        }
        catch (ClassNotFoundException e) {
            throw new QuercusModuleException(e);
        }
        catch (InstantiationException e) {
            throw new QuercusModuleException(e);
        }
        catch (IllegalAccessException e) {
            throw new QuercusModuleException(e);
        }
    }

    public void markForPoolRemoval(Connection conn) {
    }

    public Connection getConnection(Connection conn) {
        return conn;
    }

    public Statement getStatement(Statement stmt) {
        return stmt;
    }

    public void setStrict(boolean isStrict) {
        this._isStrict = isStrict;
    }

    public boolean isStrict() {
        return this._isStrict;
    }

    public void setLooseParse(boolean isLoose) {
        this._isLooseParse = isLoose;
    }

    public boolean isLooseParse() {
        return this._isLooseParse;
    }

    public int getPageCacheSize() {
        return this._pageManager.getPageCacheSize();
    }

    public void setPageCacheSize(int size) {
        this._pageManager.setPageCacheSize(size);
    }

    public int getRegexpCacheSize() {
        return RegexpModule.getRegexpCacheSize();
    }

    public void setRegexpCacheSize(int size) {
        RegexpModule.setRegexpCacheSize(size);
    }

    public void setRequireSource(boolean isRequireSource) {
        this._isRequireSource = isRequireSource;
    }

    public boolean isRequireSource() {
        return this._isRequireSource;
    }

    public void setConnectionPool(boolean isEnable) {
        this._isConnectionPool = isEnable;
    }

    public boolean isConnectionPool() {
        return this._isConnectionPool;
    }

    private void initJavaClasses() {
        for (Map.Entry<String, Class<?>> entry : this._javaInitClassMap.entrySet()) {
            String name = entry.getKey();
            Class<?> cls = entry.getValue();
            try {
                if (cls.isAnnotationPresent(ClassImplementation.class)) {
                    this._moduleContext.introspectJavaImplClass(name, cls, null);
                    continue;
                }
                this._moduleContext.introspectJavaClass(name, cls, null, null);
            }
            catch (Exception e) {
                throw new QuercusRuntimeException(e);
            }
        }
    }

    public void addJavaClass(String name, Class<?> type) throws ConfigException {
        this._javaInitClassMap.put(name, type);
    }

    public void addJavaClass(String phpName, String className) {
        try {
            Class<?> type = Class.forName(className, false, this._loader);
            this.addJavaClass(phpName, type);
        }
        catch (ClassNotFoundException e) {
            throw new QuercusRuntimeException(L.l("`{0}' not valid: {1}", (Object)className, (Object)e.toString()), e);
        }
    }

    public void addImplClass(String name, Class<?> type) throws ConfigException {
        throw new UnsupportedOperationException("XXX: need to merge with ModuleContext: " + name);
    }

    public JavaClassDef getJavaClassDefinition(Class<?> type, String className) {
        if (this._classNotFoundCache.get(className) != null) {
            return null;
        }
        JavaClassDef def = this._javaClassWrappers.get(className);
        if (def == null) {
            try {
                def = this.getModuleContext().getJavaClassDefinition(type, className);
                int id = this.getClassId(className);
                this._classDefMap[id] = def;
                this._javaClassWrappers.put(className, def);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new QuercusRuntimeException(e);
            }
        }
        def.init();
        return def;
    }

    public JavaClassDef getJavaClassDefinition(String className) {
        if (this._classNotFoundCache.get(className) != null) {
            return null;
        }
        JavaClassDef def = this._javaClassWrappers.get(className);
        if (def == null) {
            try {
                def = this.getModuleContext().getJavaClassDefinition(className);
                this._javaClassWrappers.put(className, def);
            }
            catch (RuntimeException e) {
                this._classNotFoundCache.put(className, className);
                throw e;
            }
            catch (Exception e) {
                throw new QuercusRuntimeException(e);
            }
        }
        def.init();
        return def;
    }

    public ClassDef findJavaClassWrapper(String name) {
        ClassDef def = this._javaClassWrappers.get(name);
        if (def != null) {
            return def;
        }
        return this._lowerJavaClassWrappers.get(name.toLowerCase(Locale.ENGLISH));
    }

    public void setIniFile(Path path) {
        if (path != null && path.canRead()) {
            this._iniFile = path;
        }
    }

    public Path getIniFile() {
        return this._iniFile;
    }

    public IniDefinitions getIniDefinitions() {
        return this._iniDefinitions;
    }

    public HashMap<String, Value> getIniMap(boolean create) {
        if (this._iniMap == null && create) {
            this._iniMap = new HashMap();
        }
        return this._iniMap;
    }

    public void setIni(String name, Value value) {
        this._iniDefinitions.get(name).set(this, value);
    }

    public void setIni(String name, String value) {
        this._iniDefinitions.get(name).set(this, value);
    }

    public boolean getIniBoolean(String name) {
        return this._iniDefinitions.get(name).getAsBoolean(this);
    }

    public long getIniLong(String name) {
        return this._iniDefinitions.get(name).getAsLongValue(this).toLong();
    }

    public Value getIniValue(String name) {
        return this._iniDefinitions.get(name).getValue(this);
    }

    public String getIniString(String name) {
        return this._iniDefinitions.get(name).getValue(this).toJavaString();
    }

    public void setServerEnv(String name, String value) {
        if (this.isUnicodeSemantics()) {
            this.setServerEnv(this.createUnicodeString(name), this.createUnicodeString(value));
        } else {
            this.setServerEnv(this.createString(name), this.createString(value));
        }
    }

    public void setServerEnv(StringValue name, StringValue value) {
        this._serverEnvMap.put(name, value);
    }

    public Value getServerEnv(StringValue name) {
        return this._serverEnvMap.get(name);
    }

    public HashMap<Value, Value> getServerEnvMap() {
        return this._serverEnvMap;
    }

    public ClassLoader getCompileClassLoader() {
        return null;
    }

    public void setCompileClassLoader(ClassLoader loader) {
    }

    public final String getClassName(Path path) {
        String pwdName;
        if (path == null) {
            return "tmp.eval";
        }
        String pathName = path.getFullPath();
        String relPath = pathName.startsWith(pwdName = this.getPwd().getFullPath()) ? pathName.substring(pwdName.length()) : pathName;
        return "_quercus." + JavaCompilerUtil.mangleName(relPath);
    }

    public Path getIncludeCache(StringValue include, String includePath, Path pwd, Path scriptPwd) {
        IncludeKey key = new IncludeKey(include, includePath, pwd, scriptPwd);
        Path path = this._includeCache.get(key);
        return path;
    }

    public void putIncludeCache(StringValue include, String includePath, Path pwd, Path scriptPwd, Path path) {
        IncludeKey key = new IncludeKey(include, includePath, pwd, scriptPwd);
        this._includeCache.put(key, path);
    }

    public long getDefCacheHitCount() {
        return this._defCacheHitCount;
    }

    public long getDefCacheMissCount() {
        return this._defCacheMissCount;
    }

    public void clearDefinitionCache() {
    }

    public boolean includeExists(Path path) {
        return this._pageManager.precompileExists(path);
    }

    public QuercusPage parse(Path path) throws IOException {
        return this._pageManager.parse(path);
    }

    public QuercusPage parse(Path path, String fileName, int line) throws IOException {
        return this._pageManager.parse(path, fileName, line);
    }

    public QuercusPage parse(ReadStream is) throws IOException {
        return new InterpretedPage(QuercusParser.parse(this, is));
    }

    public QuercusProgram parseCode(StringValue code) throws IOException {
        QuercusProgram program = this._evalCache.get(code);
        if (program == null) {
            program = QuercusParser.parseEval(this, code);
            this._evalCache.put(code, program);
        }
        return program;
    }

    public QuercusProgram parseEvalExpr(StringValue code) throws IOException {
        QuercusProgram program = this._evalCache.get(code);
        if (program == null) {
            program = QuercusParser.parseEvalExpr(this, code);
            this._evalCache.put(code, program);
        }
        return program;
    }

    public AbstractFunction parseFunction(String name, String args, String code) throws IOException {
        return QuercusParser.parseFunction(this, name, args, code);
    }

    public AbstractFunction findFunction(String name) {
        AbstractFunction fun = this._funMap.get(name);
        if (fun == null && !this.isStrict()) {
            fun = this._lowerFunMap.get(name.toLowerCase(Locale.ENGLISH));
        }
        return fun;
    }

    public AbstractFunction findFunctionImpl(String name) {
        AbstractFunction fun = this._funMap.get(name);
        return fun;
    }

    public AbstractFunction findLowerFunctionImpl(String lowerName) {
        AbstractFunction fun = this._lowerFunMap.get(lowerName);
        return fun;
    }

    public ArrayValue getDefinedFunctions() {
        ArrayValueImpl internal = new ArrayValueImpl();
        for (String name : this._funMap.keySet()) {
            internal.put(name);
        }
        return internal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFunctionId(String name) {
        int id;
        if (!this.isStrict()) {
            name = name.toLowerCase(Locale.ENGLISH);
        }
        if (name.startsWith("\\")) {
            name = name.substring(1);
        }
        if ((id = this._functionNameMap.get(name)) >= 0) {
            return id;
        }
        IntMap intMap = this._functionNameMap;
        synchronized (intMap) {
            id = this._functionNameMap.get(name);
            if (id >= 0) {
                return id;
            }
            id = this._functionNameMap.size() + 1;
            this._functionNameMap.put(name, id);
            this.extendFunctionMap(name, id);
        }
        return id;
    }

    protected void extendFunctionMap(String name, int id) {
        if (this._functionMap.length <= id) {
            AbstractFunction[] functionMap = new AbstractFunction[id + 256];
            System.arraycopy(this._functionMap, 0, functionMap, 0, this._functionMap.length);
            this._functionMap = functionMap;
        }
        int globalId = -1;
        int ns = name.lastIndexOf(92);
        if (ns > 0) {
            globalId = this.getFunctionId(name.substring(ns + 1));
        }
        this._functionMap[id] = new UndefinedFunction(id, name, globalId);
    }

    public int findFunctionId(String name) {
        if (!this.isStrict()) {
            name = name.toLowerCase(Locale.ENGLISH);
        }
        if (name.startsWith("\\")) {
            name = name.substring(1);
        }
        return this._functionNameMap.get(name);
    }

    public int getFunctionIdCount() {
        return this._functionNameMap.size();
    }

    public AbstractFunction[] getFunctionMap() {
        return this._functionMap;
    }

    public int setFunction(String name, AbstractFunction fun) {
        int id = this.getFunctionId(name);
        this._functionMap[id] = fun;
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClassId(String className) {
        int id = this._classNameMap.get(className);
        if (id >= 0) {
            return id;
        }
        if (className.startsWith("\\")) {
            className = className.substring(1);
        }
        if ((id = this._classNameMap.get(className)) >= 0) {
            return id;
        }
        IntMap intMap = this._classNameMap;
        synchronized (intMap) {
            String name = className.toLowerCase(Locale.ENGLISH);
            id = this._classNameMap.get(name);
            if (id >= 0) {
                this._classNameMap.put(className, id);
                return id;
            }
            id = this._classNameMap.size();
            if (this._classDefMap.length <= id) {
                String[] classNames = new String[id + 256];
                System.arraycopy(this._classNames, 0, classNames, 0, this._classNames.length);
                this._classNames = classNames;
                ClassDef[] classDefMap = new ClassDef[this._classNames.length];
                System.arraycopy(this._classDefMap, 0, classDefMap, 0, this._classDefMap.length);
                this._classDefMap = classDefMap;
                QuercusClass[] classCacheMap = new QuercusClass[this._classNames.length];
                System.arraycopy(this._classCacheMap, 0, classCacheMap, 0, this._classCacheMap.length);
                this._classCacheMap = classCacheMap;
            }
            this._classNames[id] = className;
            this._classNameMap.put(className, id);
            this._classNameMap.put(name, id);
        }
        return id;
    }

    public String getClassName(int id) {
        return this._classNames[id];
    }

    public int findClassId(String name) {
        return this._classNameMap.get(name);
    }

    public int getClassIdCount() {
        return this._classNameMap.size();
    }

    public ClassDef[] getClassDefMap() {
        return this._classDefMap;
    }

    public ClassDef getClassDef(int id) {
        return this._classDefMap[id];
    }

    public QuercusClass[] getClassCacheMap() {
        return this._classCacheMap;
    }

    public QuercusClass getCachedClass(int id) {
        return this._classCacheMap[id];
    }

    public void setCachedClass(int id, QuercusClass qClass) {
        this._classCacheMap[id] = qClass;
    }

    public int getConstantId(String name) {
        if (this.isUnicodeSemantics()) {
            return this.getConstantId(new UnicodeBuilderValue(name));
        }
        return this.getConstantId(new ConstStringValue(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConstantId(StringValue name) {
        int id = this._constantNameMap.get(name);
        if (id >= 0) {
            return id;
        }
        IntMap intMap = this._constantNameMap;
        synchronized (intMap) {
            id = this._constantNameMap.get(name);
            if (id >= 0) {
                return id;
            }
            id = this._constantNameMap.size() + 1;
            if (this._classDefMap.length <= id) {
                Value[] constantMap = new Value[id + 256];
                System.arraycopy(this._constantMap, 0, constantMap, 0, this._constantMap.length);
                this._constantMap = constantMap;
                Value[] constantNameList = new Value[id + 256];
                System.arraycopy(this._constantNameList, 0, constantNameList, 0, this._constantNameList.length);
                this._constantNameList = constantNameList;
                int[] constantLowerMap = new int[this._constantMap.length];
                System.arraycopy(this._constantLowerMap, 0, constantLowerMap, 0, this._constantLowerMap.length);
                this._constantLowerMap = constantLowerMap;
            }
            this._constantNameList[id] = name;
            this._constantNameMap.put(name, id);
        }
        return id;
    }

    public int addLowerConstantId(StringValue name) {
        int lowerId;
        int id = this.getConstantId(name);
        this._constantLowerMap[id] = lowerId = this.getConstantId(name.toLowerCase());
        return id;
    }

    public int getConstantLower(int id) {
        return this._constantLowerMap[id];
    }

    public int getConstantLowerId(String name) {
        return this.getConstantId(name.toLowerCase(Locale.ENGLISH));
    }

    public Value getConstantName(int id) {
        return this._constantNameList[id];
    }

    public Value[] getConstantMap() {
        return this._constantMap;
    }

    public int getConstantIdCount() {
        return this._constantNameMap.size();
    }

    public static boolean isSuperGlobal(StringValue name) {
        return _superGlobals.contains(name.toString());
    }

    public QuercusClass getStdClass() {
        return this._moduleContext.getStdClass();
    }

    public ClassDef findClass(String name) {
        int id = this.getClassId(name);
        return this._classDefMap[id];
    }

    public HashMap<String, ClassDef> getClassMap() {
        throw new UnsupportedOperationException();
    }

    public QuercusModule findModule(String name) {
        ModuleInfo moduleInfo = this._modules.get(name);
        QuercusModule module = null;
        module = moduleInfo != null ? moduleInfo.getModule() : this.getModuleContext().findModule(name);
        if (module == null) {
            throw new IllegalStateException(L.l("'{0}' is an unknown quercus module", (Object)name));
        }
        return module;
    }

    public HashSet<ModuleStartupListener> getModuleStartupListeners() {
        return this._moduleStartupListeners;
    }

    public boolean isExtensionLoaded(String name) {
        return this._extensionSet.contains(name) || this._extensionSetLowerCase.contains(name.toLowerCase(Locale.ENGLISH));
    }

    public HashSet<String> getLoadedExtensions() {
        return this._extensionSet;
    }

    public Value getExtensionFuncs(String name) {
        ArrayValue value = null;
        for (ModuleInfo moduleInfo : this._modules.values()) {
            HashSet<String> extensionSet = moduleInfo.getLoadedExtensions();
            if (!extensionSet.contains(name)) continue;
            for (String functionName : moduleInfo.getFunctions().keySet()) {
                if (value == null) {
                    value = new ArrayValueImpl();
                }
                value.put(functionName);
            }
        }
        if (value != null) {
            return value;
        }
        return BooleanValue.FALSE;
    }

    public Collection<ModuleInfo> getModules() {
        return this._modules.values();
    }

    public void init() {
        Env env;
        Value result;
        if (this._iniFile != null && (result = FileModule.parse_ini_file(env = new Env(this), this._iniFile, false)) instanceof ArrayValue) {
            ArrayValue array = (ArrayValue)result;
            for (Map.Entry<Value, Value> entry : array.entrySet()) {
                String key = entry.getKey().toString();
                Value value = entry.getValue();
                this.setIni(key, value);
            }
        }
        if (this._isUnicodeSemantics == null) {
            this._isUnicodeSemantics = this.getIniBoolean("unicode.semantics");
        }
        this._moduleContext.setUnicodeSemantics(this._isUnicodeSemantics);
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            this._serverEnvMap.put(this.createString(entry.getKey()), this.createString(entry.getValue()));
        }
        this.initModules();
        this.initClasses();
        this._workDir = this.getWorkDir();
        this._iniDefinitions.addAll(_ini);
        this._includeCache = new TimedCache(this.getIncludeCacheMax(), this.getIncludeCacheTimeout());
        this.initLocal();
    }

    public void addInitModule(QuercusModule module) {
        ModuleInfo info = new ModuleInfo(module.getClass().getName(), module);
        this._moduleInitList.add(info);
    }

    private void initModules() {
        HashSet<String> disableSet = null;
        String value = this.getIniString("disable_functions");
        if (value != null) {
            String[] values;
            disableSet = new HashSet<String>();
            for (String name : values = value.split(",")) {
                disableSet.add(name.trim());
            }
        }
        for (ModuleInfo info : this._moduleInitList) {
            this.initModuleInfo(info, disableSet);
        }
        for (ModuleInfo info : this._moduleContext.getModules()) {
            this.initModuleInfo(info, disableSet);
        }
    }

    private void initModuleInfo(ModuleInfo info, HashSet<String> disableSet) {
        this._modules.put(info.getName(), info);
        if (info.getModule() instanceof ModuleStartupListener) {
            this._moduleStartupListeners.add((ModuleStartupListener)info.getModule());
        }
        for (String ext : info.getLoadedExtensions()) {
            this._extensionSet.add(ext);
            this._extensionSetLowerCase.add(ext.toLowerCase(Locale.ENGLISH));
        }
        HashMap<StringValue, Value> map = this.isUnicodeSemantics() ? info.getUnicodeConstMap() : info.getConstMap();
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                int id = this.getConstantId((StringValue)entry.getKey());
                this._constantMap[id] = (Value)entry.getValue();
            }
        }
        this._iniDefinitions.addAll(info.getIniDefinitions());
        for (Map.Entry<Object, Object> entry : info.getFunctions().entrySet()) {
            String funName = (String)entry.getKey();
            Method[] methods = (Method[])entry.getValue();
            if (disableSet != null && disableSet.contains(funName)) continue;
            AbstractJavaMethod fun = this._moduleContext.createStaticFunction(info.getModule(), methods[0]);
            for (int i = 1; i < methods.length; ++i) {
                StaticFunction overload = this._moduleContext.createStaticFunction(info.getModule(), methods[i]);
                fun = fun.overload(overload);
            }
            this._funMap.put(funName, fun);
            this._lowerFunMap.put(funName.toLowerCase(Locale.ENGLISH), fun);
            this.setFunction(funName, fun);
        }
    }

    private void initClasses() {
        ClassDef def;
        String name;
        this.initJavaClasses();
        ModuleContext context = this._moduleContext;
        for (Map.Entry<String, JavaClassDef> entry : context.getWrapperMap().entrySet()) {
            name = entry.getKey();
            def = entry.getValue();
            this._javaClassWrappers.put(name, (JavaClassDef)def);
            this._lowerJavaClassWrappers.put(name.toLowerCase(Locale.ENGLISH), (JavaClassDef)def);
        }
        for (Map.Entry<String, ClassDef> entry : context.getClassMap().entrySet()) {
            name = entry.getKey();
            def = entry.getValue();
            int id = this.getClassId(name);
            this._classDefMap[id] = def;
        }
    }

    public UnicodeBuilderValue createUnicodeString(String name) {
        UnicodeBuilderValue value = _unicodeMap.get(name);
        if (value == null) {
            value = new UnicodeBuilderValue(name);
            _unicodeMap.put(name, value);
        }
        return value;
    }

    public StringValue createString(String name) {
        StringValue value = _stringMap.get(name);
        if (value == null) {
            if (this.isUnicodeSemantics()) {
                return new UnicodeBuilderValue(name);
            }
            value = new ConstStringValue(name);
            _stringMap.put(name, value);
        }
        return value;
    }

    public Value getConstant(int id) {
        return this._constantMap[id];
    }

    public StringValue createStaticName() {
        return MethodIntern.intern("s" + this._staticId++);
    }

    public Cache getSessionCache() {
        return null;
    }

    public void setSessionTimeout(long sessionTimeout) {
    }

    public SessionArrayValue loadSession(Env env, String sessionId) {
        long now = env.getCurrentTime();
        SessionArrayValue session = this._sessionManager.getSession(env, sessionId, now);
        if (session == null) {
            session = this._sessionManager.createSession(env, sessionId, now);
        }
        return session;
    }

    public void saveSession(Env env, SessionArrayValue session) {
        this._sessionManager.saveSession(env, session);
    }

    public void destroySession(String sessionId) {
        this._sessionManager.removeSession(sessionId);
    }

    public Object getSpecial(String key) {
        return this._specialMap.get(key);
    }

    public void setSpecial(String key, Object value) {
        this._specialMap.put(key, value);
    }

    public static Value objectToValue(Object obj) {
        if (obj == null) {
            return NullValue.NULL;
        }
        if (Byte.class.equals(obj.getClass()) || Short.class.equals(obj.getClass()) || Integer.class.equals(obj.getClass()) || Long.class.equals(obj.getClass())) {
            return LongValue.create(((Number)obj).longValue());
        }
        if (Float.class.equals(obj.getClass()) || Double.class.equals(obj.getClass())) {
            return DoubleValue.create(((Number)obj).doubleValue());
        }
        if (String.class.equals(obj.getClass())) {
            return new ConstStringValue((String)obj);
        }
        return null;
    }

    protected void initLocal() {
        String[] paths;
        StringBuilder sb = new StringBuilder(".");
        Path pwd = this.getPwd();
        for (String path : paths = new String[]{"/usr/share/php", "/usr/lib/php", "/usr/local/lib/php", "/usr/share/pear", "/usr/lib/pear", "/usr/local/lib/pear"}) {
            if (!pwd.lookup(path).isDirectory()) continue;
            sb.append(":").append(pwd.lookup(path).getPath());
        }
        this.setIni("include_path", sb.toString());
    }

    public void start() {
        try {
            this._quercusTimer = new QuercusTimer();
            this._envTimeoutThread = new EnvTimeoutThread();
            this._envTimeoutThread.start();
        }
        catch (Exception e) {
            log.log(Level.FINE, e.getMessage(), e);
        }
    }

    public Env createEnv(QuercusPage page, WriteStream out, HttpServletRequest request, HttpServletResponse response) {
        return new Env(this, page, out, request, response);
    }

    public ExprFactory createExprFactory() {
        return new ExprFactory();
    }

    protected Map<Env, Env> getActiveEnvSet() {
        return this._activeEnvSet;
    }

    public void startEnv(Env env) {
        this._activeEnvSet.put(env, env);
    }

    public void completeEnv(Env env) {
        this._activeEnvSet.remove(env);
    }

    protected boolean isClosed() {
        return this._isClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        QuercusContext quercusContext = this;
        synchronized (quercusContext) {
            if (this._isClosed) {
                return;
            }
            this._isClosed = true;
        }
        this._sessionManager.close();
        this._pageManager.close();
        EnvTimeoutThread envTimeoutThread = this._envTimeoutThread;
        this._envTimeoutThread = null;
        if (envTimeoutThread != null) {
            envTimeoutThread.shutdown();
        }
        QuercusTimer quercusTimer = this._quercusTimer;
        this._quercusTimer = null;
        if (quercusTimer != null) {
            quercusTimer.shutdown();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    static {
        _superGlobals.add("GLOBALS");
        _superGlobals.add("_COOKIE");
        _superGlobals.add("_ENV");
        _superGlobals.add("_FILES");
        _superGlobals.add("_GET");
        _superGlobals.add("_POST");
        _superGlobals.add("_SERVER");
        _superGlobals.add("_SESSION");
        _superGlobals.add("_REQUEST");
        INI_INCLUDE_PATH = _ini.add("include_path", ".", 7);
        INI_REGISTER_LONG_ARRAYS = _ini.add("register_long_arrays", true, 2);
        INI_ALWAYS_POPULATE_RAW_POST_DATA = _ini.add("always_populate_raw_post_data", false, 2);
        INI_UNICODE_SEMANTICS = _ini.add("unicode.semantics", false, 4);
        INI_UNICODE_FALLBACK_ENCODING = _ini.add("unicode.fallback_encoding", "utf-8", 7);
        INI_UNICODE_FROM_ERROR_MODE = _ini.add("unicode.from_error_mode", "2", 7);
        INI_UNICODE_FROM_ERROR_SUBST_CHAR = _ini.add("unicode.from_error_subst_char", "3f", 7);
        INI_UNICODE_HTTP_INPUT_ENCODING = _ini.add("unicode.http_input_encoding", null, 7);
        INI_UNICODE_OUTPUT_ENCODING = _ini.add("unicode.output_encoding", null, 7);
        INI_UNICODE_RUNTIME_ENCODING = _ini.add("unicode.runtime_encoding", null, 7);
        INI_UNICODE_SCRIPT_ENCODING = _ini.add("unicode.script_encoding", null, 7);
    }

    class EnvTimeoutThread
    extends Thread {
        private volatile boolean _isRunnable;
        private final long _timeout;
        private long _quantumCount;

        EnvTimeoutThread() {
            super("quercus-env-timeout");
            this._isRunnable = true;
            this._timeout = QuercusContext.this._envTimeout;
            this.setDaemon(true);
        }

        public void shutdown() {
            this._isRunnable = false;
            LockSupport.unpark(this);
        }

        public void run() {
            while (this._isRunnable) {
                if (this._quantumCount >= this._timeout) {
                    this._quantumCount = 0L;
                    try {
                        ArrayList activeEnv = new ArrayList(QuercusContext.this._activeEnvSet.keySet());
                        for (Env env : activeEnv) {
                            env.updateTimeout();
                        }
                    }
                    catch (Throwable throwable) {}
                } else {
                    this._quantumCount += 1000L;
                }
                LockSupport.parkNanos(1000000000L);
            }
        }
    }

    static class IncludeKey {
        private final StringValue _include;
        private final String _includePath;
        private final Path _pwd;
        private final Path _scriptPwd;

        IncludeKey(StringValue include, String includePath, Path pwd, Path scriptPwd) {
            this._include = include;
            this._includePath = includePath;
            this._pwd = pwd;
            this._scriptPwd = scriptPwd;
        }

        public int hashCode() {
            int hash = 37;
            hash = 65537 * hash + this._include.hashCode();
            hash = 65537 * hash + this._includePath.hashCode();
            if (this._pwd != null) {
                hash = 65537 * hash + this._pwd.hashCode();
            }
            hash = 65537 * hash + this._scriptPwd.hashCode();
            return hash;
        }

        public boolean equals(Object o) {
            if (!(o instanceof IncludeKey)) {
                return false;
            }
            IncludeKey key = (IncludeKey)o;
            return this._include.equals(key._include) && this._includePath.equals(key._includePath) && this._pwd.equals(key._pwd) && this._scriptPwd.equals(key._scriptPwd);
        }
    }
}

