/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.classes;

import com.caucho.quercus.env.CompiledClassDef;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.quercus.program.ClassDef;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyClassDef
extends CompiledClassDef {
    private static final Logger log = Logger.getLogger(LazyClassDef.class.getName());
    private static final L10N L = new L10N(LazyClassDef.class);
    private final String _name;
    private final Class _pageClass;
    private final String _className;
    private CompiledClassDef _def;

    public LazyClassDef(String name, Class pageClass, String className) {
        super(null, name, null, null);
        this._name = name;
        this._pageClass = pageClass;
        this._className = className;
    }

    public CompiledClassDef toClassDef() {
        if (this._def != null) {
            return this._def;
        }
        return this;
    }

    @Override
    public ClassDef loadClassDef() {
        return this.getClassDef();
    }

    private CompiledClassDef getClassDef() {
        if (this._def != null) {
            return this._def;
        }
        try {
            ClassLoader loader = this._pageClass.getClassLoader();
            String className = this._pageClass.getName() + "$" + this._className;
            Class<?> cl = Class.forName(className, false, loader);
            this._def = (CompiledClassDef)cl.newInstance();
            return this._def;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getName() {
        return this.getClassDef().getName();
    }

    @Override
    public String getParentName() {
        return this.getClassDef().getParentName();
    }

    @Override
    public String getExtension() {
        return this.getClassDef().getExtension();
    }

    @Override
    public void init() {
        this.getClassDef().init();
    }

    @Override
    public String[] getInterfaces() {
        return this.getClassDef().getInterfaces();
    }

    @Override
    public boolean isAbstract() {
        return this.getClassDef().isAbstract();
    }

    @Override
    public boolean isInterface() {
        return this.getClassDef().isInterface();
    }

    @Override
    public boolean isFinal() {
        return this.getClassDef().isFinal();
    }

    @Override
    public String getComment() {
        return this.getClassDef().getComment();
    }

    @Override
    public String getFieldComment(StringValue name) {
        return this.getClassDef().getFieldComment(name);
    }

    @Override
    public String getStaticFieldComment(StringValue name) {
        return this.getClassDef().getStaticFieldComment(name);
    }

    @Override
    public boolean hasNonPublicMethods() {
        return this.getClassDef().hasNonPublicMethods();
    }

    @Override
    public void initClass(QuercusClass cl) {
        this.getClassDef().initClass(cl);
    }

    @Override
    public ObjectValue newInstance(Env env, QuercusClass qcl) {
        return this.getClassDef().newInstance(env, qcl);
    }

    @Override
    public ObjectValue createObject(Env env, QuercusClass cls) {
        return this.getClassDef().createObject(env, cls);
    }

    @Override
    public Value callNew(Env env, Value[] args) {
        return this.getClassDef().callNew(env, args);
    }

    @Override
    public void initInstance(Env env, Value value) {
        this.getClassDef().initInstance(env, value);
    }

    @Override
    public boolean isA(String name) {
        return this.getClassDef().isA(name);
    }

    @Override
    public AbstractFunction findConstructor() {
        return this.getClassDef().findConstructor();
    }

    @Override
    public Expr findConstant(String name) {
        return this.getClassDef().findConstant(name);
    }

    @Override
    public int findFieldIndex(String name) {
        return this.getClassDef().findFieldIndex(name);
    }

    @Override
    public ArrayList<String> getFieldNames() {
        return this.getClassDef().getFieldNames();
    }

    @Override
    public Set<Map.Entry<StringValue, ClassDef.FieldEntry>> fieldSet() {
        return this.getClassDef().fieldSet();
    }

    @Override
    public Set<Map.Entry<String, AbstractFunction>> functionSet() {
        return this.getClassDef().functionSet();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "@" + System.identityHashCode(this) + "[" + this._name + "]";
    }
}

