/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.Callback;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.util.L10N;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.IdentityHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallbackObjectMethod
extends Callback {
    private static final L10N L = new L10N(CallbackObjectMethod.class);
    private final Value _obj;
    private final StringValue _methodName;
    private final int _hash;

    public CallbackObjectMethod(Value obj, StringValue methodName) {
        this._methodName = methodName;
        this._obj = obj;
        this._hash = methodName.hashCodeCaseInsensitive();
    }

    @Override
    public Value call(Env env) {
        return this._obj.callMethod(env, this._methodName, this._hash);
    }

    @Override
    public Value call(Env env, Value a1) {
        return this._obj.callMethod(env, this._methodName, this._hash, a1);
    }

    @Override
    public Value call(Env env, Value a1, Value a2) {
        return this._obj.callMethod(env, this._methodName, this._hash, a1, a2);
    }

    @Override
    public Value call(Env env, Value a1, Value a2, Value a3) {
        return this._obj.callMethod(env, this._methodName, this._hash, a1, a2, a3);
    }

    @Override
    public Value call(Env env, Value a1, Value a2, Value a3, Value a4) {
        return this._obj.callMethod(env, this._methodName, this._hash, a1, a2, a3, a4);
    }

    @Override
    public Value call(Env env, Value a1, Value a2, Value a3, Value a4, Value a5) {
        return this._obj.callMethod(env, this._methodName, this._hash, a1, a2, a3, a4, a5);
    }

    @Override
    public Value call(Env env, Value[] args) {
        return this._obj.callMethod(env, this._methodName, this._hash, args);
    }

    @Override
    public void varDumpImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        out.print(this.getClass().getName());
        out.print('[');
        out.print(this._methodName);
        out.print(']');
    }

    @Override
    public boolean isValid(Env env) {
        return true;
    }

    @Override
    public String getCallbackName() {
        return this._methodName.toString();
    }

    @Override
    public boolean isInternal(Env env) {
        return false;
    }

    private Value error(Env env) {
        env.warning(L.l("{0}::{1}() is an invalid callback method", (Object)this._obj.getClassName(), (Object)this._methodName));
        return NullValue.NULL;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._obj.getClassName() + "::" + this._methodName + "]";
    }
}

