/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.QuercusException;
import com.caucho.quercus.annotation.Expect;
import com.caucho.quercus.annotation.Name;
import com.caucho.quercus.annotation.NotNull;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.PassThru;
import com.caucho.quercus.annotation.Reference;
import com.caucho.quercus.annotation.ReturnNullAsFalse;
import com.caucho.quercus.annotation.This;
import com.caucho.quercus.annotation.UsesSymbolTable;
import com.caucho.quercus.annotation.VariableArguments;
import com.caucho.quercus.env.AbstractJavaMethod;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.marshal.Marshal;
import com.caucho.quercus.marshal.MarshalFactory;
import com.caucho.quercus.module.ModuleContext;
import com.caucho.quercus.parser.QuercusParser;
import com.caucho.quercus.program.ClassDef;
import com.caucho.quercus.program.JavaClassDef;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaInvoker
extends AbstractJavaMethod {
    private static final L10N L = new L10N(JavaInvoker.class);
    private static final Value[] NULL_VALUES = new Value[0];
    private final ModuleContext _moduleContext;
    private final JavaClassDef _classDef;
    private final String _name;
    protected final Method _method;
    private final Class<?>[] _param;
    private final Class<?> _retType;
    private final Annotation[][] _paramAnn;
    private final Annotation[] _methodAnn;
    private volatile boolean _isInit;
    private int _minArgumentLength;
    private int _maxArgumentLength;
    private boolean _hasEnv;
    private boolean _hasThis;
    private Expr[] _defaultExprs;
    private Marshal[] _marshalArgs;
    private boolean _hasRestArgs;
    private Marshal _unmarshalReturn;
    private boolean _isRestReference;
    private boolean _isCallUsesVariableArgs;
    private boolean _isCallUsesSymbolTable;

    public JavaInvoker(ModuleContext moduleContext, JavaClassDef classDef, Method method, String name, Class<?>[] param, Annotation[][] paramAnn, Annotation[] methodAnn, Class<?> retType) {
        this._moduleContext = moduleContext;
        this._name = name;
        this._param = param;
        this._paramAnn = paramAnn;
        this._methodAnn = methodAnn;
        this._retType = retType;
        this._classDef = classDef;
        this._method = method;
    }

    public JavaInvoker(ModuleContext moduleContext, JavaClassDef classDef, Method method) {
        this._name = JavaInvoker.getFunctionName(method);
        this._moduleContext = moduleContext;
        this._classDef = classDef;
        this._method = method;
        this._param = method.getParameterTypes();
        this._paramAnn = null;
        this._methodAnn = null;
        this._retType = method.getReturnType();
    }

    public static String getFunctionName(Method method) {
        Name nameAnn = method.getAnnotation(Name.class);
        if (nameAnn != null) {
            return nameAnn.value();
        }
        return method.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        if (this._isInit) {
            return;
        }
        JavaInvoker javaInvoker = this;
        synchronized (javaInvoker) {
            if (this._isInit) {
                return;
            }
            if (this._method != null) {
                this._method.setAccessible(true);
            }
            MarshalFactory marshalFactory = this._moduleContext.getMarshalFactory();
            ExprFactory exprFactory = this._moduleContext.getExprFactory();
            Annotation[][] paramAnn = this.getParamAnnImpl();
            Annotation[] methodAnn = this.getMethodAnn();
            try {
                boolean callUsesVariableArgs = false;
                boolean callUsesSymbolTable = false;
                boolean returnNullAsFalse = false;
                for (Annotation ann : methodAnn) {
                    if (VariableArguments.class.isAssignableFrom(ann.annotationType())) {
                        callUsesVariableArgs = true;
                    }
                    if (UsesSymbolTable.class.isAssignableFrom(ann.annotationType())) {
                        callUsesSymbolTable = true;
                    }
                    if (!ReturnNullAsFalse.class.isAssignableFrom(ann.annotationType())) continue;
                    returnNullAsFalse = true;
                }
                this._isCallUsesVariableArgs = callUsesVariableArgs;
                this._isCallUsesSymbolTable = callUsesSymbolTable;
                this._hasEnv = this._param.length > 0 && this._param[0].equals(Env.class);
                int envOffset = this._hasEnv ? 1 : 0;
                this._hasThis = envOffset < this._param.length ? this.hasThis(this._param[envOffset], paramAnn[envOffset]) : false;
                if (this._hasThis) {
                    ++envOffset;
                }
                boolean hasRestArgs = false;
                boolean isRestReference = false;
                if (this._param.length > 0 && (this._param[this._param.length - 1].equals(Value[].class) || this._param[this._param.length - 1].equals(Object[].class))) {
                    hasRestArgs = true;
                    for (Annotation ann : paramAnn[this._param.length - 1]) {
                        if (!Reference.class.isAssignableFrom(ann.annotationType())) continue;
                        isRestReference = true;
                    }
                }
                this._hasRestArgs = hasRestArgs;
                this._isRestReference = isRestReference;
                int argLength = this._param.length;
                if (this._hasRestArgs) {
                    --argLength;
                }
                this._defaultExprs = new Expr[argLength - envOffset];
                this._marshalArgs = new Marshal[argLength - envOffset];
                this._minArgumentLength = this._maxArgumentLength = argLength - envOffset;
                for (int i = 0; i < argLength - envOffset; ++i) {
                    boolean isReference = false;
                    boolean isPassThru = false;
                    boolean isNotNull = false;
                    boolean isExpectString = false;
                    boolean isExpectNumeric = false;
                    boolean isExpectBoolean = false;
                    Class<?> argType = this._param[i + envOffset];
                    for (Annotation ann : paramAnn[i + envOffset]) {
                        if (Optional.class.isAssignableFrom(ann.annotationType())) {
                            --this._minArgumentLength;
                            Optional opt = (Optional)ann;
                            if (opt.value().equals("caucho-not-set")) {
                                this._defaultExprs[i] = exprFactory.createDefault();
                                continue;
                            }
                            if (opt.value().equals("")) {
                                this._defaultExprs[i] = exprFactory.createLiteral(StringValue.EMPTY);
                                continue;
                            }
                            this._defaultExprs[i] = QuercusParser.parseDefault(exprFactory, opt.value());
                            continue;
                        }
                        if (Reference.class.isAssignableFrom(ann.annotationType())) {
                            if (!Value.class.equals(argType) && !Var.class.equals(argType)) {
                                throw new QuercusException(L.l("reference must be Value or Var for {0}", (Object)this._name));
                            }
                            isReference = true;
                            continue;
                        }
                        if (PassThru.class.isAssignableFrom(ann.annotationType())) {
                            if (!Value.class.equals(argType)) {
                                throw new QuercusException(L.l("pass thru must be Value for {0}", (Object)this._name));
                            }
                            isPassThru = true;
                            continue;
                        }
                        if (NotNull.class.isAssignableFrom(ann.annotationType())) {
                            isNotNull = true;
                            continue;
                        }
                        if (!Expect.class.isAssignableFrom(ann.annotationType())) continue;
                        if (!Value.class.equals(argType)) {
                            throw new QuercusException(L.l("Expect type must be Value for {0}", (Object)this._name));
                        }
                        Expect.Type type = ((Expect)ann).type();
                        if (type == Expect.Type.STRING) {
                            isExpectString = true;
                            continue;
                        }
                        if (type == Expect.Type.NUMERIC) {
                            isExpectNumeric = true;
                            continue;
                        }
                        if (type != Expect.Type.BOOLEAN) continue;
                        isExpectBoolean = true;
                    }
                    this._marshalArgs[i] = isReference ? marshalFactory.createReference() : (isPassThru ? marshalFactory.createValuePassThru() : (isExpectString ? marshalFactory.createExpectString() : (isExpectNumeric ? marshalFactory.createExpectNumeric() : (isExpectBoolean ? marshalFactory.createExpectBoolean() : marshalFactory.create(argType, isNotNull)))));
                }
                this._unmarshalReturn = marshalFactory.create(this._retType, false, returnNullAsFalse);
            }
            finally {
                this._isInit = true;
            }
        }
    }

    @Override
    public ClassDef getDeclaringClass() {
        return this._classDef;
    }

    @Override
    public int getMinArgLength() {
        if (!this._isInit) {
            this.init();
        }
        return this._minArgumentLength;
    }

    @Override
    public int getMaxArgLength() {
        if (!this._isInit) {
            this.init();
        }
        return this._maxArgumentLength;
    }

    @Override
    public Class<?> getJavaDeclaringClass() {
        if (this._method != null) {
            return this._method.getDeclaringClass();
        }
        return null;
    }

    public boolean getHasEnv() {
        if (!this._isInit) {
            this.init();
        }
        return this._hasEnv;
    }

    @Override
    public boolean getHasRestArgs() {
        if (!this._isInit) {
            this.init();
        }
        return this._hasRestArgs;
    }

    public boolean isRestReference() {
        if (!this._isInit) {
            this.init();
        }
        return this._isRestReference;
    }

    public Marshal getUnmarshalReturn() {
        if (!this._isInit) {
            this.init();
        }
        return this._unmarshalReturn;
    }

    @Override
    public boolean isCallUsesVariableArgs() {
        if (!this._isInit) {
            this.init();
        }
        return this._isCallUsesVariableArgs;
    }

    @Override
    public boolean isCallUsesSymbolTable() {
        if (!this._isInit) {
            this.init();
        }
        return this._isCallUsesSymbolTable;
    }

    @Override
    public boolean isBoolean() {
        if (!this._isInit) {
            this.init();
        }
        return this._unmarshalReturn.isBoolean();
    }

    @Override
    public boolean isString() {
        if (!this._isInit) {
            this.init();
        }
        return this._unmarshalReturn.isString();
    }

    @Override
    public boolean isLong() {
        if (!this._isInit) {
            this.init();
        }
        return this._unmarshalReturn.isLong();
    }

    @Override
    public boolean isDouble() {
        if (!this._isInit) {
            this.init();
        }
        return this._unmarshalReturn.isDouble();
    }

    @Override
    public String getName() {
        return this._name;
    }

    public Marshal[] getMarshalArgs() {
        if (!this._isInit) {
            this.init();
        }
        return this._marshalArgs;
    }

    protected Annotation[][] getParamAnn() {
        if (!this._isInit) {
            this.init();
        }
        return this.getParamAnnImpl();
    }

    private Annotation[][] getParamAnnImpl() {
        if (this._paramAnn != null) {
            return this._paramAnn;
        }
        return this._method.getParameterAnnotations();
    }

    protected Annotation[] getMethodAnn() {
        if (this._methodAnn != null) {
            return this._methodAnn;
        }
        return this._method.getAnnotations();
    }

    protected Expr[] getDefaultExprs() {
        if (!this._isInit) {
            this.init();
        }
        return this._defaultExprs;
    }

    @Override
    public Value[] evalArguments(Env env, Expr fun, Expr[] args) {
        if (!this._isInit) {
            this.init();
        }
        Value[] values = new Value[args.length];
        for (int i = 0; i < args.length; ++i) {
            Marshal arg = null;
            if (i >= this._marshalArgs.length) {
                if (this._isRestReference) {
                    values[i] = args[i].evalVar(env);
                    continue;
                }
                values[i] = args[i].eval(env);
                continue;
            }
            arg = this._marshalArgs[i];
            values[i] = arg == null ? args[i].eval(env).copy() : (arg.isReference() ? args[i].evalRef(env) : args[i].eval(env));
        }
        return values;
    }

    @Override
    public int getMarshalingCost(Value[] args) {
        int restLen;
        int i;
        if (!this._isInit) {
            this.init();
        }
        if (!this._hasRestArgs) {
            if (args.length < this.getMinArgLength()) {
                return Integer.MAX_VALUE;
            }
            if (args.length > this.getMaxArgLength()) {
                return Integer.MAX_VALUE;
            }
        }
        int cost = 0;
        for (i = 0; i < this._marshalArgs.length; ++i) {
            Marshal marshal = this._marshalArgs[i];
            if (i >= args.length || args[i] == null) continue;
            Value arg = args[i].toValue();
            int argCost = marshal.getMarshalingCost(arg);
            cost = Math.max(argCost + cost, cost);
        }
        if (this._hasRestArgs && (restLen = args.length - this._marshalArgs.length) > 0) {
            i += restLen;
        }
        if (i > this.getMaxArgLength()) {
            return Integer.MAX_VALUE;
        }
        return cost;
    }

    @Override
    public int getMarshalingCost(Expr[] args) {
        int restLen;
        int i;
        if (!this._isInit) {
            this.init();
        }
        if (!this._hasRestArgs) {
            if (args.length < this.getMinArgLength()) {
                return Integer.MAX_VALUE;
            }
            if (args.length > this.getMaxArgLength()) {
                return Integer.MAX_VALUE;
            }
        }
        int cost = 0;
        for (i = 0; i < this._marshalArgs.length; ++i) {
            Marshal marshal = this._marshalArgs[i];
            if (i >= args.length || args[i] == null) continue;
            Expr arg = args[i];
            int argCost = marshal.getMarshalingCost(arg);
            cost = Math.max(argCost + cost, cost);
        }
        if (this._hasRestArgs && (restLen = args.length - this._marshalArgs.length) > 0) {
            i += restLen;
        }
        if (i > this.getMaxArgLength()) {
            return Integer.MAX_VALUE;
        }
        return cost;
    }

    @Override
    public Value call(Env env, Value[] args) {
        return this.callMethod(env, (QuercusClass)null, (Value)null, args);
    }

    @Override
    public Value callMethodRef(Env env, QuercusClass qClass, Value qThis, Value[] args) {
        return this.callMethod(env, qClass, qThis, args);
    }

    @Override
    public Value callMethod(Env env, QuercusClass qClass, Value qThis, Value[] args) {
        ClassDef classDef;
        String parentName;
        Object result = this.callJavaMethod(env, qClass, qThis, args);
        if (qThis != null && this.isConstructor() && (parentName = qThis.getQuercusClass().getParentName()) != null && (classDef = this.getDeclaringClass()) != null && qThis.isA(classDef.getName())) {
            qThis.setJavaObject(result);
        }
        Value value = this._unmarshalReturn.unmarshal(env, result);
        return value;
    }

    @Override
    public Value callNew(Env env, QuercusClass qClass, Value qThis, Value[] args) {
        Object result = this.callJavaMethod(env, qClass, qThis, args);
        qThis.setJavaObject(result);
        return qThis;
    }

    private Object callJavaMethod(Env env, QuercusClass qClass, Value qThis, Value[] args) {
        if (!this._isInit) {
            this.init();
        }
        int len = this._param.length;
        Object[] javaArgs = new Object[len];
        int k = 0;
        if (this._hasEnv) {
            javaArgs[k++] = env;
        }
        Object obj = null;
        if (this._hasThis) {
            obj = qThis != null ? qThis.toJavaObject() : null;
            javaArgs[k++] = qThis;
        } else if (!this.isStatic() && !this.isConstructor()) {
            obj = qThis != null ? qThis.toJavaObject() : null;
        }
        String warnMessage = null;
        for (int i = 0; i < this._marshalArgs.length; ++i) {
            if (i < args.length && args[i] != null) {
                javaArgs[k] = this._marshalArgs[i].marshal(env, args[i], this._param[k]);
            } else if (this._defaultExprs[i] != null) {
                javaArgs[k] = this._marshalArgs[i].marshal(env, this._defaultExprs[i], this._param[k]);
            } else {
                warnMessage = L.l("function '{0}' has {1} required arguments, but only {2} were provided", (Object)this._name, (Object)this._minArgumentLength, (Object)args.length);
                javaArgs[k] = this._marshalArgs[i].marshal(env, NullValue.NULL, this._param[k]);
            }
            ++k;
        }
        if (warnMessage != null) {
            env.warning(warnMessage);
        }
        if (this._hasRestArgs) {
            Value[] rest;
            int restLen = args.length - this._marshalArgs.length;
            if (restLen <= 0) {
                rest = NULL_VALUES;
            } else {
                rest = new Value[restLen];
                for (int i = this._marshalArgs.length; i < args.length; ++i) {
                    rest[i - this._marshalArgs.length] = this._isRestReference ? args[i].toLocalVarDeclAsRef() : args[i].toValue();
                }
            }
            javaArgs[k++] = rest;
        } else if (this._marshalArgs.length < args.length) {
            env.warning(L.l("function '{0}' called with {1} arguments, but only expects {2} arguments", (Object)this._name, (Object)args.length, (Object)this._marshalArgs.length));
        }
        Object result = this.invoke(obj, javaArgs);
        return result;
    }

    public abstract Object invoke(Object var1, Object[] var2);

    private boolean hasThis(Class<?> param, Annotation[] ann) {
        if (!param.isAssignableFrom(ObjectValue.class)) {
            return false;
        }
        for (int i = 0; i < ann.length; ++i) {
            if (!This.class.isAssignableFrom(ann[i].annotationType())) continue;
            return true;
        }
        return false;
    }
}

