/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.QuercusException;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.EnvCloseable;
import com.caucho.quercus.env.JsonEncodeContext;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.SerializeMap;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnsetValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.program.JavaClassDef;
import com.caucho.vfs.WriteStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaValue
extends ObjectValue
implements Serializable {
    private static final Logger log = Logger.getLogger(JavaValue.class.getName());
    private JavaClassDef _classDef;
    protected Env _env;
    private Object _object;

    public JavaValue(Env env, Object object, JavaClassDef def) {
        this.setQuercusClass(env.createJavaQuercusClass(def));
        this._classDef = def;
        this._object = object;
    }

    public JavaValue(Object object, JavaClassDef def, QuercusClass qClass) {
        this.setQuercusClass(qClass);
        this._classDef = def;
        this._object = object;
    }

    protected JavaClassDef getJavaClassDef() {
        return this._classDef;
    }

    @Override
    public String getClassName() {
        return this._classDef.getName();
    }

    @Override
    public long toLong() {
        return StringValue.parseLong(this.toString(Env.getInstance()));
    }

    @Override
    public double toDouble() {
        return JavaValue.toDouble(this.toString(Env.getInstance()).toString());
    }

    public static double toDouble(String s) {
        int len = s.length();
        int i = 0;
        char ch = '\u0000';
        if (i < len && ((ch = s.charAt(i)) == '+' || ch == '-')) {
            ++i;
        }
        while (i < len && '0' <= (ch = s.charAt(i)) && ch <= '9') {
            ++i;
        }
        if (ch == '.') {
            ++i;
            while (i < len && '0' <= (ch = s.charAt(i)) && ch <= '9') {
                ++i;
            }
        }
        if (ch == 'e' || ch == 'E') {
            int e = i++;
            if (i < len && (ch = s.charAt(i)) == '+' || ch == '-') {
                ++i;
            }
            while (i < len && '0' <= (ch = s.charAt(i)) && ch <= '9') {
                ++i;
            }
            if (i == e + 1) {
                i = e;
            }
        }
        if (i != len) {
            return 1.0;
        }
        return Double.parseDouble(s);
    }

    @Override
    public StringValue toString(Env env) {
        StringValue value = this._classDef.toString(env, this);
        if (value == null) {
            value = env.createString(this.toString());
        }
        return value;
    }

    @Override
    protected void printRImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        if (this._classDef.printRImpl(env, this._object, out, depth, valueSet)) {
            return;
        }
        Set<? extends Map.Entry<Value, Value>> entrySet = this.entrySet();
        if (entrySet == null) {
            out.print("resource(" + this.toString(env) + ")");
            return;
        }
        out.print(this._classDef.getSimpleName());
        out.println(" Object");
        JavaValue.printRDepth(out, depth);
        out.print("(");
        for (Map.Entry<Value, Value> entry : entrySet) {
            out.println();
            JavaValue.printRDepth(out, depth);
            out.print("    [" + entry.getKey() + "] => ");
            entry.getValue().printRImpl(env, out, depth + 1, valueSet);
        }
        out.println();
        JavaValue.printRDepth(out, depth);
        out.println(")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void varDumpImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        Value oldThis = env.setThis(this);
        try {
            if (!this._classDef.varDumpImpl(env, this, this._object, out, depth, valueSet)) {
                out.print("resource(" + this.toString(env) + ")");
            }
        }
        finally {
            env.setThis(oldThis);
        }
    }

    @Override
    public Value getField(Env env, StringValue name) {
        Value value = this._classDef.getField(env, this, name);
        if (value != null) {
            return value;
        }
        return UnsetValue.NULL;
    }

    @Override
    public Value putField(Env env, StringValue name, Value value) {
        Value oldValue = this._classDef.putField(env, this, name, value);
        if (oldValue != null) {
            return oldValue;
        }
        return NullValue.NULL;
    }

    @Override
    public Set<? extends Map.Entry<Value, Value>> entrySet() {
        return this._classDef.entrySet(this._object);
    }

    @Override
    public Value toKey() {
        return new LongValue(System.identityHashCode(this));
    }

    @Override
    public int cmpObject(ObjectValue rValue) {
        if (rValue == this) {
            return 0;
        }
        if (!(rValue instanceof JavaValue)) {
            return -1;
        }
        Object rObject = rValue.toJavaObject();
        return this._classDef.cmpObject(this._object, rObject, ((JavaValue)rValue)._classDef);
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public boolean isResource() {
        return false;
    }

    @Override
    public String getType() {
        return "object";
    }

    @Override
    public Value callMethod(Env env, StringValue methodName, int hash, Value[] args) {
        return this._classDef.callMethod(env, (Value)this, methodName, hash, args);
    }

    @Override
    public Value callMethod(Env env, StringValue methodName, int hash) {
        return this._classDef.callMethod(env, this, methodName, hash);
    }

    @Override
    public Value callMethod(Env env, StringValue methodName, int hash, Value a1) {
        return this._classDef.callMethod(env, (Value)this, methodName, hash, a1);
    }

    @Override
    public Value callMethod(Env env, StringValue methodName, int hash, Value a1, Value a2) {
        return this._classDef.callMethod(env, this, methodName, hash, a1, a2);
    }

    @Override
    public Value callMethod(Env env, StringValue methodName, int hash, Value a1, Value a2, Value a3) {
        return this._classDef.callMethod(env, this, methodName, hash, a1, a2, a3);
    }

    @Override
    public Value callMethod(Env env, StringValue methodName, int hash, Value a1, Value a2, Value a3, Value a4) {
        return this._classDef.callMethod(env, this, methodName, hash, a1, a2, a3, a4);
    }

    @Override
    public Value callMethod(Env env, StringValue methodName, int hash, Value a1, Value a2, Value a3, Value a4, Value a5) {
        return this._classDef.callMethod(env, this, methodName, hash, a1, a2, a3, a4, a5);
    }

    @Override
    public Value callMethodRef(Env env, StringValue methodName, int hash, Value[] args) {
        return this._classDef.callMethod(env, (Value)this, methodName, hash, args);
    }

    @Override
    public Value callMethodRef(Env env, StringValue methodName, int hash) {
        Value value = this._classDef.callMethod(env, this, methodName, hash);
        return value;
    }

    @Override
    public Value callMethodRef(Env env, StringValue methodName, int hash, Value a1) {
        return this._classDef.callMethod(env, (Value)this, methodName, hash, a1);
    }

    @Override
    public Value callMethodRef(Env env, StringValue methodName, int hash, Value a1, Value a2) {
        return this._classDef.callMethod(env, this, methodName, hash, a1, a2);
    }

    @Override
    public Value callMethodRef(Env env, StringValue methodName, int hash, Value a1, Value a2, Value a3) {
        return this._classDef.callMethod(env, this, methodName, hash, a1, a2, a3);
    }

    @Override
    public Value callMethodRef(Env env, StringValue methodName, int hash, Value a1, Value a2, Value a3, Value a4) {
        return this._classDef.callMethod(env, this, methodName, hash, a1, a2, a3, a4);
    }

    @Override
    public Value callMethodRef(Env env, StringValue methodName, int hash, Value a1, Value a2, Value a3, Value a4, Value a5) {
        return this._classDef.callMethod(env, this, methodName, hash, a1, a2, a3, a4, a5);
    }

    @Override
    public Value clone(Env env) {
        Object obj = null;
        if (this._object != null) {
            if (!(this._object instanceof Cloneable)) {
                return env.error(L.l("Java class {0} does not implement Cloneable", (Object)this._object.getClass().getName()));
            }
            Class<?> cls = this._classDef.getType();
            try {
                Method method = cls.getMethod("clone", new Class[0]);
                method.setAccessible(true);
                obj = method.invoke(this._object, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                throw new QuercusException(e);
            }
            catch (InvocationTargetException e) {
                throw new QuercusException(e.getCause());
            }
            catch (IllegalAccessException e) {
                throw new QuercusException(e);
            }
        }
        return new JavaValue(obj, this._classDef, this.getQuercusClass());
    }

    @Override
    public void serialize(Env env, StringBuilder sb, SerializeMap map) {
        String name = this._classDef.getSimpleName();
        Set<? extends Map.Entry<Value, Value>> entrySet = this.entrySet();
        if (entrySet != null) {
            sb.append("O:");
            sb.append(name.length());
            sb.append(":\"");
            sb.append(name);
            sb.append("\":");
            sb.append(entrySet.size());
            sb.append(":{");
            for (Map.Entry<Value, Value> entry : entrySet) {
                entry.getKey().serialize(env, sb);
                entry.getValue().serialize(env, sb, map);
            }
            sb.append("}");
        } else {
            sb.append("i:0;");
        }
    }

    @Override
    public void jsonEncode(Env env, JsonEncodeContext context, StringValue sb) {
        if (this._classDef.jsonEncode(env, this._object, context, sb)) {
            return;
        }
        super.jsonEncode(env, context, sb);
    }

    public String toString() {
        if (this._object != null) {
            return String.valueOf(this._object);
        }
        return String.valueOf(this._classDef.getName());
    }

    @Override
    public Object toJavaObject() {
        return this._object;
    }

    @Override
    public final Object toJavaObject(Env env, Class<?> type) {
        Object object = this._object;
        Class<?> objectClass = this._object.getClass();
        if (type == objectClass || type.isAssignableFrom(objectClass)) {
            return object;
        }
        env.warning(L.l("Can't assign {0} to {1}", (Object)objectClass.getName(), (Object)type.getName()));
        return null;
    }

    @Override
    public Object toJavaObjectNotNull(Env env, Class<?> type) {
        Class<?> objClass = this._object.getClass();
        if (objClass == type || type.isAssignableFrom(objClass)) {
            return this._object;
        }
        env.warning(L.l("Can't assign {0} to {1}", (Object)objClass.getName(), (Object)type.getName()));
        return null;
    }

    @Override
    public Map<?, ?> toJavaMap(Env env, Class<?> type) {
        if (type.isAssignableFrom(this._object.getClass())) {
            return (Map)this._object;
        }
        env.warning(L.l("Can't assign {0} to {1}", (Object)this._object.getClass().getName(), (Object)type.getName()));
        return null;
    }

    @Override
    public InputStream toInputStream() {
        if (this._object instanceof InputStream) {
            return (InputStream)this._object;
        }
        if (this._object instanceof File) {
            try {
                FileInputStream is = new FileInputStream((File)this._object);
                Env.getCurrent().addCleanup(new EnvCloseable(is));
                return is;
            }
            catch (IOException e) {
                throw new QuercusException(e);
            }
        }
        return super.toInputStream();
    }

    private static void printRDepth(WriteStream out, int depth) throws IOException {
        for (int i = 0; i < 8 * depth; ++i) {
            out.print(' ');
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this._classDef.getType().getCanonicalName());
        out.writeObject(this._object);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        this._env = Env.getInstance();
        this._classDef = this._env.getJavaClassDefinition((String)in.readObject());
        int id = this._env.getQuercus().getClassId(this._classDef.getName());
        this.setQuercusClass(this._env.createQuercusClass(id, this._classDef, null));
        this._object = in.readObject();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EntryItem
    implements Map.Entry<Value, Value> {
        private Value _key;
        private Value _value;
        private boolean _isArray;

        EntryItem(Value key, Value value) {
            this._key = key;
            this._value = value;
        }

        @Override
        public Value getKey() {
            return this._key;
        }

        @Override
        public Value getValue() {
            return this._value;
        }

        @Override
        public Value setValue(Value value) {
            return this._value;
        }

        void addValue(Value value) {
            ArrayValue array = null;
            if (!this._isArray) {
                this._isArray = true;
                Value oldValue = this._value;
                this._value = new ArrayValueImpl();
                array = (ArrayValue)this._value;
                array.append(oldValue);
            } else {
                array = (ArrayValue)this._value;
            }
            array.append(value);
        }
    }
}

