/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.ArrayDelegate;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BinaryBuilderValue;
import com.caucho.quercus.env.CountDelegate;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.FieldVisibility;
import com.caucho.quercus.env.JsonEncodeContext;
import com.caucho.quercus.env.LargeStringBuilderValue;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.TraversableDelegate;
import com.caucho.quercus.env.UnicodeBuilderValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.quercus.lib.ArrayModule;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectValue
extends Value {
    protected transient QuercusClass _quercusClass;
    protected String _className;
    protected String _incompleteObjectName;

    protected ObjectValue() {
    }

    protected ObjectValue(QuercusClass quercusClass) {
        this._quercusClass = quercusClass;
        this._className = quercusClass.getName();
    }

    protected void setQuercusClass(QuercusClass cl) {
        this._quercusClass = cl;
        this._className = cl.getName();
    }

    @Override
    public QuercusClass getQuercusClass() {
        return this._quercusClass;
    }

    public boolean isIncompleteObject() {
        return this._incompleteObjectName != null;
    }

    public String getIncompleteObjectName() {
        return this._incompleteObjectName;
    }

    public void setIncompleteObjectName(String name) {
        this._incompleteObjectName = name;
    }

    public void initObject(Env env, QuercusClass cls) {
        this.setQuercusClass(cls);
        this._incompleteObjectName = null;
    }

    public final void cleanup(Env env) {
        QuercusClass qClass = this.getQuercusClass();
        AbstractFunction fun = qClass.getDestructor();
        if (fun != null) {
            fun.callMethod(env, qClass, (Value)this);
        }
    }

    @Override
    public String getClassName() {
        return this._className;
    }

    public abstract Set<? extends Map.Entry<Value, Value>> entrySet();

    public String getName() {
        return this._className;
    }

    public String getParentClassName() {
        return this._quercusClass.getParentName();
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public String getType() {
        return "object";
    }

    @Override
    public boolean isCallable(Env env, boolean isCheckSyntaxOnly, Value nameRef) {
        if (this._quercusClass.getInvoke() == null) {
            if (nameRef != null) {
                nameRef.set(NullValue.NULL);
            }
            return false;
        }
        if (nameRef != null) {
            StringValue sb = env.createStringBuilder();
            sb.append(this._quercusClass.getName());
            sb.append("::");
            sb.append("__invoke");
            nameRef.set(sb);
        }
        return true;
    }

    @Override
    public boolean toBoolean() {
        return true;
    }

    @Override
    public boolean isA(String name) {
        return this._quercusClass.isA(name);
    }

    @Override
    public long toLong() {
        return 1L;
    }

    @Override
    public double toDouble() {
        return this.toLong();
    }

    @Override
    public Value toAutoArray() {
        return this;
    }

    @Override
    public StringValue appendTo(UnicodeBuilderValue sb) {
        return sb.append(this.toString(Env.getInstance()));
    }

    @Override
    public StringValue appendTo(StringBuilderValue sb) {
        return sb.append(this.toString(Env.getInstance()));
    }

    @Override
    public StringValue appendTo(BinaryBuilderValue sb) {
        return sb.appendBytes(this.toString(Env.getInstance()));
    }

    @Override
    public StringValue appendTo(LargeStringBuilderValue sb) {
        return sb.append(this.toString(Env.getInstance()));
    }

    @Override
    public Value get(Value key) {
        Env env = Env.getInstance();
        ArrayDelegate delegate = this._quercusClass.getArrayDelegate();
        if (delegate != null) {
            return delegate.get(env, this, key);
        }
        return env.error(L.l("Can't use object '{0}' as array", (Object)this.getName()));
    }

    @Override
    public Value put(Value key, Value value) {
        Env env = Env.getInstance();
        ArrayDelegate delegate = this._quercusClass.getArrayDelegate();
        if (delegate != null) {
            return delegate.put(env, this, key, value);
        }
        return env.error(L.l("Can't use object '{0}' as array", (Object)this.getName()));
    }

    @Override
    public Value put(Value value) {
        Env env = Env.getInstance();
        ArrayDelegate delegate = this._quercusClass.getArrayDelegate();
        if (delegate != null) {
            return delegate.put(env, this, value);
        }
        return env.error(L.l("Can't use object '{0}' as array", (Object)this.getName()));
    }

    @Override
    public Value append(Value index, Value value) {
        this.put(index, value);
        return this;
    }

    @Override
    public boolean isset(Value key) {
        ArrayDelegate delegate = this._quercusClass.getArrayDelegate();
        if (delegate != null) {
            Env env = Env.getInstance();
            return delegate.isset(env, this, key);
        }
        return false;
    }

    @Override
    public Value remove(Value key) {
        ArrayDelegate delegate = this._quercusClass.getArrayDelegate();
        if (delegate != null) {
            Env env = Env.getInstance();
            return delegate.unset(env, this, key);
        }
        return super.remove(key);
    }

    @Override
    public Iterator<Map.Entry<Value, Value>> getIterator(Env env) {
        TraversableDelegate delegate = this._quercusClass.getTraversableDelegate();
        if (delegate != null) {
            return delegate.getIterator(env, this);
        }
        return this.getBaseIterator(env);
    }

    @Override
    public Iterator<Value> getKeyIterator(Env env) {
        TraversableDelegate delegate = this._quercusClass.getTraversableDelegate();
        if (delegate != null) {
            return delegate.getKeyIterator(env, this);
        }
        return super.getKeyIterator(env);
    }

    @Override
    public Iterator<Value> getValueIterator(Env env) {
        TraversableDelegate delegate = this._quercusClass.getTraversableDelegate();
        if (delegate != null) {
            return delegate.getValueIterator(env, this);
        }
        return super.getValueIterator(env);
    }

    @Override
    public int getCount(Env env) {
        CountDelegate delegate = this._quercusClass.getCountDelegate();
        if (delegate != null) {
            return delegate.count(env, this);
        }
        return super.getSize();
    }

    public Value putField(String key, String value) {
        Env env = Env.getInstance();
        return this.putThisField(env, env.createString(key), env.createString(value));
    }

    public Value putField(Env env, String key, String value) {
        return this.putThisField(env, env.createString(key), env.createString(value));
    }

    public Value putField(String key, long value) {
        Env env = Env.getInstance();
        return this.putThisField(env, env.createString(key), LongValue.create(value));
    }

    public Value putField(Env env, String key, long value) {
        return this.putThisField(env, env.createString(key), LongValue.create(value));
    }

    @Override
    public Value putField(Env env, String key, Value value) {
        return this.putThisField(env, env.createString(key), value);
    }

    @Override
    public void initField(StringValue key, Value value, FieldVisibility visibility) {
        this.putThisField(Env.getInstance(), key, value);
    }

    public Value putField(String key, double value) {
        Env env = Env.getInstance();
        return this.putThisField(env, env.createString(key), DoubleValue.create(value));
    }

    @Override
    public boolean eq(Value rValue) {
        if (rValue.isObject()) {
            return this.cmpObject((ObjectValue)(rValue = rValue.toValue())) == 0;
        }
        if (rValue.isArray()) {
            return false;
        }
        return rValue.eq(this.toStringValue());
    }

    public int cmpObject(ObjectValue rValue) {
        Set<? extends Map.Entry<Value, Value>> bSet;
        if (rValue == this) {
            return 0;
        }
        int result = this.getName().compareTo(rValue.getName());
        if (result != 0) {
            return result;
        }
        Set<? extends Map.Entry<Value, Value>> aSet = this.entrySet();
        if (((Object)aSet).equals(bSet = rValue.entrySet())) {
            return 0;
        }
        if (aSet.size() > bSet.size()) {
            return 1;
        }
        if (aSet.size() < bSet.size()) {
            return -1;
        }
        TreeSet<? extends Map.Entry<Value, Value>> aTree = new TreeSet<Map.Entry<Value, Value>>(aSet);
        TreeSet<? extends Map.Entry<Value, Value>> bTree = new TreeSet<Map.Entry<Value, Value>>(bSet);
        Iterator<? extends Map.Entry<Value, Value>> iterA = aTree.iterator();
        Iterator<? extends Map.Entry<Value, Value>> iterB = bTree.iterator();
        while (iterA.hasNext()) {
            Map.Entry<Value, Value> a = iterA.next();
            Map.Entry<Value, Value> b = iterB.next();
            result = a.getKey().cmp(b.getKey());
            if (result != 0) {
                return result;
            }
            result = a.getValue().cmp(b.getValue());
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    @Override
    public final AbstractFunction findFunction(StringValue methodName) {
        return this._quercusClass.findFunction(methodName);
    }

    @Override
    public Value call(Env env, Value[] args) {
        AbstractFunction fun = this._quercusClass.getInvoke();
        if (fun != null) {
            return fun.callMethod(env, this._quercusClass, (Value)this, args);
        }
        return super.call(env, args);
    }

    public void varDumpObject(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        Map.Entry<Value, Value> entry;
        int size = this.getSize();
        if (this.isIncompleteObject()) {
            ++size;
        }
        out.println("object(" + this.getName() + ") (" + size + ") {");
        if (this.isIncompleteObject()) {
            this.printDepth(out, 2 * (depth + 1));
            out.println("[\"__Quercus_Incomplete_Class_name\"]=>");
            this.printDepth(out, 2 * (depth + 1));
            StringValue value = env.createString(this.getIncompleteObjectName());
            value.varDump(env, out, depth + 1, valueSet);
            out.println();
        }
        ArrayValueImpl sortedEntries = new ArrayValueImpl();
        Iterator<Map.Entry<Value, Value>> iter = this.getIterator(env);
        while (iter.hasNext()) {
            entry = iter.next();
            sortedEntries.put(entry.getKey(), entry.getValue());
        }
        ArrayModule.ksort(env, sortedEntries, 2L);
        iter = sortedEntries.getIterator(env);
        while (iter.hasNext()) {
            entry = iter.next();
            Value key = entry.getKey();
            Value value = entry.getValue();
            this.printDepth(out, 2 * depth);
            out.println("[\"" + key + "\"]=>");
            this.printDepth(out, 2 * ++depth);
            value.varDump(env, out, depth, valueSet);
            out.println();
            --depth;
        }
        this.printDepth(out, 2 * depth);
        out.print("}");
    }

    @Override
    public void jsonEncode(Env env, JsonEncodeContext context, StringValue sb) {
        sb.append('{');
        int length = 0;
        Iterator<Map.Entry<Value, Value>> iter = this.getIterator(env);
        while (iter.hasNext()) {
            Map.Entry<Value, Value> entry = iter.next();
            if (length > 0) {
                sb.append(',');
            }
            entry.getKey().toStringValue(env).jsonEncode(env, context, sb);
            sb.append(':');
            entry.getValue().jsonEncode(env, context, sb);
            ++length;
        }
        sb.append('}');
    }
}

