/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.QuercusRuntimeException;
import com.caucho.quercus.env.ArrayDelegate;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.ClassField;
import com.caucho.quercus.env.ConstStringValue;
import com.caucho.quercus.env.CountDelegate;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.FieldVisibility;
import com.caucho.quercus.env.MethodMap;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.ObjectExtJavaValue;
import com.caucho.quercus.env.ObjectExtValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.TraversableDelegate;
import com.caucho.quercus.env.UnicodeBuilderValue;
import com.caucho.quercus.env.UnsetValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.ClassConstExpr;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.quercus.module.ModuleContext;
import com.caucho.quercus.program.ClassDef;
import com.caucho.quercus.program.InstanceInitializer;
import com.caucho.quercus.program.JavaClassDef;
import com.caucho.util.L10N;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuercusClass
extends NullValue {
    private static final L10N L = new L10N(QuercusClass.class);
    private static final Logger log = Logger.getLogger(QuercusClass.class.getName());
    private final JavaClassDef _javaClassDef;
    private final ClassDef _classDef;
    private final String _className;
    private QuercusClass _parent;
    private WeakReference<QuercusClass> _cacheRef;
    private boolean _isAbstract;
    private boolean _isInterface;
    private boolean _isJavaWrapper;
    private ClassDef[] _classDefList;
    private AbstractFunction _constructor;
    private AbstractFunction _destructor;
    private AbstractFunction _fieldGet;
    private AbstractFunction _fieldSet;
    private AbstractFunction _call;
    private AbstractFunction _invoke;
    private AbstractFunction _toString;
    private AbstractFunction _isset;
    private AbstractFunction _unset;
    private ArrayDelegate _arrayDelegate;
    private TraversableDelegate _traversableDelegate;
    private CountDelegate _countDelegate;
    private final ArrayList<InstanceInitializer> _initializers;
    private final MethodMap<AbstractFunction> _methodMap;
    private final HashMap<StringValue, Expr> _constMap;
    private final HashMap<StringValue, Object> _constJavaMap;
    private final LinkedHashMap<StringValue, ClassField> _fieldMap;
    private final HashMap<String, ArrayList<StaticField>> _staticFieldExprMap;
    private final HashMap<StringValue, StringValue> _staticFieldNameMap;
    private final HashSet<String> _instanceofSet;
    private boolean _isModified;
    private final ModuleContext _moduleContext;

    public QuercusClass(ModuleContext moduleContext, ClassDef classDef, QuercusClass parent) {
        int i;
        ClassDef[] classDefList;
        this._moduleContext = moduleContext;
        this._classDef = classDef.loadClassDef();
        this._className = classDef.getName();
        this._parent = parent;
        this._isAbstract = this._classDef.isAbstract();
        this._isInterface = this._classDef.isInterface();
        this._initializers = new ArrayList();
        this._fieldMap = new LinkedHashMap();
        this._methodMap = new MethodMap(this, null);
        this._constMap = new HashMap();
        this._constJavaMap = new HashMap();
        this._staticFieldExprMap = new LinkedHashMap<String, ArrayList<StaticField>>();
        this._staticFieldNameMap = new LinkedHashMap<StringValue, StringValue>();
        if (parent != null) {
            this._staticFieldNameMap.putAll(parent._staticFieldNameMap);
        }
        JavaClassDef javaClassDef = null;
        if (classDef instanceof JavaClassDef) {
            javaClassDef = (JavaClassDef)classDef;
            boolean bl = this._isJavaWrapper = !javaClassDef.isDelegate();
        }
        if (this._parent != null) {
            classDefList = new ClassDef[parent._classDefList.length + 1];
            System.arraycopy(parent._classDefList, 0, classDefList, 1, parent._classDefList.length);
            classDefList[0] = classDef;
        } else {
            classDefList = new ClassDef[]{classDef};
        }
        this._classDefList = classDefList;
        for (int i2 = 0; i2 < classDefList.length; ++i2) {
            if (!(classDefList[i2] instanceof JavaClassDef)) continue;
            javaClassDef = (JavaClassDef)classDefList[i2];
        }
        this._javaClassDef = javaClassDef;
        this._instanceofSet = new HashSet();
        HashSet<String> ifaces = new HashSet<String>();
        for (i = classDefList.length - 1; i >= 0; --i) {
            classDef = classDefList[i];
            if (classDef == null) {
                throw new NullPointerException("classDef:" + this._classDef + " i:" + i + " parent:" + parent);
            }
            classDef.init();
            this.addInstances(this._instanceofSet, ifaces, classDef);
        }
        for (i = classDefList.length - 1; i >= 0; --i) {
            classDef = classDefList[i];
            classDef.initClass(this);
        }
        if (this._constructor != null && parent != null && !this._constructor.getName().equals("__construct") && !this._className.equals(this._constructor.getDeclaringClassName())) {
            this.addMethodIfNotExist(this._className, this._constructor);
        }
        if (this._destructor == null && parent != null) {
            this._destructor = parent.getDestructor();
        }
    }

    private void addInstances(HashSet<String> instanceofSet, HashSet<String> ifaces, ClassDef classDef) {
        classDef.addInterfaces(instanceofSet);
        for (String iface : classDef.getInterfaces()) {
            boolean isJavaClassDef = classDef instanceof JavaClassDef;
            QuercusClass cl = Env.getInstance().findClass(iface, !isJavaClassDef, true);
            if (cl == null) {
                throw new QuercusRuntimeException(L.l("cannot find interface {0}", (Object)iface));
            }
            ClassDef ifaceDef = cl.getClassDef();
            if (ifaceDef == null || !ifaces.add(iface)) continue;
            this.addInstances(instanceofSet, ifaces, ifaceDef);
            ifaceDef.initClass(this);
        }
    }

    public QuercusClass(QuercusClass cacheClass, QuercusClass parent) {
        this._cacheRef = new WeakReference<QuercusClass>(cacheClass);
        this._javaClassDef = cacheClass._javaClassDef;
        this._classDef = cacheClass._classDef;
        this._className = cacheClass._className;
        this._isJavaWrapper = cacheClass._isJavaWrapper;
        this._classDefList = cacheClass._classDefList;
        this._parent = parent;
        this._constructor = cacheClass._constructor;
        this._destructor = cacheClass._destructor;
        this._fieldGet = cacheClass._fieldGet;
        this._fieldSet = cacheClass._fieldSet;
        this._call = cacheClass._call;
        this._invoke = cacheClass._invoke;
        this._toString = cacheClass._toString;
        this._arrayDelegate = cacheClass._arrayDelegate;
        this._traversableDelegate = cacheClass._traversableDelegate;
        this._countDelegate = cacheClass._countDelegate;
        this._initializers = cacheClass._initializers;
        this._fieldMap = cacheClass._fieldMap;
        this._methodMap = cacheClass._methodMap;
        this._constMap = cacheClass._constMap;
        this._constJavaMap = cacheClass._constJavaMap;
        this._staticFieldExprMap = cacheClass._staticFieldExprMap;
        this._staticFieldNameMap = cacheClass._staticFieldNameMap;
        this._instanceofSet = cacheClass._instanceofSet;
        this._moduleContext = cacheClass._moduleContext;
    }

    public ClassDef getClassDef() {
        return this._classDef;
    }

    public JavaClassDef getJavaClassDef() {
        return this._javaClassDef;
    }

    public MethodMap<AbstractFunction> getMethodMap() {
        return this._methodMap;
    }

    public HashSet<String> getInstanceofSet() {
        return this._instanceofSet;
    }

    public String getName() {
        return this._className;
    }

    public QuercusClass getParent() {
        return this._parent;
    }

    public ClassDef[] getClassDefList() {
        return this._classDefList;
    }

    public String getExtension() {
        return this._classDef.getExtension();
    }

    public boolean isInterface() {
        return this._isInterface;
    }

    public boolean isAbstract() {
        return this._isAbstract;
    }

    public boolean isFinal() {
        return this._classDef.isFinal();
    }

    public void setConstructor(AbstractFunction fun) {
        this._constructor = fun;
    }

    public AbstractFunction getConstructor() {
        return this._constructor;
    }

    public void setDestructor(AbstractFunction fun) {
        this._destructor = fun;
    }

    public AbstractFunction getDestructor() {
        return this._destructor;
    }

    public boolean isModified() {
        if (this._isModified) {
            return true;
        }
        if (this._parent != null) {
            return this._parent.isModified();
        }
        return false;
    }

    public void setModified() {
        if (!this._isModified) {
            QuercusClass cacheClass;
            this._isModified = true;
            if (this._cacheRef != null && (cacheClass = (QuercusClass)this._cacheRef.get()) != null) {
                cacheClass.setModified();
            }
        }
    }

    public void setArrayDelegate(ArrayDelegate delegate) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, L.l("{0} adding array delegate {1}", (Object)this, (Object)delegate));
        }
        this._arrayDelegate = delegate;
    }

    public final ArrayDelegate getArrayDelegate() {
        return this._arrayDelegate;
    }

    public void setTraversableDelegate(TraversableDelegate delegate) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, L.l("{0} setting traversable delegate {1}", (Object)this, (Object)delegate));
        }
        this._traversableDelegate = delegate;
    }

    public final TraversableDelegate getTraversableDelegate() {
        return this._traversableDelegate;
    }

    public void setCountDelegate(CountDelegate delegate) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, L.l("{0} setting count delegate {1}", (Object)this, (Object)delegate));
        }
        this._countDelegate = delegate;
    }

    public final CountDelegate getCountDelegate() {
        return this._countDelegate;
    }

    public void setFieldGet(AbstractFunction fun) {
        this._fieldGet = fun;
    }

    public AbstractFunction getFieldGet() {
        return this._fieldGet;
    }

    public void setFieldSet(AbstractFunction fun) {
        this._fieldSet = fun;
    }

    public AbstractFunction getFieldSet() {
        return this._fieldSet;
    }

    public void setCall(AbstractFunction fun) {
        this._call = fun;
    }

    public AbstractFunction getCall() {
        return this._call;
    }

    public void setInvoke(AbstractFunction fun) {
        this._invoke = fun;
    }

    public AbstractFunction getInvoke() {
        return this._invoke;
    }

    public void setToString(AbstractFunction fun) {
        this._toString = fun;
    }

    public AbstractFunction getToString() {
        return this._toString;
    }

    public void addInitializer(InstanceInitializer init) {
        this._initializers.add(init);
    }

    public void addField(StringValue name, Expr initExpr, FieldVisibility visibility) {
        ClassField field = new ClassField(name, initExpr, visibility);
        this._fieldMap.put(name, field);
    }

    public HashMap<StringValue, ClassField> getClassFields() {
        return this._fieldMap;
    }

    public ClassField getClassField(StringValue name) {
        return this._fieldMap.get(name);
    }

    public int findFieldIndex(StringValue name) {
        throw new UnsupportedOperationException();
    }

    public Iterable<AbstractFunction> getClassMethods() {
        return this._methodMap.values();
    }

    public void addMethod(String name, AbstractFunction fun) {
        if (fun == null) {
            throw new NullPointerException(L.l("'{0}' is a null function", (Object)name));
        }
        StringValue nameV = this._moduleContext.createString(name);
        AbstractFunction existingFun = this._methodMap.getRaw(nameV);
        if (existingFun == null || !fun.isAbstract()) {
            this._methodMap.put(nameV, fun);
        } else if (!existingFun.isAbstract() && fun.isAbstract()) {
            Env.getInstance().error(L.l("cannot make non-abstract function {0}:{1}() abstract", (Object)this.getName(), (Object)name));
        }
    }

    public void addMethodIfNotExist(String name, AbstractFunction fun) {
        if (fun == null) {
            throw new NullPointerException(L.l("'{0}' is a null function", (Object)name));
        }
        StringValue nameV = this._moduleContext.createString(name);
        AbstractFunction existingFun = this._methodMap.getRaw(nameV);
        if (existingFun == null && !fun.isAbstract()) {
            this._methodMap.put(nameV, fun);
        }
    }

    public void addStaticFieldExpr(String className, StringValue name, Expr value) {
        ArrayList<StaticField> fieldList = this._staticFieldExprMap.get(className);
        if (fieldList == null) {
            fieldList = new ArrayList();
            this._staticFieldExprMap.put(className, fieldList);
        }
        fieldList.add(new StaticField(name, value));
        StringValue sb = this.createStringBuilder();
        sb.append(className);
        sb.append("::");
        sb.append(name);
        this._staticFieldNameMap.put(name, sb);
    }

    private StringValue createString(String s) {
        if (this._moduleContext.isUnicodeSemantics()) {
            return new UnicodeBuilderValue(s);
        }
        return new ConstStringValue(s);
    }

    private StringValue createStringBuilder() {
        if (this._moduleContext.isUnicodeSemantics()) {
            return new UnicodeBuilderValue();
        }
        return new StringBuilderValue();
    }

    public ArrayList<StringValue> getStaticFieldNames() {
        ArrayList<StringValue> names = new ArrayList<StringValue>();
        if (this._staticFieldExprMap != null) {
            for (StringValue fieldName : this._staticFieldNameMap.keySet()) {
                names.add(fieldName);
            }
        }
        return names;
    }

    public void addConstant(StringValue name, Expr expr) {
        this._constMap.put(name, expr);
    }

    public void addJavaConstant(StringValue name, Object obj) {
        this._constJavaMap.put(name, obj);
    }

    public int getFieldSize() {
        return this._fieldMap.size();
    }

    public void validate(Env env) {
        if (!this._isAbstract && !this._isInterface) {
            for (AbstractFunction fun : this._methodMap.values()) {
                boolean isAbstract = this._constructor != null && fun.getName().equals(this._constructor.getName()) ? this._constructor.isAbstract() : fun.isAbstract();
                if (!isAbstract) continue;
                throw env.createErrorException(this._classDef.getLocation(), L.l("Abstract function '{0}' must be implemented in concrete class {1}.", (Object)fun.getName(), (Object)this.getName()));
            }
        }
    }

    public void init(Env env) {
        if (this._staticFieldExprMap.size() == 0) {
            return;
        }
        for (Map.Entry<String, ArrayList<StaticField>> map : this._staticFieldExprMap.entrySet()) {
            if (env.isInitializedClass(map.getKey())) continue;
            for (StaticField field : map.getValue()) {
                Expr expr = field._expr;
                Value val = expr instanceof ClassConstExpr ? ((ClassConstExpr)expr).eval(env) : expr.eval(env);
                StringValue fullName = env.createStringBuilder();
                fullName.append(this._className);
                fullName.append("::");
                fullName.append(field._name);
                env.setStaticRef(fullName, val);
            }
            env.addInitializedClass(map.getKey());
        }
    }

    public Value getStaticFieldValue(Env env, StringValue name) {
        StringValue staticName = this._staticFieldNameMap.get(name);
        if (staticName == null) {
            env.error(L.l("{0}::${1} is an undeclared static field", (Object)this._className, (Object)name));
            return NullValue.NULL;
        }
        return env.getStaticValue(staticName);
    }

    public Var getStaticFieldVar(Env env, StringValue name) {
        StringValue staticName = this._staticFieldNameMap.get(name);
        if (staticName == null) {
            env.error(L.l("{0}::${1} is an undeclared static field", (Object)this._className, (Object)name));
            throw new IllegalStateException();
        }
        return env.getStaticVar(staticName);
    }

    public Value setStaticFieldRef(Env env, StringValue name, Value value) {
        StringValue staticName = this._staticFieldNameMap.get(name);
        if (staticName == null) {
            env.error(L.l("{0}::{1} is an unknown static field", (Object)this._className, (Object)name));
            throw new IllegalStateException();
        }
        return env.setStaticRef(staticName, value);
    }

    public Value getStaticField(Env env, StringValue name) {
        StringValue staticName = this._staticFieldNameMap.get(name);
        if (staticName != null) {
            return env.getStaticValue(staticName);
        }
        return null;
    }

    public Value createObject(Env env) {
        if (this._isAbstract) {
            throw env.createErrorException(L.l("abstract class '{0}' cannot be instantiated.", (Object)this._className));
        }
        if (this._isInterface) {
            throw env.createErrorException(L.l("interface '{0}' cannot be instantiated.", (Object)this._className));
        }
        ObjectValue objectValue = null;
        if (this._isJavaWrapper) {
            return this._javaClassDef.callNew(env, Value.NULL_ARGS);
        }
        if (this._javaClassDef != null && this._javaClassDef.isDelegate()) {
            objectValue = new ObjectExtValue(this);
        } else if (this._javaClassDef != null && this._javaClassDef.isPhpClass()) {
            Object object = null;
            objectValue = new ObjectExtJavaValue(this, object, this._javaClassDef);
        } else {
            objectValue = this._javaClassDef != null && !this._javaClassDef.isDelegate() ? new ObjectExtJavaValue(this, null, this._javaClassDef) : this._classDef.createObject(env, this);
        }
        this.initObject(env, objectValue);
        return objectValue;
    }

    public void initObject(Env env, ObjectValue obj) {
        for (int i = 0; i < this._initializers.size(); ++i) {
            this._initializers.get(i).initInstance(env, obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value callNew(Env env, Object parentJavaObject, Value ... args) {
        QuercusClass oldCallingClass = env.setCallingClass(this);
        try {
            if (this._classDef.isAbstract()) {
                throw env.createErrorException(L.l("abstract class '{0}' cannot be instantiated.", (Object)this._className));
            }
            if (this._classDef.isInterface()) {
                throw env.createErrorException(L.l("interface '{0}' cannot be instantiated.", (Object)this._className));
            }
            ObjectExtJavaValue objectValue = new ObjectExtJavaValue(this, parentJavaObject, this._javaClassDef);
            this.initObject(env, objectValue);
            AbstractFunction fun = this.findConstructor();
            if (fun != null && !fun.isJavaMethod()) {
                fun.callMethod(env, this, (Value)objectValue, args);
            }
            ObjectExtJavaValue objectExtJavaValue = objectValue;
            return objectExtJavaValue;
        }
        finally {
            env.setCallingClass(oldCallingClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value callNew(Env env, Value ... args) {
        QuercusClass oldCallingClass = env.setCallingClass(this);
        try {
            if (this._classDef.isAbstract()) {
                throw env.createErrorException(L.l("abstract class '{0}' cannot be instantiated.", (Object)this._className));
            }
            if (this._classDef.isInterface()) {
                throw env.createErrorException(L.l("interface '{0}' cannot be instantiated.", (Object)this._className));
            }
            ObjectValue objectValue = null;
            if (this._isJavaWrapper) {
                Value obj;
                Value value = obj = this._javaClassDef.callNew(env, args);
                return value;
            }
            if (this._javaClassDef != null && this._javaClassDef.isDelegate()) {
                objectValue = new ObjectExtValue(this);
            } else if (this._javaClassDef != null && this._javaClassDef.isPhpClass()) {
                Object object = null;
                objectValue = new ObjectExtJavaValue(this, object, this._javaClassDef);
            } else {
                objectValue = this._javaClassDef != null && !this._javaClassDef.isDelegate() ? new ObjectExtJavaValue(this, null, this._javaClassDef) : this._classDef.newInstance(env, this);
            }
            this.initObject(env, objectValue);
            AbstractFunction fun = this.findConstructor();
            if (fun != null) {
                fun.callNew(env, this, objectValue, args);
            }
            ObjectValue objectValue2 = objectValue;
            return objectValue2;
        }
        finally {
            env.setCallingClass(oldCallingClass);
        }
    }

    public String getParentName() {
        return this._classDefList[0].getParentName();
    }

    @Override
    public boolean isA(String name) {
        return this._instanceofSet.contains(name.toLowerCase(Locale.ENGLISH));
    }

    public ArrayValue getInterfaces(Env env, boolean autoload) {
        ArrayValueImpl array = new ArrayValueImpl();
        this.getInterfaces(env, array, autoload, true);
        return array;
    }

    private void getInterfaces(Env env, ArrayValue array, boolean autoload, boolean isTop) {
        ClassDef[] defList = this._classDefList;
        for (int i = 0; i < defList.length; ++i) {
            ClassDef def = defList[i];
            if (!isTop && def.isInterface()) {
                String name = def.getName();
                array.put(name, name);
            }
            String[] defNames = def.getInterfaces();
            for (int j = 0; j < defNames.length; ++j) {
                QuercusClass cls = env.findClass(defNames[j]);
                cls.getInterfaces(env, array, autoload, false);
            }
        }
        if (this._parent != null) {
            this._parent.getInterfaces(env, array, autoload, false);
        }
    }

    public boolean implementsInterface(Env env, String name) {
        ClassDef[] defList = this._classDefList;
        for (int i = 0; i < defList.length; ++i) {
            ClassDef def = defList[i];
            if (def.isInterface() && def.getName().equals(name)) {
                return true;
            }
            String[] defNames = def.getInterfaces();
            for (int j = 0; j < defNames.length; ++j) {
                QuercusClass cls = env.findClass(defNames[j]);
                if (!cls.implementsInterface(env, name)) continue;
                return true;
            }
        }
        if (this._parent != null) {
            return this._parent.implementsInterface(env, name);
        }
        return false;
    }

    public AbstractFunction findConstructor() {
        return this._constructor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value getField(Env env, Value qThis, StringValue name) {
        if (this.issetField(env, name) && this._fieldMap.get(name).isPublic()) {
            Value v_current = this.get(name);
            if (v_current != NullValue.NULL && v_current != UnsetValue.UNSET) {
                return v_current;
            }
            if (this._fieldGet == null) {
                return this._fieldMap.get(name).getInitValue().eval(env);
            }
        }
        if (this._fieldGet != null) {
            if (!env.pushFieldGet(Env.OVERLOADING_TYPES.FIELDGET, qThis.getClassName(), name)) {
                return UnsetValue.UNSET;
            }
            try {
                Value value = this._fieldGet.callMethod(env, this, qThis, (Value)name);
                return value;
            }
            finally {
                env.popFieldGet(Env.OVERLOADING_TYPES.FIELDGET);
            }
        }
        return UnsetValue.UNSET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean issetField(Env env, Value qThis, StringValue name) {
        ClassField field = this._fieldMap.get(name);
        if (field != null && field.isPublic()) {
            return true;
        }
        if (this._isset != null) {
            if (!env.pushFieldGet(Env.OVERLOADING_TYPES.ISSET, qThis.getClassName(), name)) {
                return false;
            }
            try {
                Value result = this._isset.callMethod(env, this, qThis, (Value)name);
                boolean bl = result.toBoolean();
                return bl;
            }
            finally {
                env.popFieldGet(Env.OVERLOADING_TYPES.ISSET);
            }
        }
        return false;
    }

    @Override
    public boolean issetField(Env env, StringValue name) {
        return this._fieldMap.containsKey(name);
    }

    @Override
    public void unsetField(StringValue name) {
        if (this._fieldMap.containsKey(name)) {
            this._fieldMap.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value unsetField(Env env, Value qThis, StringValue name) {
        if (this.issetField(env, name) && this._fieldMap.get(name).isPublic()) {
            this.unsetField(name);
            return NullValue.NULL;
        }
        if (this._unset != null) {
            if (!env.pushFieldGet(Env.OVERLOADING_TYPES.UNSET, qThis.getClassName(), name)) {
                return UnsetValue.UNSET;
            }
            try {
                Value value = this._unset.callMethod(env, this, qThis, (Value)name);
                return value;
            }
            finally {
                env.popFieldGet(Env.OVERLOADING_TYPES.UNSET);
            }
        }
        this.unsetField(name);
        return NullValue.NULL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value setField(Env env, Value qThis, StringValue name, Value value) {
        if (this._fieldSet != null) {
            if (!env.pushFieldGet(Env.OVERLOADING_TYPES.FIELDSET, qThis.getClassName(), name)) {
                return UnsetValue.UNSET;
            }
            try {
                Value value2 = this._fieldSet.callMethod(env, this, qThis, (Value)name, value);
                return value2;
            }
            finally {
                env.popFieldGet(Env.OVERLOADING_TYPES.FIELDSET);
            }
        }
        return UnsetValue.UNSET;
    }

    public AbstractFunction findStaticFunction(String name) {
        return this.findFunction(name);
    }

    public final AbstractFunction getFunction(StringValue methodName) {
        return this._methodMap.get(methodName, methodName.hashCodeCaseInsensitive());
    }

    public final AbstractFunction findFunction(String methodName) {
        StringValue nameV = this._moduleContext.createString(methodName);
        return this._methodMap.getRaw(nameV);
    }

    @Override
    public final AbstractFunction findFunction(StringValue methodName) {
        return this._methodMap.getRaw(methodName);
    }

    public final AbstractFunction getFunction(StringValue methodName, int hash) {
        return this._methodMap.get(methodName, methodName.hashCode());
    }

    public Value callConstructor(Env env, Value qThis, Value ... args) {
        AbstractFunction cons = this.getConstructor();
        if (cons == null) {
            env.error(L.l("cannot call constructor for class {0}", (Object)this.getName()));
        } else if (qThis.isNull()) {
            env.error(L.l("{0}::{1}() cannot be called statically", (Object)this.getName(), (Object)cons.getName()));
        }
        return this.getConstructor().callMethod(env, this, qThis, args);
    }

    public Value callMethod(Env env, Value qThis, StringValue methodName, int hash, Value[] args) {
        if (qThis.isNull()) {
            qThis = this;
        }
        AbstractFunction fun = this._methodMap.get(methodName, hash);
        return fun.callMethod(env, this, qThis, args);
    }

    public final Value callMethod(Env env, Value qThis, StringValue methodName, Value[] args) {
        return this.callMethod(env, qThis, methodName, methodName.hashCodeCaseInsensitive(), args);
    }

    public Value callMethod(Env env, Value qThis, StringValue methodName, int hash) {
        if (qThis.isNull()) {
            qThis = this;
        }
        AbstractFunction fun = this._methodMap.get(methodName, hash);
        return fun.callMethod(env, this, qThis);
    }

    public final Value callMethod(Env env, Value qThis, StringValue methodName) {
        return this.callMethod(env, qThis, methodName, methodName.hashCodeCaseInsensitive());
    }

    public Value callMethod(Env env, Value qThis, StringValue methodName, int hash, Value a1) {
        if (qThis.isNull()) {
            qThis = this;
        }
        AbstractFunction fun = this._methodMap.get(methodName, hash);
        return fun.callMethod(env, this, qThis, a1);
    }

    public final Value callMethod(Env env, Value qThis, StringValue methodName, Value a1) {
        return this.callMethod(env, qThis, methodName, methodName.hashCodeCaseInsensitive(), a1);
    }

    public Value callMethod(Env env, Value qThis, StringValue methodName, int hash, Value a1, Value a2) {
        if (qThis.isNull()) {
            qThis = this;
        }
        AbstractFunction fun = this._methodMap.get(methodName, hash);
        return fun.callMethod(env, this, qThis, a1, a2);
    }

    public final Value callMethod(Env env, Value qThis, StringValue methodName, Value a1, Value a2) {
        return this.callMethod(env, qThis, methodName, methodName.hashCodeCaseInsensitive(), a1, a2);
    }

    public Value callMethod(Env env, Value qThis, StringValue methodName, int hash, Value a1, Value a2, Value a3) {
        if (qThis.isNull()) {
            qThis = this;
        }
        AbstractFunction fun = this._methodMap.get(methodName, hash);
        return fun.callMethod(env, this, qThis, a1, a2, a3);
    }

    public final Value callMethod(Env env, Value qThis, StringValue methodName, Value a1, Value a2, Value a3) {
        return this.callMethod(env, qThis, methodName, methodName.hashCodeCaseInsensitive(), a1, a2, a3);
    }

    public Value callMethod(Env env, Value qThis, StringValue methodName, int hash, Value a1, Value a2, Value a3, Value a4) {
        if (qThis.isNull()) {
            qThis = this;
        }
        AbstractFunction fun = this._methodMap.get(methodName, hash);
        return fun.callMethod(env, this, qThis, a1, a2, a3, a4);
    }

    public final Value callMethod(Env env, Value qThis, StringValue methodName, Value a1, Value a2, Value a3, Value a4) {
        return this.callMethod(env, qThis, methodName, methodName.hashCodeCaseInsensitive(), a1, a2, a3, a4);
    }

    public Value callMethod(Env env, Value qThis, StringValue methodName, int hash, Value a1, Value a2, Value a3, Value a4, Value a5) {
        if (qThis.isNull()) {
            qThis = this;
        }
        AbstractFunction fun = this._methodMap.get(methodName, hash);
        return fun.callMethod(env, this, qThis, a1, a2, a3, a4, a5);
    }

    public final Value callMethod(Env env, Value qThis, StringValue methodName, Value a1, Value a2, Value a3, Value a4, Value a5) {
        return this.callMethod(env, qThis, methodName, methodName.hashCodeCaseInsensitive(), a1, a2, a3, a4, a5);
    }

    public Value callMethodRef(Env env, Value qThis, StringValue methodName, int hash, Value[] args) {
        if (qThis.isNull()) {
            qThis = this;
        }
        AbstractFunction fun = this._methodMap.get(methodName, hash);
        return fun.callMethodRef(env, this, qThis, args);
    }

    public final Value callMethodRef(Env env, Value qThis, StringValue methodName, Value[] args) {
        return this.callMethodRef(env, qThis, methodName, methodName.hashCodeCaseInsensitive(), args);
    }

    public Value callMethodRef(Env env, Value qThis, StringValue methodName, int hash) {
        if (qThis.isNull()) {
            qThis = this;
        }
        AbstractFunction fun = this._methodMap.get(methodName, hash);
        return fun.callMethodRef(env, this, qThis);
    }

    public final Value callMethodRef(Env env, Value qThis, StringValue methodName) {
        return this.callMethodRef(env, qThis, methodName, methodName.hashCodeCaseInsensitive());
    }

    public Value callMethodRef(Env env, Value qThis, StringValue methodName, int hash, Value a1) {
        if (qThis.isNull()) {
            qThis = this;
        }
        AbstractFunction fun = this._methodMap.get(methodName, hash);
        return fun.callMethodRef(env, this, qThis, a1);
    }

    public final Value callMethodRef(Env env, Value qThis, StringValue methodName, Value a1) {
        return this.callMethodRef(env, qThis, methodName, methodName.hashCodeCaseInsensitive(), a1);
    }

    public Value callMethodRef(Env env, Value qThis, StringValue methodName, int hash, Value a1, Value a2) {
        if (qThis.isNull()) {
            qThis = this;
        }
        AbstractFunction fun = this._methodMap.get(methodName, hash);
        return fun.callMethodRef(env, this, qThis, a1, a2);
    }

    public final Value callMethodRef(Env env, Value qThis, StringValue methodName, Value a1, Value a2) {
        return this.callMethodRef(env, qThis, methodName, methodName.hashCodeCaseInsensitive(), a1, a2);
    }

    public Value callMethodRef(Env env, Value qThis, StringValue methodName, int hash, Value a1, Value a2, Value a3) {
        if (qThis.isNull()) {
            qThis = this;
        }
        AbstractFunction fun = this._methodMap.get(methodName, hash);
        return fun.callMethodRef(env, this, qThis, a1, a2, a3);
    }

    public final Value callMethodRef(Env env, Value qThis, StringValue methodName, Value a1, Value a2, Value a3) {
        return this.callMethodRef(env, qThis, methodName, methodName.hashCodeCaseInsensitive(), a1, a2, a3);
    }

    public Value callMethodRef(Env env, Value qThis, StringValue methodName, int hash, Value a1, Value a2, Value a3, Value a4) {
        if (qThis.isNull()) {
            qThis = this;
        }
        AbstractFunction fun = this._methodMap.get(methodName, hash);
        return fun.callMethodRef(env, this, qThis, a1, a2, a3, a4);
    }

    public final Value callMethodRef(Env env, Value qThis, StringValue methodName, Value a1, Value a2, Value a3, Value a4) {
        return this.callMethodRef(env, qThis, methodName, methodName.hashCodeCaseInsensitive(), a1, a2, a3, a4);
    }

    public Value callMethodRef(Env env, Value qThis, StringValue methodName, int hash, Value a1, Value a2, Value a3, Value a4, Value a5) {
        if (qThis.isNull()) {
            qThis = this;
        }
        AbstractFunction fun = this._methodMap.get(methodName, hash);
        return fun.callMethodRef(env, this, qThis, a1, a2, a3, a4, a5);
    }

    public final Value callMethodRef(Env env, Value qThis, StringValue methodName, Value a1, Value a2, Value a3, Value a4, Value a5) {
        return this.callMethodRef(env, qThis, methodName, methodName.hashCodeCaseInsensitive(), a1, a2, a3, a4, a5);
    }

    @Override
    public Value callMethod(Env env, StringValue methodName, int hash, Value[] args) {
        return this.callMethod(env, (Value)this, methodName, hash, args);
    }

    @Override
    public Value callMethod(Env env, StringValue methodName, int hash) {
        return this.callMethod(env, (Value)this, methodName, hash);
    }

    @Override
    public Value callMethod(Env env, StringValue methodName, int hash, Value a1) {
        return this.callMethod(env, (Value)this, methodName, hash, a1);
    }

    @Override
    public Value callMethod(Env env, StringValue methodName, int hash, Value a1, Value a2) {
        return this.callMethod(env, (Value)this, methodName, hash, a1, a2);
    }

    @Override
    public Value callMethod(Env env, StringValue methodName, int hash, Value a1, Value a2, Value a3) {
        return this.callMethod(env, (Value)this, methodName, hash, a1, a2, a3);
    }

    @Override
    public Value callMethod(Env env, StringValue methodName, int hash, Value a1, Value a2, Value a3, Value a4) {
        return this.callMethod(env, (Value)this, methodName, hash, a1, a2, a3, a4);
    }

    @Override
    public Value callMethod(Env env, StringValue methodName, int hash, Value a1, Value a2, Value a3, Value a4, Value a5) {
        return this.callMethod(env, this, methodName, hash, a1, a2, a3, a4, a5);
    }

    @Override
    public Value callMethodRef(Env env, StringValue methodName, int hash, Value[] args) {
        return this.callMethodRef(env, (Value)this, methodName, hash, args);
    }

    @Override
    public Value callMethodRef(Env env, StringValue methodName, int hash) {
        return this.callMethodRef(env, (Value)this, methodName, hash);
    }

    @Override
    public Value callMethodRef(Env env, StringValue methodName, int hash, Value a1) {
        return this.callMethodRef(env, (Value)this, methodName, hash, a1);
    }

    @Override
    public Value callMethodRef(Env env, StringValue methodName, int hash, Value a1, Value a2) {
        return this.callMethodRef(env, (Value)this, methodName, hash, a1, a2);
    }

    @Override
    public Value callMethodRef(Env env, StringValue methodName, int hash, Value a1, Value a2, Value a3) {
        return this.callMethodRef(env, (Value)this, methodName, hash, a1, a2, a3);
    }

    @Override
    public Value callMethodRef(Env env, StringValue methodName, int hash, Value a1, Value a2, Value a3, Value a4) {
        return this.callMethodRef(env, (Value)this, methodName, hash, a1, a2, a3, a4);
    }

    @Override
    public Value callMethodRef(Env env, StringValue methodName, int hash, Value a1, Value a2, Value a3, Value a4, Value a5) {
        return this.callMethodRef(env, this, methodName, hash, a1, a2, a3, a4, a5);
    }

    private String toMethod(char[] key, int keyLength) {
        return new String(key, 0, keyLength);
    }

    public AbstractFunction findStaticFunctionLowerCase(String name) {
        return null;
    }

    public final AbstractFunction getStaticFunction(String name) {
        AbstractFunction fun = this.findStaticFunction(name);
        if (fun != null) {
            return fun;
        }
        throw new QuercusRuntimeException(L.l("{0}::{1} is an unknown method", (Object)this.getName(), (Object)name));
    }

    public final Value getConstant(Env env, StringValue name) {
        Expr expr = this._constMap.get(name);
        if (expr != null) {
            return expr.eval(env);
        }
        Object obj = this._constJavaMap.get(name);
        if (obj != null) {
            return env.wrapJava(obj);
        }
        throw new QuercusRuntimeException(L.l("{0}::{1} is an unknown constant", (Object)this.getName(), (Object)name));
    }

    public final boolean hasConstant(StringValue name) {
        if (this._constMap.get(name) != null) {
            return true;
        }
        return this._constJavaMap.get(name) != null;
    }

    public final HashMap<StringValue, Value> getConstantMap(Env env) {
        HashMap<StringValue, Value> map = new HashMap<StringValue, Value>();
        for (Map.Entry<StringValue, Expr> entry : this._constMap.entrySet()) {
            map.put(entry.getKey(), entry.getValue().eval(env));
        }
        for (Map.Entry<StringValue, Object> entry : this._constJavaMap.entrySet()) {
            map.put(entry.getKey(), env.wrapJava(entry.getValue()));
        }
        return map;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public String getClassName() {
        return this.getName();
    }

    @Override
    public QuercusClass getQuercusClass() {
        return this;
    }

    @Override
    public int hashCode() {
        return this._className.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QuercusClass)) {
            return false;
        }
        QuercusClass qClass = (QuercusClass)o;
        if (this._classDef != qClass._classDef) {
            return false;
        }
        if (this._javaClassDef != qClass._javaClassDef) {
            return false;
        }
        if (this._parent == qClass._parent) {
            return true;
        }
        return this._parent != null && this._parent.equals(qClass._parent);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "]";
    }

    public void setIsset(AbstractFunction isset) {
        this._isset = isset;
    }

    public void setUnset(AbstractFunction unset) {
        this._unset = unset;
    }

    public AbstractFunction getIsset() {
        return this._isset;
    }

    public AbstractFunction getUnset() {
        return this._unset;
    }

    static class StaticField {
        StringValue _name;
        Expr _expr;

        StaticField(StringValue name, Expr expr) {
            this._name = name;
            this._expr = expr;
        }

        StringValue getName() {
            return this._name;
        }
    }
}

