/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.Location;
import com.caucho.quercus.QuercusException;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ConstStringValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.ErrorModule;

public class QuercusLanguageException
extends QuercusException {
    private static final StringValue FILE = new ConstStringValue("file");
    private static final StringValue LINE = new ConstStringValue("line");
    private static final StringValue MESSAGE = new ConstStringValue("message");
    private ArrayValue _trace;
    private Value _value;

    protected QuercusLanguageException(Env env) {
        this._value = env.wrapJava(this);
    }

    public QuercusLanguageException(Value value) {
        super(value.toString());
        this._value = value;
    }

    public Value toException(Env env) {
        if (this._value.isA("Exception")) {
            return this._value;
        }
        return env.wrapJava(this);
    }

    public Value getValue() {
        return this._value;
    }

    public Value toValue(Env env) {
        return this._value;
    }

    public String getMessage(Env env) {
        Value field = this._value.getField(env, MESSAGE);
        String msg = field != null ? field.toString() : this.getMessage();
        return msg + env.getStackTraceAsString(this.getTrace(env), this.getLocation(env));
    }

    public Location getLocation(Env env) {
        Value file = this._value.getField(env, FILE);
        Value line = this._value.getField(env, LINE);
        if (file.isNull() || line.isNull()) {
            return Location.UNKNOWN;
        }
        return new Location(file.toString(), line.toInt(), null, null);
    }

    public int getLine(Env env) {
        return this.getLocation(env).getLineNumber();
    }

    public String getFile(Env env) {
        return this.getLocation(env).getFileName();
    }

    public ArrayValue getTrace(Env env) {
        if (this._trace == null) {
            this._trace = ErrorModule.debug_backtrace_exception(env, this, 0);
        }
        return this._trace;
    }
}

