/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.QuercusRequestAdapter;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.ConstStringValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeBuilderValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.util.Base64;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerArrayValue
extends ArrayValueImpl {
    private static final StringValue SERVER_ADDR_V = new ConstStringValue("SERVER_ADDR");
    private static final StringValue SERVER_ADDR_VU = new UnicodeBuilderValue("SERVER_ADDR");
    private static final StringValue SERVER_NAME_V = new ConstStringValue("SERVER_NAME");
    private static final StringValue SERVER_NAME_VU = new UnicodeBuilderValue("SERVER_NAME");
    private static final StringValue SERVER_PORT_V = new ConstStringValue("SERVER_PORT");
    private static final StringValue SERVER_PORT_VU = new UnicodeBuilderValue("SERVER_PORT");
    private static final StringValue REMOTE_HOST_V = new ConstStringValue("REMOTE_HOST");
    private static final StringValue REMOTE_HOST_VU = new UnicodeBuilderValue("REMOTE_HOST");
    private static final StringValue REMOTE_ADDR_V = new ConstStringValue("REMOTE_ADDR");
    private static final StringValue REMOTE_ADDR_VU = new UnicodeBuilderValue("REMOTE_ADDR");
    private static final StringValue REMOTE_PORT_V = new ConstStringValue("REMOTE_PORT");
    private static final StringValue REMOTE_PORT_VU = new UnicodeBuilderValue("REMOTE_PORT");
    private static final StringValue DOCUMENT_ROOT_V = new ConstStringValue("DOCUMENT_ROOT");
    private static final StringValue DOCUMENT_ROOT_VU = new UnicodeBuilderValue("DOCUMENT_ROOT");
    private static final StringValue SERVER_SOFTWARE_V = new ConstStringValue("SERVER_SOFTWARE");
    private static final StringValue SERVER_SOFTWARE_VU = new UnicodeBuilderValue("SERVER_SOFTWARE");
    private static final StringValue SERVER_PROTOCOL_V = new ConstStringValue("SERVER_PROTOCOL");
    private static final StringValue SERVER_PROTOCOL_VU = new UnicodeBuilderValue("SERVER_PROTOCOL");
    private static final StringValue REQUEST_METHOD_V = new ConstStringValue("REQUEST_METHOD");
    private static final StringValue REQUEST_METHOD_VU = new UnicodeBuilderValue("REQUEST_METHOD");
    private static final StringValue QUERY_STRING_V = new ConstStringValue("QUERY_STRING");
    private static final StringValue QUERY_STRING_VU = new UnicodeBuilderValue("QUERY_STRING");
    private static final StringValue REQUEST_URI_V = new ConstStringValue("REQUEST_URI");
    private static final StringValue REQUEST_URI_VU = new UnicodeBuilderValue("REQUEST_URI");
    private static final StringValue REQUEST_TIME_V = new ConstStringValue("REQUEST_TIME");
    private static final StringValue REQUEST_TIME_VU = new UnicodeBuilderValue("REQUEST_TIME");
    private static final StringValue SCRIPT_URL_V = new ConstStringValue("SCRIPT_URL");
    private static final StringValue SCRIPT_URL_VU = new UnicodeBuilderValue("SCRIPT_URL");
    private static final StringValue SCRIPT_NAME_V = new ConstStringValue("SCRIPT_NAME");
    private static final StringValue SCRIPT_NAME_VU = new UnicodeBuilderValue("SCRIPT_NAME");
    private static final StringValue SCRIPT_FILENAME_V = new ConstStringValue("SCRIPT_FILENAME");
    private static final StringValue SCRIPT_FILENAME_VU = new UnicodeBuilderValue("SCRIPT_FILENAME");
    private static final StringValue PATH_INFO_V = new ConstStringValue("PATH_INFO");
    private static final StringValue PATH_INFO_VU = new UnicodeBuilderValue("PATH_INFO");
    private static final StringValue PATH_TRANSLATED_V = new ConstStringValue("PATH_TRANSLATED");
    private static final StringValue PATH_TRANSLATED_VU = new UnicodeBuilderValue("PATH_TRANSLATED");
    private static final StringValue PHP_SELF_V = new ConstStringValue("PHP_SELF");
    private static final StringValue PHP_SELF_VU = new UnicodeBuilderValue("PHP_SELF");
    private static final StringValue PHP_AUTH_USER_V = new ConstStringValue("PHP_AUTH_USER");
    private static final StringValue PHP_AUTH_USER_VU = new UnicodeBuilderValue("PHP_AUTH_USER");
    private static final StringValue PHP_AUTH_PW_V = new ConstStringValue("PHP_AUTH_PW");
    private static final StringValue PHP_AUTH_PW_VU = new UnicodeBuilderValue("PHP_AUTH_PW");
    private static final StringValue PHP_AUTH_DIGEST_V = new ConstStringValue("PHP_AUTH_DIGEST");
    private static final StringValue PHP_AUTH_DIGEST_VU = new UnicodeBuilderValue("PHP_AUTH_DIGEST");
    private static final StringValue AUTH_TYPE_V = new ConstStringValue("AUTH_TYPE");
    private static final StringValue AUTH_TYPE_VU = new UnicodeBuilderValue("AUTH_TYPE");
    private static final StringValue HTTPS_V = new ConstStringValue("HTTPS");
    private static final StringValue HTTPS_VU = new UnicodeBuilderValue("HTTPS");
    private static final StringValue HTTP_HOST_V = new ConstStringValue("HTTP_HOST");
    private static final StringValue HTTP_HOST_VU = new UnicodeBuilderValue("HTTP_HOST");
    private static final StringValue CONTENT_LENGTH_V = new ConstStringValue("CONTENT_LENGTH");
    private static final StringValue CONTENT_LENGTH_VU = new UnicodeBuilderValue("CONTENT_LENGTH");
    private static final StringValue CONTENT_TYPE_V = new ConstStringValue("CONTENT_TYPE");
    private static final StringValue CONTENT_TYPE_VU = new UnicodeBuilderValue("CONTENT_TYPE");
    private final Env _env;
    private boolean _isFilled;

    public ServerArrayValue(Env env) {
        this._env = env;
    }

    @Override
    public Object toObject() {
        return null;
    }

    @Override
    public ArrayValue append(Value key, Value value) {
        if (!this._isFilled) {
            this.fillMap();
        }
        return super.append(key, value);
    }

    @Override
    public Value put(Value value) {
        if (!this._isFilled) {
            this.fillMap();
        }
        return super.put(value);
    }

    @Override
    public Value get(Value key) {
        if (!this._isFilled) {
            this.fillMap();
        }
        return super.get(key);
    }

    @Override
    public Value getArg(Value key, boolean isTop) {
        if (!this._isFilled) {
            this.fillMap();
        }
        return super.getArg(key, isTop);
    }

    @Override
    public Var getVar(Value key) {
        if (!this._isFilled) {
            this.fillMap();
        }
        return super.getVar(key);
    }

    @Override
    public Value copy() {
        if (!this._isFilled) {
            this.fillMap();
        }
        return super.copy();
    }

    @Override
    public Value copySaveFunArg() {
        if (!this._isFilled) {
            this.fillMap();
        }
        return super.copySaveFunArg();
    }

    @Override
    public Set<Map.Entry<Value, Value>> entrySet() {
        if (!this._isFilled) {
            this.fillMap();
        }
        return super.entrySet();
    }

    @Override
    public void put(String key, String value) {
        if (!this._isFilled) {
            this.fillMap();
        }
        super.put(this._env.createString(key), this._env.createString(value));
    }

    @Override
    public boolean isset(Value key) {
        return this.get(key).isset();
    }

    @Override
    public void varDumpImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        if (!this._isFilled) {
            this.fillMap();
        }
        super.varDumpImpl(env, out, depth, valueSet);
    }

    @Override
    protected void printRImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        if (!this._isFilled) {
            this.fillMap();
        }
        super.printRImpl(env, out, depth, valueSet);
    }

    private void fillMap() {
        if (this._isFilled) {
            return;
        }
        this._isFilled = true;
        for (Map.Entry<Value, Value> entry : this._env.getQuercus().getServerEnvMap().entrySet()) {
            super.put(entry.getKey(), entry.getValue());
        }
        HttpServletRequest request = this._env.getRequest();
        boolean isUnicode = this._env.isUnicodeSemantics();
        if (request != null) {
            String root;
            super.put(isUnicode ? SERVER_ADDR_VU : SERVER_ADDR_V, this._env.createString(request.getLocalAddr()));
            super.put(isUnicode ? SERVER_NAME_VU : SERVER_NAME_V, this._env.createString(request.getServerName()));
            super.put(isUnicode ? SERVER_PORT_VU : SERVER_PORT_V, LongValue.create(request.getServerPort()));
            super.put(isUnicode ? REMOTE_HOST_VU : REMOTE_HOST_V, this._env.createString(request.getRemoteHost()));
            super.put(isUnicode ? REMOTE_ADDR_VU : REMOTE_ADDR_V, this._env.createString(request.getRemoteAddr()));
            super.put(isUnicode ? REMOTE_PORT_VU : REMOTE_PORT_V, LongValue.create(request.getRemotePort()));
            super.put(isUnicode ? SERVER_SOFTWARE_VU : SERVER_SOFTWARE_V, this._env.createString("Apache PHP Quercus(" + this._env.getQuercus().getVersion() + ")"));
            super.put(isUnicode ? SERVER_PROTOCOL_VU : SERVER_PROTOCOL_V, this._env.createString(request.getProtocol()));
            super.put(isUnicode ? REQUEST_METHOD_VU : REQUEST_METHOD_V, this._env.createString(request.getMethod()));
            String queryString = QuercusRequestAdapter.getPageQueryString(request);
            String requestURI = QuercusRequestAdapter.getPageURI(request);
            String servletPath = QuercusRequestAdapter.getPageServletPath(request);
            String pathInfo = QuercusRequestAdapter.getPagePathInfo(request);
            String contextPath = QuercusRequestAdapter.getPageContextPath(request);
            if (queryString != null) {
                super.put(isUnicode ? QUERY_STRING_VU : QUERY_STRING_V, this._env.createString(queryString));
            }
            if ((root = request.getRealPath("/")) == null) {
                root = this._env.getPwd().getFullPath();
            }
            if (root.indexOf(92) >= 0) {
                root = root.replace('\\', '/');
                root = '/' + root;
            }
            super.put(isUnicode ? DOCUMENT_ROOT_VU : DOCUMENT_ROOT_V, this._env.createString(root));
            super.put(isUnicode ? SCRIPT_NAME_VU : SCRIPT_NAME_V, this._env.createString(contextPath + servletPath));
            super.put(isUnicode ? SCRIPT_URL_VU : SCRIPT_URL_V, this._env.createString(requestURI));
            if (queryString != null) {
                requestURI = requestURI + '?' + queryString;
            }
            super.put(isUnicode ? REQUEST_URI_VU : REQUEST_URI_V, this._env.createString(requestURI));
            super.put(isUnicode ? REQUEST_TIME_VU : REQUEST_TIME_V, LongValue.create(this._env.getStartTime() / 1000L));
            super.put(isUnicode ? SCRIPT_FILENAME_VU : SCRIPT_FILENAME_V, this._env.createString(request.getRealPath(servletPath)));
            if (pathInfo != null) {
                super.put(isUnicode ? PATH_INFO_VU : PATH_INFO_V, this._env.createString(pathInfo));
                super.put(isUnicode ? PATH_TRANSLATED_VU : PATH_TRANSLATED_V, this._env.createString(request.getRealPath(pathInfo)));
            }
            if (request.isSecure()) {
                super.put(isUnicode ? HTTPS_VU : HTTPS_V, this._env.createString("on"));
            }
            if (pathInfo == null) {
                super.put(isUnicode ? PHP_SELF_VU : PHP_SELF_V, this._env.createString(contextPath + servletPath));
            } else {
                super.put(isUnicode ? PHP_SELF_VU : PHP_SELF_V, this._env.createString(contextPath + servletPath + pathInfo));
            }
            String authHeader = request.getHeader("Authorization");
            if (authHeader != null) {
                if (authHeader.indexOf("Basic") == 0) {
                    String digest;
                    String userPass;
                    int i;
                    super.put(isUnicode ? AUTH_TYPE_VU : AUTH_TYPE_V, this._env.createString("Basic"));
                    boolean userNameIsSet = false;
                    if (request.getRemoteUser() != null) {
                        super.put(isUnicode ? PHP_AUTH_USER_VU : PHP_AUTH_USER_V, this._env.createString(request.getRemoteUser()));
                        userNameIsSet = true;
                    }
                    if ((i = (userPass = Base64.decode(digest = authHeader.substring("Basic ".length()))).indexOf(58)) > 0) {
                        if (!userNameIsSet) {
                            super.put(isUnicode ? PHP_AUTH_USER_VU : PHP_AUTH_USER_V, this._env.createString(userPass.substring(0, i)));
                        }
                        super.put(isUnicode ? PHP_AUTH_PW_VU : PHP_AUTH_PW_V, this._env.createString(userPass.substring(i + 1)));
                    }
                } else if (authHeader.indexOf("Digest") == 0) {
                    super.put(isUnicode ? AUTH_TYPE_VU : AUTH_TYPE_V, this._env.createString("Digest"));
                    String digest = authHeader.substring("Digest ".length());
                    super.put(isUnicode ? PHP_AUTH_DIGEST_VU : PHP_AUTH_DIGEST_V, this._env.createString(digest));
                }
            }
            Enumeration<String> e = request.getHeaderNames();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                String value = request.getHeader(key);
                if (key.equalsIgnoreCase("Host")) {
                    super.put(isUnicode ? HTTP_HOST_VU : HTTP_HOST_V, this._env.createString(value));
                    continue;
                }
                if (key.equalsIgnoreCase("Content-Length")) {
                    super.put(isUnicode ? CONTENT_LENGTH_VU : CONTENT_LENGTH_V, this._env.createString(value));
                    continue;
                }
                if (key.equalsIgnoreCase("Content-Type")) {
                    super.put(isUnicode ? CONTENT_TYPE_VU : CONTENT_TYPE_V, this._env.createString(value));
                    continue;
                }
                super.put(this.convertHttpKey(key), this._env.createString(value));
            }
        }
    }

    private StringValue convertHttpKey(String key) {
        StringValue sb = this._env.createUnicodeBuilder();
        sb.append("HTTP_");
        int len = key.length();
        for (int i = 0; i < len; ++i) {
            char ch = key.charAt(i);
            if (Character.isLowerCase(ch)) {
                sb.append(Character.toUpperCase(ch));
                continue;
            }
            if (ch == '-') {
                sb.append('_');
                continue;
            }
            sb.append(ch);
        }
        return sb;
    }

    private Object writeReplace() {
        if (!this._isFilled) {
            this.fillMap();
        }
        return super.copy();
    }
}

