/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.AbstractVarExpr;
import com.caucho.quercus.expr.Expr;

public class ArrayGetExpr
extends AbstractVarExpr {
    protected final Expr _expr;
    protected final Expr _index;

    public ArrayGetExpr(Location location, Expr expr, Expr index) {
        super(location);
        this._expr = expr;
        this._index = index;
    }

    public ArrayGetExpr(Expr expr, Expr index) {
        this._expr = expr;
        this._index = index;
    }

    public Expr getExpr() {
        return this._expr;
    }

    public Expr getIndex() {
        return this._index;
    }

    public Value eval(Env env) {
        Value array = this._expr.eval(env);
        Value index = this._index.eval(env);
        return array.get(index);
    }

    public Value evalCopy(Env env) {
        Value array = this._expr.eval(env);
        Value index = this._index.eval(env);
        return array.get(index).copy();
    }

    public Value evalArray(Env env) {
        Value array = this._expr.evalArray(env);
        Value index = this._index.eval(env);
        return array.getArray(index);
    }

    public Value evalDirty(Env env) {
        Value array = this._expr.eval(env);
        Value index = this._index.eval(env);
        return array.getDirty(index);
    }

    public Value evalObject(Env env) {
        Value array = this._expr.evalArray(env);
        Value index = this._index.eval(env);
        return array.getObject(env, index);
    }

    public Value evalArg(Env env, boolean isTop) {
        Value value = this._expr.evalArg(env, false);
        return value.getArg(this._index.eval(env), isTop);
    }

    public Var evalVar(Env env) {
        Value value = this._expr.evalArray(env);
        return value.getVar(this._index.eval(env));
    }

    public Value evalAssignValue(Env env, Value value) {
        Value array = this._expr.evalArrayAssign(env, this._index.eval(env), value);
        return array;
    }

    public Value evalAssignRef(Env env, Value value) {
        Value array = this._expr.evalArray(env);
        return array.put(this._index.eval(env), value);
    }

    public boolean evalIsset(Env env) {
        Value array = this._expr.evalIssetValue(env);
        Value index = this._index.evalIssetValue(env);
        return array.isset(index);
    }

    public void evalUnset(Env env) {
        Value index = this._index.eval(env);
        this._expr.evalUnsetArray(env, index);
    }

    public String toString() {
        return this._expr + "[" + this._index + "]";
    }
}

