/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.AbstractVarExpr;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.parser.QuercusParser;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassVarFieldExpr
extends AbstractVarExpr {
    private static final L10N L = new L10N(ClassVarFieldExpr.class);
    protected final Expr _className;
    protected final StringValue _varName;

    public ClassVarFieldExpr(Expr className, StringValue varName) {
        this._className = className;
        this._varName = varName;
    }

    @Override
    public Expr createCall(QuercusParser parser, Location location, ArrayList<Expr> args) throws IOException {
        ExprFactory factory = parser.getExprFactory();
        Expr var = parser.createVar(this._varName);
        return factory.createClassMethodCall(location, this._className, var, args);
    }

    @Override
    public Value eval(Env env) {
        String className = this._className.evalString(env);
        QuercusClass qClass = env.getClass(className);
        return qClass.getStaticFieldValue(env, this._varName);
    }

    @Override
    public Var evalVar(Env env) {
        String className = this._className.evalString(env);
        QuercusClass qClass = env.getClass(className);
        return qClass.getStaticFieldVar(env, this._varName);
    }

    @Override
    public Value evalAssignRef(Env env, Value value) {
        String className = this._className.evalString(env);
        QuercusClass qClass = env.getClass(className);
        return qClass.setStaticFieldRef(env, this._varName, value);
    }

    @Override
    public void evalUnset(Env env) {
        env.error(this.getLocation(), L.l("{0}::${1}: Cannot unset static variables.", (Object)this._className, (Object)this._varName));
    }

    @Override
    public String toString() {
        return this._className + "::$" + this._varName;
    }
}

