/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.quercus.parser.QuercusParser;
import com.caucho.util.L10N;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassVarMethodVarExpr
extends Expr {
    private static final L10N L = new L10N(ClassVarMethodVarExpr.class);
    protected final Expr _className;
    protected final Expr _methodName;
    protected final Expr[] _args;
    protected Expr[] _fullArgs;
    protected AbstractFunction _fun;
    protected boolean _isMethod;

    public ClassVarMethodVarExpr(Location location, Expr className, Expr methodName, ArrayList<Expr> args) {
        super(location);
        this._className = className;
        this._methodName = methodName;
        this._args = new Expr[args.size()];
        args.toArray(this._args);
    }

    @Override
    public Expr createRef(QuercusParser parser) {
        return parser.getFactory().createRef(this);
    }

    @Override
    public Expr createCopy(ExprFactory factory) {
        return factory.createCopy(this);
    }

    @Override
    public Value eval(Env env) {
        String className = this._className.evalString(env);
        QuercusClass cl = env.findClass(className);
        if (cl == null) {
            env.error(this.getLocation(), L.l("no matching class {0}", (Object)className));
        }
        StringValue methodName = this._methodName.evalStringValue(env);
        int hash = methodName.hashCodeCaseInsensitive();
        Value[] args = ClassVarMethodVarExpr.evalArgs(env, this._args);
        return cl.callMethod(env, env.getThis(), methodName, hash, args);
    }

    @Override
    public String toString() {
        return this._className + "::" + this._methodName + "()";
    }
}

