/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.AbstractVarExpr;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.expr.VarVarExpr;
import com.caucho.quercus.parser.QuercusParser;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassVirtualFieldVarExpr
extends AbstractVarExpr {
    private static final L10N L = new L10N(ClassVirtualFieldVarExpr.class);
    protected final Expr _varName;

    public ClassVirtualFieldVarExpr(Location location, Expr varName) {
        super(location);
        this._varName = varName;
    }

    public ClassVirtualFieldVarExpr(Expr varName) {
        this._varName = varName;
    }

    @Override
    public Expr createCall(QuercusParser parser, Location location, ArrayList<Expr> args) throws IOException {
        ExprFactory factory = parser.getExprFactory();
        VarVarExpr var = factory.createVarVar(this._varName);
        return factory.createClassVirtualMethodCall(location, var, args);
    }

    @Override
    public Value eval(Env env) {
        String className = env.getThis().getQuercusClass().getName();
        StringValue varName = this._varName.evalStringValue(env);
        StringValue sb = env.createStringBuilder();
        sb.append(className);
        sb.append("::");
        sb.append(varName);
        return env.getStaticValue(sb);
    }

    @Override
    public Var evalVar(Env env) {
        String className = env.getThis().getQuercusClass().getName();
        StringValue varName = this._varName.evalStringValue(env);
        StringValue var = env.createStringBuilder();
        var.append(className);
        var.append("::");
        var.append(varName);
        return env.getStaticVar(var);
    }

    @Override
    public Value evalAssignRef(Env env, Value value) {
        String className = env.getThis().getQuercusClass().getName();
        StringValue varName = this._varName.evalStringValue(env);
        StringValue var = env.createStringBuilder();
        var.append(className);
        var.append("::");
        var.append(varName);
        env.setStaticRef(var, value);
        return value;
    }

    @Override
    public void evalUnset(Env env) {
        env.error(this.getLocation(), L.l("{0}::${1}: Cannot unset static variables.", (Object)env.getCallingClass().getName(), (Object)this._varName));
    }

    @Override
    public String toString() {
        return "static::$" + this._varName;
    }
}

