/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.parser.QuercusParser;

public class ConstExpr
extends Expr {
    protected final String _var;

    public ConstExpr(Location location, String var) {
        super(location);
        this._var = var;
    }

    public ConstExpr(String var) {
        this(Location.UNKNOWN, var);
    }

    public String getVar() {
        return this._var;
    }

    public Expr createClassConst(QuercusParser parser, StringValue name) {
        ExprFactory factory = parser.getExprFactory();
        String className = this._var;
        String specialClassName = this.getSpecialClassName();
        if ("self".equals(specialClassName)) {
            className = parser.getSelfClassName();
            return factory.createClassConst(className, name);
        }
        if ("parent".equals(specialClassName)) {
            className = parser.getParentClassName();
            return factory.createClassConst(className, name);
        }
        if ("static".equals(specialClassName)) {
            return factory.createClassVirtualConst(name);
        }
        return factory.createClassConst(className, name);
    }

    public Expr createClassField(QuercusParser parser, StringValue name) {
        ExprFactory factory = parser.getExprFactory();
        String className = this._var;
        String specialClassName = this.getSpecialClassName();
        if ("self".equals(specialClassName)) {
            if ("this".equals(name)) {
                return factory.createThis(parser.getClassDef());
            }
            className = parser.getSelfClassName();
            return factory.createClassField(className, name);
        }
        if ("parent".equals(specialClassName)) {
            className = parser.getParentClassName();
            return factory.createClassField(className, name);
        }
        if ("static".equals(specialClassName)) {
            return factory.createClassVirtualField(name);
        }
        return factory.createClassField(className, name);
    }

    public Expr createClassField(QuercusParser parser, Expr name) {
        ExprFactory factory = parser.getExprFactory();
        String className = this._var;
        String specialClassName = this.getSpecialClassName();
        if ("self".equals(specialClassName)) {
            className = parser.getSelfClassName();
            return factory.createClassField(className, name);
        }
        if ("parent".equals(specialClassName)) {
            className = parser.getParentClassName();
            return factory.createClassField(className, name);
        }
        if ("static".equals(specialClassName)) {
            return factory.createClassVirtualField(name);
        }
        return factory.createClassField(className, name);
    }

    private String getSpecialClassName() {
        String className = this._var;
        int ns = className.lastIndexOf(92);
        if (ns >= 0) {
            return className.substring(ns + 1);
        }
        return className;
    }

    public Value evalConstant() {
        return new StringBuilderValue(this._var);
    }

    public Value eval(Env env) {
        return env.getConstant(this._var);
    }

    public String toString() {
        return this._var;
    }
}

