/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.QuercusContext;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.AbstractVarExpr;
import com.caucho.quercus.expr.ArrayGetExpr;
import com.caucho.quercus.expr.ArrayTailExpr;
import com.caucho.quercus.expr.BinaryAddExpr;
import com.caucho.quercus.expr.BinaryAndExpr;
import com.caucho.quercus.expr.BinaryAppendExpr;
import com.caucho.quercus.expr.BinaryAssignExpr;
import com.caucho.quercus.expr.BinaryAssignListEachExpr;
import com.caucho.quercus.expr.BinaryAssignListExpr;
import com.caucho.quercus.expr.BinaryAssignRefExpr;
import com.caucho.quercus.expr.BinaryBitAndExpr;
import com.caucho.quercus.expr.BinaryBitOrExpr;
import com.caucho.quercus.expr.BinaryBitXorExpr;
import com.caucho.quercus.expr.BinaryCharAtExpr;
import com.caucho.quercus.expr.BinaryCommaExpr;
import com.caucho.quercus.expr.BinaryDivExpr;
import com.caucho.quercus.expr.BinaryEqExpr;
import com.caucho.quercus.expr.BinaryEqualsExpr;
import com.caucho.quercus.expr.BinaryGeqExpr;
import com.caucho.quercus.expr.BinaryGtExpr;
import com.caucho.quercus.expr.BinaryInstanceOfExpr;
import com.caucho.quercus.expr.BinaryInstanceOfVarExpr;
import com.caucho.quercus.expr.BinaryLeftShiftExpr;
import com.caucho.quercus.expr.BinaryLeqExpr;
import com.caucho.quercus.expr.BinaryLtExpr;
import com.caucho.quercus.expr.BinaryModExpr;
import com.caucho.quercus.expr.BinaryMulExpr;
import com.caucho.quercus.expr.BinaryNeqExpr;
import com.caucho.quercus.expr.BinaryOrExpr;
import com.caucho.quercus.expr.BinaryRightShiftExpr;
import com.caucho.quercus.expr.BinarySubExpr;
import com.caucho.quercus.expr.BinaryXorExpr;
import com.caucho.quercus.expr.CallExpr;
import com.caucho.quercus.expr.CallVarExpr;
import com.caucho.quercus.expr.ClassConstExpr;
import com.caucho.quercus.expr.ClassConstructExpr;
import com.caucho.quercus.expr.ClassConstructorExpr;
import com.caucho.quercus.expr.ClassFieldExpr;
import com.caucho.quercus.expr.ClassFieldVarExpr;
import com.caucho.quercus.expr.ClassMethodExpr;
import com.caucho.quercus.expr.ClassMethodVarExpr;
import com.caucho.quercus.expr.ClassVarConstExpr;
import com.caucho.quercus.expr.ClassVarFieldExpr;
import com.caucho.quercus.expr.ClassVarFieldVarExpr;
import com.caucho.quercus.expr.ClassVarMethodExpr;
import com.caucho.quercus.expr.ClassVarMethodVarExpr;
import com.caucho.quercus.expr.ClassVirtualConstExpr;
import com.caucho.quercus.expr.ClassVirtualFieldExpr;
import com.caucho.quercus.expr.ClassVirtualFieldVarExpr;
import com.caucho.quercus.expr.ClassVirtualMethodExpr;
import com.caucho.quercus.expr.ClassVirtualMethodVarExpr;
import com.caucho.quercus.expr.ClosureExpr;
import com.caucho.quercus.expr.ConditionalExpr;
import com.caucho.quercus.expr.ConditionalShortExpr;
import com.caucho.quercus.expr.ConstDirExpr;
import com.caucho.quercus.expr.ConstExpr;
import com.caucho.quercus.expr.ConstFileExpr;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.FunArrayExpr;
import com.caucho.quercus.expr.FunCloneExpr;
import com.caucho.quercus.expr.FunDieExpr;
import com.caucho.quercus.expr.FunEachExpr;
import com.caucho.quercus.expr.FunExitExpr;
import com.caucho.quercus.expr.FunGetCalledClassExpr;
import com.caucho.quercus.expr.FunGetClassExpr;
import com.caucho.quercus.expr.FunIncludeExpr;
import com.caucho.quercus.expr.FunIncludeOnceExpr;
import com.caucho.quercus.expr.FunIssetExpr;
import com.caucho.quercus.expr.ImportExpr;
import com.caucho.quercus.expr.ListHeadExpr;
import com.caucho.quercus.expr.LiteralBinaryStringExpr;
import com.caucho.quercus.expr.LiteralExpr;
import com.caucho.quercus.expr.LiteralLongExpr;
import com.caucho.quercus.expr.LiteralNullExpr;
import com.caucho.quercus.expr.LiteralStringExpr;
import com.caucho.quercus.expr.LiteralUnicodeExpr;
import com.caucho.quercus.expr.ObjectFieldExpr;
import com.caucho.quercus.expr.ObjectFieldVarExpr;
import com.caucho.quercus.expr.ObjectMethodExpr;
import com.caucho.quercus.expr.ObjectMethodVarExpr;
import com.caucho.quercus.expr.ObjectNewExpr;
import com.caucho.quercus.expr.ObjectNewStaticExpr;
import com.caucho.quercus.expr.ObjectNewVarExpr;
import com.caucho.quercus.expr.ParamDefaultExpr;
import com.caucho.quercus.expr.ParamRequiredExpr;
import com.caucho.quercus.expr.ThisExpr;
import com.caucho.quercus.expr.ThisFieldExpr;
import com.caucho.quercus.expr.ThisFieldVarExpr;
import com.caucho.quercus.expr.ThisMethodExpr;
import com.caucho.quercus.expr.ThisMethodVarExpr;
import com.caucho.quercus.expr.ToArrayExpr;
import com.caucho.quercus.expr.ToBinaryExpr;
import com.caucho.quercus.expr.ToBooleanExpr;
import com.caucho.quercus.expr.ToDoubleExpr;
import com.caucho.quercus.expr.ToLongExpr;
import com.caucho.quercus.expr.ToObjectExpr;
import com.caucho.quercus.expr.ToStringExpr;
import com.caucho.quercus.expr.ToUnicodeExpr;
import com.caucho.quercus.expr.UnaryBitNotExpr;
import com.caucho.quercus.expr.UnaryCopyExpr;
import com.caucho.quercus.expr.UnaryMinusExpr;
import com.caucho.quercus.expr.UnaryNotExpr;
import com.caucho.quercus.expr.UnaryPlusExpr;
import com.caucho.quercus.expr.UnaryPostIncrementExpr;
import com.caucho.quercus.expr.UnaryPreIncrementExpr;
import com.caucho.quercus.expr.UnaryRefExpr;
import com.caucho.quercus.expr.UnarySuppressErrorExpr;
import com.caucho.quercus.expr.VarExpr;
import com.caucho.quercus.expr.VarInfo;
import com.caucho.quercus.expr.VarUnsetExpr;
import com.caucho.quercus.expr.VarVarExpr;
import com.caucho.quercus.parser.QuercusParser;
import com.caucho.quercus.program.Arg;
import com.caucho.quercus.program.ClassDef;
import com.caucho.quercus.program.Function;
import com.caucho.quercus.program.FunctionInfo;
import com.caucho.quercus.program.InterpretedClassDef;
import com.caucho.quercus.program.MethodDeclaration;
import com.caucho.quercus.program.ObjectMethod;
import com.caucho.quercus.statement.BlockStatement;
import com.caucho.quercus.statement.BreakStatement;
import com.caucho.quercus.statement.ClassDefStatement;
import com.caucho.quercus.statement.ClassStaticStatement;
import com.caucho.quercus.statement.ContinueStatement;
import com.caucho.quercus.statement.DoStatement;
import com.caucho.quercus.statement.EchoStatement;
import com.caucho.quercus.statement.ExprStatement;
import com.caucho.quercus.statement.ForStatement;
import com.caucho.quercus.statement.ForeachStatement;
import com.caucho.quercus.statement.FunctionDefStatement;
import com.caucho.quercus.statement.GlobalStatement;
import com.caucho.quercus.statement.IfStatement;
import com.caucho.quercus.statement.NullStatement;
import com.caucho.quercus.statement.ReturnRefStatement;
import com.caucho.quercus.statement.ReturnStatement;
import com.caucho.quercus.statement.Statement;
import com.caucho.quercus.statement.StaticStatement;
import com.caucho.quercus.statement.SwitchStatement;
import com.caucho.quercus.statement.TextStatement;
import com.caucho.quercus.statement.ThrowStatement;
import com.caucho.quercus.statement.TryStatement;
import com.caucho.quercus.statement.VarGlobalStatement;
import com.caucho.quercus.statement.WhileStatement;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExprFactory {
    private static final L10N L = new L10N(ExprFactory.class);
    private static final Logger log = Logger.getLogger(ExprFactory.class.getName());
    private static boolean _isPro = true;

    public static ExprFactory create() {
        if (!_isPro) {
            return new ExprFactory();
        }
        try {
            Class<?> cl = Class.forName("com.caucho.quercus.expr.ExprFactoryPro");
            return (ExprFactory)cl.newInstance();
        }
        catch (Exception e) {
            log.log(Level.FINEST, e.toString(), e);
            _isPro = false;
            return new ExprFactory();
        }
    }

    public Expr createNull() {
        return LiteralNullExpr.NULL;
    }

    public Expr createString(String lexeme) {
        return new LiteralStringExpr(lexeme);
    }

    public Expr createUnicode(String lexeme) {
        return new LiteralUnicodeExpr(lexeme);
    }

    public Expr createBinary(byte[] bytes) {
        return new LiteralBinaryStringExpr(bytes);
    }

    public Expr createLong(long value) {
        return new LiteralLongExpr(value);
    }

    public Expr createLiteral(Value literal) {
        return new LiteralExpr(literal);
    }

    public VarExpr createVar(VarInfo var) {
        return new VarExpr(var);
    }

    public VarVarExpr createVarVar(Expr var) {
        return new VarVarExpr(var);
    }

    public ConstFileExpr createFileNameExpr(String fileName) {
        return new ConstFileExpr(fileName);
    }

    public ConstDirExpr createDirExpr(String dirName) {
        return new ConstDirExpr(dirName);
    }

    public ConstExpr createConst(String name) {
        return new ConstExpr(name);
    }

    public ArrayGetExpr createArrayGet(Location location, Expr base, Expr index) {
        return new ArrayGetExpr(location, base, index);
    }

    public ArrayTailExpr createArrayTail(Location location, Expr base) {
        return new ArrayTailExpr(location, base);
    }

    public Expr createFieldGet(Expr base, StringValue name) {
        return new ObjectFieldExpr(base, name);
    }

    public Expr createFieldVarGet(Expr base, Expr name) {
        return new ObjectFieldVarExpr(base, name);
    }

    public ThisExpr createThis(InterpretedClassDef cl) {
        return new ThisExpr(cl);
    }

    public ThisFieldExpr createThisField(ThisExpr qThis, StringValue name) {
        return new ThisFieldExpr(qThis, name);
    }

    public ThisFieldVarExpr createThisField(ThisExpr qThis, Expr name) {
        return new ThisFieldVarExpr(qThis, name);
    }

    public Expr createThisMethod(Location loc, ThisExpr qThis, StringValue methodName, ArrayList<Expr> args) {
        return new ThisMethodExpr(loc, qThis, methodName, args);
    }

    public Expr createThisMethod(Location loc, ThisExpr qThis, Expr methodName, ArrayList<Expr> args) {
        return new ThisMethodVarExpr(loc, qThis, methodName, args);
    }

    public ClassConstExpr createClassConst(String className, StringValue name) {
        return new ClassConstExpr(className, name);
    }

    public Expr createClassConst(Expr className, StringValue name) {
        return new ClassVarConstExpr(className, name);
    }

    public ClassVirtualConstExpr createClassVirtualConst(StringValue name) {
        return new ClassVirtualConstExpr(name);
    }

    public Expr createClassField(String className, StringValue name) {
        return new ClassFieldExpr(className, name);
    }

    public Expr createClassField(Expr className, StringValue name) {
        return new ClassVarFieldExpr(className, name);
    }

    public Expr createClassVirtualField(StringValue name) {
        return new ClassVirtualFieldExpr(name);
    }

    public Expr createClassField(String className, Expr name) {
        return new ClassFieldVarExpr(className, name);
    }

    public Expr createClassField(Expr className, Expr name) {
        return new ClassVarFieldVarExpr(className, name);
    }

    public Expr createClassVirtualField(Expr name) {
        return new ClassVirtualFieldVarExpr(name);
    }

    public Expr createUnsetVar(AbstractVarExpr var) {
        return new VarUnsetExpr(var);
    }

    public BinaryCharAtExpr createCharAt(Expr base, Expr index) {
        return new BinaryCharAtExpr(base, index);
    }

    public UnaryPostIncrementExpr createPostIncrement(Expr expr, int incr) {
        return new UnaryPostIncrementExpr(expr, incr);
    }

    public UnaryPreIncrementExpr createPreIncrement(Expr expr, int incr) {
        return new UnaryPreIncrementExpr(expr, incr);
    }

    public Expr createMinus(Expr expr) {
        return new UnaryMinusExpr(expr);
    }

    public Expr createPlus(Expr expr) {
        return new UnaryPlusExpr(expr);
    }

    public Expr createNot(Expr expr) {
        return new UnaryNotExpr(expr);
    }

    public Expr createBitNot(Expr expr) {
        return new UnaryBitNotExpr(expr);
    }

    public Expr createClone(Expr expr) {
        return new FunCloneExpr(expr);
    }

    public Expr createCopy(Expr expr) {
        return new UnaryCopyExpr(expr);
    }

    public Expr createSuppress(Expr expr) {
        return new UnarySuppressErrorExpr(expr);
    }

    public Expr createToBoolean(Expr expr) {
        return new ToBooleanExpr(expr);
    }

    public Expr createToLong(Expr expr) {
        return new ToLongExpr(expr);
    }

    public Expr createToDouble(Expr expr) {
        return new ToDoubleExpr(expr);
    }

    public Expr createToString(Expr expr) {
        return new ToStringExpr(expr);
    }

    public Expr createToUnicode(Expr expr) {
        return new ToUnicodeExpr(expr);
    }

    public Expr createToBinary(Expr expr) {
        return new ToBinaryExpr(expr);
    }

    public Expr createToObject(Expr expr) {
        return new ToObjectExpr(expr);
    }

    public Expr createToArray(Expr expr) {
        return new ToArrayExpr(expr);
    }

    public Expr createDie(Expr expr) {
        return new FunDieExpr(expr);
    }

    public Expr createExit(Expr expr) {
        return new FunExitExpr(expr);
    }

    public Expr createRequired() {
        return ParamRequiredExpr.REQUIRED;
    }

    public Expr createDefault() {
        return new ParamDefaultExpr();
    }

    public Expr createAdd(Expr left, Expr right) {
        return new BinaryAddExpr(left, right);
    }

    public Expr createSub(Expr left, Expr right) {
        return new BinarySubExpr(left, right);
    }

    public Expr createMul(Expr left, Expr right) {
        return new BinaryMulExpr(left, right);
    }

    public Expr createDiv(Expr left, Expr right) {
        return new BinaryDivExpr(left, right);
    }

    public Expr createMod(Expr left, Expr right) {
        return new BinaryModExpr(left, right);
    }

    public Expr createLeftShift(Expr left, Expr right) {
        return new BinaryLeftShiftExpr(left, right);
    }

    public Expr createRightShift(Expr left, Expr right) {
        return new BinaryRightShiftExpr(left, right);
    }

    public Expr createBitAnd(Expr left, Expr right) {
        return new BinaryBitAndExpr(left, right);
    }

    public Expr createBitOr(Expr left, Expr right) {
        return new BinaryBitOrExpr(left, right);
    }

    public Expr createBitXor(Expr left, Expr right) {
        return new BinaryBitXorExpr(left, right);
    }

    public final Expr createAppend(Expr left, Expr right) {
        BinaryAppendExpr next;
        BinaryAppendExpr leftAppend = left instanceof BinaryAppendExpr ? (BinaryAppendExpr)left : this.createAppendImpl(left, null);
        BinaryAppendExpr result = this.append(leftAppend, next = right instanceof BinaryAppendExpr ? (BinaryAppendExpr)right : this.createAppendImpl(right, null));
        if (result.getNext() != null) {
            return result;
        }
        return result.getValue();
    }

    private BinaryAppendExpr append(BinaryAppendExpr left, BinaryAppendExpr tail) {
        if (left == null) {
            return tail;
        }
        tail = this.append(left.getNext(), tail);
        if (left.getValue() instanceof LiteralBinaryStringExpr && tail.getValue() instanceof LiteralBinaryStringExpr) {
            LiteralBinaryStringExpr leftString = (LiteralBinaryStringExpr)left.getValue();
            LiteralBinaryStringExpr rightString = (LiteralBinaryStringExpr)tail.getValue();
            try {
                byte[] bytes = (leftString.evalConstant().toString() + rightString.evalConstant().toString()).getBytes("ISO-8859-1");
                Expr value = this.createBinary(bytes);
                return this.createAppendImpl(value, tail.getNext());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (left.getValue() instanceof LiteralBinaryStringExpr || tail.getValue() instanceof LiteralBinaryStringExpr) {
            left.setNext(tail);
            return left;
        }
        if (left.getValue() instanceof LiteralStringExpr && tail.getValue() instanceof LiteralStringExpr) {
            LiteralStringExpr leftString = (LiteralStringExpr)left.getValue();
            LiteralStringExpr rightString = (LiteralStringExpr)tail.getValue();
            Expr value = this.createString(leftString.evalConstant().toString() + rightString.evalConstant().toString());
            return this.createAppendImpl(value, tail.getNext());
        }
        if (left.getValue() instanceof LiteralUnicodeExpr && tail.getValue() instanceof LiteralUnicodeExpr) {
            LiteralUnicodeExpr leftString = (LiteralUnicodeExpr)left.getValue();
            LiteralUnicodeExpr rightString = (LiteralUnicodeExpr)tail.getValue();
            Expr value = this.createUnicode(leftString.evalConstant().toString() + rightString.evalConstant().toString());
            return this.createAppendImpl(value, tail.getNext());
        }
        left.setNext(tail);
        return left;
    }

    protected BinaryAppendExpr createAppendImpl(Expr left, BinaryAppendExpr right) {
        return new BinaryAppendExpr(left, right);
    }

    public Expr createLt(Expr left, Expr right) {
        return new BinaryLtExpr(left, right);
    }

    public Expr createLeq(Expr left, Expr right) {
        return new BinaryLeqExpr(left, right);
    }

    public Expr createGt(Expr left, Expr right) {
        return new BinaryGtExpr(left, right);
    }

    public Expr createGeq(Expr left, Expr right) {
        return new BinaryGeqExpr(left, right);
    }

    public Expr createEq(Expr left, Expr right) {
        return new BinaryEqExpr(left, right);
    }

    public Expr createNeq(Expr left, Expr right) {
        return new BinaryNeqExpr(left, right);
    }

    public Expr createEquals(Expr left, Expr right) {
        return new BinaryEqualsExpr(left, right);
    }

    public Expr createAssign(AbstractVarExpr left, Expr right) {
        return new BinaryAssignExpr(left, right);
    }

    public Expr createAssignRef(AbstractVarExpr left, Expr right) {
        return new BinaryAssignRefExpr(left, right);
    }

    public UnaryRefExpr createRef(Expr base) {
        return new UnaryRefExpr(base);
    }

    public Expr createAnd(Expr left, Expr right) {
        return new BinaryAndExpr(left, right);
    }

    public Expr createOr(Expr left, Expr right) {
        return new BinaryOrExpr(left, right);
    }

    public Expr createXor(Expr left, Expr right) {
        return new BinaryXorExpr(left, right);
    }

    public Expr createComma(Expr left, Expr right) {
        return new BinaryCommaExpr(left, right);
    }

    public Expr createInstanceOf(Expr expr, String name) {
        return new BinaryInstanceOfExpr(expr, name);
    }

    public Expr createInstanceOfVar(Expr expr, Expr name) {
        return new BinaryInstanceOfVarExpr(expr, name);
    }

    public Expr createEach(Expr expr) {
        return new FunEachExpr(expr);
    }

    public final Expr createList(QuercusParser parser, ListHeadExpr head, Expr value) {
        Expr expr;
        boolean isSuppress = value instanceof UnarySuppressErrorExpr;
        if (isSuppress) {
            UnarySuppressErrorExpr suppressExpr = (UnarySuppressErrorExpr)value;
            value = suppressExpr.getExpr();
        }
        if (value instanceof FunEachExpr) {
            Expr arg = ((FunEachExpr)value).getExpr();
            expr = this.createListEach(head, arg);
        } else {
            expr = this.createList(head, value);
        }
        if (isSuppress) {
            return this.createSuppress(expr);
        }
        return expr;
    }

    public ListHeadExpr createListHead(ArrayList<Expr> keys) {
        return new ListHeadExpr(keys);
    }

    public Expr createList(ListHeadExpr head, Expr value) {
        return new BinaryAssignListExpr(head, value);
    }

    public Expr createListEach(ListHeadExpr head, Expr value) {
        return new BinaryAssignListEachExpr(head, value);
    }

    public Expr createConditional(Expr test, Expr left, Expr right) {
        return new ConditionalExpr(test, left, right);
    }

    public Expr createShortConditional(Expr test, Expr right) {
        return new ConditionalShortExpr(test, right);
    }

    public Expr createArrayFun(ArrayList<Expr> keys, ArrayList<Expr> values) {
        return new FunArrayExpr(keys, values);
    }

    public Expr createCall(QuercusParser parser, String name, ArrayList<Expr> args) {
        Location loc = parser.getLocation();
        if ("isset".equals(name) && args.size() == 1) {
            return new FunIssetExpr(args.get(0));
        }
        if ("get_called_class".equals(name) && args.size() == 0) {
            return new FunGetCalledClassExpr(loc);
        }
        if ("get_class".equals(name) && args.size() == 0) {
            return new FunGetClassExpr(parser);
        }
        if ("each".equals(name) && args.size() == 1) {
            Expr arg = args.get(0);
            if (!arg.isVar()) {
                parser.error(L.l("each() argument must be a variable at '{0}'", (Object)arg));
            }
            return new FunEachExpr(arg);
        }
        return new CallExpr(loc, name, args);
    }

    public CallVarExpr createVarFunction(Location loc, Expr name, ArrayList<Expr> args) {
        return new CallVarExpr(loc, name, args);
    }

    public ClosureExpr createClosure(Location loc, Function fun, ArrayList<VarExpr> useArgs) {
        return new ClosureExpr(loc, fun);
    }

    public Expr createMethodCall(Location loc, Expr objExpr, StringValue methodName, ArrayList<Expr> args) {
        return new ObjectMethodExpr(loc, objExpr, methodName, args);
    }

    public Expr createMethodCall(Location loc, Expr objExpr, Expr methodName, ArrayList<Expr> args) {
        return new ObjectMethodVarExpr(loc, objExpr, methodName, args);
    }

    public Expr createClassMethodCall(Location loc, String className, StringValue methodName, ArrayList<Expr> args) {
        if ("__construct".equals(methodName.toString())) {
            return new ClassConstructExpr(loc, className, args);
        }
        return new ClassMethodExpr(loc, className, methodName, args);
    }

    public Expr createClassMethodCall(Location loc, Expr className, StringValue methodName, ArrayList<Expr> args) {
        return new ClassVarMethodExpr(loc, className, methodName, args);
    }

    public Expr createClassVirtualMethodCall(Location loc, StringValue methodName, ArrayList<Expr> args) {
        return new ClassVirtualMethodExpr(loc, methodName, args);
    }

    public Expr createClassMethodCall(Location loc, String className, Expr methodName, ArrayList<Expr> args) {
        return new ClassMethodVarExpr(loc, className, methodName, args);
    }

    public Expr createClassMethodCall(Location loc, Expr className, Expr methodName, ArrayList<Expr> args) {
        return new ClassVarMethodVarExpr(loc, className, methodName, args);
    }

    public Expr createClassVirtualMethodCall(Location loc, Expr var, ArrayList<Expr> args) {
        return new ClassVirtualMethodVarExpr(loc, var, args);
    }

    public Expr createClassConstructor(Location loc, String className, StringValue methodName, ArrayList<Expr> args) {
        return new ClassConstructorExpr(loc, className, methodName, args);
    }

    public ObjectNewExpr createNew(Location loc, String name, ArrayList<Expr> args) {
        return new ObjectNewExpr(loc, name, args);
    }

    public ObjectNewVarExpr createVarNew(Location loc, Expr name, ArrayList<Expr> args) {
        return new ObjectNewVarExpr(loc, name, args);
    }

    public ObjectNewStaticExpr createNewStatic(Location loc, ArrayList<Expr> args) {
        return new ObjectNewStaticExpr(loc, args);
    }

    public Expr createInclude(Location loc, Path source, Expr expr) {
        return new FunIncludeExpr(loc, source, expr, false);
    }

    public Expr createRequire(Location loc, Path source, Expr expr) {
        return new FunIncludeExpr(loc, source, expr, true);
    }

    public Expr createIncludeOnce(Location loc, Path source, Expr expr) {
        return new FunIncludeOnceExpr(loc, source, expr, false);
    }

    public Expr createRequireOnce(Location loc, Path source, Expr expr) {
        return new FunIncludeOnceExpr(loc, source, expr, true);
    }

    public Expr createImport(Location loc, String name, boolean isWildcard) {
        return new ImportExpr(loc, name, isWildcard);
    }

    public Statement createNullStatement() {
        return NullStatement.NULL;
    }

    public Statement createEcho(Location loc, Expr expr) {
        return new EchoStatement(loc, expr);
    }

    public Statement createExpr(Location loc, Expr expr) {
        return new ExprStatement(loc, expr);
    }

    public final Statement createBlock(Location loc, ArrayList<Statement> statementList) {
        if (statementList.size() == 1) {
            return statementList.get(0);
        }
        Statement[] statements = new Statement[statementList.size()];
        statementList.toArray(statements);
        return this.createBlockImpl(loc, statements);
    }

    public final Statement createBlock(Location loc, Statement[] statementList) {
        if (statementList.length == 1) {
            return statementList[0];
        }
        Statement[] statements = new Statement[statementList.length];
        System.arraycopy(statementList, 0, statements, 0, statementList.length);
        return this.createBlockImpl(loc, statements);
    }

    public final BlockStatement createBlockImpl(Location loc, ArrayList<Statement> statementList) {
        Statement[] statements = new Statement[statementList.size()];
        statementList.toArray(statements);
        return this.createBlockImpl(loc, statements);
    }

    public BlockStatement createBlockImpl(Location loc, Statement[] statements) {
        return new BlockStatement(loc, statements);
    }

    public Statement createText(Location loc, String text) {
        return new TextStatement(loc, text);
    }

    public Statement createIf(Location loc, Expr test, Statement trueBlock, Statement falseBlock) {
        return new IfStatement(loc, test, trueBlock, falseBlock);
    }

    public Statement createSwitch(Location loc, Expr value, ArrayList<Expr[]> caseList, ArrayList<BlockStatement> blockList, Statement defaultBlock, String label) {
        return new SwitchStatement(loc, value, caseList, blockList, defaultBlock, label);
    }

    public Statement createFor(Location loc, Expr init, Expr test, Expr incr, Statement block, String label) {
        return new ForStatement(loc, init, test, incr, block, label);
    }

    public Statement createForeach(Location loc, Expr objExpr, AbstractVarExpr key, AbstractVarExpr value, boolean isRef, Statement block, String label) {
        return new ForeachStatement(loc, objExpr, key, value, isRef, block, label);
    }

    public Statement createWhile(Location loc, Expr test, Statement block, String label) {
        return new WhileStatement(loc, test, block, label);
    }

    public Statement createDo(Location loc, Expr test, Statement block, String label) {
        return new DoStatement(loc, test, block, label);
    }

    public BreakStatement createBreak(Location location, Expr target, ArrayList<String> loopLabelList) {
        return new BreakStatement(location, target, loopLabelList);
    }

    public ContinueStatement createContinue(Location location, Expr target, ArrayList<String> loopLabelList) {
        return new ContinueStatement(location, target, loopLabelList);
    }

    public Statement createGlobal(Location loc, VarExpr var) {
        return new GlobalStatement(loc, var);
    }

    public Statement createVarGlobal(Location loc, VarVarExpr var) {
        return new VarGlobalStatement(loc, var);
    }

    public Statement createClassStatic(Location loc, String className, VarExpr var, Expr value) {
        return new ClassStaticStatement(loc, className, var, value);
    }

    public Statement createStatic(Location loc, VarExpr var, Expr value) {
        return new StaticStatement(loc, var, value);
    }

    public Statement createThrow(Location loc, Expr value) {
        return new ThrowStatement(loc, value);
    }

    public TryStatement createTry(Location loc, Statement block) {
        return new TryStatement(loc, block);
    }

    public Statement createReturn(Location loc, Expr value) {
        return new ReturnStatement(loc, value);
    }

    public Statement createReturnRef(Location loc, Expr value) {
        return new ReturnRefStatement(loc, value);
    }

    public Statement createFunctionDef(Location loc, Function fun) {
        return new FunctionDefStatement(loc, fun);
    }

    public Statement createClassDef(Location loc, InterpretedClassDef cl) {
        return new ClassDefStatement(loc, cl);
    }

    public FunctionInfo createFunctionInfo(QuercusContext quercus, ClassDef classDef, String name) {
        return new FunctionInfo(quercus, classDef, name);
    }

    public Function createFunction(Location loc, String name, FunctionInfo info, Arg[] argList, Statement[] statementList) {
        return new Function(this, loc, name, info, argList, statementList);
    }

    public Function createObjectMethod(Location loc, InterpretedClassDef cl, String name, FunctionInfo info, Arg[] argList, Statement[] statementList) {
        return new ObjectMethod(this, loc, cl, name, info, argList, statementList);
    }

    public Function createMethodDeclaration(Location loc, InterpretedClassDef cl, String name, FunctionInfo info, Arg[] argList) {
        return new MethodDeclaration(this, loc, cl, name, info, argList);
    }

    public InterpretedClassDef createClassDef(Location location, String name, String parentName, String[] ifaceList, int index) {
        return new InterpretedClassDef(location, name, parentName, ifaceList, index);
    }
}

