/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.ConstStringValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.parser.QuercusParser;

public class LiteralStringExpr
extends Expr {
    protected final StringValue _value;

    public LiteralStringExpr(Location location, String value) {
        super(location);
        this._value = new ConstStringValue(value);
    }

    public LiteralStringExpr(Location location, StringValue value) {
        super(location);
        this._value = value;
    }

    public LiteralStringExpr(String value) {
        this(Location.UNKNOWN, value);
    }

    public LiteralStringExpr(StringValue value) {
        this(Location.UNKNOWN, value);
    }

    public boolean isLiteral() {
        return true;
    }

    public boolean isString() {
        return true;
    }

    public Expr createClassConst(QuercusParser parser, StringValue name) {
        ExprFactory factory = parser.getExprFactory();
        String className = this._value.toString();
        if ("self".equals(className)) {
            className = parser.getSelfClassName();
            return factory.createClassConst(className, name);
        }
        if ("parent".equals(className)) {
            className = parser.getParentClassName();
            return factory.createClassConst(className, name);
        }
        if ("static".equals(className)) {
            return factory.createClassVirtualConst(name);
        }
        return factory.createClassConst(className, name);
    }

    public Value evalConstant() {
        return this._value;
    }

    public Value eval(Env env) {
        return this._value;
    }

    public StringValue evalStringValue(Env env) {
        return this._value;
    }

    public String toString() {
        return "\"" + this._value + "\"";
    }
}

