/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.AbstractVarExpr;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.expr.ThisExpr;
import com.caucho.quercus.parser.QuercusParser;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThisFieldExpr
extends AbstractVarExpr {
    private static final L10N L = new L10N(ThisFieldExpr.class);
    protected final ThisExpr _qThis;
    protected final StringValue _name;

    public ThisFieldExpr(ThisExpr qThis, StringValue name) {
        this._qThis = qThis;
        this._name = name;
    }

    private Value cannotUseThisError(Env env) {
        return env.error(this.getLocation(), "Cannot use '$this' when not in object context.");
    }

    @Override
    public Expr createCall(QuercusParser parser, Location location, ArrayList<Expr> args) throws IOException {
        ExprFactory factory = parser.getExprFactory();
        return factory.createThisMethod(location, this._qThis, this._name, args);
    }

    @Override
    public Value eval(Env env) {
        Value obj = env.getThis();
        if (obj.isNull()) {
            return this.cannotUseThisError(env);
        }
        return obj.getThisField(env, this._name);
    }

    @Override
    public Value evalCopy(Env env) {
        Value obj = env.getThis();
        if (obj.isNull()) {
            return this.cannotUseThisError(env);
        }
        return obj.getThisField(env, this._name).copy();
    }

    @Override
    public Var evalVar(Env env) {
        Value obj = env.getThis();
        if (obj.isNull()) {
            this.cannotUseThisError(env);
            return new Var();
        }
        return obj.getThisFieldVar(env, this._name);
    }

    @Override
    public Value evalArg(Env env, boolean isTop) {
        Value obj = env.getThis();
        if (obj.isNull()) {
            return this.cannotUseThisError(env);
        }
        return obj.getThisFieldArg(env, this._name);
    }

    @Override
    public Value evalAssignValue(Env env, Value value) {
        Value obj = env.getThis();
        if (obj.isNull()) {
            this.cannotUseThisError(env);
        }
        obj.putThisField(env, this._name, value);
        return value;
    }

    @Override
    public Value evalAssignRef(Env env, Value value) {
        Value obj = env.getThis();
        if (obj.isNull()) {
            this.cannotUseThisError(env);
        }
        obj.putThisField(env, this._name, value);
        return value;
    }

    @Override
    public Value evalArrayAssign(Env env, Value index, Value value) {
        Value obj = env.getThis();
        if (obj.isNull()) {
            this.cannotUseThisError(env);
        }
        Value fieldVar = obj.getThisFieldArray(env, this._name);
        return fieldVar.putThisFieldArray(env, obj, this._name, index, value);
    }

    @Override
    public Value evalArray(Env env) {
        Value obj = env.getThis();
        if (obj.isNull()) {
            return this.cannotUseThisError(env);
        }
        return obj.getThisFieldArray(env, this._name);
    }

    @Override
    public Value evalObject(Env env) {
        Value obj = env.getThis();
        if (obj.isNull()) {
            return this.cannotUseThisError(env);
        }
        return obj.getThisFieldObject(env, this._name);
    }

    @Override
    public void evalUnset(Env env) {
        Value obj = env.getThis();
        if (obj.isNull()) {
            this.cannotUseThisError(env);
        }
        obj.unsetThisField(this._name);
    }

    @Override
    public String toString() {
        return "$this->" + this._name;
    }
}

