/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.AbstractVarExpr;
import com.caucho.quercus.expr.Expr;

public class VarVarExpr
extends AbstractVarExpr {
    protected final Expr _var;

    public VarVarExpr(Location location, Expr var) {
        super(location);
        this._var = var;
    }

    public VarVarExpr(Expr var) {
        this._var = var;
    }

    public Expr getExpr() {
        return this._var;
    }

    public Value eval(Env env) {
        StringValue varName = this._var.evalStringValue(env);
        Value value = env.getValue(varName);
        if (value != null) {
            return value;
        }
        return NullValue.NULL;
    }

    public Value evalAssignRef(Env env, Value value) {
        StringValue varName = this._var.evalStringValue(env);
        env.setRef(varName, value);
        return value;
    }

    public void evalUnset(Env env) {
        StringValue varName = this._var.evalStringValue(env);
        env.unsetVar(varName);
    }

    public Var evalVar(Env env) {
        StringValue varName = this._var.evalStringValue(env);
        return env.getVar(varName);
    }

    public Value evalArg(Env env, boolean isTop) {
        StringValue varName = this._var.evalStringValue(env);
        Var value = env.getVar(varName);
        if (value != null) {
            return value;
        }
        return NullValue.NULL;
    }

    public Value evalArray(Env env) {
        StringValue varName = this._var.evalStringValue(env);
        Var value = env.getVar(varName);
        if (value != null) {
            return ((Value)value).getArray();
        }
        ArrayValueImpl array = new ArrayValueImpl();
        env.setRef(varName, array);
        return array;
    }

    public String toString() {
        return "$" + this._var;
    }
}

