/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.function;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.function.AbstractFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyMethod
extends AbstractFunction {
    private final QuercusClass _quercusClass;
    private final LazyMethod _parent;
    private final String _name;
    private final Class<?> _pageClass;
    private final String _className;
    private AbstractFunction _fun;

    public LazyMethod(Class<?> pageClass, String name, String className) {
        this._parent = null;
        this._quercusClass = null;
        this._name = name;
        this._pageClass = pageClass;
        this._className = className;
    }

    private LazyMethod(LazyMethod parent, QuercusClass quercusClass, Class<?> pageClass, String name, String className) {
        this._parent = parent == null ? null : (parent._parent != null ? parent._parent : parent);
        this._quercusClass = quercusClass;
        this._name = name;
        this._pageClass = pageClass;
        this._className = className;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public AbstractFunction toFun(QuercusClass quercusClass) {
        if (this._fun != null) {
            return this._fun;
        }
        return new LazyMethod(this, quercusClass, this._pageClass, this._name, this._className);
    }

    private AbstractFunction getFun() {
        if (this._fun != null) {
            return this._fun;
        }
        try {
            ClassLoader loader = this._pageClass.getClassLoader();
            String className = this._pageClass.getName() + "$" + this._className;
            Class<?> cl = Class.forName(className, false, loader);
            this._fun = (AbstractFunction)cl.newInstance();
            this._fun.setBindingClass(this._quercusClass);
            if (this._quercusClass != null) {
                this._quercusClass.setModified();
            }
            if (this._parent != null) {
                this._parent._fun = this._fun;
                if (this._parent._quercusClass != null) {
                    this._parent._quercusClass.setModified();
                }
            }
            return this._fun;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isStatic() {
        return this.getFun().isStatic();
    }

    @Override
    public boolean isFinal() {
        return this.getFun().isFinal();
    }

    @Override
    public boolean isPublic() {
        return this.getFun().isPublic();
    }

    @Override
    public boolean isProtected() {
        return this.getFun().isProtected();
    }

    @Override
    public boolean isPrivate() {
        return this.getFun().isPrivate();
    }

    @Override
    public boolean isAbstract() {
        return this.getFun().isAbstract();
    }

    @Override
    public String getComment() {
        return this.getFun().getComment();
    }

    @Override
    public String getDeclaringClassName() {
        return this.getFun().getDeclaringClassName();
    }

    @Override
    public Value callMethod(Env env, QuercusClass qClass, Value qThis, Value[] args) {
        return this.getFun().callMethod(env, qClass, qThis, args);
    }

    @Override
    public Value callMethod(Env env, QuercusClass qClass, Value qThis) {
        return this.getFun().callMethod(env, qClass, qThis);
    }

    @Override
    public Value callMethod(Env env, QuercusClass qClass, Value qThis, Value a1) {
        return this.getFun().callMethod(env, qClass, qThis, a1);
    }

    @Override
    public Value callMethod(Env env, QuercusClass qClass, Value qThis, Value a1, Value a2) {
        return this.getFun().callMethod(env, qClass, qThis, a1, a2);
    }

    @Override
    public Value callMethod(Env env, QuercusClass qClass, Value qThis, Value a1, Value a2, Value a3) {
        return this.getFun().callMethod(env, qClass, qThis, a1, a2, a3);
    }

    @Override
    public Value callMethod(Env env, QuercusClass qClass, Value qThis, Value a1, Value a2, Value a3, Value a4) {
        return this.getFun().callMethod(env, qClass, qThis, a1, a2, a3, a4);
    }

    @Override
    public Value callMethod(Env env, QuercusClass qClass, Value qThis, Value a1, Value a2, Value a3, Value a4, Value a5) {
        return this.getFun().callMethod(env, qClass, qThis, a1, a2, a3, a4, a5);
    }

    @Override
    public Value callMethodRef(Env env, QuercusClass qClass, Value qThis, Value[] args) {
        return this.getFun().callMethodRef(env, qClass, qThis, args);
    }

    @Override
    public Value callMethodRef(Env env, QuercusClass qClass, Value qThis) {
        return this.getFun().callMethodRef(env, qClass, qThis);
    }

    @Override
    public Value callMethodRef(Env env, QuercusClass qClass, Value qThis, Value a1) {
        return this.getFun().callMethodRef(env, qClass, qThis, a1);
    }

    @Override
    public Value callMethodRef(Env env, QuercusClass qClass, Value qThis, Value a1, Value a2) {
        return this.getFun().callMethodRef(env, qClass, qThis, a1, a2);
    }

    @Override
    public Value callMethodRef(Env env, QuercusClass qClass, Value qThis, Value a1, Value a2, Value a3) {
        return this.getFun().callMethodRef(env, qClass, qThis, a1, a2, a3);
    }

    @Override
    public Value callMethodRef(Env env, QuercusClass qClass, Value qThis, Value a1, Value a2, Value a3, Value a4) {
        return this.getFun().callMethodRef(env, qClass, qThis, a1, a2, a3, a4);
    }

    @Override
    public Value callMethodRef(Env env, QuercusClass qClass, Value qThis, Value a1, Value a2, Value a3, Value a4, Value a5) {
        return this.getFun().callMethodRef(env, qClass, qThis, a1, a2, a3, a4, a5);
    }

    @Override
    public Value call(Env env, Value[] args) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._name + "]";
    }
}

