/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.Location;
import com.caucho.quercus.QuercusException;
import com.caucho.quercus.annotation.ClassImplementation;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.This;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.ErrorModule;
import java.util.Iterator;

@ClassImplementation
public class ExceptionClass {
    public static Value __construct(Env env, @This ObjectValue value, @Optional StringValue message, @Optional(value="0") int code, @Optional Value previous) {
        Location location;
        value.putField(env, "message", (Value)message);
        if (!value.issetField(env, env.createString("code"))) {
            value.putField(env, "code", (Value)LongValue.create(code));
        }
        if ((location = env.getLocation()) != null) {
            if (location.getFileName() != null) {
                value.putField(env, "file", (Value)env.createString(location.getFileName()));
            } else {
                value.putField(env, "file", (Value)env.createString("unknown"));
            }
            value.putField(env, "line", (Value)LongValue.create(location.getLineNumber()));
        }
        value.putField(env, "trace", (Value)ErrorModule.debug_backtrace(env, 0));
        QuercusException e = new QuercusException();
        e.fillInStackTrace();
        value.putField(env, "_quercusException", env.wrapJava(e));
        if (!previous.isDefault()) {
            value.putField(env, "previous", previous);
        }
        return value;
    }

    public static Value __toString(Env env, @This ObjectValue value) {
        StringValue sb = env.createUnicodeBuilder();
        sb.append("ExceptionClass[" + value.getName() + "]\n");
        sb.append(ExceptionClass.getMessage(env, value));
        sb.append("\n");
        sb.append(ExceptionClass.getTraceAsString(env, value));
        sb.append("\n");
        return sb;
    }

    public static Value getMessage(Env env, @This ObjectValue obj) {
        return obj.getField(env, env.createString("message"));
    }

    public static Value getCode(Env env, @This ObjectValue obj) {
        return obj.getField(env, env.createString("code"));
    }

    public static Value getFile(Env env, @This ObjectValue obj) {
        return obj.getField(env, env.createString("file"));
    }

    public static Value getLine(Env env, @This ObjectValue obj) {
        return obj.getField(env, env.createString("line"));
    }

    public static Value getTrace(Env env, @This Value obj) {
        return obj.getField(env, env.createString("trace"));
    }

    public static Value getPrevious(Env env, @This Value obj) {
        return obj.getField(env, env.createString("previous"));
    }

    public static Value getJavaException(Env env, @This Value obj) {
        return obj.getField(env, env.createString("__javaException"));
    }

    public static Value getTraceAsString(Env env, @This Value obj) {
        Value trace = ExceptionClass.getTrace(env, obj);
        StringValue sb = env.createUnicodeBuilder();
        sb.append("<trace>");
        Iterator<Value> iter = trace.getValueIterator(env);
        while (iter.hasNext()) {
            Value value = iter.next();
            sb = sb.append('\n');
            sb = sb.append(value.get(env.createString("file")));
            sb = sb.append(':');
            sb = sb.append(value.get(env.createString("line")));
            sb = sb.append(": ");
            sb = sb.append(value.get(env.createString("function")));
        }
        return sb;
    }
}

