/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.QuercusContext;
import com.caucho.quercus.QuercusException;
import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.annotation.NotNull;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.Reference;
import com.caucho.quercus.annotation.ReturnNullAsFalse;
import com.caucho.quercus.annotation.UsesSymbolTable;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnsetValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.ProcOpenInput;
import com.caucho.quercus.lib.ProcOpenOutput;
import com.caucho.quercus.lib.ProcOpenResource;
import com.caucho.quercus.lib.file.BinaryStream;
import com.caucho.quercus.lib.file.FileInput;
import com.caucho.quercus.lib.file.FileModule;
import com.caucho.quercus.lib.file.FileOutput;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.quercus.program.QuercusProgram;
import com.caucho.util.L10N;
import com.caucho.util.RandomUtil;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MiscModule
extends AbstractQuercusModule {
    private static final L10N L = new L10N(MiscModule.class);
    private static final Logger log = Logger.getLogger(MiscModule.class.getName());
    public static final int CONNECTION_NORMAL = 0;
    public static final int CONNECTION_ABORTED = 1;
    public static final int CONNECTION_TIMEOUT = 2;

    public static int connection_aborted(Env env) {
        return env.getConnectionStatus();
    }

    public static int connection_status(Env env) {
        return env.getConnectionStatus();
    }

    public static String escapeshellcmd(String command) {
        int p;
        StringBuilder sb = new StringBuilder();
        int len = command.length();
        boolean hasApos = false;
        boolean hasQuot = false;
        block5: for (int i = 0; i < len; ++i) {
            char ch = command.charAt(i);
            switch (ch) {
                case '\n': 
                case '#': 
                case '$': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case ',': 
                case ';': 
                case '<': 
                case '>': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '`': 
                case '{': 
                case '|': 
                case '}': 
                case '~': 
                case '\u00ff': {
                    sb.append('\\');
                    sb.append(ch);
                    continue block5;
                }
                case '\'': {
                    hasApos = !hasApos;
                    sb.append(ch);
                    continue block5;
                }
                case '\"': {
                    hasQuot = !hasQuot;
                    sb.append(ch);
                    continue block5;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        String result = sb.toString();
        if (hasApos) {
            p = result.lastIndexOf(39);
            result = result.substring(0, p) + "\\" + result.substring(p);
        }
        if (hasQuot) {
            p = result.lastIndexOf(34);
            result = result.substring(0, p) + "\\" + result.substring(p);
        }
        return result;
    }

    public static StringValue escapeshellarg(Env env, StringValue arg) {
        boolean isWindows = Path.isWindows();
        char quote = isWindows ? (char)'\"' : '\'';
        StringValue sb = env.createStringBuilder();
        sb.append(quote);
        int len = arg.length();
        for (int i = 0; i < len; ++i) {
            char ch = arg.charAt(i);
            if (ch == quote) {
                sb.append('\\');
                sb.append(ch);
                continue;
            }
            if (ch == '%' && isWindows) {
                sb.append(' ');
                continue;
            }
            sb.append(ch);
        }
        sb.append(quote);
        return sb;
    }

    @UsesSymbolTable
    public Value eval(Env env, StringValue code) {
        try {
            QuercusContext quercus;
            QuercusProgram program;
            Value value;
            if (log.isLoggable(Level.FINER)) {
                log.finer("quercus eval: [[" + code + "]]");
            }
            if ((value = (program = (quercus = env.getQuercus()).parseCode(code)).execute(env)) == null) {
                value = NullValue.NULL;
            }
            return value;
        }
        catch (IOException e) {
            throw new QuercusException(e);
        }
    }

    public static String exec(Env env, String command, @Optional Value output, @Optional @Reference Value result) {
        try {
            int ch;
            String[] args = new String[3];
            if (Path.isWindows()) {
                args[0] = "cmd";
                args[1] = "/c";
            } else {
                args[0] = "sh";
                args[1] = "-c";
            }
            args[2] = command;
            ProcessBuilder processBuilder = new ProcessBuilder(args);
            processBuilder.redirectErrorStream(false);
            processBuilder.directory(new File(env.getShellPwd()));
            Process process = processBuilder.start();
            InputStream is = process.getInputStream();
            InputStream es = process.getErrorStream();
            OutputStream os = process.getOutputStream();
            os.close();
            StringBuilder sb = new StringBuilder();
            String line = "";
            boolean hasCr = false;
            while ((ch = is.read()) >= 0) {
                if (ch == 10) {
                    if (!hasCr) {
                        line = sb.toString();
                        sb.setLength(0);
                        if (output != null) {
                            output.put(env.createString(line));
                        }
                    }
                    hasCr = false;
                    continue;
                }
                if (ch == 13) {
                    line = sb.toString();
                    sb.setLength(0);
                    output.put(env.createString(line));
                    hasCr = true;
                    continue;
                }
                sb.append((char)ch);
            }
            if (sb.length() > 0) {
                line = sb.toString();
                sb.setLength(0);
                output.put(env.createString(line));
            }
            is.close();
            env.getOut().writeStream(es);
            es.close();
            int status = process.waitFor();
            result.set(LongValue.create(status));
            return line;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Value get_browser(Env env, @Optional String user_agent, @Optional boolean return_array) {
        if (user_agent == null || user_agent.length() == 0) {
            user_agent = env.getRequest().getHeader("User-Agent");
        }
        if (user_agent == null) {
            env.warning(L.l("HTTP_USER_AGENT not set."));
            return BooleanValue.FALSE;
        }
        Value browscap = env.getConfigVar("browscap");
        if (browscap == null) {
            env.warning(L.l("Browscap path not set in PHP.ini."));
            return BooleanValue.FALSE;
        }
        Path path = env.lookup(browscap.toStringValue());
        if (path == null) {
            env.warning(L.l("Browscap file not found."));
            return BooleanValue.FALSE;
        }
        Value ini = FileModule.parse_ini_file(env, path, true);
        if (ini == BooleanValue.FALSE) {
            return BooleanValue.FALSE;
        }
        return MiscModule.getBrowserReport(env, ini.toArrayValue(env), user_agent, return_array);
    }

    private static Value getBrowserReport(Env env, ArrayValue browsers, String user_agent, boolean return_array) {
        StringValue patternMatched = env.getEmptyString();
        String regExpMatched = null;
        for (Map.Entry<Value, Value> entry : browsers.entrySet()) {
            StringValue pattern = entry.getKey().toStringValue();
            if (pattern.toString().equals(user_agent)) {
                patternMatched = pattern;
                regExpMatched = null;
                break;
            }
            String regExp = MiscModule.formatBrowscapRegexp(pattern);
            Matcher m = Pattern.compile(regExp).matcher(user_agent);
            if (!m.matches() || pattern.length() <= patternMatched.length()) continue;
            patternMatched = pattern;
            regExpMatched = regExp;
        }
        if (patternMatched.length() == 0) {
            return BooleanValue.FALSE;
        }
        return MiscModule.prepareBrowserReport(env, browsers, patternMatched, regExpMatched, user_agent, return_array);
    }

    private static Value prepareBrowserReport(Env env, ArrayValue browsers, StringValue patternMatched, String regExpMatched, String user_agent, boolean return_array) {
        ArrayValue capabilities = browsers.get(patternMatched).toArrayValue(env);
        if (regExpMatched == null) {
            capabilities.put(env.createString("browser_name_regex"), patternMatched);
        } else {
            capabilities.put("browser_name_regex", regExpMatched);
        }
        capabilities.put(env.createString("browser_name_pattern"), patternMatched);
        MiscModule.addBrowserCapabilities(env, browsers, capabilities.get(env.createString("parent")), capabilities);
        if (return_array) {
            ArrayValueImpl array = new ArrayValueImpl();
            array.put(env.createString(user_agent), capabilities);
            return array;
        }
        ObjectValue object = env.createObject();
        for (Map.Entry<Value, Value> entry : capabilities.entrySet()) {
            object.putField(env, entry.getKey().toString(), entry.getValue());
        }
        return object;
    }

    private static void addBrowserCapabilities(Env env, ArrayValue browsers, Value browser, ArrayValue cap) {
        if (browser == UnsetValue.UNSET) {
            return;
        }
        Value field = null;
        field = browsers.get(browser);
        if (field == UnsetValue.UNSET) {
            return;
        }
        ArrayValue browserCapabilities = field.toArrayValue(env);
        StringValue parentString = env.createString("parent");
        for (Map.Entry<Value, Value> entry : browserCapabilities.entrySet()) {
            Value key = entry.getKey();
            if (key.equals(parentString)) {
                MiscModule.addBrowserCapabilities(env, browsers, entry.getValue(), cap);
                continue;
            }
            if (cap.containsKey(key) != null) continue;
            cap.put(key, entry.getValue());
        }
    }

    private static String formatBrowscapRegexp(StringValue key) {
        int length = key.length();
        StringBuilder sb = new StringBuilder();
        block17: for (int i = 0; i < length; ++i) {
            char ch = key.charAt(i);
            switch (ch) {
                case '*': {
                    sb.append('.');
                    sb.append('*');
                    continue block17;
                }
                case '?': {
                    sb.append('.');
                    continue block17;
                }
                case '.': {
                    sb.append('\\');
                    sb.append('.');
                    continue block17;
                }
                case '+': {
                    sb.append('\\');
                    sb.append('+');
                    continue block17;
                }
                case '(': {
                    sb.append('\\');
                    sb.append('(');
                    continue block17;
                }
                case ')': {
                    sb.append('\\');
                    sb.append(')');
                    continue block17;
                }
                case '{': {
                    sb.append('\\');
                    sb.append('{');
                    continue block17;
                }
                case '}': {
                    sb.append('\\');
                    sb.append('}');
                    continue block17;
                }
                case ']': {
                    sb.append('\\');
                    sb.append(']');
                    continue block17;
                }
                case '[': {
                    sb.append('\\');
                    sb.append('[');
                    continue block17;
                }
                case '\\': {
                    sb.append('\\');
                    sb.append('\\');
                    continue block17;
                }
                case '^': {
                    sb.append('\\');
                    sb.append('^');
                    continue block17;
                }
                case '$': {
                    sb.append('\\');
                    sb.append('$');
                    continue block17;
                }
                case '&': {
                    sb.append('\\');
                    sb.append('&');
                    continue block17;
                }
                case '|': {
                    sb.append('\\');
                    sb.append('|');
                    continue block17;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public Value pack(Env env, String format, Value[] args) {
        try {
            ArrayList<PackSegment> segments = MiscModule.parsePackFormat(env, format, false);
            if (segments == null) {
                return BooleanValue.FALSE;
            }
            StringValue bb = env.createBinaryBuilder();
            int i = 0;
            for (PackSegment segment : segments) {
                i = segment.pack(env, bb, i, args);
            }
            return bb;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public Value unpack(Env env, String format, StringValue s) {
        if (format == null) {
            return NullValue.NULL;
        }
        try {
            ArrayList<PackSegment> segments = MiscModule.parsePackFormat(env, format, true);
            if (segments == null) {
                return BooleanValue.FALSE;
            }
            ArrayValueImpl array = new ArrayValueImpl();
            int length = s.length();
            int offset = 0;
            for (PackSegment segment : segments) {
                offset = segment.unpack(env, array, s, offset, length);
            }
            return array;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public Value resin_debug(String code) {
        log.info(code);
        return NullValue.NULL;
    }

    public Value resin_thread_dump() {
        Thread.dumpStack();
        return NullValue.NULL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Value dump_stack(Env env) {
        try {
            Exception e = new Exception("Stack trace");
            e.fillInStackTrace();
            WriteStream out = env.getPwd().lookup("stderr:").openWrite();
            try {
                e.printStackTrace(out.getPrintWriter());
            }
            finally {
                out.close();
            }
            return NullValue.NULL;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public static Value shell_exec(Env env, String command) {
        String[] args = new String[3];
        try {
            int ch;
            if (Path.isWindows()) {
                args[0] = "cmd";
                args[1] = "/c";
            } else {
                args[0] = "sh";
                args[1] = "-c";
            }
            args[2] = command;
            ProcessBuilder processBuilder = new ProcessBuilder(args);
            processBuilder.redirectErrorStream(false);
            processBuilder.directory(new File(env.getShellPwd()));
            Process process = processBuilder.start();
            InputStream is = process.getInputStream();
            InputStream es = process.getErrorStream();
            OutputStream os = process.getOutputStream();
            os.close();
            StringValue sb = env.createUnicodeBuilder();
            while ((ch = is.read()) >= 0) {
                sb.append((char)ch);
            }
            is.close();
            ch = es.read();
            if (ch >= 0) {
                env.print((char)ch);
                while ((ch = es.read()) >= 0) {
                    env.print((char)ch);
                }
                return NullValue.NULL;
            }
            es.close();
            int status = process.waitFor();
            return sb;
        }
        catch (Throwable e) {
            env.warning(e.getMessage(), e);
            return NullValue.NULL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void passthru(Env env, String command, @Optional @Reference Value result) {
        try {
            String[] args = new String[3];
            if (Path.isWindows()) {
                args[0] = "cmd";
                args[1] = "/c";
            } else {
                args[0] = "sh";
                args[1] = "-c";
            }
            args[2] = command;
            if (log.isLoggable(Level.FINER)) {
                log.finer("Quercus: passthru " + args[0] + " " + args[1] + " " + args[2]);
            }
            ProcessBuilder processBuilder = new ProcessBuilder(args);
            processBuilder.redirectErrorStream(true);
            processBuilder.directory(new File(env.getShellPwd()));
            Process process = processBuilder.start();
            try {
                InputStream is = process.getInputStream();
                OutputStream os = process.getOutputStream();
                os.close();
                env.getOut().writeStream(is);
                is.close();
                int status = process.waitFor();
                if (result != null) {
                    result.set(LongValue.create(status));
                }
            }
            finally {
                process.destroy();
            }
        }
        catch (Throwable e) {
            env.warning(e.getMessage(), e);
        }
    }

    @ReturnNullAsFalse
    public static ProcOpenResource proc_open(Env env, String command, ArrayValue descriptorArray, @Reference Value pipes, @Optional Path pwd, @Optional ArrayValue envArray, @Optional ArrayValue options) {
        String[] args = new String[3];
        try {
            if (Path.isWindows()) {
                args[0] = "cmd";
                args[1] = "/c";
            } else {
                args[0] = "sh";
                args[1] = "-c";
            }
            args[2] = command;
            String[] envStrings = null;
            File pwdFile = null;
            if (envArray != null) {
                int size = envArray.getSize();
                envStrings = new String[size];
                int i = 0;
                for (Map.Entry<Value, Value> entry : envArray.entrySet()) {
                    envStrings[i++] = entry.getKey() + "=" + entry.getValue();
                }
            }
            if (pwd != null) {
                pwdFile = new File(pwd.getFullPath());
            }
            Process process = Runtime.getRuntime().exec(args, envStrings, pwdFile);
            ProcOpenOutput in = null;
            ProcOpenInput out = null;
            ProcOpenInput es = null;
            ArrayValue array = pipes.toAutoArray().toArrayValue(env);
            pipes.set(array);
            array.clear();
            for (Map.Entry<Value, Value> entry : descriptorArray.entrySet()) {
                FileOutput file;
                BinaryStream stream;
                Value key = entry.getKey();
                Value val = entry.getValue();
                String type = val.get(LongValue.ZERO).toString();
                StringValue name = val.get(LongValue.ONE).toStringValue();
                String mode = val.get(LongValue.create(2L)).toString();
                if (key.equals(LongValue.ZERO)) {
                    if (type.equals("pipe")) {
                        in = new ProcOpenOutput(env, process.getOutputStream());
                        array.put(LongValue.ZERO, env.wrapJava(in));
                        continue;
                    }
                    if (!type.equals("file")) continue;
                    OutputStream processOut = process.getOutputStream();
                    BinaryStream stream2 = FileModule.fopen(env, name, mode, false, null);
                    if (stream2 instanceof FileInput) {
                        int ch;
                        FileInput file2 = (FileInput)stream2;
                        while ((ch = file2.read()) >= 0) {
                            processOut.write(ch);
                        }
                    }
                    stream2.close();
                    processOut.close();
                    continue;
                }
                if (key.equals(LongValue.ONE)) {
                    if (type.equals("pipe")) {
                        out = new ProcOpenInput(env, process.getInputStream());
                        array.put(LongValue.ONE, env.wrapJava(out));
                        continue;
                    }
                    if (!type.equals("file")) continue;
                    stream = FileModule.fopen(env, name, mode, false, null);
                    if (stream instanceof FileOutput) {
                        file = (FileOutput)stream;
                        out = new ProcOpenInput(env, process.getInputStream(), file);
                        continue;
                    }
                    if (stream == null) continue;
                    stream.close();
                    continue;
                }
                if (!key.equals(LongValue.create(2L))) continue;
                if (type.equals("pipe")) {
                    es = new ProcOpenInput(env, process.getErrorStream());
                    array.put(LongValue.create(2L), env.wrapJava(es));
                    continue;
                }
                if (!type.equals("file")) continue;
                stream = FileModule.fopen(env, name, mode, false, null);
                if (stream instanceof FileOutput) {
                    file = (FileOutput)stream;
                    es = new ProcOpenInput(env, process.getErrorStream(), file);
                    continue;
                }
                if (stream == null) continue;
                stream.close();
            }
            return new ProcOpenResource(env, process, in, out, es, command);
        }
        catch (Throwable e) {
            env.warning(e);
            return null;
        }
    }

    public static int proc_close(Env env, @NotNull ProcOpenResource stream) {
        if (stream == null) {
            env.warning("input to proc_close must not be null");
            return -1;
        }
        return stream.pclose();
    }

    public static boolean proc_terminate(Env env, @NotNull ProcOpenResource stream) {
        if (stream == null) {
            log.log(Level.FINE, "input to proc_close must not be null");
            env.warning("input to proc_close must not be null");
            return false;
        }
        return stream.terminate();
    }

    public static Value proc_get_status(Env env, @NotNull ProcOpenResource stream) {
        if (stream == null) {
            env.warning("input to proc_get_status() must not be null");
            return BooleanValue.FALSE;
        }
        ArrayValueImpl array = new ArrayValueImpl();
        array.put("command", stream.getCommand());
        array.put("running", stream.isRunning());
        array.put("exitcode", stream.getExitCode());
        return array;
    }

    public static int ignore_user_abort(@Optional boolean set) {
        return 0;
    }

    public String uniqid(@Optional String prefix, @Optional boolean moreEntropy) {
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            sb.append(prefix);
        }
        this.addUnique(sb);
        if (moreEntropy) {
            this.addUnique(sb);
        }
        return sb.toString();
    }

    private void addUnique(StringBuilder sb) {
        long value = RandomUtil.getRandomLong();
        if (value < 0L) {
            value = -value;
        }
        for (int limit = 13; limit > 0; --limit) {
            long digit = value % 26L;
            value /= 26L;
            sb.append((char)(97L + digit));
        }
    }

    public static Value usleep(long microseconds) {
        try {
            Thread.sleep(microseconds / 1000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return NullValue.NULL;
    }

    public static long sleep(long seconds) {
        try {
            Thread.sleep(seconds * 1000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return seconds;
    }

    public static String system(Env env, String command, @Optional @Reference Value result) {
        return MiscModule.exec(env, command, null, result);
    }

    private static ArrayList<PackSegment> parsePackFormat123(Env env, String format) {
        ArrayList<PackSegment> segments = new ArrayList<PackSegment>();
        int length = format.length();
        block16: for (int i = 0; i < length; ++i) {
            char ch = format.charAt(i);
            int count = 0;
            boolean isEnd = false;
            int ch1 = 32;
            ++i;
            while (i < length) {
                char c = format.charAt(i);
                ch1 = c;
                if ('0' > c || ch1 > 57) break;
                count = 10 * count + ch1 - 48;
                ++i;
            }
            if (ch1 == 42 && count == 0) {
                ++i;
                isEnd = true;
            } else if (count == 0) {
                count = 1;
            }
            if (i < length) {
                --i;
            }
            switch (ch) {
                case 'a': {
                    if (isEnd) {
                        segments.add(new SpaceEndPackSegment(env, 0));
                        continue block16;
                    }
                    segments.add(new SpacePackSegment(env, count, 0));
                    continue block16;
                }
                case 'A': {
                    segments.add(new SpacePackSegment(env, count, 32));
                    continue block16;
                }
                case 'h': {
                    segments.add(new RevHexPackSegment(count));
                    continue block16;
                }
                case 'H': {
                    segments.add(new HexPackSegment(env, count));
                    continue block16;
                }
                case 'C': 
                case 'c': {
                    segments.add(new BigEndianPackSegment(count, 1, ch == 'c'));
                    continue block16;
                }
                case 'S': 
                case 'n': 
                case 's': {
                    segments.add(new BigEndianPackSegment(count, 2, ch != 'S'));
                    continue block16;
                }
                case 'v': {
                    segments.add(new LittleEndianPackSegment(count, 2));
                    continue block16;
                }
                case 'L': 
                case 'N': 
                case 'l': {
                    segments.add(new BigEndianPackSegment(count, 4, ch == 'l'));
                    continue block16;
                }
                case 'V': {
                    segments.add(new LittleEndianPackSegment(count, 4));
                    continue block16;
                }
                case 'I': 
                case 'i': {
                    segments.add(new BigEndianPackSegment(count, 8, ch == 'i'));
                    continue block16;
                }
                case 'd': {
                    segments.add(new DoublePackSegment(count));
                    continue block16;
                }
                case 'f': {
                    segments.add(new FloatPackSegment(count));
                    continue block16;
                }
                case 'x': {
                    segments.add(new NullPackSegment(count));
                    continue block16;
                }
                case '@': {
                    segments.add(new PositionPackSegment(count));
                }
            }
        }
        return segments;
    }

    private static ArrayList<PackSegment> parsePackFormat(Env env, String format, boolean hasName) {
        ArrayList<PackSegment> segments = new ArrayList<PackSegment>();
        int length = format.length();
        int i = 0;
        block19: while (i < length) {
            char ch = format.charAt(i++);
            int count = 0;
            boolean isEnd = false;
            if (i < length && format.charAt(i) == '*') {
                count = Integer.MAX_VALUE;
                isEnd = true;
                ++i;
            } else {
                char ch1;
                while (i < length && '0' <= (ch1 = format.charAt(i)) && ch1 <= '9') {
                    count = count * 10 + ch1 - 48;
                    ++i;
                }
                if (count == 0) {
                    count = 1;
                }
            }
            String name = "";
            if (hasName && i < length) {
                char ch1;
                StringBuilder sb = new StringBuilder();
                while (i < length && (ch1 = format.charAt(i++)) != '/') {
                    sb.append(ch1);
                }
                name = sb.toString();
            }
            switch (ch) {
                case 'a': {
                    if (isEnd) {
                        segments.add(new SpaceEndPackSegment(env, name, 0));
                        continue block19;
                    }
                    segments.add(new SpacePackSegment(env, name, count, 0));
                    continue block19;
                }
                case 'A': {
                    if (isEnd) {
                        segments.add(new SpaceEndPackSegment(env, name, 32));
                        continue block19;
                    }
                    segments.add(new SpacePackSegment(env, name, count, 32));
                    continue block19;
                }
                case 'h': {
                    segments.add(new RevHexPackSegment(name, count));
                    continue block19;
                }
                case 'H': {
                    segments.add(new HexPackSegment(env, name, count));
                    continue block19;
                }
                case 'c': {
                    segments.add(new BigEndianPackSegment(name, count, 1, true));
                    continue block19;
                }
                case 'C': {
                    segments.add(new BigEndianPackSegment(name, count, 1, false));
                    continue block19;
                }
                case 's': {
                    segments.add(new BigEndianPackSegment(name, count, 2, true));
                    continue block19;
                }
                case 'S': 
                case 'n': {
                    segments.add(new BigEndianPackSegment(name, count, 2, false));
                    continue block19;
                }
                case 'v': {
                    segments.add(new LittleEndianPackSegment(name, count, 2));
                    continue block19;
                }
                case 'l': {
                    segments.add(new BigEndianPackSegment(name, count, 4, true));
                    continue block19;
                }
                case 'L': 
                case 'N': {
                    segments.add(new BigEndianPackSegment(name, count, 4, false));
                    continue block19;
                }
                case 'V': {
                    segments.add(new LittleEndianPackSegment(name, count, 4));
                    continue block19;
                }
                case 'I': 
                case 'i': {
                    segments.add(new BigEndianPackSegment(name, count, 8, false));
                    continue block19;
                }
                case 'd': {
                    segments.add(new DoublePackSegment(name, count));
                    continue block19;
                }
                case 'f': {
                    segments.add(new FloatPackSegment(name, count));
                    continue block19;
                }
                case 'x': {
                    segments.add(new NullPackSegment(name, count));
                    continue block19;
                }
                case '@': {
                    segments.add(new PositionPackSegment(name, count));
                    continue block19;
                }
            }
            env.warning(L.l("invalid format '{0}'", (Object)String.valueOf(ch)));
            return null;
        }
        return segments;
    }

    static int hexToDigit(Env env, char ch) {
        if ('0' <= ch && ch <= '9') {
            return ch - 48;
        }
        if ('a' <= ch && ch <= 'f') {
            return ch - 97 + 10;
        }
        if ('A' <= ch && ch <= 'F') {
            return ch - 65 + 10;
        }
        env.warning("pack: non hex digit: " + ch);
        return 0;
    }

    static char digitToHex(int d) {
        if ((d &= 0xF) < 10) {
            return (char)(48 + d);
        }
        return (char)(97 + d - 10);
    }

    static class PositionPackSegment
    extends PackSegment {
        private final int _length;

        PositionPackSegment(int length) {
            this("", length);
        }

        PositionPackSegment(String name, int length) {
            if (length == Integer.MAX_VALUE) {
                length = 0;
            }
            this._length = length;
        }

        public int pack(Env env, StringValue bb, int i, Value[] args) throws IOException {
            while (bb.length() < this._length) {
                bb.appendByte(0);
            }
            return i;
        }

        public int unpack(Env env, ArrayValue result, StringValue s, int offset, int strLen) {
            throw new UnsupportedOperationException("'@' skip to position");
        }
    }

    static class NullPackSegment
    extends PackSegment {
        private final String _name;
        private final int _length;

        NullPackSegment(int length) {
            this("", length);
        }

        NullPackSegment(String name, int length) {
            this._name = name;
            if (length == Integer.MAX_VALUE) {
                length = 0;
            }
            this._length = length;
        }

        public int pack(Env env, StringValue bb, int i, Value[] args) throws IOException {
            for (int j = 0; j < this._length; ++j) {
                bb.appendByte(0);
            }
            return i;
        }

        public int unpack(Env env, ArrayValue result, StringValue s, int offset, int strLen) {
            return (int)Math.min((long)offset + (long)this._length, (long)strLen);
        }
    }

    static class FloatPackSegment
    extends PackSegment {
        private final String _name;
        private final int _length;

        FloatPackSegment(int length) {
            this("", length);
        }

        FloatPackSegment(String name, int length) {
            this._name = name;
            this._length = length;
        }

        public int pack(Env env, StringValue bb, int i, Value[] args) throws IOException {
            for (int j = 0; j < this._length; ++j) {
                Value arg;
                if (i < args.length) {
                    arg = args[i];
                    ++i;
                } else {
                    if (this._length == Integer.MAX_VALUE) {
                        return i;
                    }
                    env.warning("a: not enough arguments");
                    return i;
                }
                double d = arg.toDouble();
                int v = Float.floatToIntBits((float)d);
                for (int k = 3; k >= 0; --k) {
                    bb.appendByte(v >> 8 * k & 0xFF);
                }
            }
            return i;
        }

        public int unpack(Env env, ArrayValue result, StringValue s, int offset, int strLen) {
            block0: for (int j = 0; j < this._length; ++j) {
                Value key;
                if (this._name.length() == 0) {
                    key = LongValue.create(j + 1);
                } else if (this._length == 1) {
                    key = env.createString(this._name);
                } else {
                    StringValue sb = env.createBinaryBuilder();
                    sb.append(this._name);
                    sb.append(j + 1);
                    key = sb;
                }
                int v = 0;
                for (int k = 0; k < 4; ++k) {
                    if (offset >= strLen) break block0;
                    char ch = s.charAt(offset++);
                    int d = ch & 0xFF;
                    v = 256 * v + d;
                }
                result.put(key, new DoubleValue(Float.intBitsToFloat(v)));
            }
            return offset;
        }
    }

    static class DoublePackSegment
    extends PackSegment {
        private final String _name;
        private final int _length;

        DoublePackSegment(int length) {
            this("", length);
        }

        DoublePackSegment(String name, int length) {
            this._name = name;
            this._length = length;
        }

        public int pack(Env env, StringValue bb, int i, Value[] args) throws IOException {
            for (int j = 0; j < this._length; ++j) {
                Value arg;
                if (i < args.length) {
                    arg = args[i];
                    ++i;
                } else {
                    if (this._length == Integer.MAX_VALUE) {
                        return i;
                    }
                    env.warning("a: not enough arguments");
                    return i;
                }
                double d = arg.toDouble();
                long v = Double.doubleToLongBits(d);
                for (int k = 7; k >= 0; --k) {
                    bb.appendByte((int)(v >> 8 * k & 0xFFL));
                }
            }
            return i;
        }

        public int unpack(Env env, ArrayValue result, StringValue s, int offset, int strLen) {
            block0: for (int j = 0; j < this._length; ++j) {
                Value key;
                if (this._name.length() == 0) {
                    key = LongValue.create(j + 1);
                } else if (this._length == 1) {
                    key = env.createString(this._name);
                } else {
                    StringValue sb = env.createBinaryBuilder();
                    sb.append(this._name);
                    sb.append(j + 1);
                    key = sb;
                }
                long v = 0L;
                for (int k = 0; k < 8; ++k) {
                    if (offset >= strLen) break block0;
                    char ch = s.charAt(offset++);
                    long d = ch & 0xFF;
                    v = 256L * v + d;
                }
                result.put(key, new DoubleValue(Double.longBitsToDouble(v)));
            }
            return offset;
        }
    }

    static class LittleEndianPackSegment
    extends PackSegment {
        private final String _name;
        private final int _length;
        private final int _bytes;

        LittleEndianPackSegment(int length, int bytes) {
            this._name = "";
            this._length = length;
            this._bytes = bytes;
        }

        LittleEndianPackSegment(String name, int length, int bytes) {
            this._name = name;
            this._length = length;
            this._bytes = bytes;
        }

        public int pack(Env env, StringValue bb, int i, Value[] args) throws IOException {
            for (int j = 0; j < this._length; ++j) {
                Value arg;
                if (i < args.length) {
                    arg = args[i];
                    ++i;
                } else {
                    if (this._length == Integer.MAX_VALUE) {
                        return i;
                    }
                    env.warning("a: not enough arguments");
                    return i;
                }
                long v = arg.toLong();
                for (int k = 0; k < this._bytes; ++k) {
                    bb.appendByte((int)(v >> 8 * k));
                }
            }
            return i;
        }

        public int unpack(Env env, ArrayValue result, StringValue s, int offset, int strLen) {
            block0: for (int j = 0; j < this._length; ++j) {
                Value key;
                if (this._name.length() == 0) {
                    key = LongValue.create(j + 1);
                } else if (this._length == 1) {
                    key = env.createString(this._name);
                } else {
                    StringValue sb = env.createStringBuilder();
                    sb.append(this._name);
                    sb.append(j + 1);
                    key = sb;
                }
                long v = 0L;
                for (int k = 0; k < this._bytes; ++k) {
                    if (offset >= strLen) break block0;
                    char ch = s.charAt(offset++);
                    long d = ch & 0xFF;
                    v |= d << 8 * k;
                }
                result.put(key, LongValue.create(v));
            }
            return offset;
        }
    }

    static class BigEndianPackSegment
    extends PackSegment {
        private final String _name;
        private final int _length;
        private final int _bytes;
        private final boolean _isSigned;

        BigEndianPackSegment(int length, int bytes, boolean isSigned) {
            this._name = "";
            this._length = length;
            this._bytes = bytes;
            this._isSigned = isSigned;
        }

        BigEndianPackSegment(String name, int length, int bytes, boolean isSigned) {
            this._name = name;
            this._length = length;
            this._bytes = bytes;
            this._isSigned = isSigned;
        }

        public int pack(Env env, StringValue bb, int i, Value[] args) throws IOException {
            for (int j = 0; j < this._length; ++j) {
                Value arg;
                if (i < args.length) {
                    arg = args[i];
                    ++i;
                } else {
                    if (this._length == Integer.MAX_VALUE) {
                        return i;
                    }
                    env.warning("a: not enough arguments");
                    return i;
                }
                long v = arg.toLong();
                for (int k = this._bytes - 1; k >= 0; --k) {
                    bb.appendByte((int)(v >> 8 * k));
                }
            }
            return i;
        }

        public int unpack(Env env, ArrayValue result, StringValue s, int offset, int strLen) {
            block5: for (int j = 0; j < this._length; ++j) {
                Value key;
                if (this._name.length() == 0) {
                    key = LongValue.create(j + 1);
                } else if (this._length == 1) {
                    key = env.createString(this._name);
                } else {
                    StringValue sb = env.createStringBuilder();
                    sb.append(this._name);
                    sb.append(j + 1);
                    key = sb;
                }
                long v = 0L;
                for (int k = 0; k < this._bytes; ++k) {
                    if (strLen <= offset) break block5;
                    char ch = s.charAt(offset++);
                    long d = ch & 0xFF;
                    v = (v << 8) + d;
                }
                if (this._isSigned) {
                    switch (this._bytes) {
                        case 1: {
                            v = (byte)v;
                            break;
                        }
                        case 2: {
                            v = (short)v;
                            break;
                        }
                        case 4: {
                            v = (int)v;
                        }
                    }
                }
                result.put(key, LongValue.create(v));
            }
            return offset;
        }
    }

    static class RevHexPackSegment
    extends PackSegment {
        private final StringValue _name;
        private final int _length;

        RevHexPackSegment(int length) {
            this("", length);
        }

        RevHexPackSegment(String name, int length) {
            this._name = new StringBuilderValue(name);
            this._length = length;
        }

        public int pack(Env env, StringValue bb, int i, Value[] args) throws IOException {
            Value arg;
            if (i < args.length) {
                arg = args[i];
                ++i;
            } else {
                env.warning("a: not enough arguments");
                return i;
            }
            StringValue s = arg.toStringValue();
            int strlen = s.length();
            if (this._length != Integer.MAX_VALUE) {
                if (strlen < this._length) {
                    env.warning("not enough characters in hex string");
                    return i;
                }
                if (this._length < strlen) {
                    strlen = this._length;
                }
            }
            int tail = strlen / 2;
            for (int j = 0; j < tail; ++j) {
                int d = 0;
                char ch = s.charAt(2 * j);
                d += MiscModule.hexToDigit(env, ch);
                ch = s.charAt(2 * j + 1);
                bb.appendByte(d += 16 * MiscModule.hexToDigit(env, ch));
            }
            if ((strlen & 1) == 1) {
                int d = MiscModule.hexToDigit(env, s.charAt(strlen - 1));
                bb.appendByte(d);
            }
            return i;
        }

        public int unpack(Env env, ArrayValue result, StringValue s, int offset, int strLen) {
            if ((long)offset + (long)(this._length / 2 - 1) >= (long)strLen) {
                return offset;
            }
            StringValue sb = env.createStringBuilder();
            for (int i = this._length / 2 - 1; i >= 0; --i) {
                char ch = s.charAt(offset++);
                sb.append(MiscModule.digitToHex(ch));
                sb.append(MiscModule.digitToHex(ch >> 4));
            }
            result.put(this._name, sb);
            return offset;
        }
    }

    static class HexPackSegment
    extends PackSegment {
        private final StringValue _name;
        private final int _length;

        HexPackSegment(Env env, int length) {
            this(env, "", length);
        }

        HexPackSegment(Env env, String name, int length) {
            this._name = env.createString(name);
            this._length = length;
        }

        public int pack(Env env, StringValue bb, int i, Value[] args) throws IOException {
            Value arg;
            if (i < args.length) {
                arg = args[i];
                ++i;
            } else {
                env.warning("a: not enough arguments");
                return i;
            }
            StringValue s = arg.toStringValue();
            int strlen = s.length();
            if (this._length != Integer.MAX_VALUE) {
                if (strlen < this._length) {
                    env.warning("not enough characters in hex string");
                    return i;
                }
                if (this._length < strlen) {
                    strlen = this._length;
                }
            }
            int tail = strlen / 2;
            for (int j = 0; j < tail; ++j) {
                int d = 0;
                char ch = s.charAt(2 * j);
                d += 16 * MiscModule.hexToDigit(env, ch);
                ch = s.charAt(2 * j + 1);
                bb.appendByte(d += MiscModule.hexToDigit(env, ch));
            }
            if ((strlen & 1) == 1) {
                int d = 16 * MiscModule.hexToDigit(env, s.charAt(strlen - 1));
                bb.appendByte(d);
            }
            return i;
        }

        public int unpack(Env env, ArrayValue result, StringValue s, int offset, int strLen) {
            if ((long)offset + (long)(this._length / 2 - 1) >= (long)strLen) {
                return offset;
            }
            StringValue sb = env.createStringBuilder();
            for (int i = this._length / 2 - 1; i >= 0; --i) {
                char ch = s.charAt(offset++);
                sb.append(MiscModule.digitToHex(ch >> 4));
                sb.append(MiscModule.digitToHex(ch));
            }
            result.put(this._name, sb);
            return offset;
        }
    }

    static class SpaceEndPackSegment
    extends PackSegment {
        private final StringValue _name;
        private final byte _pad;

        SpaceEndPackSegment(Env env, byte pad) {
            this(env, "", pad);
        }

        SpaceEndPackSegment(Env env, String name, byte pad) {
            this._name = env.createString(name);
            this._pad = pad;
        }

        public int pack(Env env, StringValue bb, int i, Value[] args) throws IOException {
            if (i >= args.length) {
                env.warning("a: not enough arguments");
                return i;
            }
            Value arg = args[i];
            StringValue s = arg.toStringValue(env);
            bb.append(s);
            return ++i;
        }

        public int unpack(Env env, ArrayValue result, StringValue s, int offset, int strLen) {
            StringValue bb = env.createBinaryBuilder();
            int j = offset;
            while (offset < strLen) {
                char ch;
                if ((ch = s.charAt(offset++)) == this._pad) continue;
                if (j + 1 != offset) {
                    bb.append(s, j, offset);
                } else {
                    bb.append(ch);
                }
                j = offset;
            }
            if (this._name.length() == 0) {
                result.put(env.createString('1'), bb);
            } else {
                result.put(this._name, bb);
            }
            return offset;
        }
    }

    static class SpacePackSegment
    extends PackSegment {
        private final StringValue _name;
        private final int _length;
        private final byte _pad;

        SpacePackSegment(Env env, int length, byte pad) {
            this(env, "", length, pad);
        }

        SpacePackSegment(Env env, String name, int length, byte pad) {
            this._name = env.createString(name);
            this._length = length;
            this._pad = pad;
        }

        public int pack(Env env, StringValue bb, int i, Value[] args) throws IOException {
            Value arg;
            if (i < args.length) {
                arg = args[i];
                ++i;
            } else {
                env.warning("a: not enough arguments");
                return i;
            }
            InputStream is = arg.toInputStream();
            int length = this._length;
            for (int j = 0; j < length; ++j) {
                int ch = is.read();
                if (ch >= 0) {
                    bb.appendByte(ch);
                    continue;
                }
                if (length == Integer.MAX_VALUE) {
                    return i;
                }
                bb.appendByte(this._pad);
            }
            return i;
        }

        public int unpack(Env env, ArrayValue result, StringValue s, int offset, int strLen) {
            if (strLen - offset < this._length) {
                return offset;
            }
            StringValue bb = env.createBinaryBuilder();
            int j = offset;
            for (int i = 0; i < this._length; ++i) {
                char ch;
                if ((ch = s.charAt(offset++)) == this._pad) continue;
                if (j + 1 != offset) {
                    bb.append(s, j, offset);
                } else {
                    bb.append(ch);
                }
                j = offset;
            }
            if (this._name.length() == 0) {
                result.put(env.createString('1'), bb);
            } else {
                result.put(this._name, bb);
            }
            return offset;
        }
    }

    static abstract class PackSegment {
        PackSegment() {
        }

        public abstract int pack(Env var1, StringValue var2, int var3, Value[] var4) throws IOException;

        public abstract int unpack(Env var1, ArrayValue var2, StringValue var3, int var4, int var5) throws IOException;
    }
}

