/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.FieldVisibility;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeBuilderValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

public final class UnserializeReader {
    private static final L10N L = new L10N(UnserializeReader.class);
    private static final Logger log = Logger.getLogger(UnserializeReader.class.getName());
    private static final LruCache<StringKey, StringValue> _keyCache = new LruCache(4096);
    private final char[] _buffer;
    private final int _length;
    private int _index;
    private StringKey _key = new StringKey();
    private ArrayList<Value> _valueList = new ArrayList();
    private ArrayList<Boolean> _referenceList = new ArrayList();
    private boolean _useReference;

    public UnserializeReader(StringValue s) throws IOException {
        this._buffer = s.toCharArray();
        this._length = this._buffer.length;
        if (s.indexOf("R:") >= 0 || s.indexOf("r:") >= 0) {
            this.initReferenceList();
        }
    }

    public UnserializeReader(String s) throws IOException {
        this._buffer = s.toCharArray();
        this._length = this._buffer.length;
        if (s.indexOf("R:") >= 0 || s.indexOf("r:") >= 0) {
            this.initReferenceList();
        }
    }

    protected boolean useReference() {
        return this._useReference;
    }

    public Value unserialize(Env env) throws IOException {
        int ch = this.read();
        switch (ch) {
            case 98: {
                Value value;
                this.expect(58);
                long v = this.readInt();
                this.expect(59);
                BooleanValue booleanValue = value = v == 0L ? BooleanValue.FALSE : BooleanValue.TRUE;
                if (this._useReference) {
                    value = this.createReference(value);
                }
                return value;
            }
            case 83: 
            case 85: 
            case 115: 
            case 117: {
                this.expect(58);
                int len = (int)this.readInt();
                this.expect(58);
                this.expect(34);
                if (!this.isValidString(len)) {
                    env.notice(L.l("expected string length of {0}", len));
                    return BooleanValue.FALSE;
                }
                Value value = ch == 115 || ch == 83 ? this.readStringValue(env, len) : this.readUnicodeValue(env, len);
                this.expect(34);
                this.expect(59);
                if (this._useReference) {
                    value = this.createReference(value);
                }
                return value;
            }
            case 105: {
                this.expect(58);
                long l = this.readInt();
                this.expect(59);
                Value value = LongValue.create(l);
                if (this._useReference) {
                    value = this.createReference(value);
                }
                return value;
            }
            case 100: {
                this.expect(58);
                StringBuilder sb = new StringBuilder();
                ch = this.read();
                while (ch >= 0 && ch != 59) {
                    sb.append((char)ch);
                    ch = this.read();
                }
                if (ch != 59) {
                    throw new IOException(L.l("expected ';'"));
                }
                Value value = new DoubleValue(Double.parseDouble(sb.toString()));
                if (this._useReference) {
                    value = this.createReference(value);
                }
                return value;
            }
            case 97: {
                this.expect(58);
                int len = (int)this.readInt();
                this.expect(58);
                this.expect(123);
                Value array = new ArrayValueImpl(len);
                if (this._useReference) {
                    array = this.createReference(array);
                }
                for (int i = 0; i < len; ++i) {
                    Value key = this.unserializeKey(env);
                    Value value = this.unserialize(env);
                    array.put(key, value);
                }
                this.expect(125);
                return array;
            }
            case 79: {
                Value obj;
                this.expect(58);
                int len = (int)this.readInt();
                this.expect(58);
                this.expect(34);
                if (!this.isValidString(len)) {
                    return BooleanValue.FALSE;
                }
                String className = this.readString(len);
                this.expect(34);
                this.expect(58);
                int count = (int)this.readInt();
                this.expect(58);
                this.expect(123);
                QuercusClass qClass = env.findClass(className);
                if (qClass != null) {
                    obj = qClass.createObject(env);
                } else {
                    log.fine(L.l("{0} is an undefined class in unserialize", (Object)className));
                    obj = env.createIncompleteObject(className);
                }
                Value ref = null;
                if (this._useReference) {
                    ref = this.createReference(obj);
                }
                for (int i = 0; i < count; ++i) {
                    StringValue key = this.unserializeKey(env).toStringValue();
                    FieldVisibility visibility = FieldVisibility.PUBLIC;
                    if (key.length() > 3 && key.charAt(0) == '\u0000') {
                        switch (key.charAt(1)) {
                            case 'A': {
                                visibility = FieldVisibility.PRIVATE;
                                break;
                            }
                            case '*': {
                                visibility = FieldVisibility.PROTECTED;
                                break;
                            }
                            default: {
                                throw new IOException(L.l("field visibility modifier is not valid: 0x{0}", (Object)Integer.toHexString(key.charAt(2))));
                            }
                        }
                        if (key.charAt(2) != '\u0000') {
                            throw new IOException(L.l("end of field visibility modifier is not valid: 0x{0}", (Object)Integer.toHexString(key.charAt(2))));
                        }
                        key = key.substring(3);
                    }
                    Value value = this.unserialize(env);
                    obj.initField(key, value, visibility);
                }
                this.expect(125);
                if (ref != null) {
                    return ref;
                }
                return obj;
            }
            case 78: {
                this.expect(59);
                Value value = NullValue.NULL;
                if (this._useReference) {
                    value = this.createReference(value);
                }
                return value;
            }
            case 82: {
                this.expect(58);
                int index = (int)this.readInt();
                this.expect(59);
                if (index - 1 >= this._valueList.size()) {
                    throw new IOException(L.l("reference out of range: {0}, size {1}, index {2}", (Object)(index - 1), (Object)this._valueList.size(), (Object)this._index));
                }
                Value ref = this._valueList.get(index - 1);
                return ref;
            }
            case 114: {
                this.expect(58);
                int index = (int)this.readInt();
                this.expect(59);
                if (index - 1 >= this._valueList.size()) {
                    throw new IOException(L.l("reference out of range: {0}, size {1}, index {2}", (Object)(index - 1), (Object)this._valueList.size(), (Object)this._index));
                }
                Value value = this._valueList.get(index - 1).copy();
                if (this._useReference) {
                    value = this.createReference(value);
                }
                return value;
            }
        }
        throw new IOException(L.l("option not recognized '{0}' (0x{1}) at index {2} ({3})", (Object)String.valueOf((char)ch), (Object)Integer.toHexString(ch), (Object)this._index, (Object)String.valueOf(this._buffer)));
    }

    public Value createReference(Value value) {
        if (this._referenceList.get(this._valueList.size()) == Boolean.FALSE) {
            this._valueList.add(value);
            return value;
        }
        Var var = new Var(value);
        this._valueList.add(var);
        return var;
    }

    private void initReferenceList() throws IOException {
        this.populateReferenceList();
        this._index = 0;
    }

    private void populateReferenceList() throws IOException {
        int ch = this.read();
        switch (ch) {
            case 98: {
                this._referenceList.add(Boolean.FALSE);
                this.expect(58);
                ch = this.read();
                while (ch >= 0 && ch != 59) {
                    ch = this.read();
                }
                return;
            }
            case 83: 
            case 85: 
            case 115: 
            case 117: {
                this._referenceList.add(Boolean.FALSE);
                this.expect(58);
                int len = (int)this.readInt();
                this.expect(58);
                this.expect(34);
                this._index += len;
                this.expect(34);
                this.expect(59);
                return;
            }
            case 105: {
                this._referenceList.add(Boolean.FALSE);
                this.expect(58);
                ch = this.read();
                while (ch >= 0 && ch != 59) {
                    ch = this.read();
                }
                return;
            }
            case 100: {
                this._referenceList.add(Boolean.FALSE);
                this.expect(58);
                ch = this.read();
                while (ch >= 0 && ch != 59) {
                    ch = this.read();
                }
                return;
            }
            case 97: {
                this._referenceList.add(Boolean.FALSE);
                this.expect(58);
                int len = (int)this.readInt();
                this.expect(58);
                this.expect(123);
                for (int i = 0; i < len; ++i) {
                    switch (this.read()) {
                        case 83: 
                        case 115: {
                            this.expect(58);
                            int keyLen = (int)this.readInt();
                            this.expect(58);
                            this.expect(34);
                            this._index += keyLen;
                            this.expect(34);
                            this.expect(59);
                            break;
                        }
                        case 105: {
                            this.expect(58);
                            ch = this.read();
                            while (ch >= 0 && ch != 59) {
                                ch = this.read();
                            }
                            break;
                        }
                    }
                    this.populateReferenceList();
                }
                this.expect(125);
                return;
            }
            case 79: {
                this._referenceList.add(Boolean.FALSE);
                this.expect(58);
                int len = (int)this.readInt();
                this.expect(58);
                this.expect(34);
                this._index += len;
                this.expect(34);
                this.expect(58);
                int count = (int)this.readInt();
                this.expect(58);
                this.expect(123);
                for (int i = 0; i < count; ++i) {
                    switch (this.read()) {
                        case 83: 
                        case 115: {
                            this.expect(58);
                            int keyLen = (int)this.readInt();
                            this.expect(58);
                            this.expect(34);
                            this._index += keyLen;
                            this.expect(34);
                            this.expect(59);
                            break;
                        }
                        case 105: {
                            this.expect(58);
                            ch = this.read();
                            while (ch >= 0 && ch != 59) {
                                ch = this.read();
                            }
                            break;
                        }
                    }
                    this.populateReferenceList();
                }
                this.expect(125);
                return;
            }
            case 78: {
                this._referenceList.add(Boolean.FALSE);
                this.expect(59);
                return;
            }
            case 82: {
                this._referenceList.add(Boolean.FALSE);
                this._useReference = true;
                this.expect(58);
                int value = (int)this.readInt();
                this.expect(59);
                this._referenceList.set(value - 1, Boolean.TRUE);
                return;
            }
            case 114: {
                this._referenceList.add(Boolean.FALSE);
                this._useReference = true;
                this.expect(58);
                int value = (int)this.readInt();
                this.expect(59);
                return;
            }
        }
    }

    public Value unserializeKey(Env env) throws IOException {
        int ch = this.read();
        switch (ch) {
            case 83: 
            case 85: 
            case 115: 
            case 117: {
                StringValue v;
                this.expect(58);
                int len = (int)this.readInt();
                this.expect(58);
                this.expect(34);
                if (len < 32) {
                    this._key.init(this._buffer, this._index, len);
                    v = _keyCache.get(this._key);
                    if (v != null) {
                        this._index += len;
                    } else {
                        StringKey key = new StringKey(this._buffer, this._index, len);
                        v = ch == 115 || ch == 83 ? this.readStringValue(env, len) : this.readUnicodeValue(env, len);
                        _keyCache.put(key, v);
                    }
                } else {
                    v = this.readStringValue(env, len);
                }
                this.expect(34);
                this.expect(59);
                return v;
            }
            case 105: {
                this.expect(58);
                long value = this.readInt();
                this.expect(59);
                return LongValue.create(value);
            }
        }
        return BooleanValue.FALSE;
    }

    private String unserializeString() throws IOException {
        int ch = this.read();
        if (ch != 115 && ch != 83) {
            throw new IOException(L.l("expected 's' at '{1}' (0x{2})", (Object)String.valueOf((char)ch), (Object)Integer.toHexString(ch)));
        }
        this.expect(58);
        int len = (int)this.readInt();
        this.expect(58);
        this.expect(34);
        String s = this.readString(len);
        this.expect(34);
        this.expect(59);
        return s;
    }

    public final void expect(int expectCh) throws IOException {
        char ch;
        if (this._length <= this._index) {
            throw new IOException(L.l("expected '{0}' at end of string", (Object)String.valueOf((char)expectCh)));
        }
        if ((ch = this._buffer[this._index++]) != expectCh) {
            String context = String.valueOf(ch);
            if (this._index - 2 >= 0) {
                context = this._buffer[this._index - 2] + context;
            }
            if (this._index < this._buffer.length) {
                context = context + this._buffer[this._index];
            }
            throw new IOException(L.l("expected '{0}' at '{1}' (0x{2}) (context '{3}', index {4})", (Object)String.valueOf((char)expectCh), (Object)String.valueOf(ch), (Object)Integer.toHexString(ch), (Object)context, (Object)this._index));
        }
    }

    public final long readInt() {
        int ch = this.read();
        long sign = 1L;
        long value = 0L;
        if (ch == 45) {
            sign = -1L;
            ch = this.read();
        } else if (ch == 43) {
            ch = this.read();
        }
        while (48 <= ch && ch <= 57) {
            value = 10L * value + (long)ch - 48L;
            ch = this.read();
        }
        this.unread();
        return sign * value;
    }

    public final boolean isValidString(int len) {
        return this._index + len < this._buffer.length;
    }

    public final String readString(int len) {
        String s = new String(this._buffer, this._index, len);
        this._index += len;
        return s;
    }

    public final StringValue readStringValue(Env env, int len) {
        StringValue s = env.createString(this._buffer, this._index, len);
        this._index += len;
        return s;
    }

    public final StringValue readUnicodeValue(Env env, int len) {
        UnicodeBuilderValue s = new UnicodeBuilderValue(this._buffer, this._index, len);
        this._index += len;
        return s;
    }

    public final int read() {
        if (this._index < this._length) {
            return this._buffer[this._index++];
        }
        return -1;
    }

    public final int read(char[] buffer, int offset, int length) {
        System.arraycopy(this._buffer, this._index, buffer, offset, length);
        this._index += length;
        return length;
    }

    public final void unread() {
        --this._index;
    }

    public static final class StringKey {
        char[] _buffer;
        int _offset;
        int _length;

        StringKey() {
        }

        StringKey(char[] buffer, int offset, int length) {
            this._buffer = new char[length];
            System.arraycopy(buffer, offset, this._buffer, 0, length);
            this._offset = 0;
            this._length = length;
        }

        void init(char[] buffer, int offset, int length) {
            this._buffer = buffer;
            this._offset = offset;
            this._length = length;
        }

        public int hashCode() {
            int offset;
            char[] buffer = this._buffer;
            int end = offset + this._length;
            int hash = 17;
            for (offset = this._offset; offset < end; ++offset) {
                hash = 65521 * hash + buffer[offset];
            }
            return hash;
        }

        public boolean equals(Object o) {
            if (!(o instanceof StringKey)) {
                return false;
            }
            StringKey key = (StringKey)o;
            int length = this._length;
            if (length != key._length) {
                return false;
            }
            char[] aBuf = this._buffer;
            char[] bBuf = key._buffer;
            int aOffset = this._offset;
            int bOffset = key._offset;
            int aEnd = aOffset + length;
            while (aOffset < aEnd) {
                if (aBuf[aOffset++] == bBuf[bOffset++]) continue;
                return false;
            }
            return true;
        }
    }
}

