/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.env.Callable;
import com.caucho.quercus.env.CallbackFunction;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.JavaMethod;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.OutputBuffer;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.util.URLUtil;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;

public class UrlRewriterCallback
extends CallbackFunction {
    private StringBuilder _rewriterQuery = new StringBuilder();
    private ArrayList<String[]> _rewriterVars = new ArrayList();

    public UrlRewriterCallback(Env env) {
        super(env, "URL-Rewriter");
        try {
            Method rewriterMethod = UrlRewriterCallback.class.getMethod("_internal_url_rewriter", Env.class, Value.class);
            this.setFunction(new JavaMethod(env.getModuleContext(), null, rewriterMethod));
        }
        catch (NoSuchMethodException e) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public static UrlRewriterCallback getInstance(Env env) {
        for (OutputBuffer ob = env.getOutputBuffer(); ob != null; ob = ob.getNext()) {
            Callable callback = ob.getCallback();
            if (!(callback instanceof UrlRewriterCallback)) continue;
            return (UrlRewriterCallback)callback;
        }
        return null;
    }

    public void addRewriterVar(String var, String value) {
        if (this._rewriterQuery.length() > 0) {
            this._rewriterQuery.append("&");
        }
        String encodedVar = URLUtil.encodeURL(var.replace(' ', '+'));
        String encodedValue = URLUtil.encodeURL(value.replace(' ', '+'));
        this._rewriterQuery.append(encodedVar + "=" + encodedValue);
        this._rewriterVars.add(new String[]{encodedVar, encodedValue});
    }

    public void resetRewriterVars() {
        this._rewriterQuery = new StringBuilder();
        this._rewriterVars.clear();
    }

    public static Value _internal_url_rewriter(Env env, Value buffer) {
        Value result;
        UrlRewriterCallback rewriter = UrlRewriterCallback.getInstance(env);
        if (rewriter == null) {
            result = buffer;
        } else {
            UrlRewriterCallback urlRewriterCallback = rewriter;
            urlRewriterCallback.getClass();
            Parser parser = urlRewriterCallback.new Parser(buffer.toString(), env);
            result = parser.parse();
            if (result.isNull()) {
                result = buffer;
            }
        }
        return result;
    }

    private class Parser {
        private Env _env;
        private boolean _includeSessionInfo = false;
        private String _sessionName = null;
        private String _sessionId = null;
        private String _javaSessionName = null;
        private String _javaSessionId = null;
        private int _index;
        private String _value;
        private boolean _quoted;
        private String _input;
        private StringValue _output;

        public Parser(String input, Env env) {
            this._input = input;
            this._env = env;
            this._index = 0;
            this._output = env.createUnicodeBuilder();
        }

        public Value parse() {
            if (this._env.getSession() != null && this._env.getJavaSession() != null && this._env.getIni("session.use_trans_sid").toBoolean()) {
                this._includeSessionInfo = true;
                this._sessionName = this._env.getIni("session.name").toString();
                this._sessionId = this._env.getSession().getId();
                this._javaSessionName = this._env.getQuercus().getCookieName();
                this._javaSessionId = this._env.getJavaSession().getId();
            }
            if (!this._includeSessionInfo && UrlRewriterCallback.this._rewriterVars.isEmpty()) {
                return NullValue.NULL;
            }
            String[] tagPairs = this._env.getIni("url_rewriter.tags").toString().split(",");
            HashMap<String, String> tags = new HashMap<String, String>();
            block4: for (String tagPair : tagPairs) {
                String[] tagAttribute = tagPair.split("=");
                switch (tagAttribute.length) {
                    case 1: {
                        tags.put(tagAttribute[0], null);
                        continue block4;
                    }
                    case 2: {
                        tags.put(tagAttribute[0], tagAttribute[1]);
                        continue block4;
                    }
                }
            }
            String tag = this.getNextTag();
            while (tag != null) {
                if (tags.containsKey(tag)) {
                    String attribute = (String)tags.get(tag);
                    if (attribute == null) {
                        this.consumeToEndOfTag();
                        if (this._includeSessionInfo) {
                            String phpSessionInputTag = "<input type=\"hidden\" name=\"" + this._sessionName + "\"" + " value=\"" + this._sessionId + "\" />";
                            this._output.append(phpSessionInputTag);
                        }
                        for (String[] entry : UrlRewriterCallback.this._rewriterVars) {
                            String inputTag = "<input type=\"hidden\" name=\"" + entry[0] + "\"" + " value=\"" + entry[1] + "\" />";
                            this._output.append(inputTag);
                        }
                    } else {
                        int valueEnd = 0;
                        valueEnd = this.getNextAttribute(attribute);
                        while (valueEnd == 0) {
                            valueEnd = this.getNextAttribute(attribute);
                        }
                        if (valueEnd > 0) {
                            this._output.append(this.rewriteUrl(this._value));
                            if (this._quoted) {
                                this.consumeOneCharacter();
                            }
                        }
                    }
                }
                tag = this.getNextTag();
            }
            return this._output;
        }

        private String getNextTag() {
            int tagStart = this._input.indexOf(60, this._index);
            if (tagStart < 0) {
                this._output.append(this._input.substring(this._index));
                return null;
            }
            this._output.append(this._input.substring(this._index, tagStart + 1));
            this._index = tagStart + 1;
            this.consumeNonWhiteSpace();
            return this._input.substring(tagStart + 1, this._index);
        }

        private int getNextAttribute(String attribute) {
            this.consumeWhiteSpace();
            int attributeStart = this._index;
            while (this._index < this._input.length() && this.isValidAttributeCharacter(this._input.charAt(this._index))) {
                this.consumeOneCharacter();
            }
            if (this._index == attributeStart) {
                return -1;
            }
            String foundAttribute = this._input.substring(attributeStart, this._index);
            this.consumeWhiteSpace();
            if (this._input.length() <= this._index || this._input.charAt(this._index) != '=') {
                return -1;
            }
            this.consumeOneCharacter();
            this.consumeWhiteSpace();
            int quote = 32;
            if (this._input.charAt(this._index) == '\"' || this._input.charAt(this._index) == '\'') {
                this._quoted = true;
                quote = this._input.charAt(this._index);
                this.consumeOneCharacter();
            }
            int valueEnd = this._index;
            if (this._quoted) {
                valueEnd = this._input.indexOf(quote, this._index);
                int tagEnd = this._input.indexOf(62, this._index);
                if (valueEnd < 0) {
                    valueEnd = tagEnd > 0 ? tagEnd : this._input.length();
                }
            } else {
                for (valueEnd = this._index; valueEnd < this._input.length() && this._input.charAt(valueEnd) != '/' && this._input.charAt(valueEnd) != '>' && this._input.charAt(valueEnd) != ' '; ++valueEnd) {
                }
            }
            if (foundAttribute.equals(attribute)) {
                this._value = this._input.substring(this._index, valueEnd);
                this._index = valueEnd;
                return 1;
            }
            if (this._quoted) {
                ++valueEnd;
            }
            this._output.append(this._input.substring(this._index, valueEnd));
            this._index = valueEnd;
            return 0;
        }

        private void consumeOneCharacter() {
            if (this._index < this._input.length()) {
                this._output.append(this._input.charAt(this._index));
                ++this._index;
            }
        }

        private void consumeWhiteSpace() {
            while (this._index < this._input.length() && Character.isWhitespace(this._input.charAt(this._index))) {
                this.consumeOneCharacter();
            }
        }

        private void consumeNonWhiteSpace() {
            while (this._index < this._input.length() && !Character.isWhitespace(this._input.charAt(this._index))) {
                this.consumeOneCharacter();
            }
        }

        private void consumeToEndOfTag() {
            while (this._input.charAt(this._index) != '>') {
                this.consumeOneCharacter();
            }
            this.consumeOneCharacter();
        }

        private boolean isValidAttributeCharacter(char ch) {
            return Character.isLetterOrDigit(ch) || ch == '-' || ch == '.' || ch == '_' || ch == ':';
        }

        private String rewriteUrl(String urlString) {
            URI uri;
            try {
                uri = new URI(urlString);
            }
            catch (URISyntaxException e) {
                return urlString;
            }
            if (uri.getScheme() != null || uri.getAuthority() != null) {
                return urlString;
            }
            StringBuilder query = new StringBuilder();
            if (uri.getQuery() != null) {
                query.append("?");
                query.append(uri.getQuery());
                query.append("&");
            } else {
                query.append("?");
            }
            if (this._includeSessionInfo) {
                query.append(this._sessionName);
                query.append("=");
                query.append(this._sessionId);
            }
            if (UrlRewriterCallback.this._rewriterQuery.length() != 0) {
                if (this._includeSessionInfo) {
                    query.append("&");
                }
                query.append((CharSequence)UrlRewriterCallback.this._rewriterQuery);
            }
            StringBuilder newUri = new StringBuilder();
            if (uri.getPath() != null) {
                newUri.append(uri.getPath());
            }
            newUri.append((CharSequence)query);
            if (uri.getFragment() != null) {
                newUri.append("#");
                newUri.append(uri.getFragment());
            }
            return newUri.toString();
        }
    }
}

