/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.date;

import com.caucho.quercus.UnimplementedException;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.date.DateInterval;
import com.caucho.quercus.lib.date.DateModule;
import com.caucho.quercus.lib.date.DateParser;
import com.caucho.quercus.lib.date.DateTimeZone;
import com.caucho.util.QDate;

public class DateTime
implements Cloneable {
    public static final String ATOM = "Y-m-d\\TH:i:sP";
    public static final String COOKIE = "l, d-M-y H:i:s T";
    public static final String ISO8601 = "Y-m-d\\TH:i:sO";
    public static final String RFC822 = "D, d M y H:i:s O";
    public static final String RFC850 = "l, d-M-y H:i:s T";
    public static final String RFC1036 = "D, d M y H:i:s O";
    public static final String RFC1123 = "D, d M Y H:i:s O";
    public static final String RFC2822 = "D, d M Y H:i:s O";
    public static final String RFC3339 = "Y-m-d\\TH:i:sP";
    public static final String RSS = "D, d M Y H:i:s O";
    public static final String W3C = "Y-m-d\\TH:i:sP";
    private QDate _qDate;
    private DateTimeZone _dateTimeZone;

    protected DateTime(QDate qDate, DateTimeZone dateTimeZone) {
        this._qDate = qDate;
        this._dateTimeZone = dateTimeZone;
    }

    protected DateTime(Env env, StringValue timeString) {
        this(env, timeString, null);
    }

    protected DateTime(Env env, StringValue timeString, DateTimeZone dateTimeZone) {
        if (dateTimeZone == null) {
            dateTimeZone = new DateTimeZone(env);
        }
        this._qDate = new QDate(dateTimeZone.getTimeZone(), env.getCurrentTime());
        this._dateTimeZone = dateTimeZone;
        this.init(env, timeString);
    }

    private void init(Env env, StringValue timeString) {
        long now = env.getCurrentTime();
        this._qDate.setGMTTime(now);
        if (timeString.equals("")) {
            this._qDate.setHour(0);
            this._qDate.setMinute(0);
            this._qDate.setSecond(0);
        }
        DateParser parser = new DateParser(timeString, this._qDate);
        parser.parse();
    }

    public static DateTime __construct(Env env, @Optional Value time, @Optional DateTimeZone timeZone) {
        StringValue timeStr = null;
        timeStr = time.isDefault() ? env.createString("now") : time.toStringValue(env);
        if (timeZone == null) {
            return new DateTime(env, timeStr);
        }
        return new DateTime(env, timeStr, timeZone);
    }

    public Object clone() {
        QDate qDate = (QDate)this._qDate.clone();
        DateTimeZone dateTimeZone = (DateTimeZone)this._dateTimeZone.clone();
        return new DateTime(qDate, dateTimeZone);
    }

    public StringValue format(Env env, StringValue format) {
        long time = this._qDate.getGMTTime() / 1000L;
        QDate calendar = new QDate(this._qDate.getLocalTimeZone());
        return DateModule.dateImpl(env, format, time, calendar);
    }

    public void modify(StringValue modify) {
        DateParser parser = new DateParser(modify, this._qDate);
        long time = parser.parse();
    }

    public long getTimestamp() {
        return this.getTime() / 1000L;
    }

    public DateTime setTimestamp(long timestamp) {
        this.setTime(timestamp * 1000L);
        return this;
    }

    public DateTimeZone getTimeZone() {
        return this._dateTimeZone;
    }

    public DateTime setTimeZone(Env env, DateTimeZone dateTimeZone) {
        this._dateTimeZone = dateTimeZone;
        long time = this._qDate.getGMTTime();
        this._qDate = new QDate(dateTimeZone.getTimeZone(), env.getCurrentTime());
        this._qDate.setGMTTime(time);
        return this;
    }

    public long getOffset() {
        return this._qDate.getZoneOffset() / 1000L;
    }

    public void setTime(int hour, int minute, @Optional int second) {
        this._qDate.setTime(hour, minute, second, 0L);
    }

    public void setDate(int year, int month, int day) {
        this._qDate.setDate(year, month - 1, day);
    }

    public void setISODate(int year, int week, @Optional int day) {
        throw new UnimplementedException("DateTime::setISODate()");
    }

    public DateInterval diff(Env env, DateTime dateTime, @Optional boolean isAbsolute) {
        DateInterval dateInterval = new DateInterval();
        QDate qDate0 = this._qDate;
        QDate qDate1 = dateTime._qDate;
        if (qDate0.getLocalTime() < qDate1.getLocalTime()) {
            qDate0 = dateTime._qDate;
            qDate1 = this._qDate;
        }
        int year = qDate0.getYear() - qDate1.getYear();
        int month = qDate0.getMonth() - qDate1.getMonth();
        int day = qDate0.getDayOfMonth() - qDate1.getDayOfMonth();
        int hour = qDate0.getHour() - qDate1.getHour();
        int minute = qDate0.getMinute() - qDate1.getMinute();
        int second = qDate0.getSecond() - qDate1.getSecond();
        if (second < 0) {
            --minute;
            second += 60;
        }
        if (minute < 0) {
            --hour;
            minute += 60;
        }
        if (hour < 0) {
            --day;
            hour += 24;
        }
        if (day < 0) {
            --month;
            day += qDate1.getDaysInMonth();
        }
        if (month < 0) {
            --year;
            month += 12;
        }
        dateInterval.y = year;
        dateInterval.m = month;
        dateInterval.d = day;
        dateInterval.h = hour;
        dateInterval.i = minute;
        dateInterval.s = second;
        long diff = qDate0.getLocalTime() - qDate1.getLocalTime();
        long days = diff / 86400000L;
        dateInterval.days = LongValue.create(days);
        return dateInterval;
    }

    protected QDate getQDate() {
        return this._qDate;
    }

    protected long getTime() {
        return this._qDate.getGMTTime();
    }

    protected void setTime(long time) {
        this._qDate.setGMTTime(time);
    }

    public String toString() {
        Env env = Env.getInstance();
        return this.format(env, env.createString("now")).toString();
    }
}

