/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.db;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.UnsetValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.db.ColumnType;
import com.caucho.quercus.lib.db.JdbcConnectionResource;
import com.caucho.quercus.lib.db.JdbcStatementResource;
import com.caucho.quercus.lib.db.OracleStatement;
import com.caucho.quercus.lib.file.FileReadValue;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.TempReadStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;

public class JdbcPreparedStatementResource
extends JdbcStatementResource {
    private static final Logger log = Log.open(JdbcPreparedStatementResource.class);
    private static final L10N L = new L10N(JdbcPreparedStatementResource.class);
    private PreparedStatement _preparedStmt;
    private ColumnType[] _types;
    private Value[] _params;

    public JdbcPreparedStatementResource(JdbcConnectionResource conn) {
        super(conn);
    }

    protected boolean bindParams(Env env, ColumnType[] types, Value[] params) {
        this._types = types;
        this._params = params;
        return true;
    }

    private boolean setLobParameter(Env env, int index, Value value) {
        block11: {
            if (this._preparedStmt == null) {
                return false;
            }
            try {
                if (value == null || value.isNull()) {
                    this._preparedStmt.setObject(index, null);
                    break block11;
                }
                if (value.isString()) {
                    this._preparedStmt.setBinaryStream(index, value.toInputStream(), value.length());
                    break block11;
                }
                InputStream inputStream = value.toInputStream();
                if (inputStream == null) {
                    env.warning(L.l("type {0} ({1}) for parameter index {2} cannot be used for lob", (Object)value.getType(), (Object)value.getClass(), (Object)index));
                    return false;
                }
                int length = -1;
                if (value instanceof FileReadValue && (length = (int)((FileReadValue)value).getLength()) <= 0) {
                    length = -1;
                }
                if (length < 0) {
                    TempBuffer tempBuffer = TempBuffer.allocate();
                    try {
                        int len;
                        byte[] bytes = new byte[1024];
                        while ((len = inputStream.read(bytes, 0, 1024)) != -1) {
                            tempBuffer.write(bytes, 0, len);
                        }
                    }
                    catch (IOException e) {
                        env.warning(e);
                        return false;
                    }
                    TempReadStream tempReadStream = new TempReadStream(tempBuffer);
                    tempReadStream.setFreeWhenDone(true);
                    this._preparedStmt.setBinaryStream(index, (InputStream)new ReadStream(tempReadStream), tempBuffer.getLength());
                    break block11;
                }
                this._preparedStmt.setBinaryStream(index, inputStream, length);
            }
            catch (SQLException e) {
                this.setError(env, e);
                return false;
            }
        }
        return true;
    }

    protected boolean prepareForExecute(Env env) throws SQLException {
        if (this._types == null || this._preparedStmt == null) {
            return true;
        }
        int size = this._types.length;
        for (int i = 0; i < size; ++i) {
            ColumnType type = this._types[i];
            if (type == ColumnType.BOOLEAN) {
                this._preparedStmt.setBoolean(i + 1, this._params[i].toBoolean());
                continue;
            }
            if (type == ColumnType.NULL) {
                this._preparedStmt.setNull(i + 1, 0);
                continue;
            }
            if (type == ColumnType.LONG) {
                this._preparedStmt.setLong(i + 1, this._params[i].toInt());
                continue;
            }
            if (type == ColumnType.DOUBLE) {
                this._preparedStmt.setDouble(i + 1, this._params[i].toDouble());
                continue;
            }
            if (type == ColumnType.BLOB) {
                this._preparedStmt.setString(i + 1, this._params[i].toString());
                continue;
            }
            if (type == ColumnType.STRING) {
                this._preparedStmt.setString(i + 1, this._params[i].toString());
                continue;
            }
            if (type == ColumnType.LOB) {
                this.setLobParameter(env, i + 1, this._params[i]);
                continue;
            }
            throw new SQLException("unknown type: " + (Object)((Object)type));
        }
        return true;
    }

    protected boolean executeImpl(Env env) throws SQLException {
        if (this._preparedStmt != null) {
            return this._preparedStmt.execute();
        }
        return super.executeImpl(env);
    }

    protected PreparedStatement getPreparedStatement() {
        return this._preparedStmt;
    }

    public int paramCount() {
        String query = this.getQuery();
        if (query == null) {
            return -1;
        }
        int count = 0;
        int length = query.length();
        boolean inQuotes = false;
        for (int i = 0; i < length; ++i) {
            char c = query.charAt(i);
            if (c == '\\') {
                if (i >= length - 1) continue;
                ++i;
                continue;
            }
            if (inQuotes) {
                if (c != '\'') continue;
                inQuotes = false;
                continue;
            }
            if (c == '\'') {
                inQuotes = true;
                continue;
            }
            if (c != '?') continue;
            ++count;
        }
        return count;
    }

    public boolean prepare(Env env, String query) {
        try {
            PreparedStatement preparedStmt = this._preparedStmt;
            if (preparedStmt != null) {
                preparedStmt.close();
            }
            this.setQuery(query);
            if (query.length() == 0) {
                return false;
            }
            JdbcConnectionResource conn = this.getConnection();
            Connection javaConn = this.getJavaConnection(env);
            if (conn == null) {
                return false;
            }
            if (!this.isPreparable(query)) {
                Statement stmt = javaConn.createStatement();
                this.setStatement(stmt);
                return true;
            }
            preparedStmt = this instanceof OracleStatement ? javaConn.prepareCall(query, 1004, 1007) : (conn.isSeekable() ? javaConn.prepareStatement(query, 1004, 1007) : javaConn.prepareStatement(query));
            this._preparedStmt = preparedStmt;
            this.setStatement(preparedStmt);
            return true;
        }
        catch (SQLException e) {
            this.setError(env, e);
            return false;
        }
    }

    protected boolean isPreparable(String query) {
        JdbcConnectionResource.SqlParseToken token = this.getConnection().parseSqlToken(query, null);
        if (token == null) {
            return false;
        }
        switch (token.getFirstChar()) {
            case 'S': 
            case 's': {
                return !token.matchesToken("SAVEPOINT");
            }
            case 'R': 
            case 'r': {
                if (token.matchesToken("RELEASE")) {
                    return false;
                }
                return !token.matchesToken("ROLLBACK");
            }
        }
        return true;
    }

    protected Value getParam(int i) {
        if (i >= this._params.length) {
            return UnsetValue.UNSET;
        }
        return this._params[i];
    }

    protected int getParamLength() {
        return this._params.length;
    }

    protected void setPreparedStatement(PreparedStatement stmt) {
        this._preparedStmt = stmt;
    }

    protected void setObject(int i, Object param) throws SQLException {
        ParameterMetaData pmd = this._preparedStmt.getParameterMetaData();
        int type = pmd.getParameterType(i);
        switch (type) {
            case 1111: {
                String typeName = pmd.getParameterTypeName(i);
                if (typeName.equals("interval")) {
                    this._preparedStmt.setObject(i, param);
                    break;
                }
                try {
                    Class<?> cl = Class.forName("org.postgresql.util.PGobject");
                    Constructor<?> constructor = cl.getDeclaredConstructor(new Class[0]);
                    Object object = constructor.newInstance(new Object[0]);
                    Method method = cl.getDeclaredMethod("setType", String.class);
                    method.invoke(object, typeName);
                    method = cl.getDeclaredMethod("setValue", String.class);
                    method.invoke(object, param);
                    this._preparedStmt.setObject(i, object, type);
                    break;
                }
                catch (ClassNotFoundException e) {
                    throw new SQLException(e);
                }
                catch (NoSuchMethodException e) {
                    throw new SQLException(e);
                }
                catch (InvocationTargetException e) {
                    throw new SQLException(e.getCause());
                }
                catch (IllegalAccessException e) {
                    throw new SQLException(e);
                }
                catch (InstantiationException e) {
                    throw new SQLException(e);
                }
            }
            case 8: {
                String typeName = pmd.getParameterTypeName(i);
                if (typeName.equals("money")) {
                    String s = param.toString();
                    if (s.length() == 0) {
                        throw new IllegalArgumentException(L.l("argument `{0}' cannot be empty", param));
                    }
                    String money = s;
                    if (s.charAt(0) == '$') {
                        s = s.substring(1);
                    } else {
                        money = "$" + money;
                    }
                    try {
                        Double.parseDouble(s);
                    }
                    catch (Exception ex) {
                        throw new IllegalArgumentException(L.l("cannot convert argument `{0}' to money", param));
                    }
                    try {
                        Class<?> cl = Class.forName("org.postgresql.util.PGmoney");
                        Constructor<?> constructor = cl.getDeclaredConstructor(String.class);
                        Object object = constructor.newInstance(money);
                        this._preparedStmt.setObject(i, object, 1111);
                        break;
                    }
                    catch (ClassNotFoundException e) {
                        throw new SQLException(e);
                    }
                    catch (NoSuchMethodException e) {
                        throw new SQLException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw new SQLException(e.getCause());
                    }
                    catch (IllegalAccessException e) {
                        throw new SQLException(e);
                    }
                    catch (InstantiationException e) {
                        throw new SQLException(e);
                    }
                }
            }
            default: {
                this._preparedStmt.setObject(i, param, type);
            }
        }
    }
}

