/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.db;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.ConnectionEntry;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.lib.db.JdbcConnectionResource;
import com.caucho.quercus.lib.db.JdbcResultResource;
import com.caucho.quercus.lib.db.OracleResult;
import com.caucho.quercus.lib.db.OracleStatement;
import com.caucho.util.L10N;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Oracle
extends JdbcConnectionResource {
    private static final Logger log = Logger.getLogger(Oracle.class.getName());
    private static final L10N L = new L10N(Oracle.class);

    public Oracle(Env env, @Optional(value="localhost") String host, @Optional String user, @Optional String password, @Optional String db, @Optional(value="1521") int port, @Optional String driver, @Optional String url) {
        super(env);
        this.connectInternal(env, host, user, password, db, port, "", 0, driver, url, false);
    }

    protected String getDriverName() {
        return "oci";
    }

    protected ConnectionEntry connectImpl(Env env, String host, String userName, String password, String dbname, int port, String socket, int flags, String driver, String url, boolean isNewLink) {
        if (this.isConnected()) {
            env.warning(L.l("Connection is already opened to '{0}'", (Object)this));
            return null;
        }
        try {
            if (host == null || host.equals("")) {
                host = "localhost";
            }
            if (driver == null || driver.equals("")) {
                driver = "oracle.jdbc.OracleDriver";
            }
            if (url == null || url.equals("")) {
                if (dbname.indexOf("//") == 0) {
                    url = "jdbc:oracle:thin:@" + dbname.substring(2);
                    url = url.replace('/', ':');
                } else {
                    url = "jdbc:oracle:thin:@" + host + ":" + port + ":" + dbname;
                }
            }
            ConnectionEntry jConn = env.getConnection(driver, url, userName, password, !isNewLink);
            return jConn;
        }
        catch (SQLException e) {
            env.warning("A link to the server could not be established. " + e.toString());
            env.setSpecialValue("oracle.connectErrno", LongValue.create(e.getErrorCode()));
            env.setSpecialValue("oracle.connectError", env.createString(e.getMessage()));
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
        catch (Exception e) {
            env.warning("A link to the server could not be established. " + e.toString());
            env.setSpecialValue("oracle.connectError", env.createString(e.getMessage()));
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }

    public OracleStatement prepare(Env env, String query) {
        OracleStatement stmt = new OracleStatement((Oracle)this.validateConnection(env));
        stmt.prepare(env, query);
        return stmt;
    }

    protected JdbcResultResource createResult(Statement stmt, ResultSet rs) {
        return new OracleResult(rs, this);
    }

    public String toString() {
        if (this.isConnected()) {
            return "Oracle[" + this.getHost() + "]";
        }
        return "Oracle[]";
    }
}

