/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.db;

import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.lib.db.PDOException;
import com.caucho.util.L10N;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PDOError {
    private static final L10N L = new L10N(PDOError.class);
    private static final Logger log = Logger.getLogger(PDOError.class.getName());
    private static final String ERR_NONE = "00000";
    private static final String ERR_GENERAL = "HY000";
    private int _errmode;
    private boolean _isError;
    private String _errorCode = "00000";
    private ArrayValue _errorInfo;

    public void clear() {
        this._isError = false;
        this._errorCode = ERR_NONE;
        this._errorInfo = null;
    }

    private void error(Env env, String errorCode, int driverError, String errorMessage) {
        this._isError = true;
        int level = Math.max(this._errmode, 0);
        this._errorCode = errorCode;
        this._errorInfo = new ArrayValueImpl();
        this._errorInfo.put(errorCode);
        this._errorInfo.put(driverError);
        this._errorInfo.put(errorMessage);
        if (level == 1) {
            env.warning("SQLSTATE[" + errorCode + "]: " + errorMessage);
        } else if (level == 2) {
            throw new PDOException(env, errorCode, errorMessage);
        }
    }

    public void error(Env env, Throwable exception) {
        int driverError;
        String errorMessage;
        String errorCode;
        log.log(Level.FINE, exception.toString(), exception);
        if (exception instanceof SQLException) {
            SQLException sqlException = (SQLException)exception;
            errorCode = sqlException.getSQLState();
            errorMessage = sqlException.getMessage();
            driverError = sqlException.getErrorCode();
        } else {
            errorCode = ERR_GENERAL;
            errorMessage = exception.getMessage();
            driverError = 0;
        }
        this.error(env, errorCode, driverError, errorMessage);
    }

    public String getErrorCode() {
        return this._errorCode;
    }

    public ArrayValue getErrorInfo() {
        if (this._errorInfo == null) {
            this._errorInfo = new ArrayValueImpl();
            this._errorInfo.put(ERR_NONE);
        }
        return this._errorInfo;
    }

    public int getErrmode() {
        return this._errmode;
    }

    public boolean isError() {
        return this._isError;
    }

    public void notice(Env env, String message) {
        this._isError = true;
        this._errorCode = ERR_GENERAL;
        this._errorInfo = new ArrayValueImpl();
        this._errorInfo.put(this._errorCode);
        this._errorInfo.put(2050L);
        this._errorInfo.put("");
        env.notice(message);
    }

    public boolean setErrmode(Env env, int value) {
        switch (value) {
            case 0: 
            case 1: 
            case 2: {
                this._errmode = value;
                return true;
            }
        }
        this.warning(env, L.l("invalid error mode"));
        return false;
    }

    public void warning(Env env, String message) {
        this._isError = true;
        this._errorCode = ERR_GENERAL;
        this._errorInfo = new ArrayValueImpl();
        this._errorInfo.put(this._errorCode);
        if (this._errmode == 2) {
            throw new PDOException(env, this._errorCode, message);
        }
        env.warning("SQLSTATE[" + this._errorCode + "]: " + message);
    }

    public void unsupportedAttribute(Env env, int attribute) {
        this.error(env, "IM001", 0, L.l("attribute `{0}' is not supported", attribute));
    }

    public void unsupportedAttributeValue(Env env, Object value) {
        this.error(env, "IM001", 0, L.l("attribute value `{0}' is not supported", value));
    }
}

