/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.db;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.db.JdbcResultResource;
import com.caucho.quercus.lib.db.Postgres;
import com.caucho.util.L10N;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.logging.Logger;

public class PostgresResult
extends JdbcResultResource {
    private static final Logger log = Logger.getLogger(PostgresResult.class.getName());
    private static final L10N L = new L10N(PostgresResult.class);
    private boolean _passedNullRow = false;
    private Postgres _conn;
    private Statement _stmt;

    public PostgresResult(Postgres conn, Statement stmt, ResultSet rs) {
        super(rs);
        this._conn = conn;
        this._stmt = stmt;
    }

    public PostgresResult(Postgres conn, ResultSetMetaData metaData) {
        super(metaData);
        this._conn = conn;
    }

    public void setPassedNullRow() {
        this._passedNullRow = true;
    }

    public boolean getPassedNullRow() {
        return this._passedNullRow;
    }

    protected Value getColumnTime(Env env, ResultSet rs, int column) throws SQLException {
        Time time = rs.getTime(column);
        if (time == null) {
            return NullValue.NULL;
        }
        return env.createString(rs.getString(column));
    }

    protected Value getColumnDate(Env env, ResultSet rs, int column) throws SQLException {
        Date date = rs.getDate(column);
        if (date == null) {
            return NullValue.NULL;
        }
        return env.createString(rs.getString(column));
    }

    protected Value getColumnTimestamp(Env env, ResultSet rs, int column) throws SQLException {
        Timestamp timestamp = rs.getTimestamp(column);
        if (timestamp == null) {
            return NullValue.NULL;
        }
        return env.createString(rs.getString(column));
    }

    protected Postgres getConnection() {
        return this._conn;
    }

    protected Statement getJavaStatement(Env env) {
        return env.getQuercus().getStatement(this._stmt);
    }
}

