/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.file;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.annotation.NotNull;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.ReturnNullAsFalse;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.DefaultValue;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.EnvCleanup;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnsetValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.file.BinaryInput;
import com.caucho.quercus.lib.file.BinaryOutput;
import com.caucho.quercus.lib.file.BinaryStream;
import com.caucho.quercus.lib.file.Directory;
import com.caucho.quercus.lib.file.FileInputOutput;
import com.caucho.quercus.lib.file.FileOutput;
import com.caucho.quercus.lib.file.IniParser;
import com.caucho.quercus.lib.file.PopenInput;
import com.caucho.quercus.lib.file.PopenOutput;
import com.caucho.quercus.lib.file.ProtocolWrapper;
import com.caucho.quercus.lib.file.ReadStreamInput;
import com.caucho.quercus.lib.file.StreamModule;
import com.caucho.quercus.lib.file.WriteStreamOutput;
import com.caucho.quercus.lib.string.StringModule;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.quercus.module.IniDefinition;
import com.caucho.quercus.module.IniDefinitions;
import com.caucho.util.L10N;
import com.caucho.vfs.LockableStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileModule
extends AbstractQuercusModule {
    private static final L10N L = new L10N(FileModule.class);
    private static final Logger log = Logger.getLogger(FileModule.class.getName());
    public static final String DIRECTORY_SEPARATOR = String.valueOf(Path.getFileSeparatorChar());
    public static final String PATH_SEPARATOR = String.valueOf(Path.getPathSeparatorChar());
    public static final int UPLOAD_ERR_OK = 0;
    public static final int UPLOAD_ERR_INI_SIZE = 1;
    public static final int UPLOAD_ERR_FORM_SIZE = 2;
    public static final int UPLOAD_ERR_PARTIAL = 3;
    public static final int UPLOAD_ERR_NO_FILE = 4;
    public static final int UPLOAD_ERR_NO_TMP_DIR = 6;
    public static final int UPLOAD_ERR_CANT_WRITE = 7;
    public static final int UPLOAD_ERR_EXTENSION = 8;
    public static final int FILE_USE_INCLUDE_PATH = 1;
    public static final int FILE_IGNORE_NEW_LINES = 2;
    public static final int FILE_SKIP_EMPTY_LINES = 4;
    public static final int FILE_APPEND = 8;
    public static final int LOCK_SH = 1;
    public static final int LOCK_EX = 2;
    public static final int LOCK_UN = 3;
    public static final int LOCK_NB = 4;
    public static final int FNM_PATHNAME = 1;
    public static final int FNM_NOESCAPE = 2;
    public static final int FNM_PERIOD = 4;
    public static final int FNM_CASEFOLD = 16;
    public static final int GLOB_MARK = 1;
    public static final int GLOB_NOSORT = 2;
    public static final int GLOB_NOCHECK = 4;
    public static final int GLOB_NOESCAPE = 8;
    public static final int GLOB_BRACE = 16;
    public static final int GLOB_ONLYDIR = 32;
    public static final int GLOB_ERR = 64;
    public static final int PATHINFO_DIRNAME = 1;
    public static final int PATHINFO_BASENAME = 2;
    public static final int PATHINFO_EXTENSION = 4;
    public static final int PATHINFO_FILENAME = 8;
    public static final int SEEK_SET = 0;
    public static final int SEEK_CUR = 1;
    public static final int SEEK_END = 2;
    private static final IniDefinitions _iniDefinitions = new IniDefinitions();
    private static final HashMap<StringValue, Value> _constMap = new HashMap();
    static final IniDefinition INI_ALLOW_URL_FOPEN;
    static final IniDefinition INI_USER_AGENT;
    static final IniDefinition INI_DEFAULT_SOCKET_TIMEOUT;
    static final IniDefinition INI_FROM;
    static final IniDefinition INI_AUTO_DETECT_LINE_ENDINGS;
    static final IniDefinition INI_FILE_UPLOADS;
    static final IniDefinition INI_UPLOAD_TMP_DIR;
    static final IniDefinition INI_UPLOAD_MAX_FILESIZE;

    @Override
    public IniDefinitions getIniDefinitions() {
        return _iniDefinitions;
    }

    @Override
    public Map<StringValue, Value> getConstMap() {
        return _constMap;
    }

    public static Value basename(StringValue path, @Optional StringValue suffix) {
        int len = path.length();
        if (len == 0) {
            return path;
        }
        if (path.charAt(len - 1) == '/') {
            --len;
        } else if (path.charAt(len - 1) == '\\') {
            --len;
        }
        int p = path.lastIndexOf('/', len - 1);
        if (p < 0) {
            p = path.lastIndexOf('\\', len - 1);
        }
        StringValue file = p < 0 ? path.substring(0, len) : path.substring(p + 1, len);
        if (suffix != null && file.endsWith(suffix) && !file.equals(suffix)) {
            file = file.substring(0, file.length() - suffix.length());
        }
        return file;
    }

    public static boolean chdir(Env env, Path path) {
        if (path.isDirectory()) {
            env.setPwd(path);
            return true;
        }
        env.warning(L.l("{0} is not a directory", (Object)path.getFullPath()));
        return false;
    }

    public static boolean chroot(Env env, Path path) {
        if (path.isDirectory()) {
            env.setPwd(path.createRoot());
            return true;
        }
        env.warning(L.l("{0} is not a directory", (Object)path.getFullPath()));
        return false;
    }

    public static boolean chgrp(Env env, Path file, Value group) {
        if (!file.canRead()) {
            env.warning(L.l("{0} cannot be read", (Object)file.getFullPath()));
            return false;
        }
        try {
            if (group instanceof LongValue) {
                file.changeGroup(group.toInt());
            } else {
                file.changeGroup(group.toString());
            }
            return true;
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    public static boolean chmod(Env env, Path file, int mode) {
        if (!file.canRead()) {
            env.warning(L.l("{0} cannot be read", (Object)file.getFullPath()));
            return false;
        }
        file.chmod(mode);
        return true;
    }

    public static boolean chown(Env env, Path file, Value user) {
        if (!file.canRead()) {
            env.warning(L.l("{0} cannot be read", (Object)file.getFullPath()));
            return false;
        }
        try {
            if (user instanceof LongValue) {
                file.changeOwner(user.toInt());
            } else {
                file.changeOwner(user.toString());
            }
            return true;
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    public static Value clearstatcache(Env env) {
        return NullValue.NULL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean copy(Env env, StringValue src, StringValue dst) {
        boolean bl;
        TempBuffer tempBuffer;
        BinaryOutput os;
        BinaryInput is;
        block50: {
            block51: {
                boolean bl2;
                block48: {
                    block49: {
                        ProtocolWrapper srcWrapper = FileModule.getProtocolWrapper(env, src);
                        is = null;
                        os = null;
                        tempBuffer = null;
                        try {
                            int len;
                            if (srcWrapper != null) {
                                BinaryStream bis = srcWrapper.fopen(env, src, env.createString("rb"), LongValue.ZERO);
                                if (!(bis instanceof BinaryInput)) {
                                    boolean bl3 = false;
                                    return bl3;
                                }
                                is = (BinaryInput)bis;
                            } else {
                                Path srcPath = env.lookupPwd(src);
                                if (srcPath == null) {
                                    env.warning(L.l("path cannot be read"));
                                    boolean bl4 = false;
                                    return bl4;
                                }
                                if (!srcPath.canRead() || !srcPath.isFile()) {
                                    env.warning(L.l("'{0}' cannot be read", (Object)srcPath.getFullPath()));
                                    boolean bl5 = false;
                                    return bl5;
                                }
                                is = new ReadStreamInput(env, srcPath.openRead());
                            }
                            ProtocolWrapper dstWrapper = FileModule.getProtocolWrapper(env, dst);
                            if (dstWrapper != null) {
                                BinaryStream bos = dstWrapper.fopen(env, dst, env.createString("wb"), LongValue.ZERO);
                                if (!(bos instanceof BinaryOutput)) {
                                    boolean bl6 = false;
                                    return bl6;
                                }
                                os = (BinaryOutput)bos;
                            } else {
                                Path dstPath = env.lookupPwd(dst);
                                if (dstPath.isDirectory() || dstPath.getScheme().equals("error")) {
                                    env.warning(L.l("'{0}' cannot be written to", (Object)dstPath.getFullPath()));
                                    bl2 = false;
                                    if (tempBuffer == null) break block48;
                                    break block49;
                                }
                                os = new WriteStreamOutput(dstPath.openWrite());
                            }
                            tempBuffer = TempBuffer.allocate();
                            byte[] buffer = tempBuffer.getBuffer();
                            while ((len = is.read(buffer, 0, buffer.length)) >= 0) {
                                os.write(buffer, 0, len);
                            }
                            bl = true;
                            if (tempBuffer == null) break block50;
                            break block51;
                        }
                        catch (IOException e) {
                            log.log(Level.FINE, e.toString(), e);
                            boolean bl7 = false;
                            return bl7;
                        }
                        catch (SecurityException e) {
                            log.log(Level.FINE, e.toString(), e);
                            boolean bl8 = false;
                            return bl8;
                        }
                    }
                    TempBuffer.free(tempBuffer);
                }
                try {
                    if (is == null) return bl2;
                    is.close();
                    return bl2;
                }
                finally {
                    if (os != null) {
                        os.close();
                    }
                }
            }
            TempBuffer.free(tempBuffer);
        }
        try {
            if (is == null) return bl;
            is.close();
            return bl;
        }
        finally {
            if (tempBuffer != null) {
                TempBuffer.free(tempBuffer);
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            finally {
                if (os != null) {
                    os.close();
                }
            }
        }
    }

    public static Value dir(Env env, StringValue filename) {
        ProtocolWrapper wrapper = FileModule.getProtocolWrapper(env, filename);
        if (wrapper != null) {
            return wrapper.opendir(env, filename, LongValue.ZERO);
        }
        Path path = env.lookupPwd(filename);
        if (path == null) {
            return BooleanValue.FALSE;
        }
        try {
            if (!path.isDirectory()) {
                env.warning(L.l("{0} is not a directory", (Object)path.getFullPath()));
                return BooleanValue.FALSE;
            }
            Directory dir = new Directory(env, path);
            return env.wrapJava(dir);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
        catch (SecurityException e) {
            throw new QuercusModuleException(e);
        }
    }

    public StringValue dirname(Env env, StringValue path) {
        int len = path.length();
        if (len == 0) {
            return env.getEmptyString();
        }
        if (len == 1 && path.charAt(0) == '/') {
            return path;
        }
        int p = path.lastIndexOf('/', len - 2);
        if ((p = Math.max(p, path.lastIndexOf('\\', len - 2))) == 0) {
            return env.createString("/");
        }
        if (p > 0) {
            return path.substring(0, p);
        }
        p = path.lastIndexOf('\\', len - 2);
        if (p == 0) {
            return env.createString("\\");
        }
        if (p > 0) {
            return path.substring(0, p);
        }
        return env.createString(".");
    }

    public static Value disk_free_space(Env env, Path directory) {
        if (!directory.canRead()) {
            env.warning(L.l("{0} cannot be read", (Object)directory.getFullPath()));
            return BooleanValue.FALSE;
        }
        return new DoubleValue(directory.getDiskSpaceFree());
    }

    public static Value disk_total_space(Env env, Path directory) {
        if (!directory.canRead()) {
            env.warning(L.l("{0} cannot be read", (Object)directory.getFullPath()));
            return BooleanValue.FALSE;
        }
        return new DoubleValue(directory.getDiskSpaceTotal());
    }

    public static Value diskfreespace(Env env, Path directory) {
        return FileModule.disk_free_space(env, directory);
    }

    public static boolean fclose(Env env, @NotNull BinaryStream s) {
        if (s == null) {
            return false;
        }
        s.close();
        return true;
    }

    public static boolean feof(Env env, @NotNull BinaryStream binaryStream) {
        if (binaryStream == null) {
            return false;
        }
        return binaryStream.isEOF();
    }

    public static boolean fflush(Env env, @NotNull BinaryOutput os) {
        if (os == null) {
            return false;
        }
        try {
            os.flush();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static Value fgetc(Env env, @NotNull BinaryInput is) {
        if (is == null) {
            return BooleanValue.FALSE;
        }
        try {
            int ch = is.read();
            if (ch >= 0) {
                StringValue v = env.createBinaryBuilder(1);
                v.append((char)ch);
                return v;
            }
            return BooleanValue.FALSE;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public Value fgetcsv(Env env, @NotNull BinaryInput is, @Optional int length, @Optional String delimiter, @Optional String enclosure) {
        try {
            if (is == null) {
                return BooleanValue.FALSE;
            }
            if (length <= 0) {
                length = Integer.MAX_VALUE;
            }
            int comma = 44;
            if (delimiter != null && delimiter.length() > 0) {
                comma = delimiter.charAt(0);
            }
            int quote = 34;
            if (enclosure != null && enclosure.length() > 0) {
                quote = enclosure.charAt(0);
            }
            ArrayValueImpl array = new ArrayValueImpl();
            while (true) {
                int ch;
                if ((ch = is.read()) < 0) {
                    if (((ArrayValue)array).getSize() == 0) {
                        return BooleanValue.FALSE;
                    }
                    return array;
                }
                if (ch == 10) {
                    return array;
                }
                if (ch == 13) {
                    is.readOptionalLinefeed();
                    return array;
                }
                if (ch == 32 || ch == 9) continue;
                StringValue sb = env.createBinaryBuilder();
                if (ch == quote) {
                    ch = is.read();
                    while (ch >= 0) {
                        if (ch == quote) {
                            ch = is.read();
                            if (ch != quote) break;
                            sb.append((char)ch);
                        } else {
                            sb.append((char)ch);
                        }
                        ch = is.read();
                    }
                    array.append(sb);
                    while (ch >= 0 && ch == 32 || ch == 9) {
                        ch = is.read();
                    }
                } else {
                    while (ch >= 0 && ch != comma && ch != 13 && ch != 10) {
                        sb.append((char)ch);
                        ch = is.read();
                    }
                    array.append(sb);
                }
                if (ch < 0) {
                    if (((ArrayValue)array).getSize() == 0) {
                        return BooleanValue.FALSE;
                    }
                    return array;
                }
                if (ch == 10) {
                    return array;
                }
                if (ch == 13) {
                    is.readOptionalLinefeed();
                    return array;
                }
                if (ch == comma) continue;
                env.warning("expected comma");
            }
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public static Value fgets(Env env, @NotNull BinaryInput is, @Optional(value="0x7fffffff") int length) {
        try {
            if (is == null) {
                return BooleanValue.FALSE;
            }
            StringValue value = is.readLine(length);
            if (value != null) {
                return value;
            }
            return BooleanValue.FALSE;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public static Value fgetss(Env env, BinaryInput is, @Optional(value="0x7fffffff") int length, @Optional Value allowedTags) {
        try {
            if (is == null) {
                env.warning(L.l("{0} is null", (Object)"handle"));
                return BooleanValue.FALSE;
            }
            StringValue value = is.readLine(length);
            if (value != null) {
                return StringModule.strip_tags(env, value, allowedTags);
            }
            return BooleanValue.FALSE;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Value file(Env env, StringValue filename, @Optional int flags, @Optional Value context) {
        if (filename.length() == 0) {
            return BooleanValue.FALSE;
        }
        boolean useIncludePath = (flags & 1) != 0;
        boolean ignoreNewLines = (flags & 2) != 0;
        boolean skipEmptyLines = (flags & 4) != 0;
        BinaryStream stream = FileModule.fopen(env, filename, "r", useIncludePath, context);
        if (stream == null) {
            return BooleanValue.FALSE;
        }
        BinaryInput is = (BinaryInput)stream;
        ArrayValueImpl array = new ArrayValueImpl();
        try {
            StringValue bb = env.createBinaryBuilder();
            int ch = is.read();
            while (ch >= 0) {
                if (ch == 10) {
                    if (!ignoreNewLines) {
                        bb.appendByte(ch);
                    }
                    if (bb.length() > 0 || !skipEmptyLines) {
                        array.append(bb);
                        bb = env.createBinaryBuilder();
                    }
                } else if (ch == 13) {
                    int ch2;
                    if (!ignoreNewLines) {
                        bb.appendByte(13);
                    }
                    if ((ch2 = is.read()) == 10) {
                        if (!ignoreNewLines) {
                            bb.appendByte(10);
                        }
                    } else {
                        is.unread();
                    }
                    if (bb.length() > 0 || !skipEmptyLines) {
                        array.append(bb);
                        bb = env.createBinaryBuilder();
                    }
                } else {
                    bb.appendByte(ch);
                }
                ch = is.read();
            }
            if (bb.length() > 0) {
                array.append(bb);
            }
            ArrayValueImpl arrayValueImpl = array;
            is.close();
            return arrayValueImpl;
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new QuercusModuleException(e);
            }
        }
    }

    public static Value fileatime(Env env, StringValue filename) {
        ProtocolWrapper wrapper = FileModule.getProtocolWrapper(env, filename);
        if (wrapper != null) {
            Value array = wrapper.url_stat(env, filename, LongValue.ZERO);
            if (!array.isArray()) {
                return BooleanValue.FALSE;
            }
            return array.get(env.createString("atime"));
        }
        Path path = env.lookupPwd(filename);
        if (path == null) {
            return BooleanValue.FALSE;
        }
        if (!path.canRead()) {
            env.warning(L.l("{0} cannot be read", (Object)path.getFullPath()));
            return BooleanValue.FALSE;
        }
        long time = path.getLastAccessTime();
        if (time <= 86400000L) {
            return BooleanValue.FALSE;
        }
        return new LongValue(time / 1000L);
    }

    public static Value filectime(Env env, StringValue filename) {
        ProtocolWrapper wrapper = FileModule.getProtocolWrapper(env, filename);
        if (wrapper != null) {
            Value array = wrapper.url_stat(env, filename, LongValue.ZERO);
            if (!array.isArray()) {
                return BooleanValue.FALSE;
            }
            return array.get(env.createString("ctime"));
        }
        Path path = env.lookupPwd(filename);
        if (path == null) {
            return BooleanValue.FALSE;
        }
        if (!path.canRead()) {
            env.warning(L.l("{0} cannot be read", (Object)path.getFullPath()));
            return BooleanValue.FALSE;
        }
        long time = path.getCreateTime();
        if (time <= 86400000L) {
            return BooleanValue.FALSE;
        }
        return new LongValue(time / 1000L);
    }

    public static Value filegroup(Env env, Path path) {
        if (!path.canRead()) {
            env.warning(L.l("{0} cannot be read", (Object)path.getFullPath()));
            return BooleanValue.FALSE;
        }
        return LongValue.create(path.getGroup());
    }

    public static Value fileinode(Env env, Path path) {
        if (!path.canRead()) {
            env.warning(L.l("{0} cannot be read", (Object)path.getFullPath()));
            return BooleanValue.FALSE;
        }
        return new LongValue(path.getInode());
    }

    public static Value filemtime(Env env, StringValue filename) {
        ProtocolWrapper wrapper = FileModule.getProtocolWrapper(env, filename);
        if (wrapper != null) {
            Value array = wrapper.url_stat(env, filename, LongValue.ZERO);
            if (!array.isArray()) {
                return BooleanValue.FALSE;
            }
            return array.get(env.createString("mtime"));
        }
        Path path = env.lookupPwd(filename);
        if (path == null) {
            return BooleanValue.FALSE;
        }
        long time = path.getLastModified();
        if (86400000L < time) {
            return new LongValue(time / 1000L);
        }
        if (!path.canRead()) {
            env.warning(L.l("{0} cannot be read", (Object)path.getFullPath()));
            return BooleanValue.FALSE;
        }
        return BooleanValue.FALSE;
    }

    public static Value fileowner(Env env, StringValue filename) {
        ProtocolWrapper wrapper = FileModule.getProtocolWrapper(env, filename);
        if (wrapper != null) {
            Value array = wrapper.url_stat(env, filename, LongValue.ZERO);
            if (!array.isArray()) {
                return BooleanValue.FALSE;
            }
            Value owner = array.get(env.createString("uid"));
            if (owner != UnsetValue.UNSET) {
                return owner.toLongValue();
            }
            return BooleanValue.FALSE;
        }
        Path path = env.lookupPwd(filename);
        if (path == null) {
            return BooleanValue.FALSE;
        }
        return LongValue.create(path.getOwner());
    }

    public static Value fileperms(Env env, Path path) {
        if (!path.canRead()) {
            env.warning(L.l("{0} cannot be read", (Object)path.getFullPath()));
            return BooleanValue.FALSE;
        }
        return LongValue.create(path.getMode());
    }

    public static Value filesize(Env env, StringValue filename) {
        ProtocolWrapper wrapper = FileModule.getProtocolWrapper(env, filename);
        if (wrapper != null) {
            Value array = wrapper.url_stat(env, filename, LongValue.ZERO);
            if (!array.isArray()) {
                return BooleanValue.FALSE;
            }
            return array.get(env.createString("size"));
        }
        Path path = env.lookupPwd(filename);
        if (path == null) {
            env.warning(L.l("path cannot be read"));
            return BooleanValue.FALSE;
        }
        if (!path.exists() || !path.isFile()) {
            env.warning(L.l("{0} cannot be read", (Object)path.getFullPath()));
            return BooleanValue.FALSE;
        }
        long length = path.getLength();
        if (length < 0L) {
            return BooleanValue.FALSE;
        }
        return LongValue.create(length);
    }

    public static Value filetype(Env env, @NotNull Path path) {
        if (path == null) {
            return BooleanValue.FALSE;
        }
        if (!path.exists()) {
            env.warning(L.l("{0} cannot be read", (Object)path.getFullPath()));
            return BooleanValue.FALSE;
        }
        if (path.isLink()) {
            return env.createString("link");
        }
        if (path.isDirectory()) {
            return env.createString("dir");
        }
        if (path.isFile()) {
            return env.createString("file");
        }
        if (path.isFIFO()) {
            return env.createString("fifo");
        }
        if (path.isBlockDevice()) {
            return env.createString("block");
        }
        if (path.isCharacterDevice()) {
            return env.createString("char");
        }
        return env.createString("unknown");
    }

    public static boolean file_exists(Env env, StringValue filename) {
        ProtocolWrapper wrapper = FileModule.getProtocolWrapper(env, filename);
        if (wrapper != null) {
            Value array = wrapper.url_stat(env, filename, LongValue.ZERO);
            return array.isArray();
        }
        Path path = env.lookupPwd(filename);
        if (path != null) {
            return path.exists();
        }
        return false;
    }

    @ReturnNullAsFalse
    public static StringValue file_get_contents(Env env, StringValue filename, @Optional boolean useIncludePath, @Optional Value context, @Optional long offset, @Optional(value="4294967296") long maxLen) {
        if (filename.length() == 0) {
            env.warning(L.l("file name must not be null"));
            return null;
        }
        BinaryStream s = FileModule.fopen(env, filename, "rb", useIncludePath, context);
        if (!(s instanceof BinaryInput)) {
            return null;
        }
        BinaryInput is = (BinaryInput)s;
        StringValue bb = env.createLargeBinaryBuilder();
        bb.appendReadAll(is, maxLen);
        s.close();
        return bb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Value file_put_contents(Env env, StringValue filename, Value data, @Optional int flags, @Optional Value context) {
        if (filename.length() == 0) {
            env.warning(L.l("file name must not be null"));
            return BooleanValue.FALSE;
        }
        BinaryStream s = null;
        try {
            LongValue longValue;
            boolean useIncludePath = (flags & 1) != 0;
            String mode = (flags & 8) != 0 ? "a" : "w";
            s = FileModule.fopen(env, filename, mode, useIncludePath, context);
            if (!(s instanceof BinaryOutput)) {
                BooleanValue booleanValue = BooleanValue.FALSE;
                return booleanValue;
            }
            if ((flags & 2) != 0) {
                if (s instanceof LockableStream) {
                    if (!FileModule.flock(env, (LockableStream)((Object)s), 2, null)) {
                        BooleanValue booleanValue = BooleanValue.FALSE;
                        return booleanValue;
                    }
                } else {
                    BooleanValue booleanValue = BooleanValue.FALSE;
                    return booleanValue;
                }
            }
            BinaryOutput os = (BinaryOutput)s;
            try {
                long dataWritten = 0L;
                if (data instanceof ArrayValue) {
                    for (Value item : ((ArrayValue)data).values()) {
                        InputStream is = item.toInputStream();
                        dataWritten += (long)os.write(is, Integer.MAX_VALUE);
                        is.close();
                    }
                } else {
                    InputStream is = data.toInputStream();
                    dataWritten += (long)os.write(is, Integer.MAX_VALUE);
                    is.close();
                }
                longValue = LongValue.create(dataWritten);
            }
            catch (Throwable throwable) {
                try {
                    if (os != null && os instanceof LockableStream && (flags & 2) != 0) {
                        FileModule.flock(env, (LockableStream)((Object)os), 3, null);
                    }
                    os.close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new QuercusModuleException(e);
                }
            }
            if (os != null && os instanceof LockableStream && (flags & 2) != 0) {
                FileModule.flock(env, (LockableStream)((Object)os), 3, null);
            }
            os.close();
            return longValue;
        }
        finally {
            if (s != null && s instanceof LockableStream && (flags & 2) != 0) {
                FileModule.flock(env, (LockableStream)((Object)s), 3, null);
            }
        }
    }

    public static boolean flock(Env env, LockableStream fileV, int operation, @Optional Value wouldBlock) {
        if (fileV == null) {
            env.warning(L.l("flock: file is null"));
            return false;
        }
        boolean shared = false;
        boolean block = true;
        if (operation > 4) {
            block = false;
            operation -= 4;
        }
        switch (operation) {
            case 1: {
                shared = true;
                break;
            }
            case 2: {
                shared = false;
                break;
            }
            case 3: {
                fileV.unlock();
                return true;
            }
            default: {
                return true;
            }
        }
        return fileV.lock(shared, block);
    }

    private static String globToRegex(String pattern, int flags, boolean brace) {
        StringBuilder globRegex = new StringBuilder();
        int bracketCount = 0;
        boolean inSquareBrackets = false;
        boolean inCurlyBrackets = false;
        int lastCh = 32;
        for (int i = 0; i < pattern.length(); ++i) {
            char ch = pattern.charAt(i);
            switch (ch) {
                case '*': {
                    if (inSquareBrackets || inCurlyBrackets) {
                        globRegex.append("*");
                        if (!inSquareBrackets) break;
                        ++bracketCount;
                        break;
                    }
                    if ((flags & 1) != 0) {
                        globRegex.append("[^/]*");
                        break;
                    }
                    globRegex.append(".*");
                    break;
                }
                case '?': {
                    if (inSquareBrackets || inCurlyBrackets) {
                        globRegex.append("*");
                        if (!inSquareBrackets) break;
                        ++bracketCount;
                        break;
                    }
                    if ((flags & 1) != 0) {
                        globRegex.append("[^/]");
                        break;
                    }
                    globRegex.append(".");
                    break;
                }
                case '^': {
                    if (lastCh == 91) {
                        globRegex.append(ch);
                        break;
                    }
                    globRegex.append("\\" + ch);
                    if (!inSquareBrackets) break;
                    ++bracketCount;
                    break;
                }
                case '!': {
                    if (lastCh == 91) {
                        globRegex.append('^');
                        break;
                    }
                    globRegex.append(ch);
                    if (!inSquareBrackets) break;
                    ++bracketCount;
                    break;
                }
                case '/': {
                    if ((inSquareBrackets || inCurlyBrackets) && (flags & 1) != 0) break;
                    globRegex.append(ch);
                    if (!inSquareBrackets) break;
                    ++bracketCount;
                    break;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '|': {
                    globRegex.append('\\');
                    globRegex.append(ch);
                    if (!inSquareBrackets) break;
                    ++bracketCount;
                    break;
                }
                case '\\': {
                    if ((flags & 2) != 0) {
                        globRegex.append('\\');
                    }
                    globRegex.append(ch);
                    if (!inSquareBrackets) break;
                    ++bracketCount;
                    break;
                }
                case '[': {
                    inSquareBrackets = true;
                    globRegex.append(ch);
                    break;
                }
                case ']': {
                    inSquareBrackets = false;
                    if (bracketCount == 0) {
                        return null;
                    }
                    globRegex.append(ch);
                    break;
                }
                case '{': {
                    if (inSquareBrackets || inCurlyBrackets) {
                        globRegex.append(ch);
                        if (!inSquareBrackets) break;
                        ++bracketCount;
                        break;
                    }
                    if (brace) {
                        globRegex.append('(');
                        inCurlyBrackets = true;
                        break;
                    }
                    globRegex.append('\\');
                    globRegex.append(ch);
                    break;
                }
                case '}': {
                    if (inSquareBrackets) {
                        globRegex.append(ch);
                        ++bracketCount;
                        break;
                    }
                    if (brace && inCurlyBrackets) {
                        globRegex.append(')');
                        inCurlyBrackets = false;
                        break;
                    }
                    globRegex.append('\\');
                    globRegex.append(ch);
                    break;
                }
                case ',': {
                    if (brace && inCurlyBrackets) {
                        globRegex.append('|');
                        break;
                    }
                    globRegex.append(ch);
                    break;
                }
                default: {
                    globRegex.append(ch);
                    if (!inSquareBrackets) break;
                    ++bracketCount;
                }
            }
            lastCh = ch;
        }
        return globRegex.toString();
    }

    public static boolean fnmatch(Env env, String pattern, String string, @Optional int flags) {
        String globRegex;
        if (pattern == null || string == null) {
            return false;
        }
        if ((flags & 0x10) != 0) {
            string = string.toLowerCase(Locale.ENGLISH);
            pattern = pattern.toLowerCase(Locale.ENGLISH);
        }
        if ((flags & 4) != 0) {
            if (string.length() > 0 && string.charAt(0) == '.') {
                if (pattern.length() <= 0 || pattern.charAt(0) != '.') {
                    return false;
                }
                string = string.substring(1);
                pattern = pattern.substring(1);
            } else if ((flags & 1) != 0 && string.length() >= 2 && string.charAt(0) == '/' && string.charAt(1) == '.') {
                if (pattern.length() < 2 || pattern.charAt(0) != '/' || pattern.charAt(1) != '.') {
                    return false;
                }
                string = string.substring(2);
                pattern = pattern.substring(2);
            }
        }
        if ((globRegex = FileModule.globToRegex(pattern, flags, false)) == null) {
            return false;
        }
        return string.matches(globRegex.toString());
    }

    private static ProtocolWrapper getProtocolWrapper(Env env, StringValue pathName) {
        int p = pathName.indexOf(":");
        if (p < 0) {
            return null;
        }
        StringValue scheme = pathName.substring(0, p);
        return env.getStreamWrapper(scheme);
    }

    /*
     * Exception decompiling
     */
    @ReturnNullAsFalse
    public static BinaryStream fopen(Env env, StringValue filename, String mode, @Optional boolean useIncludePath, @Optional Value contextV) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean isUrl(Path path) {
        String scheme = path.getScheme();
        if ("".equals(scheme) || "file".equals(scheme) || "memory".equals(scheme)) {
            return false;
        }
        return !"php".equals(scheme) || path.toString().startsWith("php://filter");
    }

    public Value fpassthru(Env env, @NotNull BinaryInput is) {
        try {
            if (is == null) {
                return BooleanValue.FALSE;
            }
            WriteStream out = env.getOut();
            long writeLength = out.writeStream(is.getInputStream());
            return LongValue.create(writeLength);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public Value fputcsv(Env env, @NotNull BinaryOutput os, @NotNull ArrayValue value, @Optional StringValue delimiter, @Optional StringValue enclosure) {
        try {
            if (os == null) {
                return BooleanValue.FALSE;
            }
            if (value == null) {
                return BooleanValue.FALSE;
            }
            char comma = ',';
            char quote = '\"';
            if (delimiter != null && delimiter.length() > 0) {
                comma = delimiter.charAt(0);
            }
            if (enclosure != null && enclosure.length() > 0) {
                quote = enclosure.charAt(0);
            }
            int writeLength = 0;
            boolean isFirst = true;
            for (Value data : value.values()) {
                if (!isFirst) {
                    os.print(comma);
                    ++writeLength;
                }
                isFirst = false;
                StringValue s = data.toStringValue();
                int strlen = s.length();
                ++writeLength;
                os.print(quote);
                for (int i = 0; i < strlen; ++i) {
                    char ch = s.charAt(i);
                    if (ch != quote) {
                        os.print(ch);
                        ++writeLength;
                        continue;
                    }
                    os.print(quote);
                    os.print(quote);
                    writeLength += 2;
                }
                os.print(quote);
                ++writeLength;
            }
            os.print("\n");
            return LongValue.create(++writeLength);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public static Value fputs(Env env, BinaryOutput os, InputStream value, @Optional(value="0x7fffffff") int length) {
        return FileModule.fwrite(env, os, value, length);
    }

    public static Value fread(Env env, @NotNull BinaryInput is, int length) {
        if (is == null) {
            return BooleanValue.FALSE;
        }
        if (length < 0) {
            length = Integer.MAX_VALUE;
        }
        StringValue sb = env.createBinaryBuilder();
        sb.appendRead(is, (long)length);
        return sb;
    }

    public static Value fscanf(Env env, @NotNull BinaryInput is, StringValue format, @Optional Value[] args) {
        try {
            if (is == null) {
                return BooleanValue.FALSE;
            }
            StringValue value = is.readLine(Integer.MAX_VALUE);
            if (value == null) {
                return BooleanValue.FALSE;
            }
            return StringModule.sscanf(env, value, format, args);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public static Value fseek(Env env, @NotNull BinaryStream binaryStream, long offset, @Optional(value="SEEK_SET") int whence) {
        if (binaryStream == null) {
            return LongValue.MINUS_ONE;
        }
        long position = binaryStream.seek(offset, whence);
        if (position < 0L) {
            return LongValue.MINUS_ONE;
        }
        return LongValue.ZERO;
    }

    public static Value fstat(Env env, @NotNull BinaryStream stream) {
        if (stream == null) {
            return BooleanValue.FALSE;
        }
        return stream.stat();
    }

    public static Value ftell(Env env, @NotNull BinaryStream binaryStream) {
        if (binaryStream == null) {
            return BooleanValue.FALSE;
        }
        long pos = binaryStream.getPosition();
        if (pos < 0L) {
            return BooleanValue.FALSE;
        }
        return LongValue.create(pos);
    }

    public static boolean ftruncate(Env env, @NotNull BinaryOutput handle, long size) {
        Path path = null;
        if (handle instanceof FileOutput) {
            path = ((FileOutput)handle).getPath();
        } else if (handle instanceof FileInputOutput) {
            path = ((FileInputOutput)handle).getPath();
        } else {
            return false;
        }
        try {
            return path.truncate(size);
        }
        catch (IOException e) {
            return false;
        }
    }

    public static Value fwrite(Env env, @NotNull BinaryOutput os, InputStream value, @Optional(value="0x7fffffff") int length) {
        try {
            if (os == null) {
                return BooleanValue.FALSE;
            }
            return LongValue.create(os.write(value, length));
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    private static ArrayValue globImpl(Env env, String pattern, int flags, Path path, String prefix, ArrayValue result) {
        String[] list;
        Pattern compiledGlobRegex;
        boolean doBraces;
        String globRegex;
        String cwdPattern;
        String subPattern = null;
        int firstSlash = pattern.indexOf(47);
        if (firstSlash < 0) {
            cwdPattern = pattern;
        } else {
            cwdPattern = pattern.substring(0, firstSlash);
            while (firstSlash < pattern.length() && pattern.charAt(firstSlash) == '/') {
                ++firstSlash;
            }
            subPattern = pattern.substring(firstSlash);
        }
        int fnmatchFlags = 0;
        if ((flags & 8) != 0) {
            fnmatchFlags = 2;
        }
        if ((globRegex = FileModule.globToRegex(cwdPattern, fnmatchFlags, doBraces = (flags & 0x10) != 0)) == null) {
            return null;
        }
        try {
            compiledGlobRegex = Pattern.compile(globRegex);
        }
        catch (PatternSyntaxException e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
        try {
            list = path.list();
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
        for (String entry : list) {
            Matcher matcher = compiledGlobRegex.matcher(entry);
            if (!matcher.matches()) continue;
            StringValue sb = env.createUnicodeBuilder();
            if (prefix.length() > 0) {
                sb.append(prefix);
                if (!prefix.equals("/")) {
                    sb.append("/");
                }
            }
            sb.append(entry);
            Path entryPath = path.lookup(entry);
            if (entryPath != null && entryPath.isDirectory()) {
                if (firstSlash >= 0 && subPattern.length() > 0) {
                    boolean isNull;
                    boolean bl = isNull = null == FileModule.globImpl(env, subPattern, flags, entryPath, sb.toString(), result);
                    if ((flags & 0x40) != 0 && isNull) {
                        return null;
                    }
                } else if ((flags & 1) != 0) {
                    sb.append("/");
                }
            }
            if (firstSlash >= 0 && subPattern.length() != 0 || (flags & 0x20) != 0 && ((flags & 0x20) == 0 || entryPath == null || !entryPath.isDirectory())) continue;
            result.put(sb);
        }
        return result;
    }

    public static Value glob(Env env, String pattern, @Optional int flags) {
        int i;
        int braceIndex;
        Path path = env.getPwd();
        int patternLength = pattern.length();
        String prefix = "";
        if ((flags & 0x10) != 0 && (braceIndex = pattern.indexOf(123)) >= 0) {
            if ((flags & 8) != 0) {
                return FileModule.globBrace(env, pattern, flags, braceIndex);
            }
            boolean isEscaped = false;
            for (i = 0; i < patternLength; ++i) {
                char ch = pattern.charAt(i);
                if (ch == '\\') {
                    isEscaped = !isEscaped;
                    continue;
                }
                if (ch == '{') {
                    if (!isEscaped) break;
                    isEscaped = false;
                    continue;
                }
                isEscaped = false;
            }
            if (i < patternLength) {
                return FileModule.globBrace(env, pattern, flags, i);
            }
        }
        if (patternLength > 0 && pattern.charAt(0) == '/') {
            prefix = "/";
            for (i = 0; i < patternLength && pattern.charAt(i) == '/'; ++i) {
            }
            path = path.lookup("/");
            pattern = pattern.substring(i);
        } else if (Path.isWindows() && patternLength > 2 && pattern.charAt(1) == ':') {
            prefix = pattern.substring(0, 2);
            String driveLetter = pattern.substring(0, 2);
            path = path.lookup(driveLetter + '/');
            pattern = pattern.substring(3);
        }
        ArrayValue result = new ArrayValueImpl();
        result = FileModule.globImpl(env, pattern, flags, path, prefix, result);
        if (result == null) {
            return BooleanValue.FALSE;
        }
        if (result.getSize() == 0 && (flags & 4) != 0) {
            result.put(pattern);
        }
        if ((flags & 2) == 0) {
            result.sort(ArrayValue.ValueComparator.CMP, true, true);
        }
        return result;
    }

    private static Value globBrace(Env env, String pattern, int flags, int braceIndex) {
        int patternLength = pattern.length();
        boolean isEscaped = false;
        String prefix = pattern.substring(0, braceIndex);
        ArrayList<StringBuilder> basePathList = new ArrayList<StringBuilder>();
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        isEscaped = false;
        int i = braceIndex + 1;
        while (i < patternLength) {
            char ch;
            if ((ch = pattern.charAt(i++)) == ',') {
                if (isEscaped) {
                    isEscaped = false;
                    sb.append(',');
                    continue;
                }
                basePathList.add(sb);
                sb = new StringBuilder();
                sb.append(prefix);
                continue;
            }
            if (ch == '}') {
                if (isEscaped) {
                    isEscaped = false;
                    sb.append('}');
                    continue;
                }
                basePathList.add(sb);
                break;
            }
            if (ch == '\\') {
                if ((flags & 8) != 0) {
                    sb.append('\\');
                    continue;
                }
                if (isEscaped) {
                    isEscaped = false;
                    sb.append('\\');
                    sb.append('\\');
                    continue;
                }
                isEscaped = true;
                continue;
            }
            if (isEscaped) {
                isEscaped = false;
                sb.append('\\');
            }
            sb.append(ch);
        }
        String suffix = "";
        if (i < patternLength) {
            suffix = pattern.substring(i);
        }
        Value result = null;
        for (StringBuilder path : basePathList) {
            path.append(suffix);
            Value subresult = FileModule.glob(env, path.toString(), flags);
            if (!subresult.isArray() || subresult.getSize() <= 0) continue;
            if (prefix.length() == 0 && suffix.length() == 0) {
                return subresult;
            }
            if (result == null) {
                result = subresult;
                continue;
            }
            Iterator<Value> iter = subresult.getValueIterator(env);
            while (iter.hasNext()) {
                result.put(iter.next());
            }
        }
        if (result == null) {
            result = new ArrayValueImpl();
        }
        return result;
    }

    public static String getcwd(Env env) {
        return env.getPwd().getPath();
    }

    public static boolean is_dir(Env env, StringValue filename) {
        ProtocolWrapper wrapper = FileModule.getProtocolWrapper(env, filename);
        if (wrapper != null) {
            LongValue flags = LongValue.create(2L);
            Value array = wrapper.url_stat(env, filename, flags);
            int mode = array.get(env.createString("mode")).toInt();
            return (mode & 0x200) != 0;
        }
        Path path = env.lookupPwd(filename);
        if (path == null) {
            return false;
        }
        return path.isDirectory();
    }

    public static boolean is_executable(Env env, @NotNull Path path) {
        if (path == null || !path.exists()) {
            return false;
        }
        if (Path.isWindows()) {
            String tail = path.getTail();
            return tail.endsWith(".exe") || tail.endsWith(".com") || tail.endsWith(".bat") || tail.endsWith(".cmd");
        }
        return path.isExecutable();
    }

    public static boolean is_file(@NotNull Path path) {
        if (path == null) {
            return false;
        }
        return path.isFile();
    }

    public static boolean is_link(Env env, @NotNull Path path) {
        if (path == null) {
            return false;
        }
        return path.isLink();
    }

    public static boolean is_readable(Path path) {
        if (path == null) {
            return false;
        }
        return path.canRead();
    }

    public static boolean is_uploaded_file(Env env, @NotNull Path path) {
        if (path == null) {
            return false;
        }
        String tail = path.getTail();
        return env.getUploadDirectory().lookup(tail).canRead();
    }

    public static boolean is_writable(Env env, StringValue filename) {
        ProtocolWrapper wrapper = FileModule.getProtocolWrapper(env, filename);
        if (wrapper != null) {
            LongValue flags = LongValue.create(2L);
            Value array = wrapper.url_stat(env, filename, flags);
            return array.isArray();
        }
        Path path = env.lookupPwd(filename);
        if (path == null) {
            return false;
        }
        return path.canWrite();
    }

    public static boolean is_writeable(Env env, StringValue filename) {
        return FileModule.is_writable(env, filename);
    }

    public boolean link(Env env, Path source, Path destination) {
        try {
            return destination.createLink(source, true);
        }
        catch (Exception e) {
            env.warning(e);
            return false;
        }
    }

    public static long linkinfo(Env env, Path path) {
        if (path.isLink()) {
            return path.getDevice();
        }
        return 0L;
    }

    public static Value lstat(Env env, StringValue filename) {
        ProtocolWrapper wrapper = FileModule.getProtocolWrapper(env, filename);
        if (wrapper != null) {
            LongValue flags = LongValue.create(1L);
            return wrapper.url_stat(env, filename, flags);
        }
        Path path = env.lookupPwd(filename);
        path.isLink();
        return FileModule.statImpl(env, path);
    }

    public static boolean mkdir(Env env, StringValue dirname, @Optional(value="") int mode, @Optional boolean recursive, @Optional Value context) {
        ProtocolWrapper wrapper = FileModule.getProtocolWrapper(env, dirname);
        if (wrapper != null) {
            return wrapper.mkdir(env, dirname, LongValue.create(mode), LongValue.ZERO);
        }
        Path path = env.lookupPwd(dirname);
        if (path == null) {
            return false;
        }
        try {
            if (recursive) {
                return path.mkdirs();
            }
            return path.mkdir();
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
        catch (SecurityException e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    public static boolean move_uploaded_file(Env env, @NotNull Path src, StringValue dst) {
        if (src == null) {
            return false;
        }
        if (dst.length() == 0) {
            return false;
        }
        String tail = src.getTail();
        src = env.getUploadDirectory().lookup(tail);
        if (!src.canRead()) {
            return false;
        }
        ProtocolWrapper wrapper = FileModule.getProtocolWrapper(env, dst);
        try {
            if (wrapper != null) {
                StringValue path = env.createString(src.getNativePath());
                boolean result = FileModule.copy(env, path, dst);
                if (!result) {
                    return false;
                }
                return src.remove();
            }
            Path path = env.lookupPwd(dst);
            return src.renameTo(path);
        }
        catch (IOException e) {
            env.warning(e);
            return false;
        }
    }

    public static Value opendir(Env env, StringValue pathName, @Optional Value context) {
        ProtocolWrapper wrapper = FileModule.getProtocolWrapper(env, pathName);
        if (wrapper != null) {
            return wrapper.opendir(env, pathName, LongValue.ZERO);
        }
        try {
            Path path = env.lookupPwd(pathName);
            if (path.isDirectory()) {
                Directory dir = new Directory(env, path);
                return env.wrapJava(dir);
            }
            env.warning(L.l("{0} is not a directory", (Object)path.getFullPath()));
            return BooleanValue.FALSE;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Value parse_ini_file(Env env, Path path, @Optional boolean processSections) {
        ReadStream is = null;
        try {
            is = path.openRead();
            is.setEncoding(env.getScriptEncoding());
            ArrayValue arrayValue = FileModule.parseIni(env, is, processSections);
            return arrayValue;
        }
        catch (IOException e) {
            env.warning(e);
            BooleanValue booleanValue = BooleanValue.FALSE;
            return booleanValue;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    private static ArrayValue parseIni(Env env, ReadStream is, boolean isProcessSections) throws IOException {
        return IniParser.parse(env, is, isProcessSections);
    }

    public static Value pathinfo(Env env, String path, @Optional Value optionsV) {
        String dirname;
        if (optionsV == null) {
            return env.getEmptyString();
        }
        if (path == null) {
            if (!optionsV.isDefault()) {
                return env.getEmptyString();
            }
            ArrayValueImpl value = new ArrayValueImpl();
            value.put(env.createString("basename"), env.createString(""));
            value.put(env.createString("filename"), env.createString(""));
            return value;
        }
        int p = path.lastIndexOf(47);
        if (p >= 0) {
            dirname = path.substring(0, p);
            path = path.substring(p + 1);
        } else {
            dirname = ".";
        }
        p = path.lastIndexOf(46);
        String filename = path;
        String ext = "";
        if (p > 0) {
            filename = path.substring(0, p);
            ext = path.substring(p + 1);
        }
        if (!(optionsV instanceof DefaultValue)) {
            int options = optionsV.toInt();
            if ((options & 1) == 1) {
                return env.createString(dirname);
            }
            if ((options & 2) == 2) {
                return env.createString(path);
            }
            if ((options & 4) == 4) {
                return env.createString(ext);
            }
            if ((options & 8) == 8) {
                return env.createString(filename);
            }
            return env.getEmptyString();
        }
        ArrayValueImpl value = new ArrayValueImpl();
        value.put(env.createString("dirname"), env.createString(dirname));
        value.put(env.createString("basename"), env.createString(path));
        value.put(env.createString("extension"), env.createString(ext));
        value.put(env.createString("filename"), env.createString(filename));
        return value;
    }

    public static int pclose(Env env, @NotNull BinaryStream stream) {
        if (stream instanceof PopenInput) {
            return ((PopenInput)stream).pclose();
        }
        if (stream instanceof PopenOutput) {
            return ((PopenOutput)stream).pclose();
        }
        env.warning(L.l("{0} was not returned by popen()", (Object)stream));
        return -1;
    }

    @ReturnNullAsFalse
    public static BinaryStream popen(Env env, @NotNull String command, @NotNull StringValue mode) {
        boolean doRead = false;
        if (mode.toString().equalsIgnoreCase("r")) {
            doRead = true;
        } else if (mode.toString().equalsIgnoreCase("w")) {
            doRead = false;
        } else {
            return null;
        }
        String[] args = new String[3];
        try {
            if (Path.isWindows()) {
                args[0] = "cmd";
                args[1] = "/c";
            } else {
                args[0] = "sh";
                args[1] = "-c";
            }
            args[2] = command;
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.command(args);
            builder.redirectErrorStream(true);
            Process process = builder.start();
            if (doRead) {
                return new PopenInput(env, process);
            }
            return new PopenOutput(env, process);
        }
        catch (Exception e) {
            env.warning(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Value readdir(Env env, @NotNull Directory dir) {
        if (dir == null) {
            return BooleanValue.FALSE;
        }
        return dir.read(env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value readfile(Env env, StringValue filename, @Optional boolean useIncludePath, @Optional Value context) {
        if (filename.length() == 0) {
            return BooleanValue.FALSE;
        }
        BinaryStream s = FileModule.fopen(env, filename, "r", useIncludePath, context);
        if (!(s instanceof BinaryInput)) {
            return BooleanValue.FALSE;
        }
        BinaryInput is = (BinaryInput)s;
        try {
            Value value = this.fpassthru(env, is);
            return value;
        }
        finally {
            is.close();
        }
    }

    public static Value readlink(Env env, Path path) {
        String link = path.readLink();
        if (link == null) {
            return BooleanValue.FALSE;
        }
        return env.createString(link);
    }

    public static Value realpath(Env env, Path path) {
        if (path == null) {
            return BooleanValue.FALSE;
        }
        String pathStr = path.getNativePath();
        if (pathStr == null) {
            pathStr = path.getFullPath();
        }
        StringValue sb = env.createStringBuilder();
        if (pathStr.endsWith("/")) {
            return sb.append(pathStr, 0, pathStr.length() - 1);
        }
        return sb.append(pathStr, 0, pathStr.length());
    }

    public static boolean rename(Env env, StringValue from, StringValue to) {
        ProtocolWrapper wrapper = FileModule.getProtocolWrapper(env, from);
        if (wrapper != null) {
            return wrapper.rename(env, from, to);
        }
        Path fromPath = env.lookupPwd(from);
        Path toPath = env.lookupPwd(to);
        if (!fromPath.canRead()) {
            env.warning(L.l("{0} cannot be read", (Object)fromPath.getFullPath()));
            return false;
        }
        try {
            return fromPath.renameTo(toPath);
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    public static Value rewind(Env env, @NotNull BinaryStream binaryStream) {
        if (binaryStream == null) {
            return BooleanValue.FALSE;
        }
        FileModule.fseek(env, binaryStream, 0L, 0);
        return BooleanValue.TRUE;
    }

    public static void rewinddir(Env env, @NotNull Directory dir) {
        if (dir == null) {
            return;
        }
        dir.rewind(env);
    }

    public static boolean rmdir(Env env, StringValue filename, @Optional Value context) {
        ProtocolWrapper wrapper = FileModule.getProtocolWrapper(env, filename);
        if (wrapper != null) {
            return wrapper.rmdir(env, filename, LongValue.ZERO);
        }
        try {
            Path path = env.lookupPwd(filename);
            if (!path.isDirectory()) {
                env.warning(L.l("{0} is not a directory", (Object)path.getFullPath()));
                return false;
            }
            return path.remove();
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    public static Value closedir(Env env, @NotNull Directory dir) {
        if (dir != null) {
            dir.close(env);
        }
        return NullValue.NULL;
    }

    public static Value scandir(Env env, StringValue fileName, @Optional(value="1") int order, @Optional Value context) {
        if (fileName.length() == 0) {
            env.warning(L.l("file name must not be NULL"));
            return BooleanValue.FALSE;
        }
        try {
            Path path = env.lookupPwd(fileName);
            if (path == null || !path.isDirectory()) {
                env.warning(L.l("'{0}' is not a directory", (Object)fileName));
                return BooleanValue.FALSE;
            }
            Object[] values = path.list();
            Arrays.sort(values);
            ArrayValueImpl result = new ArrayValueImpl();
            if (order == 1) {
                for (int i = 0; i < values.length; ++i) {
                    ((ArrayValue)result).append(LongValue.create(i), env.createString((String)values[i]));
                }
            } else {
                for (int i = values.length - 1; i >= 0; --i) {
                    ((ArrayValue)result).append(LongValue.create(values.length - i - 1), env.createString((String)values[i]));
                }
            }
            return result;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public static int set_file_buffer(Env env, BinaryOutput stream, int bufferSize) {
        return StreamModule.stream_set_write_buffer(env, stream, bufferSize);
    }

    public static Value stat(Env env, StringValue filename) {
        ProtocolWrapper wrapper = FileModule.getProtocolWrapper(env, filename);
        if (wrapper != null) {
            return wrapper.url_stat(env, filename, LongValue.ZERO);
        }
        Path path = env.getPwd().lookup(filename.toString());
        return FileModule.statImpl(env, path);
    }

    static Value statImpl(Env env, Path path) {
        if (!path.exists()) {
            env.warning(L.l("stat failed for {0}", (Object)path.getFullPath().toString()));
            return BooleanValue.FALSE;
        }
        ArrayValueImpl result = new ArrayValueImpl();
        result.put(path.getDevice());
        result.put(path.getInode());
        result.put(path.getMode());
        result.put(path.getNumberOfLinks());
        result.put(path.getUser());
        result.put(path.getGroup());
        result.put(path.getDeviceId());
        result.put(path.getLength());
        result.put(path.getLastAccessTime() / 1000L);
        result.put(path.getLastModified() / 1000L);
        result.put(path.getLastStatusChangeTime() / 1000L);
        result.put(path.getBlockSize());
        result.put(path.getBlockCount());
        result.put(env, "dev", path.getDevice());
        result.put(env, "ino", path.getInode());
        result.put(env, "mode", path.getMode());
        result.put(env, "nlink", path.getNumberOfLinks());
        result.put(env, "uid", path.getUser());
        result.put(env, "gid", path.getGroup());
        result.put(env, "rdev", path.getDeviceId());
        result.put(env, "size", path.getLength());
        result.put(env, "atime", path.getLastAccessTime() / 1000L);
        result.put(env, "mtime", path.getLastModified() / 1000L);
        result.put(env, "ctime", path.getLastStatusChangeTime() / 1000L);
        result.put(env, "blksize", path.getBlockSize());
        result.put(env, "blocks", path.getBlockCount());
        return result;
    }

    public boolean symlink(Env env, Path source, Path destination) {
        try {
            return destination.createLink(source, false);
        }
        catch (Exception e) {
            env.warning(e);
            return false;
        }
    }

    @ReturnNullAsFalse
    public static String tempnam(Env env, Path dir, String prefix) {
        if (dir == null || !dir.isDirectory()) {
            dir = env.getTempDirectory();
        }
        try {
            dir.mkdirs();
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
        try {
            Path path = dir.createTempFile(prefix, ".tmp");
            env.addCleanup(new RemoveFile(path));
            return path.getNativePath();
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }

    @ReturnNullAsFalse
    public static FileInputOutput tmpfile(Env env) {
        try {
            Path tmp = env.getTempDirectory();
            tmp.mkdirs();
            Path file = tmp.createTempFile("resin", "tmp");
            env.addCleanup(new RemoveFile(file));
            return new FileInputOutput(env, file, false, false, true);
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }

    public static boolean touch(Env env, StringValue filename, @Optional int time, @Optional int atime) {
        ProtocolWrapper wrapper = FileModule.getProtocolWrapper(env, filename);
        if (wrapper != null) {
            LongValue option = LongValue.create(1L);
            ArrayValueImpl array = new ArrayValueImpl();
            ((ArrayValue)array).put(LongValue.create(time));
            ((ArrayValue)array).put(LongValue.create(atime));
            return wrapper.stream_metadata(env, filename, option, array);
        }
        Path path = env.lookupPwd(filename);
        try {
            if (path.exists()) {
                if (time > 0) {
                    path.setLastModified(1000L * (long)time);
                } else {
                    path.setLastModified(env.getCurrentTime());
                }
            } else {
                WriteStream ws = path.openWrite();
                ws.close();
            }
            return true;
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    public static int umask(Env env, @Optional(value="0") int maskV) {
        return 2;
    }

    public static boolean unlink(Env env, StringValue filename, @Optional Value context) {
        try {
            ProtocolWrapper wrapper = FileModule.getProtocolWrapper(env, filename);
            if (wrapper != null) {
                return wrapper.unlink(env, filename);
            }
            Path path = env.lookupPwd(filename);
            if (path == null || path.exists()) {
                env.warning(L.l("file does not exist: '{0}'", (Object)filename));
                return false;
            }
            return path.remove();
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    static {
        FileModule.addConstant(_constMap, "SEEK_SET", 0L);
        FileModule.addConstant(_constMap, "SEEK_CUR", 1L);
        FileModule.addConstant(_constMap, "SEEK_END", 2L);
        FileModule.addConstant(_constMap, "LOCK_SH", 1L);
        FileModule.addConstant(_constMap, "LOCK_EX", 2L);
        FileModule.addConstant(_constMap, "LOCK_UN", 3L);
        FileModule.addConstant(_constMap, "LOCK_NB", 4L);
        FileModule.addConstant(_constMap, "FNM_PATHNAME", 1L);
        FileModule.addConstant(_constMap, "FNM_NOESCAPE", 2L);
        FileModule.addConstant(_constMap, "FNM_PERIOD", 4L);
        FileModule.addConstant(_constMap, "FNM_CASEFOLD", 16L);
        FileModule.addConstant(_constMap, "GLOB_MARK", 1L);
        FileModule.addConstant(_constMap, "GLOB_NOSORT", 2L);
        FileModule.addConstant(_constMap, "GLOB_NOCHECK", 4L);
        FileModule.addConstant(_constMap, "GLOB_NOESCAPE", 8L);
        FileModule.addConstant(_constMap, "GLOB_BRACE", 16L);
        FileModule.addConstant(_constMap, "GLOB_ONLYDIR", 32L);
        INI_ALLOW_URL_FOPEN = _iniDefinitions.add("allow_url_fopen", true, 4);
        INI_USER_AGENT = _iniDefinitions.add("user_agent", null, 7);
        INI_DEFAULT_SOCKET_TIMEOUT = _iniDefinitions.add("default_socket_timeout", 60L, 7);
        INI_FROM = _iniDefinitions.add("from", "", 7);
        INI_AUTO_DETECT_LINE_ENDINGS = _iniDefinitions.add("auto_detect_line_endings", false, 7);
        INI_FILE_UPLOADS = _iniDefinitions.add("file_uploads", true, 4);
        INI_UPLOAD_TMP_DIR = _iniDefinitions.add("upload_tmp_dir", null, 4);
        INI_UPLOAD_MAX_FILESIZE = _iniDefinitions.add("upload_max_filesize", "2M", 4);
    }

    static class RemoveFile
    implements EnvCleanup {
        private Path _path;

        RemoveFile(Path path) {
            this._path = path;
        }

        public void cleanup() throws IOException {
            this._path.remove();
        }
    }
}

