/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.file;

import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.quercus.lib.file.BinaryStream;
import com.caucho.quercus.lib.file.WrappedDirectory;
import com.caucho.quercus.lib.file.WrappedStream;

public class ProtocolWrapper {
    private QuercusClass _qClass;

    protected ProtocolWrapper() {
    }

    public ProtocolWrapper(QuercusClass qClass) {
        this._qClass = qClass;
    }

    public BinaryStream fopen(Env env, StringValue path, StringValue mode, LongValue options) {
        return new WrappedStream(env, this._qClass, path, mode, options);
    }

    public Value opendir(Env env, StringValue path, LongValue flags) {
        WrappedDirectory value = new WrappedDirectory(env, this._qClass);
        if (!value.open(env, path, flags)) {
            return BooleanValue.FALSE;
        }
        return env.wrapJava(value);
    }

    public boolean unlink(Env env, StringValue path) {
        Value obj = this._qClass.createObject(env);
        AbstractFunction function = this._qClass.findFunction("unlink");
        if (function == null) {
            return false;
        }
        Value result = function.callMethod(env, this._qClass, obj, (Value)path);
        return result.toBoolean();
    }

    public boolean rename(Env env, StringValue from, StringValue to) {
        Value obj = this._qClass.createObject(env);
        AbstractFunction function = this._qClass.findFunction("rename");
        if (function == null) {
            return false;
        }
        Value result = function.callMethod(env, this._qClass, obj, (Value)from, (Value)to);
        return result.toBoolean();
    }

    public boolean mkdir(Env env, StringValue path, LongValue mode, LongValue options) {
        Value obj = this._qClass.createObject(env);
        AbstractFunction function = this._qClass.findFunction("mkdir");
        if (function == null) {
            return false;
        }
        Value result = function.callMethod(env, this._qClass, obj, (Value)path, (Value)mode, (Value)options);
        return result.toBoolean();
    }

    public boolean rmdir(Env env, StringValue path, LongValue options) {
        Value obj = this._qClass.createObject(env);
        AbstractFunction function = this._qClass.findFunction("rmdir");
        if (function == null) {
            return false;
        }
        Value result = function.callMethod(env, this._qClass, obj, (Value)path, (Value)options);
        return result.toBoolean();
    }

    public Value url_stat(Env env, StringValue path, LongValue flags) {
        Value obj = this._qClass.createObject(env);
        AbstractFunction function = this._qClass.findFunction("url_stat");
        if (function == null) {
            return BooleanValue.FALSE;
        }
        Value result = function.callMethod(env, this._qClass, obj, (Value)path, (Value)flags);
        return result;
    }

    public boolean stream_metadata(Env env, StringValue path, LongValue options, Value arg) {
        Value obj = this._qClass.createObject(env);
        AbstractFunction function = this._qClass.findFunction("stream_metadata");
        if (function == null) {
            return false;
        }
        Value result = function.callMethod(env, this._qClass, obj, (Value)path, (Value)options, arg);
        return result.toBoolean();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._qClass + "]";
    }
}

