/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.filter;

import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.filter.AbstractFilter;
import com.caucho.quercus.lib.filter.SanitizeFilter;

public class StringSanitizeFilter
extends AbstractFilter
implements SanitizeFilter {
    protected Value filterImpl(Env env, Value value, int flags, ArrayValue options) {
        StringValue str = value.toStringValue(env);
        StringValue sb = str.createStringBuilder();
        int len = str.length();
        boolean isEncodeLow = (flags & 0x10) > 0;
        boolean isEncodeHigh = (flags & 0x20) > 0;
        boolean isStripLow = (flags & 4) > 0;
        boolean isStripHigh = (flags & 8) > 0;
        boolean isEncodeAmp = (flags & 0x40) > 0;
        boolean isNoEncodeQuotes = (flags & 0x80) > 0;
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if ('\u0000' <= ch && ch <= '\u001f') {
                if (isStripLow) continue;
                if (isEncodeLow) {
                    StringSanitizeFilter.appendEncoded(sb, ch);
                    continue;
                }
                if (ch == '\u0000') continue;
                sb.append(ch);
                continue;
            }
            if ('\u0080' <= ch) {
                if (isStripHigh) continue;
                if (isEncodeHigh) {
                    StringSanitizeFilter.appendEncoded(sb, ch);
                    continue;
                }
                sb.append(ch);
                continue;
            }
            if (isEncodeAmp && ch == '&') {
                StringSanitizeFilter.appendEncoded(sb, ch);
                continue;
            }
            if (ch == '\"' || ch == '\'') {
                if (isNoEncodeQuotes) {
                    sb.append(ch);
                    continue;
                }
                StringSanitizeFilter.appendEncoded(sb, ch);
                continue;
            }
            if (ch == '<') {
                while (++i < len && str.charAt(i) != '>') {
                }
                continue;
            }
            sb.append(ch);
        }
        return sb;
    }

    private static void appendEncoded(StringValue sb, char ch) {
        sb.append('&');
        sb.append('#');
        sb.append((long)ch);
        sb.append(';');
    }
}

