/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.i18n;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.lib.i18n.GenericDecoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CoderResult;

public class Big5Decoder
extends GenericDecoder {
    public Big5Decoder(String charsetName) {
        super(charsetName);
    }

    public boolean isDecodable(Env env, StringValue str) {
        CoderResult coder;
        if (str.isUnicode()) {
            return true;
        }
        ByteBuffer in = ByteBuffer.wrap(str.toBytes());
        CharBuffer out = CharBuffer.allocate(512);
        while (in.hasRemaining()) {
            coder = this._decoder.decode(in, out, false);
            if (this.isMalformed(coder, in)) {
                return false;
            }
            out.clear();
        }
        coder = this._decoder.decode(in, out, true);
        if (this.isMalformed(coder, in)) {
            return false;
        }
        out.clear();
        coder = this._decoder.flush(out);
        return !this.isMalformed(coder, in);
    }

    private boolean isMalformed(CoderResult coder, ByteBuffer in) {
        if (coder.isMalformed() || coder.isUnmappable()) {
            int errorPosition = in.position();
            return errorPosition + 1 >= in.limit() || in.get(errorPosition) != 163 || in.get(errorPosition + 1) != 225;
        }
        return false;
    }

    protected boolean fill(StringBuilder sb, ByteBuffer in, CharBuffer out, CoderResult coder) {
        int len = out.position();
        if (len > 0) {
            int offset = out.arrayOffset();
            sb.append(out.array(), offset, len);
        }
        if (coder.isMalformed() || coder.isUnmappable()) {
            int errorPosition = in.position();
            if (errorPosition + 1 < in.limit() && (in.get(errorPosition) & 0xFF) == 163 && (in.get(errorPosition + 1) & 0xFF) == 225) {
                sb.append('\u20ac');
                in.position(errorPosition + 2);
                return true;
            }
            this._hasError = true;
            in.position(errorPosition + 1);
            if (!this._isIgnoreErrors) {
                if (this._replacement != null) {
                    sb.append(this._replacement);
                } else if (this._isAllowMalformedOut) {
                    sb.append((char)in.get(errorPosition));
                } else {
                    return false;
                }
            }
        }
        return true;
    }
}

