/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.i18n;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.lib.i18n.GenericEncoder;
import com.caucho.util.L10N;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CoderResult;
import java.util.logging.Logger;

public class Big5Encoder
extends GenericEncoder {
    private static final Logger log = Logger.getLogger(GenericEncoder.class.getName());
    private static final L10N L = new L10N(Big5Encoder.class);

    public Big5Encoder(String charsetName) {
        super(charsetName);
    }

    public boolean isEncodable(Env env, StringValue str) {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == '\u20ac' || this._encoder.canEncode(str.charAt(i))) continue;
            return false;
        }
        return false;
    }

    protected boolean fill(StringValue sb, CharBuffer in, ByteBuffer out, CoderResult coder) {
        int len = out.position();
        if (len > 0) {
            int offset = out.arrayOffset();
            sb.appendBytes(out.array(), offset, offset + len);
        }
        if (coder.isMalformed() || coder.isUnmappable()) {
            int errorIndex = in.position();
            in.position(errorIndex + 1);
            if (in.get(errorIndex) == '\u20ac') {
                sb.append('\u00a3');
                sb.append('\u00e1');
            } else if (!this._isIgnore) {
                if (this._replacement != null) {
                    sb.append(this._replacement);
                } else if (this._isReplaceUnicode) {
                    sb.append("U+" + Integer.toHexString(in.get(errorIndex)));
                } else {
                    return false;
                }
            }
        }
        return true;
    }
}

