/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.i18n;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.lib.i18n.Decoder;
import com.caucho.vfs.TempCharBuffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

public class GenericDecoder
extends Decoder {
    private Charset _charset;
    protected CharsetDecoder _decoder;

    public GenericDecoder(String charsetName) {
        super(charsetName);
        this._charset = Charset.forName(charsetName);
        this._decoder = this._charset.newDecoder();
    }

    public void reset() {
        this._decoder.reset();
        super.reset();
    }

    public boolean isDecodable(Env env, StringValue str) {
        CoderResult coder;
        if (str.isUnicode()) {
            return true;
        }
        ByteBuffer in = ByteBuffer.wrap(str.toBytes());
        CharBuffer out = CharBuffer.allocate(512);
        while (in.hasRemaining()) {
            coder = this._decoder.decode(in, out, false);
            if (coder.isMalformed()) {
                return false;
            }
            out.clear();
        }
        coder = this._decoder.decode(in, out, true);
        if (coder.isMalformed()) {
            return false;
        }
        out.clear();
        coder = this._decoder.flush(out);
        return !coder.isMalformed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StringBuilder decodeImpl(Env env, StringValue str) {
        ByteBuffer in = ByteBuffer.wrap(str.toBytes());
        TempCharBuffer tempBuf = TempCharBuffer.allocate();
        try {
            CoderResult coder;
            CharBuffer out = CharBuffer.wrap(tempBuf.getBuffer());
            StringBuilder sb = new StringBuilder();
            while (in.hasRemaining()) {
                coder = this._decoder.decode(in, out, false);
                if (!this.fill(sb, in, out, coder)) {
                    StringBuilder stringBuilder = sb;
                    return stringBuilder;
                }
                out.clear();
            }
            coder = this._decoder.decode(in, out, true);
            if (!this.fill(sb, in, out, coder)) {
                StringBuilder stringBuilder = sb;
                return stringBuilder;
            }
            out.clear();
            coder = this._decoder.flush(out);
            this.fill(sb, in, out, coder);
            StringBuilder stringBuilder = sb;
            return stringBuilder;
        }
        finally {
            TempCharBuffer.free(tempBuf);
        }
    }

    protected boolean fill(StringBuilder sb, ByteBuffer in, CharBuffer out, CoderResult coder) {
        int len = out.position();
        if (len > 0) {
            int offset = out.arrayOffset();
            sb.append(out.array(), offset, len);
        }
        if (coder.isMalformed() || coder.isUnmappable()) {
            this._hasError = true;
            int errorPosition = in.position();
            in.position(errorPosition + 1);
            if (!this._isIgnoreErrors) {
                if (this._replacement != null) {
                    sb.append(this._replacement);
                } else if (this._isAllowMalformedOut) {
                    sb.append((char)in.get(errorPosition));
                } else {
                    return false;
                }
            }
        }
        return true;
    }
}

