/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.i18n;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.lib.i18n.Encoder;
import com.caucho.vfs.TempBuffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class GenericEncoder
extends Encoder {
    private Charset _charset;
    protected CharsetEncoder _encoder;

    public GenericEncoder(String charsetName) {
        super(charsetName);
        this._charset = Charset.forName(charsetName);
        this._encoder = this._charset.newEncoder();
    }

    public boolean isEncodable(Env env, StringValue str) {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (this._encoder.canEncode(str.charAt(i))) continue;
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringValue encode(Env env, CharSequence str) {
        CharBuffer in = CharBuffer.wrap(str);
        TempBuffer tempBuf = TempBuffer.allocate();
        try {
            CoderResult coder;
            ByteBuffer out = ByteBuffer.wrap(tempBuf.getBuffer());
            StringValue sb = env.createBinaryBuilder();
            while (in.hasRemaining()) {
                coder = this._encoder.encode(in, out, false);
                if (!this.fill(sb, in, out, coder)) {
                    StringValue stringValue = sb;
                    return stringValue;
                }
                out.clear();
            }
            coder = this._encoder.encode(in, out, true);
            if (!this.fill(sb, in, out, coder)) {
                StringValue stringValue = sb;
                return stringValue;
            }
            out.clear();
            coder = this._encoder.flush(out);
            this.fill(sb, in, out, coder);
            StringValue stringValue = sb;
            return stringValue;
        }
        finally {
            TempBuffer.free(tempBuf);
        }
    }

    protected boolean fill(StringValue sb, CharBuffer in, ByteBuffer out, CoderResult coder) {
        int len = out.position();
        if (len > 0) {
            int offset = out.arrayOffset();
            sb.appendBytes(out.array(), offset, offset + len);
        }
        if (coder.isMalformed() || coder.isUnmappable()) {
            int errorIndex = in.position();
            in.position(errorIndex + 1);
            if (!this._isIgnore) {
                if (this._replacement != null) {
                    sb.append(this._replacement);
                } else if (this._isReplaceUnicode) {
                    sb.append("U+" + Integer.toHexString(in.get(errorIndex)));
                } else {
                    return false;
                }
            }
        }
        return true;
    }

    public void reset() {
        this._encoder.reset();
    }
}

