/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.pdf;

import com.caucho.quercus.lib.pdf.Font;
import com.caucho.quercus.lib.pdf.FontChar;
import com.caucho.util.L10N;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.MergePath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class AfmParser {
    private static final L10N L = new L10N(AfmParser.class);
    private static final String END_OF_FILE = "end of file";
    private ReadStream _is;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Font parse(String webInfLibPath, String name) throws IOException {
        Path path;
        MergePath mergePath = new MergePath();
        mergePath.addClassPath();
        File webInfLibFile = new File(webInfLibPath);
        if (webInfLibPath != null && !webInfLibPath.isEmpty() && webInfLibFile.isDirectory()) {
            Path webInfPath = Vfs.lookup(webInfLibFile.getAbsolutePath());
            for (File f : webInfLibFile.listFiles()) {
                if (!f.isFile() || !f.getAbsolutePath().endsWith(".jar") && !f.getAbsolutePath().endsWith(".zip")) continue;
                Path jarPath = webInfPath.lookup(f.getName());
                mergePath.addMergePath(JarPath.create(jarPath));
            }
        }
        if (!(path = mergePath.lookup("com/caucho/quercus/lib/pdf/font/" + name + ".afm")).canRead()) {
            throw new FileNotFoundException(L.l("Can't find font {0}", (Object)name));
        }
        this._is = path.openRead();
        try {
            Font font = this.parseTop();
            return font;
        }
        finally {
            this._is.close();
        }
    }

    private Font parseTop() throws IOException {
        Font font = new Font();
        while (this.skipWhitespace()) {
            String id = this.parseIdentifier();
            if ("FontName".equals(id)) {
                font.setFontName(this.parseString());
            } else if ("Weight".equals(id)) {
                font.setWeight(this.parseString());
            } else if ("FontBBox".equals(id)) {
                font.setBBox(this.parseNumber(), this.parseNumber(), this.parseNumber(), this.parseNumber());
            } else if ("CapHeight".equals(id)) {
                font.setCapHeight(this.parseNumber());
            } else if ("XHeight".equals(id)) {
                font.setXHeight(this.parseNumber());
            } else if ("Ascender".equals(id)) {
                font.setAscender(this.parseNumber());
            } else if ("Descender".equals(id)) {
                font.setDescender(this.parseNumber());
            } else if ("UnderlinePosition".equals(id)) {
                font.setUnderlinePosition(this.parseNumber());
            } else if ("UnderlineThickness".equals(id)) {
                font.setUnderlineThickness(this.parseNumber());
            } else if ("C".equals(id)) {
                font.addChar(this.parseCharacter());
            }
            this.skipToEndOfLine();
        }
        return font;
    }

    private FontChar parseCharacter() throws IOException {
        int code = this.parseInteger();
        this.skipWhitespace();
        int ch = this._is.read();
        if (ch != 59) {
            throw new IOException("Expected ';'");
        }
        String wx = this.parseString();
        if (!"WX".equals(wx)) {
            throw new IOException("Expected 'WX'");
        }
        double width = this.parseNumber();
        return new FontChar(code, width);
    }

    private String parseString() throws IOException {
        int ch;
        this.skipWhitespace();
        StringBuilder sb = new StringBuilder();
        while ((ch = this._is.read()) >= 0 && !Character.isWhitespace(ch)) {
            sb.append((char)ch);
        }
        if (ch >= 0) {
            this._is.unread();
        }
        return sb.toString();
    }

    private int parseInteger() throws IOException {
        this.skipWhitespace();
        int value = 0;
        int sign = 1;
        int ch = this._is.read();
        if (ch == 45) {
            sign = -1;
            ch = this._is.read();
        }
        while (48 <= ch && ch <= 57) {
            value = 10 * value + ch - 48;
            ch = this._is.read();
        }
        if (ch >= 0) {
            this._is.unread();
        }
        return sign * value;
    }

    private double parseNumber() throws IOException {
        int ch;
        this.skipWhitespace();
        StringBuilder sb = new StringBuilder();
        while (48 <= (ch = this._is.read()) && ch <= 57 || ch == 46 || ch == 45 || ch == 43) {
            sb.append((char)ch);
        }
        if (ch >= 0) {
            this._is.unread();
        }
        if (sb.length() == 0) {
            return 0.0;
        }
        return Double.parseDouble(sb.toString());
    }

    private String parseIdentifier() throws IOException {
        int ch;
        StringBuilder sb = new StringBuilder();
        while (Character.isLetterOrDigit(ch = this._is.read())) {
            sb.append((char)ch);
        }
        this._is.unread();
        return sb.toString();
    }

    private void skipToEndOfLine() throws IOException {
        int ch;
        while ((ch = this._is.read()) >= 0 && ch != 10) {
        }
    }

    private boolean skipWhitespace() throws IOException {
        int ch;
        while ((ch = this._is.read()) == 32 || ch == 9) {
        }
        if (ch >= 0) {
            this._is.unread();
        }
        return ch >= 0;
    }
}

